package software.amazon.awscdk.services.cloudfront;

/**
 * A Realtime Log Config configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Adding realtime logs config to a Cloudfront Distribution on default behavior.
 * import software.amazon.awscdk.services.kinesis.*;
 * Stream stream;
 * RealtimeLogConfig realTimeConfig = RealtimeLogConfig.Builder.create(this, "realtimeLog")
 *         .endPoints(List.of(Endpoint.fromKinesisStream(stream)))
 *         .fields(List.of("timestamp", "c-ip", "time-to-first-byte", "sc-status"))
 *         .realtimeLogConfigName("my-delivery-stream")
 *         .samplingRate(100)
 *         .build();
 * Distribution.Builder.create(this, "myCdn")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new HttpOrigin("www.example.com"))
 *                 .realtimeLogConfig(realTimeConfig)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.126Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.RealtimeLogConfig")
public class RealtimeLogConfig extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig {

    protected RealtimeLogConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RealtimeLogConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.RealtimeLogConfig.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RealtimeLogConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.RealtimeLogConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The arn of the realtime log config.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRealtimeLogConfigArn() {
        return software.amazon.jsii.Kernel.get(this, "realtimeLogConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the realtime log config.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRealtimeLogConfigName() {
        return software.amazon.jsii.Kernel.get(this, "realtimeLogConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.RealtimeLogConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.RealtimeLogConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.RealtimeLogConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.RealtimeLogConfigProps.Builder();
        }

        /**
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
         * <p>
         * @return {@code this}
         * @param endPoints Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endPoints(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.Endpoint> endPoints) {
            this.props.endPoints(endPoints);
            return this;
        }

        /**
         * A list of fields that are included in each real-time log record.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields</a>
         * @param fields A list of fields that are included in each real-time log record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(final java.util.List<java.lang.String> fields) {
            this.props.fields(fields);
            return this;
        }

        /**
         * The sampling rate for this real-time log configuration.
         * <p>
         * @return {@code this}
         * @param samplingRate The sampling rate for this real-time log configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRate(final java.lang.Number samplingRate) {
            this.props.samplingRate(samplingRate);
            return this;
        }

        /**
         * The unique name of this real-time log configuration.
         * <p>
         * Default: - the unique construct ID
         * <p>
         * @return {@code this}
         * @param realtimeLogConfigName The unique name of this real-time log configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder realtimeLogConfigName(final java.lang.String realtimeLogConfigName) {
            this.props.realtimeLogConfigName(realtimeLogConfigName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.RealtimeLogConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.RealtimeLogConfig build() {
            return new software.amazon.awscdk.services.cloudfront.RealtimeLogConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
