package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a concrete metric.
 * <p>
 * NOTE: <code>unit</code> is no longer on this object since it is only used for <code>Alarms</code>, and doesn't mean what one
 * would expect it to mean there anyway. It is most likely to be misused.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Object value;
 * MetricStatConfig metricStatConfig = MetricStatConfig.builder()
 *         .metricName("metricName")
 *         .namespace("namespace")
 *         .period(Duration.minutes(30))
 *         .statistic("statistic")
 *         // the properties below are optional
 *         .account("account")
 *         .accountOverride("accountOverride")
 *         .dimensions(List.of(Dimension.builder()
 *                 .name("name")
 *                 .value(value)
 *                 .build()))
 *         .region("region")
 *         .regionOverride("regionOverride")
 *         .unitFilter(Unit.SECONDS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.346Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.MetricStatConfig")
@software.amazon.jsii.Jsii.Proxy(MetricStatConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MetricStatConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

    /**
     * Namespace of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

    /**
     * How many seconds to aggregate over.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getPeriod();

    /**
     * Aggregation function to use (can be either simple or a percentile).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatistic();

    /**
     * Account which this metric comes from.
     * <p>
     * Default: Deployment account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return null;
    }

    /**
     * Account set directly on the metric, not inherited from the attached stack.
     * <p>
     * Default: No override.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccountOverride() {
        return null;
    }

    /**
     * The dimensions to apply to the alarm.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> getDimensions() {
        return null;
    }

    /**
     * Region which this metric comes from.
     * <p>
     * Default: Deployment region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * Region set directly on the metric, not inherited from the attached stack.
     * <p>
     * Default: No override.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegionOverride() {
        return null;
    }

    /**
     * Unit used to filter the metric stream.
     * <p>
     * Only refer to datums emitted to the metric stream with the given unit and
     * ignore all others. Only useful when datums are being emitted to the same
     * metric stream under different units.
     * <p>
     * This field has been renamed from plain <code>unit</code> to clearly communicate
     * its purpose.
     * <p>
     * Default: - Refer to all metric datums
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Unit getUnitFilter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MetricStatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricStatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MetricStatConfig> {
        java.lang.String metricName;
        java.lang.String namespace;
        software.amazon.awscdk.Duration period;
        java.lang.String statistic;
        java.lang.String account;
        java.lang.String accountOverride;
        java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> dimensions;
        java.lang.String region;
        java.lang.String regionOverride;
        software.amazon.awscdk.services.cloudwatch.Unit unitFilter;

        /**
         * Sets the value of {@link MetricStatConfig#getMetricName}
         * @param metricName Name of the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getNamespace}
         * @param namespace Namespace of the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getPeriod}
         * @param period How many seconds to aggregate over. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getStatistic}
         * @param statistic Aggregation function to use (can be either simple or a percentile). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getAccount}
         * @param account Account which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getAccountOverride}
         * @param accountOverride Account set directly on the metric, not inherited from the attached stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountOverride(java.lang.String accountOverride) {
            this.accountOverride = accountOverride;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getDimensions}
         * @param dimensions The dimensions to apply to the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder dimensions(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.Dimension> dimensions) {
            this.dimensions = (java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension>)dimensions;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getRegion}
         * @param region Region which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getRegionOverride}
         * @param regionOverride Region set directly on the metric, not inherited from the attached stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionOverride(java.lang.String regionOverride) {
            this.regionOverride = regionOverride;
            return this;
        }

        /**
         * Sets the value of {@link MetricStatConfig#getUnitFilter}
         * @param unitFilter Unit used to filter the metric stream.
         *                   Only refer to datums emitted to the metric stream with the given unit and
         *                   ignore all others. Only useful when datums are being emitted to the same
         *                   metric stream under different units.
         *                   <p>
         *                   This field has been renamed from plain <code>unit</code> to clearly communicate
         *                   its purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unitFilter(software.amazon.awscdk.services.cloudwatch.Unit unitFilter) {
            this.unitFilter = unitFilter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricStatConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MetricStatConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MetricStatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricStatConfig {
        private final java.lang.String metricName;
        private final java.lang.String namespace;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.String statistic;
        private final java.lang.String account;
        private final java.lang.String accountOverride;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> dimensions;
        private final java.lang.String region;
        private final java.lang.String regionOverride;
        private final software.amazon.awscdk.services.cloudwatch.Unit unitFilter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accountOverride = software.amazon.jsii.Kernel.get(this, "accountOverride", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Dimension.class)));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regionOverride = software.amazon.jsii.Kernel.get(this, "regionOverride", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.unitFilter = software.amazon.jsii.Kernel.get(this, "unitFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Unit.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
            this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            this.period = java.util.Objects.requireNonNull(builder.period, "period is required");
            this.statistic = java.util.Objects.requireNonNull(builder.statistic, "statistic is required");
            this.account = builder.account;
            this.accountOverride = builder.accountOverride;
            this.dimensions = (java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension>)builder.dimensions;
            this.region = builder.region;
            this.regionOverride = builder.regionOverride;
            this.unitFilter = builder.unitFilter;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getAccountOverride() {
            return this.accountOverride;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getRegionOverride() {
            return this.regionOverride;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.Unit getUnitFilter() {
            return this.unitFilter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metricName", om.valueToTree(this.getMetricName()));
            data.set("namespace", om.valueToTree(this.getNamespace()));
            data.set("period", om.valueToTree(this.getPeriod()));
            data.set("statistic", om.valueToTree(this.getStatistic()));
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getAccountOverride() != null) {
                data.set("accountOverride", om.valueToTree(this.getAccountOverride()));
            }
            if (this.getDimensions() != null) {
                data.set("dimensions", om.valueToTree(this.getDimensions()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getRegionOverride() != null) {
                data.set("regionOverride", om.valueToTree(this.getRegionOverride()));
            }
            if (this.getUnitFilter() != null) {
                data.set("unitFilter", om.valueToTree(this.getUnitFilter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.MetricStatConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricStatConfig.Jsii$Proxy that = (MetricStatConfig.Jsii$Proxy) o;

            if (!metricName.equals(that.metricName)) return false;
            if (!namespace.equals(that.namespace)) return false;
            if (!period.equals(that.period)) return false;
            if (!statistic.equals(that.statistic)) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.accountOverride != null ? !this.accountOverride.equals(that.accountOverride) : that.accountOverride != null) return false;
            if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.regionOverride != null ? !this.regionOverride.equals(that.regionOverride) : that.regionOverride != null) return false;
            return this.unitFilter != null ? this.unitFilter.equals(that.unitFilter) : that.unitFilter == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metricName.hashCode();
            result = 31 * result + (this.namespace.hashCode());
            result = 31 * result + (this.period.hashCode());
            result = 31 * result + (this.statistic.hashCode());
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.accountOverride != null ? this.accountOverride.hashCode() : 0);
            result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.regionOverride != null ? this.regionOverride.hashCode() : 0);
            result = 31 * result + (this.unitFilter != null ? this.unitFilter.hashCode() : 0);
            return result;
        }
    }
}
