package software.amazon.awscdk.services.codebuild;

/**
 * The source credentials used when contacting the BitBucket API.
 * <p>
 * <strong>Note</strong>: CodeBuild only allows a single credential for BitBucket
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BitBucketSourceCredentials.Builder.create(this, "CodeBuildBitBucketCreds")
 *         .username(SecretValue.secretsManager("my-bitbucket-creds", SecretsManagerSecretOptions.builder().jsonField("username").build()))
 *         .password(SecretValue.secretsManager("my-bitbucket-creds", SecretsManagerSecretOptions.builder().jsonField("password").build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.396Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.BitBucketSourceCredentials")
public class BitBucketSourceCredentials extends software.amazon.awscdk.Resource {

    protected BitBucketSourceCredentials(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BitBucketSourceCredentials(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BitBucketSourceCredentials(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BitBucketSourceCredentialsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codebuild.BitBucketSourceCredentialsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codebuild.BitBucketSourceCredentialsProps.Builder();
        }

        /**
         * Your BitBucket application password.
         * <p>
         * @return {@code this}
         * @param password Your BitBucket application password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(final software.amazon.awscdk.SecretValue password) {
            this.props.password(password);
            return this;
        }

        /**
         * Your BitBucket username.
         * <p>
         * @return {@code this}
         * @param username Your BitBucket username. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(final software.amazon.awscdk.SecretValue username) {
            this.props.username(username);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials build() {
            return new software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
