package software.amazon.awscdk.services.codepipeline;

/**
 * The condition for the stage.
 * <p>
 * A condition is made up of the rules and the result for the condition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * Rule rule;
 * Condition condition = Condition.builder()
 *         .result(Result.ROLLBACK)
 *         .rules(List.of(rule))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.695Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Condition")
@software.amazon.jsii.Jsii.Proxy(Condition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Condition extends software.amazon.jsii.JsiiSerializable {

    /**
     * The action to be done when the condition is met.
     * <p>
     * Default: - No result action is taken
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Result getResult() {
        return null;
    }

    /**
     * The rules that make up the condition.
     * <p>
     * Default: - No rules are applied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Rule> getRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Condition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Condition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Condition> {
        software.amazon.awscdk.services.codepipeline.Result result;
        java.util.List<software.amazon.awscdk.services.codepipeline.Rule> rules;

        /**
         * Sets the value of {@link Condition#getResult}
         * @param result The action to be done when the condition is met.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder result(software.amazon.awscdk.services.codepipeline.Result result) {
            this.result = result;
            return this;
        }

        /**
         * Sets the value of {@link Condition#getRules}
         * @param rules The rules that make up the condition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder rules(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Rule> rules) {
            this.rules = (java.util.List<software.amazon.awscdk.services.codepipeline.Rule>)rules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Condition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Condition build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Condition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Condition {
        private final software.amazon.awscdk.services.codepipeline.Result result;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Rule> rules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.result = software.amazon.jsii.Kernel.get(this, "result", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Result.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Rule.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.result = builder.result;
            this.rules = (java.util.List<software.amazon.awscdk.services.codepipeline.Rule>)builder.rules;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Result getResult() {
            return this.result;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Rule> getRules() {
            return this.rules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getResult() != null) {
                data.set("result", om.valueToTree(this.getResult()));
            }
            if (this.getRules() != null) {
                data.set("rules", om.valueToTree(this.getRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.Condition"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Condition.Jsii$Proxy that = (Condition.Jsii$Proxy) o;

            if (this.result != null ? !this.result.equals(that.result) : that.result != null) return false;
            return this.rules != null ? this.rules.equals(that.rules) : that.rules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.result != null ? this.result.hashCode() : 0;
            result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
            return result;
        }
    }
}
