package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline action to delete a stack.
 * <p>
 * Deletes a stack. If you specify a stack that doesn't exist, the action completes successfully
 * without deleting a stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.codepipeline.*;
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * import software.amazon.awscdk.services.iam.*;
 * Artifact artifact;
 * ArtifactPath artifactPath;
 * Object parameterOverrides;
 * Role role;
 * CloudFormationDeleteStackAction cloudFormationDeleteStackAction = CloudFormationDeleteStackAction.Builder.create()
 *         .actionName("actionName")
 *         .adminPermissions(false)
 *         .stackName("stackName")
 *         // the properties below are optional
 *         .account("account")
 *         .cfnCapabilities(List.of(CfnCapabilities.NONE))
 *         .deploymentRole(role)
 *         .extraInputs(List.of(artifact))
 *         .output(artifact)
 *         .outputFileName("outputFileName")
 *         .parameterOverrides(Map.of(
 *                 "parameterOverridesKey", parameterOverrides))
 *         .region("region")
 *         .role(role)
 *         .runOrder(123)
 *         .templateConfiguration(artifactPath)
 *         .variablesNamespace("variablesNamespace")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.768Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CloudFormationDeleteStackAction")
public class CloudFormationDeleteStackAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected CloudFormationDeleteStackAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationDeleteStackAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudFormationDeleteStackAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeleteStackActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add statement to the service role assumed by CloudFormation while executing this action.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToDeploymentRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToDeploymentRolePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getDeploymentRole() {
        return software.amazon.jsii.Kernel.get(this, "deploymentRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeleteStackAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeleteStackAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeleteStackActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeleteStackActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Whether to grant full permissions to CloudFormation while deploying this template.
         * <p>
         * Setting this to <code>true</code> affects the defaults for <code>role</code> and <code>capabilities</code>, if you
         * don't specify any alternatives.
         * <p>
         * The default role that will be created for you will have full (i.e., <code>*</code>)
         * permissions on all resources, and the deployment will have named IAM
         * capabilities (i.e., able to create all IAM resources).
         * <p>
         * This is a shorthand that you can use if you fully trust the templates that
         * are deployed in this pipeline. If you want more fine-grained permissions,
         * use <code>addToRolePolicy</code> and <code>capabilities</code> to control what the CloudFormation
         * deployment is allowed to do.
         * <p>
         * @return {@code this}
         * @param adminPermissions Whether to grant full permissions to CloudFormation while deploying this template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminPermissions(final java.lang.Boolean adminPermissions) {
            this.props.adminPermissions(adminPermissions);
            return this;
        }

        /**
         * The name of the stack to apply this action to.
         * <p>
         * @return {@code this}
         * @param stackName The name of the stack to apply this action to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(final java.lang.String stackName) {
            this.props.stackName(stackName);
            return this;
        }

        /**
         * The AWS account this Action is supposed to operate in.
         * <p>
         * <strong>Note</strong>: if you specify the <code>role</code> property,
         * this is ignored - the action will operate in the same region the passed role does.
         * <p>
         * Default: - action resides in the same account as the pipeline
         * <p>
         * @return {@code this}
         * @param account The AWS account this Action is supposed to operate in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(final java.lang.String account) {
            this.props.account(account);
            return this;
        }

        /**
         * Acknowledge certain changes made as part of deployment.
         * <p>
         * For stacks that contain certain resources,
         * explicit acknowledgement is required that AWS CloudFormation might create or update those resources.
         * For example, you must specify <code>ANONYMOUS_IAM</code> or <code>NAMED_IAM</code> if your stack template contains AWS
         * Identity and Access Management (IAM) resources.
         * For more information, see the link below.
         * <p>
         * Default: None, unless `adminPermissions` is true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities</a>
         * @param cfnCapabilities Acknowledge certain changes made as part of deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cfnCapabilities(final java.util.List<? extends software.amazon.awscdk.CfnCapabilities> cfnCapabilities) {
            this.props.cfnCapabilities(cfnCapabilities);
            return this;
        }

        /**
         * IAM role to assume when deploying changes.
         * <p>
         * If not specified, a fresh role is created. The role is created with zero
         * permissions unless <code>adminPermissions</code> is true, in which case the role will have
         * full permissions.
         * <p>
         * Default: A fresh role with full or no permissions (depending on the value of `adminPermissions`).
         * <p>
         * @return {@code this}
         * @param deploymentRole IAM role to assume when deploying changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentRole(final software.amazon.awscdk.services.iam.IRole deploymentRole) {
            this.props.deploymentRole(deploymentRole);
            return this;
        }

        /**
         * The list of additional input Artifacts for this Action.
         * <p>
         * This is especially useful when used in conjunction with the <code>parameterOverrides</code> property.
         * For example, if you have:
         * <p>
         * parameterOverrides: {
         * 'Param1': action1.outputArtifact.bucketName,
         * 'Param2': action2.outputArtifact.objectKey,
         * }
         * <p>
         * , if the output Artifacts of <code>action1</code> and <code>action2</code> were not used to
         * set either the <code>templateConfiguration</code> or the <code>templatePath</code> properties,
         * you need to make sure to include them in the <code>extraInputs</code> -
         * otherwise, you'll get an "unrecognized Artifact" error during your Pipeline's execution.
         * <p>
         * @return {@code this}
         * @param extraInputs The list of additional input Artifacts for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraInputs(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> extraInputs) {
            this.props.extraInputs(extraInputs);
            return this;
        }

        /**
         * The name of the output artifact to generate.
         * <p>
         * Only applied if <code>outputFileName</code> is set as well.
         * <p>
         * Default: Automatically generated artifact name.
         * <p>
         * @return {@code this}
         * @param output The name of the output artifact to generate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * A name for the filename in the output artifact to store the AWS CloudFormation call's result.
         * <p>
         * The file will contain the result of the call to AWS CloudFormation (for example
         * the call to UpdateStack or CreateChangeSet).
         * <p>
         * AWS CodePipeline adds the file to the output artifact after performing
         * the specified action.
         * <p>
         * Default: No output artifact generated
         * <p>
         * @return {@code this}
         * @param outputFileName A name for the filename in the output artifact to store the AWS CloudFormation call's result. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputFileName(final java.lang.String outputFileName) {
            this.props.outputFileName(outputFileName);
            return this;
        }

        /**
         * Additional template parameters.
         * <p>
         * Template parameters specified here take precedence over template parameters
         * found in the artifact specified by the <code>templateConfiguration</code> property.
         * <p>
         * We recommend that you use the template configuration file to specify
         * most of your parameter values. Use parameter overrides to specify only
         * dynamic parameter values (values that are unknown until you run the
         * pipeline).
         * <p>
         * All parameter names must be present in the stack template.
         * <p>
         * Note: the entire object cannot be more than 1kB.
         * <p>
         * Default: No overrides
         * <p>
         * @return {@code this}
         * @param parameterOverrides Additional template parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterOverrides(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameterOverrides) {
            this.props.parameterOverrides(parameterOverrides);
            return this;
        }

        /**
         * The AWS region the given Action resides in.
         * <p>
         * Note that a cross-region Pipeline requires replication buckets to function correctly.
         * You can provide their names with the <code>PipelineProps#crossRegionReplicationBuckets</code> property.
         * If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
         * that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
         * <p>
         * Default: the Action resides in the same region as the Pipeline
         * <p>
         * @return {@code this}
         * @param region The AWS region the given Action resides in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * Input artifact to use for template parameters values and stack policy.
         * <p>
         * The template configuration file should contain a JSON object that should look like this:
         * <code>{ "Parameters": {...}, "Tags": {...}, "StackPolicy": {... }}</code>. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-cfn-artifacts.html">AWS CloudFormation Artifacts</a>.
         * <p>
         * Note that if you include sensitive information, such as passwords, restrict access to this
         * file.
         * <p>
         * Default: No template configuration based on input artifacts
         * <p>
         * @return {@code this}
         * @param templateConfiguration Input artifact to use for template parameters values and stack policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateConfiguration(final software.amazon.awscdk.services.codepipeline.ArtifactPath templateConfiguration) {
            this.props.templateConfiguration(templateConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeleteStackAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeleteStackAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeleteStackAction(
                this.props.build()
            );
        }
    }
}
