package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The CodePipeline variables emitted by CodeStar source Action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * CodeStarSourceVariables codeStarSourceVariables = CodeStarSourceVariables.builder()
 *         .authorDate("authorDate")
 *         .branchName("branchName")
 *         .commitId("commitId")
 *         .commitMessage("commitMessage")
 *         .connectionArn("connectionArn")
 *         .fullRepositoryName("fullRepositoryName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.799Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeStarSourceVariables")
@software.amazon.jsii.Jsii.Proxy(CodeStarSourceVariables.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeStarSourceVariables extends software.amazon.jsii.JsiiSerializable {

    /**
     * The date the currently last commit on the tracked branch was authored, in ISO-8601 format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorDate();

    /**
     * The name of the branch this action tracks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBranchName();

    /**
     * The SHA1 hash of the currently last commit on the tracked branch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCommitId();

    /**
     * The message of the currently last commit on the tracked branch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCommitMessage();

    /**
     * The connection ARN this source uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionArn();

    /**
     * The name of the repository this action points to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFullRepositoryName();

    /**
     * @return a {@link Builder} of {@link CodeStarSourceVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeStarSourceVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeStarSourceVariables> {
        java.lang.String authorDate;
        java.lang.String branchName;
        java.lang.String commitId;
        java.lang.String commitMessage;
        java.lang.String connectionArn;
        java.lang.String fullRepositoryName;

        /**
         * Sets the value of {@link CodeStarSourceVariables#getAuthorDate}
         * @param authorDate The date the currently last commit on the tracked branch was authored, in ISO-8601 format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorDate(java.lang.String authorDate) {
            this.authorDate = authorDate;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarSourceVariables#getBranchName}
         * @param branchName The name of the branch this action tracks. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchName(java.lang.String branchName) {
            this.branchName = branchName;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarSourceVariables#getCommitId}
         * @param commitId The SHA1 hash of the currently last commit on the tracked branch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commitId(java.lang.String commitId) {
            this.commitId = commitId;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarSourceVariables#getCommitMessage}
         * @param commitMessage The message of the currently last commit on the tracked branch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commitMessage(java.lang.String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarSourceVariables#getConnectionArn}
         * @param connectionArn The connection ARN this source uses. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionArn(java.lang.String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarSourceVariables#getFullRepositoryName}
         * @param fullRepositoryName The name of the repository this action points to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fullRepositoryName(java.lang.String fullRepositoryName) {
            this.fullRepositoryName = fullRepositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeStarSourceVariables}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeStarSourceVariables build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeStarSourceVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeStarSourceVariables {
        private final java.lang.String authorDate;
        private final java.lang.String branchName;
        private final java.lang.String commitId;
        private final java.lang.String commitMessage;
        private final java.lang.String connectionArn;
        private final java.lang.String fullRepositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorDate = software.amazon.jsii.Kernel.get(this, "authorDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.branchName = software.amazon.jsii.Kernel.get(this, "branchName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.commitId = software.amazon.jsii.Kernel.get(this, "commitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.commitMessage = software.amazon.jsii.Kernel.get(this, "commitMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fullRepositoryName = software.amazon.jsii.Kernel.get(this, "fullRepositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorDate = java.util.Objects.requireNonNull(builder.authorDate, "authorDate is required");
            this.branchName = java.util.Objects.requireNonNull(builder.branchName, "branchName is required");
            this.commitId = java.util.Objects.requireNonNull(builder.commitId, "commitId is required");
            this.commitMessage = java.util.Objects.requireNonNull(builder.commitMessage, "commitMessage is required");
            this.connectionArn = java.util.Objects.requireNonNull(builder.connectionArn, "connectionArn is required");
            this.fullRepositoryName = java.util.Objects.requireNonNull(builder.fullRepositoryName, "fullRepositoryName is required");
        }

        @Override
        public final java.lang.String getAuthorDate() {
            return this.authorDate;
        }

        @Override
        public final java.lang.String getBranchName() {
            return this.branchName;
        }

        @Override
        public final java.lang.String getCommitId() {
            return this.commitId;
        }

        @Override
        public final java.lang.String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public final java.lang.String getConnectionArn() {
            return this.connectionArn;
        }

        @Override
        public final java.lang.String getFullRepositoryName() {
            return this.fullRepositoryName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorDate", om.valueToTree(this.getAuthorDate()));
            data.set("branchName", om.valueToTree(this.getBranchName()));
            data.set("commitId", om.valueToTree(this.getCommitId()));
            data.set("commitMessage", om.valueToTree(this.getCommitMessage()));
            data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
            data.set("fullRepositoryName", om.valueToTree(this.getFullRepositoryName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.CodeStarSourceVariables"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeStarSourceVariables.Jsii$Proxy that = (CodeStarSourceVariables.Jsii$Proxy) o;

            if (!authorDate.equals(that.authorDate)) return false;
            if (!branchName.equals(that.branchName)) return false;
            if (!commitId.equals(that.commitId)) return false;
            if (!commitMessage.equals(that.commitMessage)) return false;
            if (!connectionArn.equals(that.connectionArn)) return false;
            return this.fullRepositoryName.equals(that.fullRepositoryName);
        }

        @Override
        public final int hashCode() {
            int result = this.authorDate.hashCode();
            result = 31 * result + (this.branchName.hashCode());
            result = 31 * result + (this.commitId.hashCode());
            result = 31 * result + (this.commitMessage.hashCode());
            result = 31 * result + (this.connectionArn.hashCode());
            result = 31 * result + (this.fullRepositoryName.hashCode());
            return result;
        }
    }
}
