package software.amazon.awscdk.services.codepipeline.actions;

/**
 * A deploy specifications for EC2 deploy action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceOutput = new Artifact();
 * Pipeline pipeline = Pipeline.Builder.create(this, "MyPipeline")
 *         .pipelineType(PipelineType.V2)
 *         .build();
 * Ec2DeployAction deployAction = Ec2DeployAction.Builder.create()
 *         .actionName("Ec2Deploy")
 *         .input(sourceOutput)
 *         .instanceType(Ec2InstanceType.EC2)
 *         .instanceTagKey("Name")
 *         .instanceTagValue("MyInstance")
 *         .deploySpecifications(Ec2DeploySpecifications.inline(Ec2DeploySpecificationsInlineProps.builder()
 *                 .targetDirectory("/home/ec2-user/deploy")
 *                 .preScript("scripts/pre-deploy.sh")
 *                 .postScript("scripts/post-deploy.sh")
 *                 .build()))
 *         .build();
 * IStage deployStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("Deploy")
 *         .actions(List.of(deployAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.804Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.Ec2DeploySpecifications")
public abstract class Ec2DeploySpecifications extends software.amazon.jsii.JsiiObject {

    protected Ec2DeploySpecifications(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2DeploySpecifications(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Ec2DeploySpecifications() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Store deploy specifications as action configurations.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications inline(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecificationsInlineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications.class, "inline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The callback invoked when this deploy specifications is bound to an action.
     * <p>
     * @return the action configurations
     * @param scope the Construct tree scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Object bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The callback invoked when this deploy specifications is bound to an action.
         * <p>
         * @return the action configurations
         * @param scope the Construct tree scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Object bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
