package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Properties of <code>Ec2DeploySpecifications.inline()</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceOutput = new Artifact();
 * Pipeline pipeline = Pipeline.Builder.create(this, "MyPipeline")
 *         .pipelineType(PipelineType.V2)
 *         .build();
 * Ec2DeployAction deployAction = Ec2DeployAction.Builder.create()
 *         .actionName("Ec2Deploy")
 *         .input(sourceOutput)
 *         .instanceType(Ec2InstanceType.EC2)
 *         .instanceTagKey("Name")
 *         .instanceTagValue("MyInstance")
 *         .deploySpecifications(Ec2DeploySpecifications.inline(Ec2DeploySpecificationsInlineProps.builder()
 *                 .targetDirectory("/home/ec2-user/deploy")
 *                 .preScript("scripts/pre-deploy.sh")
 *                 .postScript("scripts/post-deploy.sh")
 *                 .build()))
 *         .build();
 * IStage deployStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("Deploy")
 *         .actions(List.of(deployAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.805Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.Ec2DeploySpecificationsInlineProps")
@software.amazon.jsii.Jsii.Proxy(Ec2DeploySpecificationsInlineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Ec2DeploySpecificationsInlineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Path to the executable script file that runs AFTER the Deploy phase.
     * <p>
     * It should start from the root directory of your uploaded source artifact.
     * Use an absolute path like <code>uploadDir/postScript.sh</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPostScript();

    /**
     * The location of the target directory you want to deploy to.
     * <p>
     * Use an absolute path like <code>/home/ec2-user/deploy</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetDirectory();

    /**
     * Path to the executable script file that runs BEFORE the Deploy phase.
     * <p>
     * It should start from the root directory of your uploaded source artifact.
     * Use an absolute path like <code>uploadDir/preScript.sh</code>.
     * <p>
     * Default: - No script
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreScript() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Ec2DeploySpecificationsInlineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Ec2DeploySpecificationsInlineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Ec2DeploySpecificationsInlineProps> {
        java.lang.String postScript;
        java.lang.String targetDirectory;
        java.lang.String preScript;

        /**
         * Sets the value of {@link Ec2DeploySpecificationsInlineProps#getPostScript}
         * @param postScript Path to the executable script file that runs AFTER the Deploy phase. This parameter is required.
         *                   It should start from the root directory of your uploaded source artifact.
         *                   Use an absolute path like <code>uploadDir/postScript.sh</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postScript(java.lang.String postScript) {
            this.postScript = postScript;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeploySpecificationsInlineProps#getTargetDirectory}
         * @param targetDirectory The location of the target directory you want to deploy to. This parameter is required.
         *                        Use an absolute path like <code>/home/ec2-user/deploy</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetDirectory(java.lang.String targetDirectory) {
            this.targetDirectory = targetDirectory;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeploySpecificationsInlineProps#getPreScript}
         * @param preScript Path to the executable script file that runs BEFORE the Deploy phase.
         *                  It should start from the root directory of your uploaded source artifact.
         *                  Use an absolute path like <code>uploadDir/preScript.sh</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preScript(java.lang.String preScript) {
            this.preScript = preScript;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Ec2DeploySpecificationsInlineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Ec2DeploySpecificationsInlineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Ec2DeploySpecificationsInlineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2DeploySpecificationsInlineProps {
        private final java.lang.String postScript;
        private final java.lang.String targetDirectory;
        private final java.lang.String preScript;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.postScript = software.amazon.jsii.Kernel.get(this, "postScript", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetDirectory = software.amazon.jsii.Kernel.get(this, "targetDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preScript = software.amazon.jsii.Kernel.get(this, "preScript", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.postScript = java.util.Objects.requireNonNull(builder.postScript, "postScript is required");
            this.targetDirectory = java.util.Objects.requireNonNull(builder.targetDirectory, "targetDirectory is required");
            this.preScript = builder.preScript;
        }

        @Override
        public final java.lang.String getPostScript() {
            return this.postScript;
        }

        @Override
        public final java.lang.String getTargetDirectory() {
            return this.targetDirectory;
        }

        @Override
        public final java.lang.String getPreScript() {
            return this.preScript;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("postScript", om.valueToTree(this.getPostScript()));
            data.set("targetDirectory", om.valueToTree(this.getTargetDirectory()));
            if (this.getPreScript() != null) {
                data.set("preScript", om.valueToTree(this.getPreScript()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.Ec2DeploySpecificationsInlineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Ec2DeploySpecificationsInlineProps.Jsii$Proxy that = (Ec2DeploySpecificationsInlineProps.Jsii$Proxy) o;

            if (!postScript.equals(that.postScript)) return false;
            if (!targetDirectory.equals(that.targetDirectory)) return false;
            return this.preScript != null ? this.preScript.equals(that.preScript) : that.preScript == null;
        }

        @Override
        public final int hashCode() {
            int result = this.postScript.hashCode();
            result = 31 * result + (this.targetDirectory.hashCode());
            result = 31 * result + (this.preScript != null ? this.preScript.hashCode() : 0);
            return result;
        }
    }
}
