package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The CodePipeline variables emitted by the InspectorScan Action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * InspectorScanVariables inspectorScanVariables = InspectorScanVariables.builder()
 *         .highestScannedSeverity("highestScannedSeverity")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:11.829Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.InspectorScanVariables")
@software.amazon.jsii.Jsii.Proxy(InspectorScanVariables.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InspectorScanVariables extends software.amazon.jsii.JsiiSerializable {

    /**
     * The highest severity output from the scan.
     * <p>
     * Valid values are medium | high | critical.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHighestScannedSeverity();

    /**
     * @return a {@link Builder} of {@link InspectorScanVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InspectorScanVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InspectorScanVariables> {
        java.lang.String highestScannedSeverity;

        /**
         * Sets the value of {@link InspectorScanVariables#getHighestScannedSeverity}
         * @param highestScannedSeverity The highest severity output from the scan. This parameter is required.
         *                               Valid values are medium | high | critical.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder highestScannedSeverity(java.lang.String highestScannedSeverity) {
            this.highestScannedSeverity = highestScannedSeverity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InspectorScanVariables}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InspectorScanVariables build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InspectorScanVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InspectorScanVariables {
        private final java.lang.String highestScannedSeverity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.highestScannedSeverity = software.amazon.jsii.Kernel.get(this, "highestScannedSeverity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.highestScannedSeverity = java.util.Objects.requireNonNull(builder.highestScannedSeverity, "highestScannedSeverity is required");
        }

        @Override
        public final java.lang.String getHighestScannedSeverity() {
            return this.highestScannedSeverity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("highestScannedSeverity", om.valueToTree(this.getHighestScannedSeverity()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.InspectorScanVariables"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InspectorScanVariables.Jsii$Proxy that = (InspectorScanVariables.Jsii$Proxy) o;

            return this.highestScannedSeverity.equals(that.highestScannedSeverity);
        }

        @Override
        public final int hashCode() {
            int result = this.highestScannedSeverity.hashCode();
            return result;
        }
    }
}
