package software.amazon.awscdk.services.cognito.identitypool;

/**
 * Represents a UserPoolAuthenticationProvider Bind Configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.identitypool.*;
 * UserPoolAuthenticationProviderBindConfig userPoolAuthenticationProviderBindConfig = UserPoolAuthenticationProviderBindConfig.builder()
 *         .clientId("clientId")
 *         .providerName("providerName")
 *         .serverSideTokenCheck(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:12.067Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito_identitypool.UserPoolAuthenticationProviderBindConfig")
@software.amazon.jsii.Jsii.Proxy(UserPoolAuthenticationProviderBindConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolAuthenticationProviderBindConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Client Id of the Associated User Pool Client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * The identity providers associated with the UserPool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProviderName();

    /**
     * Whether to enable the identity pool's server side token check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getServerSideTokenCheck();

    /**
     * @return a {@link Builder} of {@link UserPoolAuthenticationProviderBindConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolAuthenticationProviderBindConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolAuthenticationProviderBindConfig> {
        java.lang.String clientId;
        java.lang.String providerName;
        java.lang.Boolean serverSideTokenCheck;

        /**
         * Sets the value of {@link UserPoolAuthenticationProviderBindConfig#getClientId}
         * @param clientId Client Id of the Associated User Pool Client. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolAuthenticationProviderBindConfig#getProviderName}
         * @param providerName The identity providers associated with the UserPool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerName(java.lang.String providerName) {
            this.providerName = providerName;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolAuthenticationProviderBindConfig#getServerSideTokenCheck}
         * @param serverSideTokenCheck Whether to enable the identity pool's server side token check. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideTokenCheck(java.lang.Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolAuthenticationProviderBindConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolAuthenticationProviderBindConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolAuthenticationProviderBindConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolAuthenticationProviderBindConfig {
        private final java.lang.String clientId;
        private final java.lang.String providerName;
        private final java.lang.Boolean serverSideTokenCheck;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.providerName = software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverSideTokenCheck = software.amazon.jsii.Kernel.get(this, "serverSideTokenCheck", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
            this.providerName = java.util.Objects.requireNonNull(builder.providerName, "providerName is required");
            this.serverSideTokenCheck = java.util.Objects.requireNonNull(builder.serverSideTokenCheck, "serverSideTokenCheck is required");
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final java.lang.String getProviderName() {
            return this.providerName;
        }

        @Override
        public final java.lang.Boolean getServerSideTokenCheck() {
            return this.serverSideTokenCheck;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("providerName", om.valueToTree(this.getProviderName()));
            data.set("serverSideTokenCheck", om.valueToTree(this.getServerSideTokenCheck()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito_identitypool.UserPoolAuthenticationProviderBindConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolAuthenticationProviderBindConfig.Jsii$Proxy that = (UserPoolAuthenticationProviderBindConfig.Jsii$Proxy) o;

            if (!clientId.equals(that.clientId)) return false;
            if (!providerName.equals(that.providerName)) return false;
            return this.serverSideTokenCheck.equals(that.serverSideTokenCheck);
        }

        @Override
        public final int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + (this.providerName.hashCode());
            result = 31 * result + (this.serverSideTokenCheck.hashCode());
            return result;
        }
    }
}
