package software.amazon.awscdk.services.config;

/**
 * Adds or updates an AWS Config rule for your entire organization to evaluate if your AWS resources comply with your desired configurations.
 * <p>
 * For information on how many organization AWS Config rules you can have per account, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"><em>Service Limits</em></a> in the <em>AWS Config Developer Guide</em> .
 * <p>
 * Only a management account and a delegated administrator can create or update an organization AWS Config rule. When calling the <code>OrganizationConfigRule</code> resource with a delegated administrator, you must ensure AWS Organizations <code>ListDelegatedAdministrator</code> permissions are added. An organization can have up to 3 delegated administrators.
 * <p>
 * The <code>OrganizationConfigRule</code> resource enables organization service access through the <code>EnableAWSServiceAccess</code> action and creates a service-linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the management or delegated administrator account of your organization. The service-linked role is created only when the role does not exist in the caller account. AWS Config verifies the existence of role with <code>GetRole</code> action.
 * <p>
 * To use the <code>OrganizationConfigRule</code> resource with delegated administrator, register a delegated administrator by calling AWS Organization <code>register-delegated-administrator</code> for <code>config-multiaccountsetup.amazonaws.com</code> .
 * <p>
 * There are two types of rules: <em>AWS Config Managed Rules</em> and <em>AWS Config Custom Rules</em> . You can use <code>PutOrganizationConfigRule</code> to create both AWS Config Managed Rules and AWS Config Custom Rules.
 * <p>
 * AWS Config Managed Rules are predefined, customizable rules created by AWS Config . For a list of managed rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of AWS Config Managed Rules</a> . If you are adding an AWS Config managed rule, you must specify the rule's identifier for the <code>RuleIdentifier</code> key.
 * <p>
 * AWS Config Custom Rules are rules that you create from scratch. There are two ways to create AWS Config custom rules: with Lambda functions ( <a href="https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function">AWS Lambda Developer Guide</a> ) and with Guard ( <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a> ), a policy-as-code language. AWS Config custom rules created with AWS Lambda are called <em>AWS Config Custom Lambda Rules</em> and AWS Config custom rules created with Guard are called <em>AWS Config Custom Policy Rules</em> .
 * <p>
 * If you are adding a new AWS Config Custom Lambda rule, you first need to create an AWS Lambda function in the management account or a delegated administrator that the rule invokes to evaluate your resources. You also need to create an IAM role in the managed account that can be assumed by the Lambda function. When you use <code>PutOrganizationConfigRule</code> to add a Custom Lambda rule to AWS Config , you must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnOrganizationConfigRule cfnOrganizationConfigRule = CfnOrganizationConfigRule.Builder.create(this, "MyCfnOrganizationConfigRule")
 *         .organizationConfigRuleName("organizationConfigRuleName")
 *         // the properties below are optional
 *         .excludedAccounts(List.of("excludedAccounts"))
 *         .organizationCustomPolicyRuleMetadata(OrganizationCustomPolicyRuleMetadataProperty.builder()
 *                 .policyText("policyText")
 *                 .runtime("runtime")
 *                 // the properties below are optional
 *                 .debugLogDeliveryAccounts(List.of("debugLogDeliveryAccounts"))
 *                 .description("description")
 *                 .inputParameters("inputParameters")
 *                 .maximumExecutionFrequency("maximumExecutionFrequency")
 *                 .organizationConfigRuleTriggerTypes(List.of("organizationConfigRuleTriggerTypes"))
 *                 .resourceIdScope("resourceIdScope")
 *                 .resourceTypesScope(List.of("resourceTypesScope"))
 *                 .tagKeyScope("tagKeyScope")
 *                 .tagValueScope("tagValueScope")
 *                 .build())
 *         .organizationCustomRuleMetadata(OrganizationCustomRuleMetadataProperty.builder()
 *                 .lambdaFunctionArn("lambdaFunctionArn")
 *                 .organizationConfigRuleTriggerTypes(List.of("organizationConfigRuleTriggerTypes"))
 *                 // the properties below are optional
 *                 .description("description")
 *                 .inputParameters("inputParameters")
 *                 .maximumExecutionFrequency("maximumExecutionFrequency")
 *                 .resourceIdScope("resourceIdScope")
 *                 .resourceTypesScope(List.of("resourceTypesScope"))
 *                 .tagKeyScope("tagKeyScope")
 *                 .tagValueScope("tagValueScope")
 *                 .build())
 *         .organizationManagedRuleMetadata(OrganizationManagedRuleMetadataProperty.builder()
 *                 .ruleIdentifier("ruleIdentifier")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .inputParameters("inputParameters")
 *                 .maximumExecutionFrequency("maximumExecutionFrequency")
 *                 .resourceIdScope("resourceIdScope")
 *                 .resourceTypesScope(List.of("resourceTypesScope"))
 *                 .tagKeyScope("tagKeyScope")
 *                 .tagValueScope("tagValueScope")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:12.134Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConfigRule")
public class CfnOrganizationConfigRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnOrganizationConfigRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOrganizationConfigRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.CfnOrganizationConfigRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOrganizationConfigRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnOrganizationConfigRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name that you assign to organization AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOrganizationConfigRuleName() {
        return software.amazon.jsii.Kernel.get(this, "organizationConfigRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name that you assign to organization AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationConfigRuleName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "organizationConfigRuleName", java.util.Objects.requireNonNull(value, "organizationConfigRuleName is required"));
    }

    /**
     * A comma-separated list of accounts excluded from organization AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedAccounts() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "excludedAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A comma-separated list of accounts excluded from organization AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludedAccounts(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "excludedAccounts", value);
    }

    /**
     * An object that specifies metadata for your organization's AWS Config Custom Policy rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationCustomPolicyRuleMetadata() {
        return software.amazon.jsii.Kernel.get(this, "organizationCustomPolicyRuleMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that specifies metadata for your organization's AWS Config Custom Policy rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationCustomPolicyRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationCustomPolicyRuleMetadata", value);
    }

    /**
     * An object that specifies metadata for your organization's AWS Config Custom Policy rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationCustomPolicyRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomPolicyRuleMetadataProperty value) {
        software.amazon.jsii.Kernel.set(this, "organizationCustomPolicyRuleMetadata", value);
    }

    /**
     * An <code>OrganizationCustomRuleMetadata</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationCustomRuleMetadata() {
        return software.amazon.jsii.Kernel.get(this, "organizationCustomRuleMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An <code>OrganizationCustomRuleMetadata</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationCustomRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationCustomRuleMetadata", value);
    }

    /**
     * An <code>OrganizationCustomRuleMetadata</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationCustomRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty value) {
        software.amazon.jsii.Kernel.set(this, "organizationCustomRuleMetadata", value);
    }

    /**
     * An <code>OrganizationManagedRuleMetadata</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationManagedRuleMetadata() {
        return software.amazon.jsii.Kernel.get(this, "organizationManagedRuleMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An <code>OrganizationManagedRuleMetadata</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationManagedRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationManagedRuleMetadata", value);
    }

    /**
     * An <code>OrganizationManagedRuleMetadata</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationManagedRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty value) {
        software.amazon.jsii.Kernel.set(this, "organizationManagedRuleMetadata", value);
    }
    /**
     * An object that specifies metadata for your organization's AWS Config Custom Policy rule.
     * <p>
     * The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of AWS resource, and organization trigger types that initiate AWS Config to evaluate AWS resources against a rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * OrganizationCustomPolicyRuleMetadataProperty organizationCustomPolicyRuleMetadataProperty = OrganizationCustomPolicyRuleMetadataProperty.builder()
     *         .policyText("policyText")
     *         .runtime("runtime")
     *         // the properties below are optional
     *         .debugLogDeliveryAccounts(List.of("debugLogDeliveryAccounts"))
     *         .description("description")
     *         .inputParameters("inputParameters")
     *         .maximumExecutionFrequency("maximumExecutionFrequency")
     *         .organizationConfigRuleTriggerTypes(List.of("organizationConfigRuleTriggerTypes"))
     *         .resourceIdScope("resourceIdScope")
     *         .resourceTypesScope(List.of("resourceTypesScope"))
     *         .tagKeyScope("tagKeyScope")
     *         .tagValueScope("tagValueScope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationCustomPolicyRuleMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(OrganizationCustomPolicyRuleMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrganizationCustomPolicyRuleMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The policy definition containing the logic for your organization AWS Config Custom Policy rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-policytext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-policytext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyText();

        /**
         * The runtime system for your organization AWS Config Custom Policy rules.
         * <p>
         * Guard is a policy-as-code language that allows you to write policies that are enforced by AWS Config Custom Policy rules. For more information about Guard, see the <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-runtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-runtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuntime();

        /**
         * A list of accounts that you can enable debug logging for your organization AWS Config Custom Policy rule.
         * <p>
         * List is null when debug logging is enabled for all accounts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-debuglogdeliveryaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-debuglogdeliveryaccounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDebugLogDeliveryAccounts() {
            return null;
        }

        /**
         * The description that you provide for your organization AWS Config Custom Policy rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A string, in JSON format, that is passed to your organization AWS Config Custom Policy rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-inputparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-inputparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputParameters() {
            return null;
        }

        /**
         * The maximum frequency with which AWS Config runs evaluations for a rule.
         * <p>
         * Your AWS Config Custom Policy rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-maximumexecutionfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-maximumexecutionfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
            return null;
        }

        /**
         * The type of notification that initiates AWS Config to run an evaluation for a rule.
         * <p>
         * For AWS Config Custom Policy rules, AWS Config supports change-initiated notification types:
         * <p>
         * <ul>
         * <li><code>ConfigurationItemChangeNotification</code> - Initiates an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
         * <li><code>OversizedConfigurationItemChangeNotification</code> - Initiates an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-organizationconfigruletriggertypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-organizationconfigruletriggertypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationConfigRuleTriggerTypes() {
            return null;
        }

        /**
         * The ID of the AWS resource that was evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-resourceidscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-resourceidscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdScope() {
            return null;
        }

        /**
         * The type of the AWS resource that was evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-resourcetypesscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-resourcetypesscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypesScope() {
            return null;
        }

        /**
         * One part of a key-value pair that make up a tag.
         * <p>
         * A key is a general label that acts like a category for more specific tag values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-tagkeyscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-tagkeyscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKeyScope() {
            return null;
        }

        /**
         * The optional part of a key-value pair that make up a tag.
         * <p>
         * A value acts as a descriptor within a tag category (key).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-tagvaluescope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustompolicyrulemetadata.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata-tagvaluescope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagValueScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrganizationCustomPolicyRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrganizationCustomPolicyRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrganizationCustomPolicyRuleMetadataProperty> {
            java.lang.String policyText;
            java.lang.String runtime;
            java.util.List<java.lang.String> debugLogDeliveryAccounts;
            java.lang.String description;
            java.lang.String inputParameters;
            java.lang.String maximumExecutionFrequency;
            java.util.List<java.lang.String> organizationConfigRuleTriggerTypes;
            java.lang.String resourceIdScope;
            java.util.List<java.lang.String> resourceTypesScope;
            java.lang.String tagKeyScope;
            java.lang.String tagValueScope;

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getPolicyText}
             * @param policyText The policy definition containing the logic for your organization AWS Config Custom Policy rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyText(java.lang.String policyText) {
                this.policyText = policyText;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getRuntime}
             * @param runtime The runtime system for your organization AWS Config Custom Policy rules. This parameter is required.
             *                Guard is a policy-as-code language that allows you to write policies that are enforced by AWS Config Custom Policy rules. For more information about Guard, see the <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtime(java.lang.String runtime) {
                this.runtime = runtime;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getDebugLogDeliveryAccounts}
             * @param debugLogDeliveryAccounts A list of accounts that you can enable debug logging for your organization AWS Config Custom Policy rule.
             *                                 List is null when debug logging is enabled for all accounts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder debugLogDeliveryAccounts(java.util.List<java.lang.String> debugLogDeliveryAccounts) {
                this.debugLogDeliveryAccounts = debugLogDeliveryAccounts;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getDescription}
             * @param description The description that you provide for your organization AWS Config Custom Policy rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getInputParameters}
             * @param inputParameters A string, in JSON format, that is passed to your organization AWS Config Custom Policy rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParameters(java.lang.String inputParameters) {
                this.inputParameters = inputParameters;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getMaximumExecutionFrequency}
             * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
             *                                  Your AWS Config Custom Policy rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getOrganizationConfigRuleTriggerTypes}
             * @param organizationConfigRuleTriggerTypes The type of notification that initiates AWS Config to run an evaluation for a rule.
             *                                           For AWS Config Custom Policy rules, AWS Config supports change-initiated notification types:
             *                                           <p>
             *                                           <ul>
             *                                           <li><code>ConfigurationItemChangeNotification</code> - Initiates an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
             *                                           <li><code>OversizedConfigurationItemChangeNotification</code> - Initiates an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
             *                                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationConfigRuleTriggerTypes(java.util.List<java.lang.String> organizationConfigRuleTriggerTypes) {
                this.organizationConfigRuleTriggerTypes = organizationConfigRuleTriggerTypes;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getResourceIdScope}
             * @param resourceIdScope The ID of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceIdScope(java.lang.String resourceIdScope) {
                this.resourceIdScope = resourceIdScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getResourceTypesScope}
             * @param resourceTypesScope The type of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypesScope(java.util.List<java.lang.String> resourceTypesScope) {
                this.resourceTypesScope = resourceTypesScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getTagKeyScope}
             * @param tagKeyScope One part of a key-value pair that make up a tag.
             *                    A key is a general label that acts like a category for more specific tag values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKeyScope(java.lang.String tagKeyScope) {
                this.tagKeyScope = tagKeyScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomPolicyRuleMetadataProperty#getTagValueScope}
             * @param tagValueScope The optional part of a key-value pair that make up a tag.
             *                      A value acts as a descriptor within a tag category (key).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValueScope(java.lang.String tagValueScope) {
                this.tagValueScope = tagValueScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrganizationCustomPolicyRuleMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrganizationCustomPolicyRuleMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrganizationCustomPolicyRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationCustomPolicyRuleMetadataProperty {
            private final java.lang.String policyText;
            private final java.lang.String runtime;
            private final java.util.List<java.lang.String> debugLogDeliveryAccounts;
            private final java.lang.String description;
            private final java.lang.String inputParameters;
            private final java.lang.String maximumExecutionFrequency;
            private final java.util.List<java.lang.String> organizationConfigRuleTriggerTypes;
            private final java.lang.String resourceIdScope;
            private final java.util.List<java.lang.String> resourceTypesScope;
            private final java.lang.String tagKeyScope;
            private final java.lang.String tagValueScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyText = software.amazon.jsii.Kernel.get(this, "policyText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.debugLogDeliveryAccounts = software.amazon.jsii.Kernel.get(this, "debugLogDeliveryAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationConfigRuleTriggerTypes = software.amazon.jsii.Kernel.get(this, "organizationConfigRuleTriggerTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceIdScope = software.amazon.jsii.Kernel.get(this, "resourceIdScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceTypesScope = software.amazon.jsii.Kernel.get(this, "resourceTypesScope", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagKeyScope = software.amazon.jsii.Kernel.get(this, "tagKeyScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValueScope = software.amazon.jsii.Kernel.get(this, "tagValueScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyText = java.util.Objects.requireNonNull(builder.policyText, "policyText is required");
                this.runtime = java.util.Objects.requireNonNull(builder.runtime, "runtime is required");
                this.debugLogDeliveryAccounts = builder.debugLogDeliveryAccounts;
                this.description = builder.description;
                this.inputParameters = builder.inputParameters;
                this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
                this.organizationConfigRuleTriggerTypes = builder.organizationConfigRuleTriggerTypes;
                this.resourceIdScope = builder.resourceIdScope;
                this.resourceTypesScope = builder.resourceTypesScope;
                this.tagKeyScope = builder.tagKeyScope;
                this.tagValueScope = builder.tagValueScope;
            }

            @Override
            public final java.lang.String getPolicyText() {
                return this.policyText;
            }

            @Override
            public final java.lang.String getRuntime() {
                return this.runtime;
            }

            @Override
            public final java.util.List<java.lang.String> getDebugLogDeliveryAccounts() {
                return this.debugLogDeliveryAccounts;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInputParameters() {
                return this.inputParameters;
            }

            @Override
            public final java.lang.String getMaximumExecutionFrequency() {
                return this.maximumExecutionFrequency;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationConfigRuleTriggerTypes() {
                return this.organizationConfigRuleTriggerTypes;
            }

            @Override
            public final java.lang.String getResourceIdScope() {
                return this.resourceIdScope;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypesScope() {
                return this.resourceTypesScope;
            }

            @Override
            public final java.lang.String getTagKeyScope() {
                return this.tagKeyScope;
            }

            @Override
            public final java.lang.String getTagValueScope() {
                return this.tagValueScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policyText", om.valueToTree(this.getPolicyText()));
                data.set("runtime", om.valueToTree(this.getRuntime()));
                if (this.getDebugLogDeliveryAccounts() != null) {
                    data.set("debugLogDeliveryAccounts", om.valueToTree(this.getDebugLogDeliveryAccounts()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInputParameters() != null) {
                    data.set("inputParameters", om.valueToTree(this.getInputParameters()));
                }
                if (this.getMaximumExecutionFrequency() != null) {
                    data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
                }
                if (this.getOrganizationConfigRuleTriggerTypes() != null) {
                    data.set("organizationConfigRuleTriggerTypes", om.valueToTree(this.getOrganizationConfigRuleTriggerTypes()));
                }
                if (this.getResourceIdScope() != null) {
                    data.set("resourceIdScope", om.valueToTree(this.getResourceIdScope()));
                }
                if (this.getResourceTypesScope() != null) {
                    data.set("resourceTypesScope", om.valueToTree(this.getResourceTypesScope()));
                }
                if (this.getTagKeyScope() != null) {
                    data.set("tagKeyScope", om.valueToTree(this.getTagKeyScope()));
                }
                if (this.getTagValueScope() != null) {
                    data.set("tagValueScope", om.valueToTree(this.getTagValueScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationCustomPolicyRuleMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrganizationCustomPolicyRuleMetadataProperty.Jsii$Proxy that = (OrganizationCustomPolicyRuleMetadataProperty.Jsii$Proxy) o;

                if (!policyText.equals(that.policyText)) return false;
                if (!runtime.equals(that.runtime)) return false;
                if (this.debugLogDeliveryAccounts != null ? !this.debugLogDeliveryAccounts.equals(that.debugLogDeliveryAccounts) : that.debugLogDeliveryAccounts != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
                if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
                if (this.organizationConfigRuleTriggerTypes != null ? !this.organizationConfigRuleTriggerTypes.equals(that.organizationConfigRuleTriggerTypes) : that.organizationConfigRuleTriggerTypes != null) return false;
                if (this.resourceIdScope != null ? !this.resourceIdScope.equals(that.resourceIdScope) : that.resourceIdScope != null) return false;
                if (this.resourceTypesScope != null ? !this.resourceTypesScope.equals(that.resourceTypesScope) : that.resourceTypesScope != null) return false;
                if (this.tagKeyScope != null ? !this.tagKeyScope.equals(that.tagKeyScope) : that.tagKeyScope != null) return false;
                return this.tagValueScope != null ? this.tagValueScope.equals(that.tagValueScope) : that.tagValueScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.policyText.hashCode();
                result = 31 * result + (this.runtime.hashCode());
                result = 31 * result + (this.debugLogDeliveryAccounts != null ? this.debugLogDeliveryAccounts.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
                result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
                result = 31 * result + (this.organizationConfigRuleTriggerTypes != null ? this.organizationConfigRuleTriggerTypes.hashCode() : 0);
                result = 31 * result + (this.resourceIdScope != null ? this.resourceIdScope.hashCode() : 0);
                result = 31 * result + (this.resourceTypesScope != null ? this.resourceTypesScope.hashCode() : 0);
                result = 31 * result + (this.tagKeyScope != null ? this.tagKeyScope.hashCode() : 0);
                result = 31 * result + (this.tagValueScope != null ? this.tagValueScope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies organization custom rule metadata such as resource type, resource ID of AWS resource, Lambda function ARN, and organization trigger types that trigger AWS Config to evaluate your AWS resources against a rule.
     * <p>
     * It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * OrganizationCustomRuleMetadataProperty organizationCustomRuleMetadataProperty = OrganizationCustomRuleMetadataProperty.builder()
     *         .lambdaFunctionArn("lambdaFunctionArn")
     *         .organizationConfigRuleTriggerTypes(List.of("organizationConfigRuleTriggerTypes"))
     *         // the properties below are optional
     *         .description("description")
     *         .inputParameters("inputParameters")
     *         .maximumExecutionFrequency("maximumExecutionFrequency")
     *         .resourceIdScope("resourceIdScope")
     *         .resourceTypesScope(List.of("resourceTypesScope"))
     *         .tagKeyScope("tagKeyScope")
     *         .tagValueScope("tagValueScope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(OrganizationCustomRuleMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrganizationCustomRuleMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The lambda function ARN.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-lambdafunctionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-lambdafunctionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaFunctionArn();

        /**
         * The type of notification that triggers AWS Config to run an evaluation for a rule.
         * <p>
         * You can specify the following notification types:
         * <p>
         * <ul>
         * <li><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
         * <li><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
         * <li><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-organizationconfigruletriggertypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-organizationconfigruletriggertypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOrganizationConfigRuleTriggerTypes();

        /**
         * The description that you provide for your organization AWS Config rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A string, in JSON format, that is passed to your organization AWS Config rule Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-inputparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-inputparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputParameters() {
            return null;
        }

        /**
         * The maximum frequency with which AWS Config runs evaluations for a rule.
         * <p>
         * Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code> .
         * <p>
         * <blockquote>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-maximumexecutionfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-maximumexecutionfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
            return null;
        }

        /**
         * The ID of the AWS resource that was evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-resourceidscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-resourceidscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdScope() {
            return null;
        }

        /**
         * The type of the AWS resource that was evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-resourcetypesscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-resourcetypesscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypesScope() {
            return null;
        }

        /**
         * One part of a key-value pair that make up a tag.
         * <p>
         * A key is a general label that acts like a category for more specific tag values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-tagkeyscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-tagkeyscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKeyScope() {
            return null;
        }

        /**
         * The optional part of a key-value pair that make up a tag.
         * <p>
         * A value acts as a descriptor within a tag category (key).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-tagvaluescope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-tagvaluescope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagValueScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrganizationCustomRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrganizationCustomRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrganizationCustomRuleMetadataProperty> {
            java.lang.String lambdaFunctionArn;
            java.util.List<java.lang.String> organizationConfigRuleTriggerTypes;
            java.lang.String description;
            java.lang.String inputParameters;
            java.lang.String maximumExecutionFrequency;
            java.lang.String resourceIdScope;
            java.util.List<java.lang.String> resourceTypesScope;
            java.lang.String tagKeyScope;
            java.lang.String tagValueScope;

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getLambdaFunctionArn}
             * @param lambdaFunctionArn The lambda function ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionArn(java.lang.String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getOrganizationConfigRuleTriggerTypes}
             * @param organizationConfigRuleTriggerTypes The type of notification that triggers AWS Config to run an evaluation for a rule. This parameter is required.
             *                                           You can specify the following notification types:
             *                                           <p>
             *                                           <ul>
             *                                           <li><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
             *                                           <li><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
             *                                           <li><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code> .</li>
             *                                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationConfigRuleTriggerTypes(java.util.List<java.lang.String> organizationConfigRuleTriggerTypes) {
                this.organizationConfigRuleTriggerTypes = organizationConfigRuleTriggerTypes;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getDescription}
             * @param description The description that you provide for your organization AWS Config rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getInputParameters}
             * @param inputParameters A string, in JSON format, that is passed to your organization AWS Config rule Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParameters(java.lang.String inputParameters) {
                this.inputParameters = inputParameters;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getMaximumExecutionFrequency}
             * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
             *                                  Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code> .
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getResourceIdScope}
             * @param resourceIdScope The ID of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceIdScope(java.lang.String resourceIdScope) {
                this.resourceIdScope = resourceIdScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getResourceTypesScope}
             * @param resourceTypesScope The type of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypesScope(java.util.List<java.lang.String> resourceTypesScope) {
                this.resourceTypesScope = resourceTypesScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getTagKeyScope}
             * @param tagKeyScope One part of a key-value pair that make up a tag.
             *                    A key is a general label that acts like a category for more specific tag values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKeyScope(java.lang.String tagKeyScope) {
                this.tagKeyScope = tagKeyScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getTagValueScope}
             * @param tagValueScope The optional part of a key-value pair that make up a tag.
             *                      A value acts as a descriptor within a tag category (key).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValueScope(java.lang.String tagValueScope) {
                this.tagValueScope = tagValueScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrganizationCustomRuleMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrganizationCustomRuleMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrganizationCustomRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationCustomRuleMetadataProperty {
            private final java.lang.String lambdaFunctionArn;
            private final java.util.List<java.lang.String> organizationConfigRuleTriggerTypes;
            private final java.lang.String description;
            private final java.lang.String inputParameters;
            private final java.lang.String maximumExecutionFrequency;
            private final java.lang.String resourceIdScope;
            private final java.util.List<java.lang.String> resourceTypesScope;
            private final java.lang.String tagKeyScope;
            private final java.lang.String tagValueScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaFunctionArn = software.amazon.jsii.Kernel.get(this, "lambdaFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationConfigRuleTriggerTypes = software.amazon.jsii.Kernel.get(this, "organizationConfigRuleTriggerTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceIdScope = software.amazon.jsii.Kernel.get(this, "resourceIdScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceTypesScope = software.amazon.jsii.Kernel.get(this, "resourceTypesScope", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagKeyScope = software.amazon.jsii.Kernel.get(this, "tagKeyScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValueScope = software.amazon.jsii.Kernel.get(this, "tagValueScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaFunctionArn = java.util.Objects.requireNonNull(builder.lambdaFunctionArn, "lambdaFunctionArn is required");
                this.organizationConfigRuleTriggerTypes = java.util.Objects.requireNonNull(builder.organizationConfigRuleTriggerTypes, "organizationConfigRuleTriggerTypes is required");
                this.description = builder.description;
                this.inputParameters = builder.inputParameters;
                this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
                this.resourceIdScope = builder.resourceIdScope;
                this.resourceTypesScope = builder.resourceTypesScope;
                this.tagKeyScope = builder.tagKeyScope;
                this.tagValueScope = builder.tagValueScope;
            }

            @Override
            public final java.lang.String getLambdaFunctionArn() {
                return this.lambdaFunctionArn;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationConfigRuleTriggerTypes() {
                return this.organizationConfigRuleTriggerTypes;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInputParameters() {
                return this.inputParameters;
            }

            @Override
            public final java.lang.String getMaximumExecutionFrequency() {
                return this.maximumExecutionFrequency;
            }

            @Override
            public final java.lang.String getResourceIdScope() {
                return this.resourceIdScope;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypesScope() {
                return this.resourceTypesScope;
            }

            @Override
            public final java.lang.String getTagKeyScope() {
                return this.tagKeyScope;
            }

            @Override
            public final java.lang.String getTagValueScope() {
                return this.tagValueScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaFunctionArn", om.valueToTree(this.getLambdaFunctionArn()));
                data.set("organizationConfigRuleTriggerTypes", om.valueToTree(this.getOrganizationConfigRuleTriggerTypes()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInputParameters() != null) {
                    data.set("inputParameters", om.valueToTree(this.getInputParameters()));
                }
                if (this.getMaximumExecutionFrequency() != null) {
                    data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
                }
                if (this.getResourceIdScope() != null) {
                    data.set("resourceIdScope", om.valueToTree(this.getResourceIdScope()));
                }
                if (this.getResourceTypesScope() != null) {
                    data.set("resourceTypesScope", om.valueToTree(this.getResourceTypesScope()));
                }
                if (this.getTagKeyScope() != null) {
                    data.set("tagKeyScope", om.valueToTree(this.getTagKeyScope()));
                }
                if (this.getTagValueScope() != null) {
                    data.set("tagValueScope", om.valueToTree(this.getTagValueScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrganizationCustomRuleMetadataProperty.Jsii$Proxy that = (OrganizationCustomRuleMetadataProperty.Jsii$Proxy) o;

                if (!lambdaFunctionArn.equals(that.lambdaFunctionArn)) return false;
                if (!organizationConfigRuleTriggerTypes.equals(that.organizationConfigRuleTriggerTypes)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
                if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
                if (this.resourceIdScope != null ? !this.resourceIdScope.equals(that.resourceIdScope) : that.resourceIdScope != null) return false;
                if (this.resourceTypesScope != null ? !this.resourceTypesScope.equals(that.resourceTypesScope) : that.resourceTypesScope != null) return false;
                if (this.tagKeyScope != null ? !this.tagKeyScope.equals(that.tagKeyScope) : that.tagKeyScope != null) return false;
                return this.tagValueScope != null ? this.tagValueScope.equals(that.tagValueScope) : that.tagValueScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaFunctionArn.hashCode();
                result = 31 * result + (this.organizationConfigRuleTriggerTypes.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
                result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
                result = 31 * result + (this.resourceIdScope != null ? this.resourceIdScope.hashCode() : 0);
                result = 31 * result + (this.resourceTypesScope != null ? this.resourceTypesScope.hashCode() : 0);
                result = 31 * result + (this.tagKeyScope != null ? this.tagKeyScope.hashCode() : 0);
                result = 31 * result + (this.tagValueScope != null ? this.tagValueScope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies organization managed rule metadata such as resource type and ID of AWS resource along with the rule identifier.
     * <p>
     * It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * OrganizationManagedRuleMetadataProperty organizationManagedRuleMetadataProperty = OrganizationManagedRuleMetadataProperty.builder()
     *         .ruleIdentifier("ruleIdentifier")
     *         // the properties below are optional
     *         .description("description")
     *         .inputParameters("inputParameters")
     *         .maximumExecutionFrequency("maximumExecutionFrequency")
     *         .resourceIdScope("resourceIdScope")
     *         .resourceTypesScope(List.of("resourceTypesScope"))
     *         .tagKeyScope("tagKeyScope")
     *         .tagValueScope("tagValueScope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(OrganizationManagedRuleMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrganizationManagedRuleMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For organization config managed rules, a predefined identifier from a list.
         * <p>
         * For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using AWS Config managed rules</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-ruleidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-ruleidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuleIdentifier();

        /**
         * The description that you provide for your organization AWS Config rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A string, in JSON format, that is passed to your organization AWS Config rule Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-inputparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-inputparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputParameters() {
            return null;
        }

        /**
         * The maximum frequency with which AWS Config runs evaluations for a rule.
         * <p>
         * This is for an AWS Config managed rule that is triggered at a periodic frequency.
         * <p>
         * <blockquote>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-maximumexecutionfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-maximumexecutionfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
            return null;
        }

        /**
         * The ID of the AWS resource that was evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-resourceidscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-resourceidscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdScope() {
            return null;
        }

        /**
         * The type of the AWS resource that was evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-resourcetypesscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-resourcetypesscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypesScope() {
            return null;
        }

        /**
         * One part of a key-value pair that make up a tag.
         * <p>
         * A key is a general label that acts like a category for more specific tag values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-tagkeyscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-tagkeyscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKeyScope() {
            return null;
        }

        /**
         * The optional part of a key-value pair that make up a tag.
         * <p>
         * A value acts as a descriptor within a tag category (key).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-tagvaluescope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-tagvaluescope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagValueScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrganizationManagedRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrganizationManagedRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrganizationManagedRuleMetadataProperty> {
            java.lang.String ruleIdentifier;
            java.lang.String description;
            java.lang.String inputParameters;
            java.lang.String maximumExecutionFrequency;
            java.lang.String resourceIdScope;
            java.util.List<java.lang.String> resourceTypesScope;
            java.lang.String tagKeyScope;
            java.lang.String tagValueScope;

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getRuleIdentifier}
             * @param ruleIdentifier For organization config managed rules, a predefined identifier from a list. This parameter is required.
             *                       For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using AWS Config managed rules</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleIdentifier(java.lang.String ruleIdentifier) {
                this.ruleIdentifier = ruleIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getDescription}
             * @param description The description that you provide for your organization AWS Config rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getInputParameters}
             * @param inputParameters A string, in JSON format, that is passed to your organization AWS Config rule Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParameters(java.lang.String inputParameters) {
                this.inputParameters = inputParameters;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getMaximumExecutionFrequency}
             * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
             *                                  This is for an AWS Config managed rule that is triggered at a periodic frequency.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getResourceIdScope}
             * @param resourceIdScope The ID of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceIdScope(java.lang.String resourceIdScope) {
                this.resourceIdScope = resourceIdScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getResourceTypesScope}
             * @param resourceTypesScope The type of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypesScope(java.util.List<java.lang.String> resourceTypesScope) {
                this.resourceTypesScope = resourceTypesScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getTagKeyScope}
             * @param tagKeyScope One part of a key-value pair that make up a tag.
             *                    A key is a general label that acts like a category for more specific tag values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKeyScope(java.lang.String tagKeyScope) {
                this.tagKeyScope = tagKeyScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getTagValueScope}
             * @param tagValueScope The optional part of a key-value pair that make up a tag.
             *                      A value acts as a descriptor within a tag category (key).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValueScope(java.lang.String tagValueScope) {
                this.tagValueScope = tagValueScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrganizationManagedRuleMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrganizationManagedRuleMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrganizationManagedRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationManagedRuleMetadataProperty {
            private final java.lang.String ruleIdentifier;
            private final java.lang.String description;
            private final java.lang.String inputParameters;
            private final java.lang.String maximumExecutionFrequency;
            private final java.lang.String resourceIdScope;
            private final java.util.List<java.lang.String> resourceTypesScope;
            private final java.lang.String tagKeyScope;
            private final java.lang.String tagValueScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleIdentifier = software.amazon.jsii.Kernel.get(this, "ruleIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceIdScope = software.amazon.jsii.Kernel.get(this, "resourceIdScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceTypesScope = software.amazon.jsii.Kernel.get(this, "resourceTypesScope", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagKeyScope = software.amazon.jsii.Kernel.get(this, "tagKeyScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValueScope = software.amazon.jsii.Kernel.get(this, "tagValueScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleIdentifier = java.util.Objects.requireNonNull(builder.ruleIdentifier, "ruleIdentifier is required");
                this.description = builder.description;
                this.inputParameters = builder.inputParameters;
                this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
                this.resourceIdScope = builder.resourceIdScope;
                this.resourceTypesScope = builder.resourceTypesScope;
                this.tagKeyScope = builder.tagKeyScope;
                this.tagValueScope = builder.tagValueScope;
            }

            @Override
            public final java.lang.String getRuleIdentifier() {
                return this.ruleIdentifier;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInputParameters() {
                return this.inputParameters;
            }

            @Override
            public final java.lang.String getMaximumExecutionFrequency() {
                return this.maximumExecutionFrequency;
            }

            @Override
            public final java.lang.String getResourceIdScope() {
                return this.resourceIdScope;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypesScope() {
                return this.resourceTypesScope;
            }

            @Override
            public final java.lang.String getTagKeyScope() {
                return this.tagKeyScope;
            }

            @Override
            public final java.lang.String getTagValueScope() {
                return this.tagValueScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ruleIdentifier", om.valueToTree(this.getRuleIdentifier()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInputParameters() != null) {
                    data.set("inputParameters", om.valueToTree(this.getInputParameters()));
                }
                if (this.getMaximumExecutionFrequency() != null) {
                    data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
                }
                if (this.getResourceIdScope() != null) {
                    data.set("resourceIdScope", om.valueToTree(this.getResourceIdScope()));
                }
                if (this.getResourceTypesScope() != null) {
                    data.set("resourceTypesScope", om.valueToTree(this.getResourceTypesScope()));
                }
                if (this.getTagKeyScope() != null) {
                    data.set("tagKeyScope", om.valueToTree(this.getTagKeyScope()));
                }
                if (this.getTagValueScope() != null) {
                    data.set("tagValueScope", om.valueToTree(this.getTagValueScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrganizationManagedRuleMetadataProperty.Jsii$Proxy that = (OrganizationManagedRuleMetadataProperty.Jsii$Proxy) o;

                if (!ruleIdentifier.equals(that.ruleIdentifier)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
                if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
                if (this.resourceIdScope != null ? !this.resourceIdScope.equals(that.resourceIdScope) : that.resourceIdScope != null) return false;
                if (this.resourceTypesScope != null ? !this.resourceTypesScope.equals(that.resourceTypesScope) : that.resourceTypesScope != null) return false;
                if (this.tagKeyScope != null ? !this.tagKeyScope.equals(that.tagKeyScope) : that.tagKeyScope != null) return false;
                return this.tagValueScope != null ? this.tagValueScope.equals(that.tagValueScope) : that.tagValueScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ruleIdentifier.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
                result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
                result = 31 * result + (this.resourceIdScope != null ? this.resourceIdScope.hashCode() : 0);
                result = 31 * result + (this.resourceTypesScope != null ? this.resourceTypesScope.hashCode() : 0);
                result = 31 * result + (this.tagKeyScope != null ? this.tagKeyScope.hashCode() : 0);
                result = 31 * result + (this.tagValueScope != null ? this.tagValueScope.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CfnOrganizationConfigRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CfnOrganizationConfigRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.config.CfnOrganizationConfigRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.config.CfnOrganizationConfigRuleProps.Builder();
        }

        /**
         * The name that you assign to organization AWS Config rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationconfigrulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationconfigrulename</a>
         * @param organizationConfigRuleName The name that you assign to organization AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationConfigRuleName(final java.lang.String organizationConfigRuleName) {
            this.props.organizationConfigRuleName(organizationConfigRuleName);
            return this;
        }

        /**
         * A comma-separated list of accounts excluded from organization AWS Config rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-excludedaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-excludedaccounts</a>
         * @param excludedAccounts A comma-separated list of accounts excluded from organization AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludedAccounts(final java.util.List<java.lang.String> excludedAccounts) {
            this.props.excludedAccounts(excludedAccounts);
            return this;
        }

        /**
         * An object that specifies metadata for your organization's AWS Config Custom Policy rule.
         * <p>
         * The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of AWS resource, and organization trigger types that initiate AWS Config to evaluate AWS resources against a rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata</a>
         * @param organizationCustomPolicyRuleMetadata An object that specifies metadata for your organization's AWS Config Custom Policy rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationCustomPolicyRuleMetadata(final software.amazon.awscdk.IResolvable organizationCustomPolicyRuleMetadata) {
            this.props.organizationCustomPolicyRuleMetadata(organizationCustomPolicyRuleMetadata);
            return this;
        }
        /**
         * An object that specifies metadata for your organization's AWS Config Custom Policy rule.
         * <p>
         * The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of AWS resource, and organization trigger types that initiate AWS Config to evaluate AWS resources against a rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustompolicyrulemetadata</a>
         * @param organizationCustomPolicyRuleMetadata An object that specifies metadata for your organization's AWS Config Custom Policy rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationCustomPolicyRuleMetadata(final software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomPolicyRuleMetadataProperty organizationCustomPolicyRuleMetadata) {
            this.props.organizationCustomPolicyRuleMetadata(organizationCustomPolicyRuleMetadata);
            return this;
        }

        /**
         * An <code>OrganizationCustomRuleMetadata</code> object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata</a>
         * @param organizationCustomRuleMetadata An <code>OrganizationCustomRuleMetadata</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationCustomRuleMetadata(final software.amazon.awscdk.IResolvable organizationCustomRuleMetadata) {
            this.props.organizationCustomRuleMetadata(organizationCustomRuleMetadata);
            return this;
        }
        /**
         * An <code>OrganizationCustomRuleMetadata</code> object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata</a>
         * @param organizationCustomRuleMetadata An <code>OrganizationCustomRuleMetadata</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationCustomRuleMetadata(final software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty organizationCustomRuleMetadata) {
            this.props.organizationCustomRuleMetadata(organizationCustomRuleMetadata);
            return this;
        }

        /**
         * An <code>OrganizationManagedRuleMetadata</code> object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata</a>
         * @param organizationManagedRuleMetadata An <code>OrganizationManagedRuleMetadata</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationManagedRuleMetadata(final software.amazon.awscdk.IResolvable organizationManagedRuleMetadata) {
            this.props.organizationManagedRuleMetadata(organizationManagedRuleMetadata);
            return this;
        }
        /**
         * An <code>OrganizationManagedRuleMetadata</code> object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata</a>
         * @param organizationManagedRuleMetadata An <code>OrganizationManagedRuleMetadata</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationManagedRuleMetadata(final software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty organizationManagedRuleMetadata) {
            this.props.organizationManagedRuleMetadata(organizationManagedRuleMetadata);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.config.CfnOrganizationConfigRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CfnOrganizationConfigRule build() {
            return new software.amazon.awscdk.services.config.CfnOrganizationConfigRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
