package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnProject</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnProjectProps cfnProjectProps = CfnProjectProps.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .domainUnitId("domainUnitId")
 *         .glossaryTerms(List.of("glossaryTerms"))
 *         .projectProfileId("projectProfileId")
 *         .projectProfileVersion("projectProfileVersion")
 *         .userParameters(List.of(EnvironmentConfigurationUserParameterProperty.builder()
 *                 .environmentConfigurationName("environmentConfigurationName")
 *                 .environmentId("environmentId")
 *                 .environmentParameters(List.of(EnvironmentParameterProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:12.592Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnProjectProps")
@software.amazon.jsii.Jsii.Proxy(CfnProjectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProjectProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of a Amazon DataZone domain where the project exists.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The name of a project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The description of a project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ID of the domain unit.
     * <p>
     * This parameter is not required and if it is not specified, then the project is created at the root domain unit level.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-domainunitid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-domainunitid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainUnitId() {
        return null;
    }

    /**
     * The glossary terms that can be used in this Amazon DataZone project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-glossaryterms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-glossaryterms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGlossaryTerms() {
        return null;
    }

    /**
     * The project profile ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-projectprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-projectprofileid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectProfileId() {
        return null;
    }

    /**
     * The project profile version to which the project should be updated.
     * <p>
     * You can only specify the following string for this parameter: latest.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-projectprofileversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-projectprofileversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectProfileVersion() {
        return null;
    }

    /**
     * The user parameters of the project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-userparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-project.html#cfn-datazone-project-userparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProjectProps> {
        java.lang.String domainIdentifier;
        java.lang.String name;
        java.lang.String description;
        java.lang.String domainUnitId;
        java.util.List<java.lang.String> glossaryTerms;
        java.lang.String projectProfileId;
        java.lang.String projectProfileVersion;
        java.lang.Object userParameters;

        /**
         * Sets the value of {@link CfnProjectProps#getDomainIdentifier}
         * @param domainIdentifier The identifier of a Amazon DataZone domain where the project exists. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getName}
         * @param name The name of a project. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getDescription}
         * @param description The description of a project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getDomainUnitId}
         * @param domainUnitId The ID of the domain unit.
         *                     This parameter is not required and if it is not specified, then the project is created at the root domain unit level.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainUnitId(java.lang.String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getGlossaryTerms}
         * @param glossaryTerms The glossary terms that can be used in this Amazon DataZone project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder glossaryTerms(java.util.List<java.lang.String> glossaryTerms) {
            this.glossaryTerms = glossaryTerms;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getProjectProfileId}
         * @param projectProfileId The project profile ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectProfileId(java.lang.String projectProfileId) {
            this.projectProfileId = projectProfileId;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getProjectProfileVersion}
         * @param projectProfileVersion The project profile version to which the project should be updated.
         *                              You can only specify the following string for this parameter: latest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectProfileVersion(java.lang.String projectProfileVersion) {
            this.projectProfileVersion = projectProfileVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getUserParameters}
         * @param userParameters The user parameters of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userParameters(software.amazon.awscdk.IResolvable userParameters) {
            this.userParameters = userParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getUserParameters}
         * @param userParameters The user parameters of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userParameters(java.util.List<? extends java.lang.Object> userParameters) {
            this.userParameters = userParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProjectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProjectProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProjectProps {
        private final java.lang.String domainIdentifier;
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.lang.String domainUnitId;
        private final java.util.List<java.lang.String> glossaryTerms;
        private final java.lang.String projectProfileId;
        private final java.lang.String projectProfileVersion;
        private final java.lang.Object userParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainUnitId = software.amazon.jsii.Kernel.get(this, "domainUnitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.glossaryTerms = software.amazon.jsii.Kernel.get(this, "glossaryTerms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.projectProfileId = software.amazon.jsii.Kernel.get(this, "projectProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectProfileVersion = software.amazon.jsii.Kernel.get(this, "projectProfileVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userParameters = software.amazon.jsii.Kernel.get(this, "userParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.domainUnitId = builder.domainUnitId;
            this.glossaryTerms = builder.glossaryTerms;
            this.projectProfileId = builder.projectProfileId;
            this.projectProfileVersion = builder.projectProfileVersion;
            this.userParameters = builder.userParameters;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDomainUnitId() {
            return this.domainUnitId;
        }

        @Override
        public final java.util.List<java.lang.String> getGlossaryTerms() {
            return this.glossaryTerms;
        }

        @Override
        public final java.lang.String getProjectProfileId() {
            return this.projectProfileId;
        }

        @Override
        public final java.lang.String getProjectProfileVersion() {
            return this.projectProfileVersion;
        }

        @Override
        public final java.lang.Object getUserParameters() {
            return this.userParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDomainUnitId() != null) {
                data.set("domainUnitId", om.valueToTree(this.getDomainUnitId()));
            }
            if (this.getGlossaryTerms() != null) {
                data.set("glossaryTerms", om.valueToTree(this.getGlossaryTerms()));
            }
            if (this.getProjectProfileId() != null) {
                data.set("projectProfileId", om.valueToTree(this.getProjectProfileId()));
            }
            if (this.getProjectProfileVersion() != null) {
                data.set("projectProfileVersion", om.valueToTree(this.getProjectProfileVersion()));
            }
            if (this.getUserParameters() != null) {
                data.set("userParameters", om.valueToTree(this.getUserParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnProjectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProjectProps.Jsii$Proxy that = (CfnProjectProps.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.domainUnitId != null ? !this.domainUnitId.equals(that.domainUnitId) : that.domainUnitId != null) return false;
            if (this.glossaryTerms != null ? !this.glossaryTerms.equals(that.glossaryTerms) : that.glossaryTerms != null) return false;
            if (this.projectProfileId != null ? !this.projectProfileId.equals(that.projectProfileId) : that.projectProfileId != null) return false;
            if (this.projectProfileVersion != null ? !this.projectProfileVersion.equals(that.projectProfileVersion) : that.projectProfileVersion != null) return false;
            return this.userParameters != null ? this.userParameters.equals(that.userParameters) : that.userParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.domainUnitId != null ? this.domainUnitId.hashCode() : 0);
            result = 31 * result + (this.glossaryTerms != null ? this.glossaryTerms.hashCode() : 0);
            result = 31 * result + (this.projectProfileId != null ? this.projectProfileId.hashCode() : 0);
            result = 31 * result + (this.projectProfileVersion != null ? this.projectProfileVersion.hashCode() : 0);
            result = 31 * result + (this.userParameters != null ? this.userParameters.hashCode() : 0);
            return result;
        }
    }
}
