package software.amazon.awscdk.services.ec2;

/**
 * Properties of a LaunchTemplate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup sg1 = SecurityGroup.Builder.create(this, "sg1")
 *         .vpc(vpc)
 *         .build();
 * SecurityGroup sg2 = SecurityGroup.Builder.create(this, "sg2")
 *         .vpc(vpc)
 *         .build();
 * LaunchTemplate launchTemplate = LaunchTemplate.Builder.create(this, "LaunchTemplate")
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .securityGroup(sg1)
 *         .build();
 * launchTemplate.addSecurityGroup(sg2);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:13.636Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.LaunchTemplateProps")
@software.amazon.jsii.Jsii.Proxy(LaunchTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LaunchTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether instances should have a public IP addresses associated with them.
     * <p>
     * Default: - Use subnet settings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssociatePublicIpAddress() {
        return null;
    }

    /**
     * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     * <p>
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     * <p>
     * Default: - Uses the block device mapping of the AMI
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
        return null;
    }

    /**
     * CPU credit type for burstable EC2 instance types.
     * <p>
     * Default: - No credit type is specified in the Launch Template.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CpuCredits getCpuCredits() {
        return null;
    }

    /**
     * If set to true, then detailed monitoring will be enabled on instances created with this launch template.
     * <p>
     * Default: False - Detailed monitoring is disabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDetailedMonitoring() {
        return null;
    }

    /**
     * If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;
     * <p>
     * otherwise, you can.
     * <p>
     * Default: - The API termination setting is not specified in the Launch Template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableApiTermination() {
        return null;
    }

    /**
     * Indicates whether the instances are optimized for Amazon EBS I/O.
     * <p>
     * This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization
     * isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * <p>
     * Default: - EBS optimization is not specified in the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEbsOptimized() {
        return null;
    }

    /**
     * If you set this parameter to true, the instance is enabled for hibernation.
     * <p>
     * Default: - Hibernation configuration is not specified in the launch template; defaulting to false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHibernationConfigured() {
        return null;
    }

    /**
     * Enables or disables the HTTP metadata endpoint on your instances.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpendpoint">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHttpEndpoint() {
        return null;
    }

    /**
     * Enables or disables the IPv6 endpoint for the instance metadata service.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpprotocolipv6">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpprotocolipv6</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHttpProtocolIpv6() {
        return null;
    }

    /**
     * The desired HTTP PUT response hop limit for instance metadata requests.
     * <p>
     * The larger the number, the further instance metadata requests can travel.
     * <p>
     * Default: 1
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpputresponsehoplimit">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpputresponsehoplimit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPutResponseHopLimit() {
        return null;
    }

    /**
     * The state of token usage for your instance metadata requests.
     * <p>
     * The default state is <code>optional</code> if not specified. However,
     * if requireImdsv2 is true, the state must be <code>required</code>.
     * <p>
     * Default: LaunchTemplateHttpTokens.OPTIONAL
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.LaunchTemplateHttpTokens getHttpTokens() {
        return null;
    }

    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     * <p>
     * Default: - Shutdown behavior is not specified in the launch template; defaults to STOP.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior getInstanceInitiatedShutdownBehavior() {
        return null;
    }

    /**
     * Set to enabled to allow access to instance tags from the instance metadata.
     * <p>
     * Set to disabled to turn off access to instance tags from the instance metadata.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-instancemetadatatags">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-instancemetadatatags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInstanceMetadataTags() {
        return null;
    }

    /**
     * The instance profile used to pass role information to EC2 instances.
     * <p>
     * Note: You can provide an instanceProfile or a role, but not both.
     * <p>
     * Default: - No instance profile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IInstanceProfile getInstanceProfile() {
        return null;
    }

    /**
     * Type of instance to launch.
     * <p>
     * Default: - This Launch Template does not specify a default Instance Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * (deprecated) Name of SSH keypair to grant access to instance.
     * <p>
     * Default: - No SSH access will be possible.
     * <p>
     * @deprecated <ul>
     * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * The SSH keypair to grant access to the instance.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
        return null;
    }

    /**
     * Name for this launch template.
     * <p>
     * Default: Automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
        return null;
    }

    /**
     * The AMI that will be used by instances.
     * <p>
     * Default: - This Launch Template does not specify a default AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
        return null;
    }

    /**
     * If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;
     * <p>
     * otherwise, it is not enabled for AWS Nitro Enclaves.
     * <p>
     * Default: - Enablement of Nitro enclaves is not specified in the launch template; defaulting to false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNitroEnclaveEnabled() {
        return null;
    }

    /**
     * The placement group that you want to launch the instance into.
     * <p>
     * Default: - no placement group will be used for this launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IPlacementGroup getPlacementGroup() {
        return null;
    }

    /**
     * Whether IMDSv2 should be required on launched instances.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireImdsv2() {
        return null;
    }

    /**
     * An IAM role to associate with the instance profile that is used by instances.
     * <p>
     * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>.
     * Note: You can provide an instanceProfile or a role, but not both.
     * <p>
     * Default: - No new role is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Role role = Role.Builder.create(this, "MyRole")
     *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Security group to assign to instances created with the launch template.
     * <p>
     * Default: No security group is assigned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined.
     * <p>
     * Default: - Instance launched with this template will not be spot instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions getSpotOptions() {
        return null;
    }

    /**
     * The user data to make available to the instance.
     * <p>
     * Default: - This Launch Template creates a UserData based on the type of provided
     * machineImage; no UserData is created if a machineImage is not provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * A description for the first version of the launch template.
     * <p>
     * The version description must be maximum 255 characters long.
     * <p>
     * Default: - No description
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-versiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-versiondescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LaunchTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateProps> {
        java.lang.Boolean associatePublicIpAddress;
        java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        software.amazon.awscdk.services.ec2.CpuCredits cpuCredits;
        java.lang.Boolean detailedMonitoring;
        java.lang.Boolean disableApiTermination;
        java.lang.Boolean ebsOptimized;
        java.lang.Boolean hibernationConfigured;
        java.lang.Boolean httpEndpoint;
        java.lang.Boolean httpProtocolIpv6;
        java.lang.Number httpPutResponseHopLimit;
        software.amazon.awscdk.services.ec2.LaunchTemplateHttpTokens httpTokens;
        software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior;
        java.lang.Boolean instanceMetadataTags;
        software.amazon.awscdk.services.iam.IInstanceProfile instanceProfile;
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        java.lang.String keyName;
        software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        java.lang.String launchTemplateName;
        software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        java.lang.Boolean nitroEnclaveEnabled;
        software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup;
        java.lang.Boolean requireImdsv2;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions spotOptions;
        software.amazon.awscdk.services.ec2.UserData userData;
        java.lang.String versionDescription;

        /**
         * Sets the value of {@link LaunchTemplateProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Whether instances should have a public IP addresses associated with them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder blockDevices(java.util.List<? extends software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.ec2.BlockDevice>)blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getCpuCredits}
         * @param cpuCredits CPU credit type for burstable EC2 instance types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuCredits(software.amazon.awscdk.services.ec2.CpuCredits cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getDetailedMonitoring}
         * @param detailedMonitoring If set to true, then detailed monitoring will be enabled on instances created with this launch template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMonitoring(java.lang.Boolean detailedMonitoring) {
            this.detailedMonitoring = detailedMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getDisableApiTermination}
         * @param disableApiTermination If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;.
         *                              otherwise, you can.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(java.lang.Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getEbsOptimized}
         * @param ebsOptimized Indicates whether the instances are optimized for Amazon EBS I/O.
         *                     This optimization provides dedicated throughput
         *                     to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization
         *                     isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getHibernationConfigured}
         * @param hibernationConfigured If you set this parameter to true, the instance is enabled for hibernation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationConfigured(java.lang.Boolean hibernationConfigured) {
            this.hibernationConfigured = hibernationConfigured;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getHttpEndpoint}
         * @param httpEndpoint Enables or disables the HTTP metadata endpoint on your instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpEndpoint(java.lang.Boolean httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getHttpProtocolIpv6}
         * @param httpProtocolIpv6 Enables or disables the IPv6 endpoint for the instance metadata service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpProtocolIpv6(java.lang.Boolean httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getHttpPutResponseHopLimit}
         * @param httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests.
         *                                The larger the number, the further instance metadata requests can travel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPutResponseHopLimit(java.lang.Number httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getHttpTokens}
         * @param httpTokens The state of token usage for your instance metadata requests.
         *                   The default state is <code>optional</code> if not specified. However,
         *                   if requireImdsv2 is true, the state must be <code>required</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpTokens(software.amazon.awscdk.services.ec2.LaunchTemplateHttpTokens httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getInstanceInitiatedShutdownBehavior}
         * @param instanceInitiatedShutdownBehavior Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInitiatedShutdownBehavior(software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getInstanceMetadataTags}
         * @param instanceMetadataTags Set to enabled to allow access to instance tags from the instance metadata.
         *                             Set to disabled to turn off access to instance tags from the instance metadata.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMetadataTags(java.lang.Boolean instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getInstanceProfile}
         * @param instanceProfile The instance profile used to pass role information to EC2 instances.
         *                        Note: You can provide an instanceProfile or a role, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfile(software.amazon.awscdk.services.iam.IInstanceProfile instanceProfile) {
            this.instanceProfile = instanceProfile;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getInstanceType}
         * @param instanceType Type of instance to launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         * @deprecated - Use `keyPair` instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getKeyPair}
         * @param keyPair The SSH keypair to grant access to the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getLaunchTemplateName}
         * @param launchTemplateName Name for this launch template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateName(java.lang.String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getMachineImage}
         * @param machineImage The AMI that will be used by instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getNitroEnclaveEnabled}
         * @param nitroEnclaveEnabled If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;.
         *                            otherwise, it is not enabled for AWS Nitro Enclaves.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nitroEnclaveEnabled(java.lang.Boolean nitroEnclaveEnabled) {
            this.nitroEnclaveEnabled = nitroEnclaveEnabled;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getPlacementGroup}
         * @param placementGroup The placement group that you want to launch the instance into.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroup(software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getRequireImdsv2}
         * @param requireImdsv2 Whether IMDSv2 should be required on launched instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireImdsv2(java.lang.Boolean requireImdsv2) {
            this.requireImdsv2 = requireImdsv2;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getRole}
         * @param role An IAM role to associate with the instance profile that is used by instances.
         *             The role must be assumable by the service principal <code>ec2.amazonaws.com</code>.
         *             Note: You can provide an instanceProfile or a role, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getSecurityGroup}
         * @param securityGroup Security group to assign to instances created with the launch template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getSpotOptions}
         * @param spotOptions If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getUserData}
         * @param userData The user data to make available to the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getVersionDescription}
         * @param versionDescription A description for the first version of the launch template.
         *                           The version description must be maximum 255 characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(java.lang.String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LaunchTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LaunchTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateProps {
        private final java.lang.Boolean associatePublicIpAddress;
        private final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        private final software.amazon.awscdk.services.ec2.CpuCredits cpuCredits;
        private final java.lang.Boolean detailedMonitoring;
        private final java.lang.Boolean disableApiTermination;
        private final java.lang.Boolean ebsOptimized;
        private final java.lang.Boolean hibernationConfigured;
        private final java.lang.Boolean httpEndpoint;
        private final java.lang.Boolean httpProtocolIpv6;
        private final java.lang.Number httpPutResponseHopLimit;
        private final software.amazon.awscdk.services.ec2.LaunchTemplateHttpTokens httpTokens;
        private final software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior;
        private final java.lang.Boolean instanceMetadataTags;
        private final software.amazon.awscdk.services.iam.IInstanceProfile instanceProfile;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.String keyName;
        private final software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        private final java.lang.String launchTemplateName;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final java.lang.Boolean nitroEnclaveEnabled;
        private final software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup;
        private final java.lang.Boolean requireImdsv2;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions spotOptions;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final java.lang.String versionDescription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.blockDevices = software.amazon.jsii.Kernel.get(this, "blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDevice.class)));
            this.cpuCredits = software.amazon.jsii.Kernel.get(this, "cpuCredits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CpuCredits.class));
            this.detailedMonitoring = software.amazon.jsii.Kernel.get(this, "detailedMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.disableApiTermination = software.amazon.jsii.Kernel.get(this, "disableApiTermination", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.hibernationConfigured = software.amazon.jsii.Kernel.get(this, "hibernationConfigured", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.httpEndpoint = software.amazon.jsii.Kernel.get(this, "httpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.httpProtocolIpv6 = software.amazon.jsii.Kernel.get(this, "httpProtocolIpv6", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.httpPutResponseHopLimit = software.amazon.jsii.Kernel.get(this, "httpPutResponseHopLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.httpTokens = software.amazon.jsii.Kernel.get(this, "httpTokens", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LaunchTemplateHttpTokens.class));
            this.instanceInitiatedShutdownBehavior = software.amazon.jsii.Kernel.get(this, "instanceInitiatedShutdownBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior.class));
            this.instanceMetadataTags = software.amazon.jsii.Kernel.get(this, "instanceMetadataTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceProfile = software.amazon.jsii.Kernel.get(this, "instanceProfile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IInstanceProfile.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyPair = software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IKeyPair.class));
            this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.machineImage = software.amazon.jsii.Kernel.get(this, "machineImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.nitroEnclaveEnabled = software.amazon.jsii.Kernel.get(this, "nitroEnclaveEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.placementGroup = software.amazon.jsii.Kernel.get(this, "placementGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPlacementGroup.class));
            this.requireImdsv2 = software.amazon.jsii.Kernel.get(this, "requireImdsv2", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.spotOptions = software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
            this.versionDescription = software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.associatePublicIpAddress = builder.associatePublicIpAddress;
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.ec2.BlockDevice>)builder.blockDevices;
            this.cpuCredits = builder.cpuCredits;
            this.detailedMonitoring = builder.detailedMonitoring;
            this.disableApiTermination = builder.disableApiTermination;
            this.ebsOptimized = builder.ebsOptimized;
            this.hibernationConfigured = builder.hibernationConfigured;
            this.httpEndpoint = builder.httpEndpoint;
            this.httpProtocolIpv6 = builder.httpProtocolIpv6;
            this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
            this.httpTokens = builder.httpTokens;
            this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
            this.instanceMetadataTags = builder.instanceMetadataTags;
            this.instanceProfile = builder.instanceProfile;
            this.instanceType = builder.instanceType;
            this.keyName = builder.keyName;
            this.keyPair = builder.keyPair;
            this.launchTemplateName = builder.launchTemplateName;
            this.machineImage = builder.machineImage;
            this.nitroEnclaveEnabled = builder.nitroEnclaveEnabled;
            this.placementGroup = builder.placementGroup;
            this.requireImdsv2 = builder.requireImdsv2;
            this.role = builder.role;
            this.securityGroup = builder.securityGroup;
            this.spotOptions = builder.spotOptions;
            this.userData = builder.userData;
            this.versionDescription = builder.versionDescription;
        }

        @Override
        public final java.lang.Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.CpuCredits getCpuCredits() {
            return this.cpuCredits;
        }

        @Override
        public final java.lang.Boolean getDetailedMonitoring() {
            return this.detailedMonitoring;
        }

        @Override
        public final java.lang.Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final java.lang.Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final java.lang.Boolean getHibernationConfigured() {
            return this.hibernationConfigured;
        }

        @Override
        public final java.lang.Boolean getHttpEndpoint() {
            return this.httpEndpoint;
        }

        @Override
        public final java.lang.Boolean getHttpProtocolIpv6() {
            return this.httpProtocolIpv6;
        }

        @Override
        public final java.lang.Number getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.LaunchTemplateHttpTokens getHttpTokens() {
            return this.httpTokens;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final java.lang.Boolean getInstanceMetadataTags() {
            return this.instanceMetadataTags;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IInstanceProfile getInstanceProfile() {
            return this.instanceProfile;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final java.lang.String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public final java.lang.Boolean getNitroEnclaveEnabled() {
            return this.nitroEnclaveEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IPlacementGroup getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final java.lang.Boolean getRequireImdsv2() {
            return this.requireImdsv2;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions getSpotOptions() {
            return this.spotOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public final java.lang.String getVersionDescription() {
            return this.versionDescription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getCpuCredits() != null) {
                data.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
            }
            if (this.getDetailedMonitoring() != null) {
                data.set("detailedMonitoring", om.valueToTree(this.getDetailedMonitoring()));
            }
            if (this.getDisableApiTermination() != null) {
                data.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
            }
            if (this.getEbsOptimized() != null) {
                data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
            }
            if (this.getHibernationConfigured() != null) {
                data.set("hibernationConfigured", om.valueToTree(this.getHibernationConfigured()));
            }
            if (this.getHttpEndpoint() != null) {
                data.set("httpEndpoint", om.valueToTree(this.getHttpEndpoint()));
            }
            if (this.getHttpProtocolIpv6() != null) {
                data.set("httpProtocolIpv6", om.valueToTree(this.getHttpProtocolIpv6()));
            }
            if (this.getHttpPutResponseHopLimit() != null) {
                data.set("httpPutResponseHopLimit", om.valueToTree(this.getHttpPutResponseHopLimit()));
            }
            if (this.getHttpTokens() != null) {
                data.set("httpTokens", om.valueToTree(this.getHttpTokens()));
            }
            if (this.getInstanceInitiatedShutdownBehavior() != null) {
                data.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
            }
            if (this.getInstanceMetadataTags() != null) {
                data.set("instanceMetadataTags", om.valueToTree(this.getInstanceMetadataTags()));
            }
            if (this.getInstanceProfile() != null) {
                data.set("instanceProfile", om.valueToTree(this.getInstanceProfile()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getKeyPair() != null) {
                data.set("keyPair", om.valueToTree(this.getKeyPair()));
            }
            if (this.getLaunchTemplateName() != null) {
                data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
            }
            if (this.getMachineImage() != null) {
                data.set("machineImage", om.valueToTree(this.getMachineImage()));
            }
            if (this.getNitroEnclaveEnabled() != null) {
                data.set("nitroEnclaveEnabled", om.valueToTree(this.getNitroEnclaveEnabled()));
            }
            if (this.getPlacementGroup() != null) {
                data.set("placementGroup", om.valueToTree(this.getPlacementGroup()));
            }
            if (this.getRequireImdsv2() != null) {
                data.set("requireImdsv2", om.valueToTree(this.getRequireImdsv2()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSpotOptions() != null) {
                data.set("spotOptions", om.valueToTree(this.getSpotOptions()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getVersionDescription() != null) {
                data.set("versionDescription", om.valueToTree(this.getVersionDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.LaunchTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchTemplateProps.Jsii$Proxy that = (LaunchTemplateProps.Jsii$Proxy) o;

            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.cpuCredits != null ? !this.cpuCredits.equals(that.cpuCredits) : that.cpuCredits != null) return false;
            if (this.detailedMonitoring != null ? !this.detailedMonitoring.equals(that.detailedMonitoring) : that.detailedMonitoring != null) return false;
            if (this.disableApiTermination != null ? !this.disableApiTermination.equals(that.disableApiTermination) : that.disableApiTermination != null) return false;
            if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
            if (this.hibernationConfigured != null ? !this.hibernationConfigured.equals(that.hibernationConfigured) : that.hibernationConfigured != null) return false;
            if (this.httpEndpoint != null ? !this.httpEndpoint.equals(that.httpEndpoint) : that.httpEndpoint != null) return false;
            if (this.httpProtocolIpv6 != null ? !this.httpProtocolIpv6.equals(that.httpProtocolIpv6) : that.httpProtocolIpv6 != null) return false;
            if (this.httpPutResponseHopLimit != null ? !this.httpPutResponseHopLimit.equals(that.httpPutResponseHopLimit) : that.httpPutResponseHopLimit != null) return false;
            if (this.httpTokens != null ? !this.httpTokens.equals(that.httpTokens) : that.httpTokens != null) return false;
            if (this.instanceInitiatedShutdownBehavior != null ? !this.instanceInitiatedShutdownBehavior.equals(that.instanceInitiatedShutdownBehavior) : that.instanceInitiatedShutdownBehavior != null) return false;
            if (this.instanceMetadataTags != null ? !this.instanceMetadataTags.equals(that.instanceMetadataTags) : that.instanceMetadataTags != null) return false;
            if (this.instanceProfile != null ? !this.instanceProfile.equals(that.instanceProfile) : that.instanceProfile != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.keyPair != null ? !this.keyPair.equals(that.keyPair) : that.keyPair != null) return false;
            if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
            if (this.machineImage != null ? !this.machineImage.equals(that.machineImage) : that.machineImage != null) return false;
            if (this.nitroEnclaveEnabled != null ? !this.nitroEnclaveEnabled.equals(that.nitroEnclaveEnabled) : that.nitroEnclaveEnabled != null) return false;
            if (this.placementGroup != null ? !this.placementGroup.equals(that.placementGroup) : that.placementGroup != null) return false;
            if (this.requireImdsv2 != null ? !this.requireImdsv2.equals(that.requireImdsv2) : that.requireImdsv2 != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.spotOptions != null ? !this.spotOptions.equals(that.spotOptions) : that.spotOptions != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            return this.versionDescription != null ? this.versionDescription.equals(that.versionDescription) : that.versionDescription == null;
        }

        @Override
        public final int hashCode() {
            int result = this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0;
            result = 31 * result + (this.blockDevices != null ? this.blockDevices.hashCode() : 0);
            result = 31 * result + (this.cpuCredits != null ? this.cpuCredits.hashCode() : 0);
            result = 31 * result + (this.detailedMonitoring != null ? this.detailedMonitoring.hashCode() : 0);
            result = 31 * result + (this.disableApiTermination != null ? this.disableApiTermination.hashCode() : 0);
            result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
            result = 31 * result + (this.hibernationConfigured != null ? this.hibernationConfigured.hashCode() : 0);
            result = 31 * result + (this.httpEndpoint != null ? this.httpEndpoint.hashCode() : 0);
            result = 31 * result + (this.httpProtocolIpv6 != null ? this.httpProtocolIpv6.hashCode() : 0);
            result = 31 * result + (this.httpPutResponseHopLimit != null ? this.httpPutResponseHopLimit.hashCode() : 0);
            result = 31 * result + (this.httpTokens != null ? this.httpTokens.hashCode() : 0);
            result = 31 * result + (this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.hashCode() : 0);
            result = 31 * result + (this.instanceMetadataTags != null ? this.instanceMetadataTags.hashCode() : 0);
            result = 31 * result + (this.instanceProfile != null ? this.instanceProfile.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.keyPair != null ? this.keyPair.hashCode() : 0);
            result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
            result = 31 * result + (this.machineImage != null ? this.machineImage.hashCode() : 0);
            result = 31 * result + (this.nitroEnclaveEnabled != null ? this.nitroEnclaveEnabled.hashCode() : 0);
            result = 31 * result + (this.placementGroup != null ? this.placementGroup.hashCode() : 0);
            result = 31 * result + (this.requireImdsv2 != null ? this.requireImdsv2.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.spotOptions != null ? this.spotOptions.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.versionDescription != null ? this.versionDescription.hashCode() : 0);
            return result;
        }
    }
}
