package software.amazon.awscdk.services.ec2;

/**
 * Defines a placement group.
 * <p>
 * Placement groups give you fine-grained control over
 * where your instances are provisioned.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InstanceType instanceType;
 * PlacementGroup pg = PlacementGroup.Builder.create(this, "test-pg")
 *         .strategy(PlacementGroupStrategy.SPREAD)
 *         .build();
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .placementGroup(pg)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:13.674Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.PlacementGroup")
public class PlacementGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IPlacementGroup {

    protected PlacementGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PlacementGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.PlacementGroup.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PlacementGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PlacementGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import a PlacementGroup by its arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param placementGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPlacementGroup fromPlacementGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String placementGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.PlacementGroup.class, "fromPlacementGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPlacementGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(placementGroupName, "placementGroupName is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The name of this placement group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPlacementGroupName() {
        return software.amazon.jsii.Kernel.get(this, "placementGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of partitions.
     * <p>
     * Valid only when Strategy is set to PARTITION.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPartitions() {
        return software.amazon.jsii.Kernel.get(this, "partitions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Places instances on distinct hardware.
     * <p>
     * Spread placement groups are recommended for applications
     * that have a small number of critical instances that should be kept separate from each other.
     * Launching instances in a spread level placement group reduces the risk of simultaneous failures
     * that might occur when instances share the same equipment.
     * Spread level placement groups provide access to distinct hardware,
     * and are therefore suitable for mixing instance types or launching instances over time.
     * If you start or launch an instance in a spread placement group and there is insufficient
     * unique hardware to fulfill the request, the request fails. Amazon EC2 makes more distinct hardware
     * available over time, so you can try your request again later.
     * Placement groups can spread instances across racks or hosts.
     * You can use host level spread placement groups only with AWS Outposts.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel getSpreadLevel() {
        return software.amazon.jsii.Kernel.get(this, "spreadLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel.class));
    }

    /**
     * Which strategy to use when launching instances.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupStrategy getStrategy() {
        return software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PlacementGroupStrategy.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.PlacementGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.PlacementGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.PlacementGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The number of partitions.
         * <p>
         * Valid only when Strategy is set to partition.
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param partitions The number of partitions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitions(final java.lang.Number partitions) {
            this.props().partitions(partitions);
            return this;
        }

        /**
         * the name of this placement group.
         * <p>
         * Default: - generated by CFN
         * <p>
         * @return {@code this}
         * @param placementGroupName the name of this placement group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroupName(final java.lang.String placementGroupName) {
            this.props().placementGroupName(placementGroupName);
            return this;
        }

        /**
         * Places instances on distinct hardware.
         * <p>
         * Spread placement groups are recommended for applications
         * that have a small number of critical instances that should be kept separate from each other.
         * Launching instances in a spread level placement group reduces the risk of simultaneous failures
         * that might occur when instances share the same equipment.
         * Spread level placement groups provide access to distinct hardware,
         * and are therefore suitable for mixing instance types or launching instances over time.
         * If you start or launch an instance in a spread placement group and there is insufficient
         * unique hardware to fulfill the request, the request fails. Amazon EC2 makes more distinct hardware
         * available over time, so you can try your request again later.
         * Placement groups can spread instances across racks or hosts.
         * You can use host level spread placement groups only with AWS Outposts.
         * <p>
         * Default: - no spread level
         * <p>
         * @return {@code this}
         * @param spreadLevel Places instances on distinct hardware. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spreadLevel(final software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel spreadLevel) {
            this.props().spreadLevel(spreadLevel);
            return this;
        }

        /**
         * Which strategy to use when launching instances.
         * <p>
         * Default: - `PlacementGroupStrategy.PARTITION` if `partitions` is defined, `CLUSTER` otherwise
         * <p>
         * @return {@code this}
         * @param strategy Which strategy to use when launching instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strategy(final software.amazon.awscdk.services.ec2.PlacementGroupStrategy strategy) {
            this.props().strategy(strategy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.PlacementGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.PlacementGroup build() {
            return new software.amazon.awscdk.services.ec2.PlacementGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.PlacementGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.PlacementGroupProps.Builder();
            }
            return this.props;
        }
    }
}
