package software.amazon.awscdk.services.ec2;

/**
 * The service manager that will be used by InitServices.
 * <p>
 * The value needs to match the service manager used by your operating
 * system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .init(CloudFormationInit.fromElements(InitService.systemdConfigFile("simpleserver", SystemdConfigFileOptions.builder()
 *                 .command("/usr/bin/python3 -m http.server 8080")
 *                 .cwd("/var/www/html")
 *                 .build()), InitService.enable("simpleserver", InitServiceOptions.builder()
 *                 .serviceManager(ServiceManager.SYSTEMD)
 *                 .build()), InitFile.fromString("/var/www/html/index.html", "Hello! It's working!")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:13.689Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.ServiceManager")
public enum ServiceManager {
    /**
     * Use SysVinit.
     * <p>
     * This is the default for Linux systems.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SYSVINIT,
    /**
     * Use Windows.
     * <p>
     * This is the default for Windows systems.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS,
    /**
     * Use systemd.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SYSTEMD,
}
