package software.amazon.awscdk.services.efs;

/**
 * Properties for the ReplicationConfiguration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * import software.amazon.awscdk.services.kms.*;
 * FileSystem fileSystem;
 * Key key;
 * ReplicationConfigurationProps replicationConfigurationProps = ReplicationConfigurationProps.builder()
 *         .availabilityZone("availabilityZone")
 *         .destinationFileSystem(fileSystem)
 *         .kmsKey(key)
 *         .region("region")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:14.258Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.ReplicationConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(ReplicationConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReplicationConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The availability zone name of the destination file system.
     * <p>
     * One zone file system is used as the destination file system when this property is set.
     * <p>
     * Default: - no availability zone is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The existing destination file system for the replication.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.IFileSystem getDestinationFileSystem() {
        return null;
    }

    /**
     * AWS KMS key used to protect the encrypted file system.
     * <p>
     * Default: - use service-managed KMS key for Amazon EFS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * The AWS Region in which the destination file system is located.
     * <p>
     * Default: - the region of the stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ReplicationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReplicationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReplicationConfigurationProps> {
        java.lang.String availabilityZone;
        software.amazon.awscdk.services.efs.IFileSystem destinationFileSystem;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        java.lang.String region;

        /**
         * Sets the value of {@link ReplicationConfigurationProps#getAvailabilityZone}
         * @param availabilityZone The availability zone name of the destination file system.
         *                         One zone file system is used as the destination file system when this property is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationConfigurationProps#getDestinationFileSystem}
         * @param destinationFileSystem The existing destination file system for the replication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFileSystem(software.amazon.awscdk.services.efs.IFileSystem destinationFileSystem) {
            this.destinationFileSystem = destinationFileSystem;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationConfigurationProps#getKmsKey}
         * @param kmsKey AWS KMS key used to protect the encrypted file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationConfigurationProps#getRegion}
         * @param region The AWS Region in which the destination file system is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReplicationConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReplicationConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReplicationConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationConfigurationProps {
        private final java.lang.String availabilityZone;
        private final software.amazon.awscdk.services.efs.IFileSystem destinationFileSystem;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationFileSystem = software.amazon.jsii.Kernel.get(this, "destinationFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = builder.availabilityZone;
            this.destinationFileSystem = builder.destinationFileSystem;
            this.kmsKey = builder.kmsKey;
            this.region = builder.region;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final software.amazon.awscdk.services.efs.IFileSystem getDestinationFileSystem() {
            return this.destinationFileSystem;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getDestinationFileSystem() != null) {
                data.set("destinationFileSystem", om.valueToTree(this.getDestinationFileSystem()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.ReplicationConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReplicationConfigurationProps.Jsii$Proxy that = (ReplicationConfigurationProps.Jsii$Proxy) o;

            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.destinationFileSystem != null ? !this.destinationFileSystem.equals(that.destinationFileSystem) : that.destinationFileSystem != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
            result = 31 * result + (this.destinationFileSystem != null ? this.destinationFileSystem.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
