package software.amazon.awscdk.services.eks;

/**
 * Properties for defining a <code>CfnPodIdentityAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnPodIdentityAssociationProps cfnPodIdentityAssociationProps = CfnPodIdentityAssociationProps.builder()
 *         .clusterName("clusterName")
 *         .namespace("namespace")
 *         .roleArn("roleArn")
 *         .serviceAccount("serviceAccount")
 *         // the properties below are optional
 *         .disableSessionTags(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetRoleArn("targetRoleArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:14.361Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnPodIdentityAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnPodIdentityAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPodIdentityAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the cluster that the association is in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The name of the Kubernetes namespace inside the cluster to create the association in.
     * <p>
     * The service account and the Pods that use the service account must be in this namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-namespace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

    /**
     * The Amazon Resource Name (ARN) of the IAM role to associate with the service account.
     * <p>
     * The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the Pods that use this service account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-serviceaccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-serviceaccount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceAccount();

    /**
     * The state of the automatic sessions tags. The value of <em>true</em> disables these tags.
     * <p>
     * EKS Pod Identity adds a pre-defined set of session tags when it assumes the role. You can use these tags to author a single role that can work across resources by allowing access to AWS resources based on matching tags. By default, EKS Pod Identity attaches six tags, including tags for cluster name, namespace, and service account name. For the list of tags added by EKS Pod Identity, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags">List of session tags added by EKS Pod Identity</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-disablesessiontags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-disablesessiontags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableSessionTags() {
        return null;
    }

    /**
     * Metadata that assists with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or AWS resources.
     * <p>
     * The following basic restrictions apply to tags:
     * <p>
     * <ul>
     * <li>Maximum number of tags per resource – 50</li>
     * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
     * <li>Maximum key length – 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length – 256 Unicode characters in UTF-8</li>
     * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the target IAM role to associate with the service account.
     * <p>
     * This role is assumed by using the EKS Pod Identity association role, then the credentials for this role are injected into the Pod.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-targetrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-podidentityassociation.html#cfn-eks-podidentityassociation-targetrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPodIdentityAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPodIdentityAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPodIdentityAssociationProps> {
        java.lang.String clusterName;
        java.lang.String namespace;
        java.lang.String roleArn;
        java.lang.String serviceAccount;
        java.lang.Object disableSessionTags;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String targetRoleArn;

        /**
         * Sets the value of {@link CfnPodIdentityAssociationProps#getClusterName}
         * @param clusterName The name of the cluster that the association is in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPodIdentityAssociationProps#getNamespace}
         * @param namespace The name of the Kubernetes namespace inside the cluster to create the association in. This parameter is required.
         *                  The service account and the Pods that use the service account must be in this namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnPodIdentityAssociationProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role to associate with the service account. This parameter is required.
         *                The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the Pods that use this service account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPodIdentityAssociationProps#getServiceAccount}
         * @param serviceAccount The name of the Kubernetes service account inside the cluster to associate the IAM credentials with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(java.lang.String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnPodIdentityAssociationProps#getDisableSessionTags}
         * @param disableSessionTags The state of the automatic sessions tags. The value of <em>true</em> disables these tags.
         *                           EKS Pod Identity adds a pre-defined set of session tags when it assumes the role. You can use these tags to author a single role that can work across resources by allowing access to AWS resources based on matching tags. By default, EKS Pod Identity attaches six tags, including tags for cluster name, namespace, and service account name. For the list of tags added by EKS Pod Identity, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags">List of session tags added by EKS Pod Identity</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableSessionTags(java.lang.Boolean disableSessionTags) {
            this.disableSessionTags = disableSessionTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPodIdentityAssociationProps#getDisableSessionTags}
         * @param disableSessionTags The state of the automatic sessions tags. The value of <em>true</em> disables these tags.
         *                           EKS Pod Identity adds a pre-defined set of session tags when it assumes the role. You can use these tags to author a single role that can work across resources by allowing access to AWS resources based on matching tags. By default, EKS Pod Identity attaches six tags, including tags for cluster name, namespace, and service account name. For the list of tags added by EKS Pod Identity, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags">List of session tags added by EKS Pod Identity</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableSessionTags(software.amazon.awscdk.IResolvable disableSessionTags) {
            this.disableSessionTags = disableSessionTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPodIdentityAssociationProps#getTags}
         * @param tags Metadata that assists with categorization and organization.
         *             Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or AWS resources.
         *             <p>
         *             The following basic restrictions apply to tags:
         *             <p>
         *             <ul>
         *             <li>Maximum number of tags per resource – 50</li>
         *             <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         *             <li>Maximum key length – 128 Unicode characters in UTF-8</li>
         *             <li>Maximum value length – 256 Unicode characters in UTF-8</li>
         *             <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPodIdentityAssociationProps#getTargetRoleArn}
         * @param targetRoleArn The Amazon Resource Name (ARN) of the target IAM role to associate with the service account.
         *                      This role is assumed by using the EKS Pod Identity association role, then the credentials for this role are injected into the Pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetRoleArn(java.lang.String targetRoleArn) {
            this.targetRoleArn = targetRoleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPodIdentityAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPodIdentityAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPodIdentityAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPodIdentityAssociationProps {
        private final java.lang.String clusterName;
        private final java.lang.String namespace;
        private final java.lang.String roleArn;
        private final java.lang.String serviceAccount;
        private final java.lang.Object disableSessionTags;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String targetRoleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceAccount = software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableSessionTags = software.amazon.jsii.Kernel.get(this, "disableSessionTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.targetRoleArn = software.amazon.jsii.Kernel.get(this, "targetRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.serviceAccount = java.util.Objects.requireNonNull(builder.serviceAccount, "serviceAccount is required");
            this.disableSessionTags = builder.disableSessionTags;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.targetRoleArn = builder.targetRoleArn;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getServiceAccount() {
            return this.serviceAccount;
        }

        @Override
        public final java.lang.Object getDisableSessionTags() {
            return this.disableSessionTags;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTargetRoleArn() {
            return this.targetRoleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("namespace", om.valueToTree(this.getNamespace()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("serviceAccount", om.valueToTree(this.getServiceAccount()));
            if (this.getDisableSessionTags() != null) {
                data.set("disableSessionTags", om.valueToTree(this.getDisableSessionTags()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetRoleArn() != null) {
                data.set("targetRoleArn", om.valueToTree(this.getTargetRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnPodIdentityAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPodIdentityAssociationProps.Jsii$Proxy that = (CfnPodIdentityAssociationProps.Jsii$Proxy) o;

            if (!clusterName.equals(that.clusterName)) return false;
            if (!namespace.equals(that.namespace)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!serviceAccount.equals(that.serviceAccount)) return false;
            if (this.disableSessionTags != null ? !this.disableSessionTags.equals(that.disableSessionTags) : that.disableSessionTags != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.targetRoleArn != null ? this.targetRoleArn.equals(that.targetRoleArn) : that.targetRoleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName.hashCode();
            result = 31 * result + (this.namespace.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.serviceAccount.hashCode());
            result = 31 * result + (this.disableSessionTags != null ? this.disableSessionTags.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetRoleArn != null ? this.targetRoleArn.hashCode() : 0);
            return result;
        }
    }
}
