package software.amazon.awscdk.services.eks;

/**
 * Represents a helm chart within the Kubernetes system.
 * <p>
 * Applies/deletes the resources using <code>kubectl</code> in sync with the resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // option 1: use a construct
 * // option 1: use a construct
 * HelmChart.Builder.create(this, "MyOCIChart")
 *         .cluster(cluster)
 *         .chart("some-chart")
 *         .repository("oci://${ACCOUNT_ID}.dkr.ecr.${ACCOUNT_REGION}.amazonaws.com/${REPO_NAME}")
 *         .namespace("oci")
 *         .version("0.0.1")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:14.379Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.HelmChart")
public class HelmChart extends software.constructs.Construct {

    protected HelmChart(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HelmChart(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        RESOURCE_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.HelmChart.class, "RESOURCE_TYPE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HelmChart(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChartProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The CloudFormation resource type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RESOURCE_TYPE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getAtomic() {
        return software.amazon.jsii.Kernel.get(this, "atomic", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getChart() {
        return software.amazon.jsii.Kernel.get(this, "chart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.Asset getChartAsset() {
        return software.amazon.jsii.Kernel.get(this, "chartAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.assets.Asset.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.HelmChart}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.HelmChart> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.HelmChartProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.HelmChartProps.Builder();
        }

        /**
         * Whether or not Helm should treat this operation as atomic;
         * <p>
         * if set, upgrade process rolls back changes
         * made in case of failed upgrade. The --wait flag will be set automatically if --atomic is used.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param atomic Whether or not Helm should treat this operation as atomic;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atomic(final java.lang.Boolean atomic) {
            this.props.atomic(atomic);
            return this;
        }

        /**
         * The name of the chart.
         * <p>
         * Either this or <code>chartAsset</code> must be specified.
         * <p>
         * Default: - No chart name. Implies `chartAsset` is used.
         * <p>
         * @return {@code this}
         * @param chart The name of the chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chart(final java.lang.String chart) {
            this.props.chart(chart);
            return this;
        }

        /**
         * The chart in the form of an asset.
         * <p>
         * Either this or <code>chart</code> must be specified.
         * <p>
         * Default: - No chart asset. Implies `chart` is used.
         * <p>
         * @return {@code this}
         * @param chartAsset The chart in the form of an asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chartAsset(final software.amazon.awscdk.services.s3.assets.Asset chartAsset) {
            this.props.chartAsset(chartAsset);
            return this;
        }

        /**
         * create namespace if not exist.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param createNamespace create namespace if not exist. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createNamespace(final java.lang.Boolean createNamespace) {
            this.props.createNamespace(createNamespace);
            return this;
        }

        /**
         * The Kubernetes namespace scope of the requests.
         * <p>
         * Default: default
         * <p>
         * @return {@code this}
         * @param namespace The Kubernetes namespace scope of the requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(final java.lang.String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        /**
         * The name of the release.
         * <p>
         * Default: - If no release name is given, it will use the last 53 characters of the node's unique id.
         * <p>
         * @return {@code this}
         * @param release The name of the release. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder release(final java.lang.String release) {
            this.props.release(release);
            return this;
        }

        /**
         * The repository which contains the chart.
         * <p>
         * For example: https://charts.helm.sh/stable/
         * <p>
         * Default: - No repository will be used, which means that the chart needs to be an absolute URL.
         * <p>
         * @return {@code this}
         * @param repository The repository which contains the chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(final java.lang.String repository) {
            this.props.repository(repository);
            return this;
        }

        /**
         * if set, no CRDs will be installed.
         * <p>
         * Default: - CRDs are installed if not already present
         * <p>
         * @return {@code this}
         * @param skipCrds if set, no CRDs will be installed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipCrds(final java.lang.Boolean skipCrds) {
            this.props.skipCrds(skipCrds);
            return this;
        }

        /**
         * Amount of time to wait for any individual Kubernetes operation.
         * <p>
         * Maximum 15 minutes.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param timeout Amount of time to wait for any individual Kubernetes operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The values to be used by the chart.
         * <p>
         * For nested values use a nested dictionary. For example:
         * values: {
         * installationCRDs: true,
         * webhook: { port: 9443 }
         * }
         * <p>
         * Default: - No values are provided to the chart.
         * <p>
         * @return {@code this}
         * @param values The values to be used by the chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder values(final java.util.Map<java.lang.String, ? extends java.lang.Object> values) {
            this.props.values(values);
            return this;
        }

        /**
         * The chart version to install.
         * <p>
         * Default: - If this is not specified, the latest version is installed
         * <p>
         * @return {@code this}
         * @param version The chart version to install. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * Whether or not Helm should wait until all Pods, PVCs, Services, and minimum number of Pods of a Deployment, StatefulSet, or ReplicaSet are in a ready state before marking the release as successful.
         * <p>
         * Default: - Helm will not wait before marking release as successful
         * <p>
         * @return {@code this}
         * @param wait Whether or not Helm should wait until all Pods, PVCs, Services, and minimum number of Pods of a Deployment, StatefulSet, or ReplicaSet are in a ready state before marking the release as successful. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wait(final java.lang.Boolean wait) {
            this.props.wait(wait);
            return this;
        }

        /**
         * The EKS cluster to apply this configuration to.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster to apply this configuration to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.HelmChart}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.HelmChart build() {
            return new software.amazon.awscdk.services.eks.HelmChart(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
