package software.amazon.awscdk.services.emr;

/**
 * Properties for defining a <code>CfnStudioSessionMapping</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * CfnStudioSessionMappingProps cfnStudioSessionMappingProps = CfnStudioSessionMappingProps.builder()
 *         .identityName("identityName")
 *         .identityType("identityType")
 *         .sessionPolicyArn("sessionPolicyArn")
 *         .studioId("studioId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:14.814Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnStudioSessionMappingProps")
@software.amazon.jsii.Jsii.Proxy(CfnStudioSessionMappingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStudioSessionMappingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the user or group.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <em>IAM Identity Center Identity Store API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html#cfn-emr-studiosessionmapping-identityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html#cfn-emr-studiosessionmapping-identityname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityName();

    /**
     * Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html#cfn-emr-studiosessionmapping-identitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html#cfn-emr-studiosessionmapping-identitytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityType();

    /**
     * The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group.
     * <p>
     * Session policies refine Studio user permissions without the need to use multiple IAM user roles. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio user role with session policies</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html#cfn-emr-studiosessionmapping-sessionpolicyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html#cfn-emr-studiosessionmapping-sessionpolicyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSessionPolicyArn();

    /**
     * The ID of the Amazon EMR Studio to which the user or group will be mapped.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html#cfn-emr-studiosessionmapping-studioid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-studiosessionmapping.html#cfn-emr-studiosessionmapping-studioid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioId();

    /**
     * @return a {@link Builder} of {@link CfnStudioSessionMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStudioSessionMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStudioSessionMappingProps> {
        java.lang.String identityName;
        java.lang.String identityType;
        java.lang.String sessionPolicyArn;
        java.lang.String studioId;

        /**
         * Sets the value of {@link CfnStudioSessionMappingProps#getIdentityName}
         * @param identityName The name of the user or group. This parameter is required.
         *                     For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <em>IAM Identity Center Identity Store API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityName(java.lang.String identityName) {
            this.identityName = identityName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioSessionMappingProps#getIdentityType}
         * @param identityType Specifies whether the identity to map to the Amazon EMR Studio is a user or a group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityType(java.lang.String identityType) {
            this.identityType = identityType;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioSessionMappingProps#getSessionPolicyArn}
         * @param sessionPolicyArn The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. This parameter is required.
         *                         Session policies refine Studio user permissions without the need to use multiple IAM user roles. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio user role with session policies</a> in the <em>Amazon EMR Management Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionPolicyArn(java.lang.String sessionPolicyArn) {
            this.sessionPolicyArn = sessionPolicyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioSessionMappingProps#getStudioId}
         * @param studioId The ID of the Amazon EMR Studio to which the user or group will be mapped. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioId(java.lang.String studioId) {
            this.studioId = studioId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStudioSessionMappingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStudioSessionMappingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStudioSessionMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStudioSessionMappingProps {
        private final java.lang.String identityName;
        private final java.lang.String identityType;
        private final java.lang.String sessionPolicyArn;
        private final java.lang.String studioId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityName = software.amazon.jsii.Kernel.get(this, "identityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityType = software.amazon.jsii.Kernel.get(this, "identityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionPolicyArn = software.amazon.jsii.Kernel.get(this, "sessionPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioId = software.amazon.jsii.Kernel.get(this, "studioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityName = java.util.Objects.requireNonNull(builder.identityName, "identityName is required");
            this.identityType = java.util.Objects.requireNonNull(builder.identityType, "identityType is required");
            this.sessionPolicyArn = java.util.Objects.requireNonNull(builder.sessionPolicyArn, "sessionPolicyArn is required");
            this.studioId = java.util.Objects.requireNonNull(builder.studioId, "studioId is required");
        }

        @Override
        public final java.lang.String getIdentityName() {
            return this.identityName;
        }

        @Override
        public final java.lang.String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final java.lang.String getSessionPolicyArn() {
            return this.sessionPolicyArn;
        }

        @Override
        public final java.lang.String getStudioId() {
            return this.studioId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityName", om.valueToTree(this.getIdentityName()));
            data.set("identityType", om.valueToTree(this.getIdentityType()));
            data.set("sessionPolicyArn", om.valueToTree(this.getSessionPolicyArn()));
            data.set("studioId", om.valueToTree(this.getStudioId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnStudioSessionMappingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStudioSessionMappingProps.Jsii$Proxy that = (CfnStudioSessionMappingProps.Jsii$Proxy) o;

            if (!identityName.equals(that.identityName)) return false;
            if (!identityType.equals(that.identityType)) return false;
            if (!sessionPolicyArn.equals(that.sessionPolicyArn)) return false;
            return this.studioId.equals(that.studioId);
        }

        @Override
        public final int hashCode() {
            int result = this.identityName.hashCode();
            result = 31 * result + (this.identityType.hashCode());
            result = 31 * result + (this.sessionPolicyArn.hashCode());
            result = 31 * result + (this.studioId.hashCode());
            return result;
        }
    }
}
