package software.amazon.awscdk.services.events;

/**
 * Properties to associate Event Buses with a policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * import software.amazon.awscdk.services.iam.*;
 * EventBus eventBus;
 * PolicyStatement policyStatement;
 * EventBusPolicyProps eventBusPolicyProps = EventBusPolicyProps.builder()
 *         .eventBus(eventBus)
 *         .statement(policyStatement)
 *         .statementId("statementId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:14.934Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.EventBusPolicyProps")
@software.amazon.jsii.Jsii.Proxy(EventBusPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventBusPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The event bus to which the policy applies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus getEventBus();

    /**
     * An IAM Policy Statement to apply to the Event Bus.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement getStatement();

    /**
     * An identifier string for the external account that you are granting permissions to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatementId();

    /**
     * @return a {@link Builder} of {@link EventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventBusPolicyProps> {
        software.amazon.awscdk.services.events.IEventBus eventBus;
        software.amazon.awscdk.services.iam.PolicyStatement statement;
        java.lang.String statementId;

        /**
         * Sets the value of {@link EventBusPolicyProps#getEventBus}
         * @param eventBus The event bus to which the policy applies. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBus(software.amazon.awscdk.services.events.IEventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        /**
         * Sets the value of {@link EventBusPolicyProps#getStatement}
         * @param statement An IAM Policy Statement to apply to the Event Bus. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statement(software.amazon.awscdk.services.iam.PolicyStatement statement) {
            this.statement = statement;
            return this;
        }

        /**
         * Sets the value of {@link EventBusPolicyProps#getStatementId}
         * @param statementId An identifier string for the external account that you are granting permissions to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statementId(java.lang.String statementId) {
            this.statementId = statementId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventBusPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventBusPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBusPolicyProps {
        private final software.amazon.awscdk.services.events.IEventBus eventBus;
        private final software.amazon.awscdk.services.iam.PolicyStatement statement;
        private final java.lang.String statementId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventBus = software.amazon.jsii.Kernel.get(this, "eventBus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IEventBus.class));
            this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class));
            this.statementId = software.amazon.jsii.Kernel.get(this, "statementId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventBus = java.util.Objects.requireNonNull(builder.eventBus, "eventBus is required");
            this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
            this.statementId = java.util.Objects.requireNonNull(builder.statementId, "statementId is required");
        }

        @Override
        public final software.amazon.awscdk.services.events.IEventBus getEventBus() {
            return this.eventBus;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyStatement getStatement() {
            return this.statement;
        }

        @Override
        public final java.lang.String getStatementId() {
            return this.statementId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventBus", om.valueToTree(this.getEventBus()));
            data.set("statement", om.valueToTree(this.getStatement()));
            data.set("statementId", om.valueToTree(this.getStatementId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.EventBusPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventBusPolicyProps.Jsii$Proxy that = (EventBusPolicyProps.Jsii$Proxy) o;

            if (!eventBus.equals(that.eventBus)) return false;
            if (!statement.equals(that.statement)) return false;
            return this.statementId.equals(that.statementId);
        }

        @Override
        public final int hashCode() {
            int result = this.eventBus.hashCode();
            result = 31 * result + (this.statement.hashCode());
            result = 31 * result + (this.statementId.hashCode());
            return result;
        }
    }
}
