package software.amazon.awscdk.services.gamelift;

/**
 * Properties for defining a <code>CfnGameSessionQueue</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnGameSessionQueueProps cfnGameSessionQueueProps = CfnGameSessionQueueProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .customEventData("customEventData")
 *         .destinations(List.of(DestinationProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .build()))
 *         .filterConfiguration(FilterConfigurationProperty.builder()
 *                 .allowedLocations(List.of("allowedLocations"))
 *                 .build())
 *         .notificationTarget("notificationTarget")
 *         .playerLatencyPolicies(List.of(PlayerLatencyPolicyProperty.builder()
 *                 .maximumIndividualPlayerLatencyMilliseconds(123)
 *                 .policyDurationSeconds(123)
 *                 .build()))
 *         .priorityConfiguration(PriorityConfigurationProperty.builder()
 *                 .locationOrder(List.of("locationOrder"))
 *                 .priorityOrder(List.of("priorityOrder"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeoutInSeconds(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:15.279Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnGameSessionQueueProps")
@software.amazon.jsii.Jsii.Proxy(CfnGameSessionQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGameSessionQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A descriptive label that is associated with game session queue.
     * <p>
     * Queue names must be unique within each Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Information to be added to all events that are related to this game session queue.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-customeventdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-customeventdata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomEventData() {
        return null;
    }

    /**
     * A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue.
     * <p>
     * Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-destinations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
        return null;
    }

    /**
     * A list of locations where a queue is allowed to place new game sessions.
     * <p>
     * Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code> . If this parameter is not set, game sessions can be placed in any queue location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-filterconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
        return null;
    }

    /**
     * An SNS topic ARN that is set up to receive game session placement notifications.
     * <p>
     * See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html">Setting up notifications for game session placement</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-notificationtarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-notificationtarget</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotificationTarget() {
        return null;
    }

    /**
     * A set of policies that enforce a sliding cap on player latency when processing game sessions placement requests.
     * <p>
     * Use multiple policies to gradually relax the cap over time if Amazon GameLift Servers can't make a placement. Policies are evaluated in order starting with the lowest maximum latency value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-playerlatencypolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-playerlatencypolicies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPlayerLatencyPolicies() {
        return null;
    }

    /**
     * Custom settings to use when prioritizing destinations and locations for game session placements.
     * <p>
     * This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-priorityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-priorityconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPriorityConfiguration() {
        return null;
    }

    /**
     * A list of labels to assign to the new game session queue resource.
     * <p>
     * Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in the <em>AWS General Reference</em> . Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The maximum time, in seconds, that a new game session placement request remains in the queue.
     * <p>
     * When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status. If you don't specify a request timeout, the queue uses a default value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-timeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-timeoutinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInSeconds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGameSessionQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGameSessionQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGameSessionQueueProps> {
        java.lang.String name;
        java.lang.String customEventData;
        java.lang.Object destinations;
        java.lang.Object filterConfiguration;
        java.lang.String notificationTarget;
        java.lang.Object playerLatencyPolicies;
        java.lang.Object priorityConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Number timeoutInSeconds;

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getName}
         * @param name A descriptive label that is associated with game session queue. This parameter is required.
         *             Queue names must be unique within each Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getCustomEventData}
         * @param customEventData Information to be added to all events that are related to this game session queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEventData(java.lang.String customEventData) {
            this.customEventData = customEventData;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getDestinations}
         * @param destinations A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue.
         *                     Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(software.amazon.awscdk.IResolvable destinations) {
            this.destinations = destinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getDestinations}
         * @param destinations A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue.
         *                     Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
            this.destinations = destinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getFilterConfiguration}
         * @param filterConfiguration A list of locations where a queue is allowed to place new game sessions.
         *                            Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code> . If this parameter is not set, game sessions can be placed in any queue location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getFilterConfiguration}
         * @param filterConfiguration A list of locations where a queue is allowed to place new game sessions.
         *                            Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code> . If this parameter is not set, game sessions can be placed in any queue location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterConfiguration(software.amazon.awscdk.services.gamelift.CfnGameSessionQueue.FilterConfigurationProperty filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getNotificationTarget}
         * @param notificationTarget An SNS topic ARN that is set up to receive game session placement notifications.
         *                           See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html">Setting up notifications for game session placement</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTarget(java.lang.String notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getPlayerLatencyPolicies}
         * @param playerLatencyPolicies A set of policies that enforce a sliding cap on player latency when processing game sessions placement requests.
         *                              Use multiple policies to gradually relax the cap over time if Amazon GameLift Servers can't make a placement. Policies are evaluated in order starting with the lowest maximum latency value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder playerLatencyPolicies(software.amazon.awscdk.IResolvable playerLatencyPolicies) {
            this.playerLatencyPolicies = playerLatencyPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getPlayerLatencyPolicies}
         * @param playerLatencyPolicies A set of policies that enforce a sliding cap on player latency when processing game sessions placement requests.
         *                              Use multiple policies to gradually relax the cap over time if Amazon GameLift Servers can't make a placement. Policies are evaluated in order starting with the lowest maximum latency value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder playerLatencyPolicies(java.util.List<? extends java.lang.Object> playerLatencyPolicies) {
            this.playerLatencyPolicies = playerLatencyPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getPriorityConfiguration}
         * @param priorityConfiguration Custom settings to use when prioritizing destinations and locations for game session placements.
         *                              This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priorityConfiguration(software.amazon.awscdk.IResolvable priorityConfiguration) {
            this.priorityConfiguration = priorityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getPriorityConfiguration}
         * @param priorityConfiguration Custom settings to use when prioritizing destinations and locations for game session placements.
         *                              This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priorityConfiguration(software.amazon.awscdk.services.gamelift.CfnGameSessionQueue.PriorityConfigurationProperty priorityConfiguration) {
            this.priorityConfiguration = priorityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getTags}
         * @param tags A list of labels to assign to the new game session queue resource.
         *             Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in the <em>AWS General Reference</em> . Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameSessionQueueProps#getTimeoutInSeconds}
         * @param timeoutInSeconds The maximum time, in seconds, that a new game session placement request remains in the queue.
         *                         When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status. If you don't specify a request timeout, the queue uses a default value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGameSessionQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGameSessionQueueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGameSessionQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGameSessionQueueProps {
        private final java.lang.String name;
        private final java.lang.String customEventData;
        private final java.lang.Object destinations;
        private final java.lang.Object filterConfiguration;
        private final java.lang.String notificationTarget;
        private final java.lang.Object playerLatencyPolicies;
        private final java.lang.Object priorityConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Number timeoutInSeconds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customEventData = software.amazon.jsii.Kernel.get(this, "customEventData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationTarget = software.amazon.jsii.Kernel.get(this, "notificationTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.playerLatencyPolicies = software.amazon.jsii.Kernel.get(this, "playerLatencyPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.priorityConfiguration = software.amazon.jsii.Kernel.get(this, "priorityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.customEventData = builder.customEventData;
            this.destinations = builder.destinations;
            this.filterConfiguration = builder.filterConfiguration;
            this.notificationTarget = builder.notificationTarget;
            this.playerLatencyPolicies = builder.playerLatencyPolicies;
            this.priorityConfiguration = builder.priorityConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.timeoutInSeconds = builder.timeoutInSeconds;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getCustomEventData() {
            return this.customEventData;
        }

        @Override
        public final java.lang.Object getDestinations() {
            return this.destinations;
        }

        @Override
        public final java.lang.Object getFilterConfiguration() {
            return this.filterConfiguration;
        }

        @Override
        public final java.lang.String getNotificationTarget() {
            return this.notificationTarget;
        }

        @Override
        public final java.lang.Object getPlayerLatencyPolicies() {
            return this.playerLatencyPolicies;
        }

        @Override
        public final java.lang.Object getPriorityConfiguration() {
            return this.priorityConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getCustomEventData() != null) {
                data.set("customEventData", om.valueToTree(this.getCustomEventData()));
            }
            if (this.getDestinations() != null) {
                data.set("destinations", om.valueToTree(this.getDestinations()));
            }
            if (this.getFilterConfiguration() != null) {
                data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
            }
            if (this.getNotificationTarget() != null) {
                data.set("notificationTarget", om.valueToTree(this.getNotificationTarget()));
            }
            if (this.getPlayerLatencyPolicies() != null) {
                data.set("playerLatencyPolicies", om.valueToTree(this.getPlayerLatencyPolicies()));
            }
            if (this.getPriorityConfiguration() != null) {
                data.set("priorityConfiguration", om.valueToTree(this.getPriorityConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeoutInSeconds() != null) {
                data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnGameSessionQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGameSessionQueueProps.Jsii$Proxy that = (CfnGameSessionQueueProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.customEventData != null ? !this.customEventData.equals(that.customEventData) : that.customEventData != null) return false;
            if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) return false;
            if (this.filterConfiguration != null ? !this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration != null) return false;
            if (this.notificationTarget != null ? !this.notificationTarget.equals(that.notificationTarget) : that.notificationTarget != null) return false;
            if (this.playerLatencyPolicies != null ? !this.playerLatencyPolicies.equals(that.playerLatencyPolicies) : that.playerLatencyPolicies != null) return false;
            if (this.priorityConfiguration != null ? !this.priorityConfiguration.equals(that.priorityConfiguration) : that.priorityConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.timeoutInSeconds != null ? this.timeoutInSeconds.equals(that.timeoutInSeconds) : that.timeoutInSeconds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.customEventData != null ? this.customEventData.hashCode() : 0);
            result = 31 * result + (this.destinations != null ? this.destinations.hashCode() : 0);
            result = 31 * result + (this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0);
            result = 31 * result + (this.notificationTarget != null ? this.notificationTarget.hashCode() : 0);
            result = 31 * result + (this.playerLatencyPolicies != null ? this.playerLatencyPolicies.hashCode() : 0);
            result = 31 * result + (this.priorityConfiguration != null ? this.priorityConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeoutInSeconds != null ? this.timeoutInSeconds.hashCode() : 0);
            return result;
        }
    }
}
