package software.amazon.awscdk.services.iam;

/**
 * A SAML metadata document.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * vpc.addClientVpnEndpoint("Endpoint", ClientVpnEndpointOptions.builder()
 *         .cidr("10.100.0.0/16")
 *         .serverCertificateArn("arn:aws:acm:us-east-1:123456789012:certificate/server-certificate-id")
 *         // Mutual authentication
 *         .clientCertificateArn("arn:aws:acm:us-east-1:123456789012:certificate/client-certificate-id")
 *         // User-based authentication
 *         .userBasedAuthentication(ClientVpnUserBasedAuthentication.federated(samlProvider))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:15.766Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.SamlMetadataDocument")
public abstract class SamlMetadataDocument extends software.amazon.jsii.JsiiObject {

    protected SamlMetadataDocument(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SamlMetadataDocument(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected SamlMetadataDocument() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create a SAML metadata document from a XML file.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.SamlMetadataDocument fromFile(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.SamlMetadataDocument.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.SamlMetadataDocument.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Create a SAML metadata document from a XML string.
     * <p>
     * @param xml This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.SamlMetadataDocument fromXml(final @org.jetbrains.annotations.NotNull java.lang.String xml) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.SamlMetadataDocument.class, "fromXml", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.SamlMetadataDocument.class), new Object[] { java.util.Objects.requireNonNull(xml, "xml is required") });
    }

    /**
     * The XML content of the metadata document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getXml();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.iam.SamlMetadataDocument {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The XML content of the metadata document.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getXml() {
            return software.amazon.jsii.Kernel.get(this, "xml", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
