package software.amazon.awscdk.services.iot;

/**
 * Creates a new thing type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnThingType cfnThingType = CfnThingType.Builder.create(this, "MyCfnThingType")
 *         .deprecateThingType(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .thingTypeName("thingTypeName")
 *         .thingTypeProperties(ThingTypePropertiesProperty.builder()
 *                 .mqtt5Configuration(Mqtt5ConfigurationProperty.builder()
 *                         .propagatingAttributes(List.of(PropagatingAttributeProperty.builder()
 *                                 .userPropertyKey("userPropertyKey")
 *                                 // the properties below are optional
 *                                 .connectionAttribute("connectionAttribute")
 *                                 .thingAttribute("thingAttribute")
 *                                 .build()))
 *                         .build())
 *                 .searchableAttributes(List.of("searchableAttributes"))
 *                 .thingTypeDescription("thingTypeDescription")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:15.966Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThingType")
public class CfnThingType extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnThingType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnThingType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnThingType.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnThingType(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnThingTypeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnThingType(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The thing type arn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The thing type id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Deprecates a thing type.
     * <p>
     * You can not associate new things with deprecated thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeprecateThingType() {
        return software.amazon.jsii.Kernel.get(this, "deprecateThingType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Deprecates a thing type.
     * <p>
     * You can not associate new things with deprecated thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeprecateThingType(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deprecateThingType", value);
    }

    /**
     * Deprecates a thing type.
     * <p>
     * You can not associate new things with deprecated thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeprecateThingType(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deprecateThingType", value);
    }

    /**
     * Metadata which can be used to manage the thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata which can be used to manage the thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The name of the thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThingTypeName() {
        return software.amazon.jsii.Kernel.get(this, "thingTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThingTypeName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "thingTypeName", value);
    }

    /**
     * The thing type properties for the thing type to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getThingTypeProperties() {
        return software.amazon.jsii.Kernel.get(this, "thingTypeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The thing type properties for the thing type to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThingTypeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "thingTypeProperties", value);
    }

    /**
     * The thing type properties for the thing type to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThingTypeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnThingType.ThingTypePropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "thingTypeProperties", value);
    }
    /**
     * The configuration to add user-defined properties to enrich MQTT 5 messages.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * Mqtt5ConfigurationProperty mqtt5ConfigurationProperty = Mqtt5ConfigurationProperty.builder()
     *         .propagatingAttributes(List.of(PropagatingAttributeProperty.builder()
     *                 .userPropertyKey("userPropertyKey")
     *                 // the properties below are optional
     *                 .connectionAttribute("connectionAttribute")
     *                 .thingAttribute("thingAttribute")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-mqtt5configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-mqtt5configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThingType.Mqtt5ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(Mqtt5ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Mqtt5ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the connection attribute, the thing attribute, and the MQTT 5 user property key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-mqtt5configuration.html#cfn-iot-thingtype-mqtt5configuration-propagatingattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-mqtt5configuration.html#cfn-iot-thingtype-mqtt5configuration-propagatingattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropagatingAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Mqtt5ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Mqtt5ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Mqtt5ConfigurationProperty> {
            java.lang.Object propagatingAttributes;

            /**
             * Sets the value of {@link Mqtt5ConfigurationProperty#getPropagatingAttributes}
             * @param propagatingAttributes An object that represents the connection attribute, the thing attribute, and the MQTT 5 user property key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propagatingAttributes(software.amazon.awscdk.IResolvable propagatingAttributes) {
                this.propagatingAttributes = propagatingAttributes;
                return this;
            }

            /**
             * Sets the value of {@link Mqtt5ConfigurationProperty#getPropagatingAttributes}
             * @param propagatingAttributes An object that represents the connection attribute, the thing attribute, and the MQTT 5 user property key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propagatingAttributes(java.util.List<? extends java.lang.Object> propagatingAttributes) {
                this.propagatingAttributes = propagatingAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Mqtt5ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Mqtt5ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Mqtt5ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Mqtt5ConfigurationProperty {
            private final java.lang.Object propagatingAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.propagatingAttributes = software.amazon.jsii.Kernel.get(this, "propagatingAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propagatingAttributes = builder.propagatingAttributes;
            }

            @Override
            public final java.lang.Object getPropagatingAttributes() {
                return this.propagatingAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPropagatingAttributes() != null) {
                    data.set("propagatingAttributes", om.valueToTree(this.getPropagatingAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnThingType.Mqtt5ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Mqtt5ConfigurationProperty.Jsii$Proxy that = (Mqtt5ConfigurationProperty.Jsii$Proxy) o;

                return this.propagatingAttributes != null ? this.propagatingAttributes.equals(that.propagatingAttributes) : that.propagatingAttributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.propagatingAttributes != null ? this.propagatingAttributes.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the connection attribute, the thing attribute, and the MQTT 5 user property key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * PropagatingAttributeProperty propagatingAttributeProperty = PropagatingAttributeProperty.builder()
     *         .userPropertyKey("userPropertyKey")
     *         // the properties below are optional
     *         .connectionAttribute("connectionAttribute")
     *         .thingAttribute("thingAttribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-propagatingattribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-propagatingattribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThingType.PropagatingAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(PropagatingAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropagatingAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key of the MQTT 5 user property, which is a key-value pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-propagatingattribute.html#cfn-iot-thingtype-propagatingattribute-userpropertykey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-propagatingattribute.html#cfn-iot-thingtype-propagatingattribute-userpropertykey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPropertyKey();

        /**
         * The attribute associated with the connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-propagatingattribute.html#cfn-iot-thingtype-propagatingattribute-connectionattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-propagatingattribute.html#cfn-iot-thingtype-propagatingattribute-connectionattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionAttribute() {
            return null;
        }

        /**
         * The thing attribute that is propagating for MQTT 5 message enrichment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-propagatingattribute.html#cfn-iot-thingtype-propagatingattribute-thingattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-propagatingattribute.html#cfn-iot-thingtype-propagatingattribute-thingattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThingAttribute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PropagatingAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropagatingAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropagatingAttributeProperty> {
            java.lang.String userPropertyKey;
            java.lang.String connectionAttribute;
            java.lang.String thingAttribute;

            /**
             * Sets the value of {@link PropagatingAttributeProperty#getUserPropertyKey}
             * @param userPropertyKey The key of the MQTT 5 user property, which is a key-value pair. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPropertyKey(java.lang.String userPropertyKey) {
                this.userPropertyKey = userPropertyKey;
                return this;
            }

            /**
             * Sets the value of {@link PropagatingAttributeProperty#getConnectionAttribute}
             * @param connectionAttribute The attribute associated with the connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionAttribute(java.lang.String connectionAttribute) {
                this.connectionAttribute = connectionAttribute;
                return this;
            }

            /**
             * Sets the value of {@link PropagatingAttributeProperty#getThingAttribute}
             * @param thingAttribute The thing attribute that is propagating for MQTT 5 message enrichment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingAttribute(java.lang.String thingAttribute) {
                this.thingAttribute = thingAttribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropagatingAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropagatingAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropagatingAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropagatingAttributeProperty {
            private final java.lang.String userPropertyKey;
            private final java.lang.String connectionAttribute;
            private final java.lang.String thingAttribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.userPropertyKey = software.amazon.jsii.Kernel.get(this, "userPropertyKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionAttribute = software.amazon.jsii.Kernel.get(this, "connectionAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thingAttribute = software.amazon.jsii.Kernel.get(this, "thingAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.userPropertyKey = java.util.Objects.requireNonNull(builder.userPropertyKey, "userPropertyKey is required");
                this.connectionAttribute = builder.connectionAttribute;
                this.thingAttribute = builder.thingAttribute;
            }

            @Override
            public final java.lang.String getUserPropertyKey() {
                return this.userPropertyKey;
            }

            @Override
            public final java.lang.String getConnectionAttribute() {
                return this.connectionAttribute;
            }

            @Override
            public final java.lang.String getThingAttribute() {
                return this.thingAttribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("userPropertyKey", om.valueToTree(this.getUserPropertyKey()));
                if (this.getConnectionAttribute() != null) {
                    data.set("connectionAttribute", om.valueToTree(this.getConnectionAttribute()));
                }
                if (this.getThingAttribute() != null) {
                    data.set("thingAttribute", om.valueToTree(this.getThingAttribute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnThingType.PropagatingAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropagatingAttributeProperty.Jsii$Proxy that = (PropagatingAttributeProperty.Jsii$Proxy) o;

                if (!userPropertyKey.equals(that.userPropertyKey)) return false;
                if (this.connectionAttribute != null ? !this.connectionAttribute.equals(that.connectionAttribute) : that.connectionAttribute != null) return false;
                return this.thingAttribute != null ? this.thingAttribute.equals(that.thingAttribute) : that.thingAttribute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.userPropertyKey.hashCode();
                result = 31 * result + (this.connectionAttribute != null ? this.connectionAttribute.hashCode() : 0);
                result = 31 * result + (this.thingAttribute != null ? this.thingAttribute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The ThingTypeProperties contains information about the thing type including: a thing type description, and a list of searchable thing attribute names.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ThingTypePropertiesProperty thingTypePropertiesProperty = ThingTypePropertiesProperty.builder()
     *         .mqtt5Configuration(Mqtt5ConfigurationProperty.builder()
     *                 .propagatingAttributes(List.of(PropagatingAttributeProperty.builder()
     *                         .userPropertyKey("userPropertyKey")
     *                         // the properties below are optional
     *                         .connectionAttribute("connectionAttribute")
     *                         .thingAttribute("thingAttribute")
     *                         .build()))
     *                 .build())
     *         .searchableAttributes(List.of("searchableAttributes"))
     *         .thingTypeDescription("thingTypeDescription")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-thingtypeproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-thingtypeproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThingType.ThingTypePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ThingTypePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThingTypePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration to add user-defined properties to enrich MQTT 5 messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-thingtypeproperties.html#cfn-iot-thingtype-thingtypeproperties-mqtt5configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-thingtypeproperties.html#cfn-iot-thingtype-thingtypeproperties-mqtt5configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMqtt5Configuration() {
            return null;
        }

        /**
         * A list of searchable thing attribute names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-thingtypeproperties.html#cfn-iot-thingtype-thingtypeproperties-searchableattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-thingtypeproperties.html#cfn-iot-thingtype-thingtypeproperties-searchableattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSearchableAttributes() {
            return null;
        }

        /**
         * The description of the thing type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-thingtypeproperties.html#cfn-iot-thingtype-thingtypeproperties-thingtypedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thingtype-thingtypeproperties.html#cfn-iot-thingtype-thingtypeproperties-thingtypedescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThingTypeDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThingTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThingTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThingTypePropertiesProperty> {
            java.lang.Object mqtt5Configuration;
            java.util.List<java.lang.String> searchableAttributes;
            java.lang.String thingTypeDescription;

            /**
             * Sets the value of {@link ThingTypePropertiesProperty#getMqtt5Configuration}
             * @param mqtt5Configuration The configuration to add user-defined properties to enrich MQTT 5 messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mqtt5Configuration(software.amazon.awscdk.IResolvable mqtt5Configuration) {
                this.mqtt5Configuration = mqtt5Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ThingTypePropertiesProperty#getMqtt5Configuration}
             * @param mqtt5Configuration The configuration to add user-defined properties to enrich MQTT 5 messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mqtt5Configuration(software.amazon.awscdk.services.iot.CfnThingType.Mqtt5ConfigurationProperty mqtt5Configuration) {
                this.mqtt5Configuration = mqtt5Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ThingTypePropertiesProperty#getSearchableAttributes}
             * @param searchableAttributes A list of searchable thing attribute names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchableAttributes(java.util.List<java.lang.String> searchableAttributes) {
                this.searchableAttributes = searchableAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ThingTypePropertiesProperty#getThingTypeDescription}
             * @param thingTypeDescription The description of the thing type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingTypeDescription(java.lang.String thingTypeDescription) {
                this.thingTypeDescription = thingTypeDescription;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThingTypePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThingTypePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThingTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThingTypePropertiesProperty {
            private final java.lang.Object mqtt5Configuration;
            private final java.util.List<java.lang.String> searchableAttributes;
            private final java.lang.String thingTypeDescription;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mqtt5Configuration = software.amazon.jsii.Kernel.get(this, "mqtt5Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.searchableAttributes = software.amazon.jsii.Kernel.get(this, "searchableAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.thingTypeDescription = software.amazon.jsii.Kernel.get(this, "thingTypeDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mqtt5Configuration = builder.mqtt5Configuration;
                this.searchableAttributes = builder.searchableAttributes;
                this.thingTypeDescription = builder.thingTypeDescription;
            }

            @Override
            public final java.lang.Object getMqtt5Configuration() {
                return this.mqtt5Configuration;
            }

            @Override
            public final java.util.List<java.lang.String> getSearchableAttributes() {
                return this.searchableAttributes;
            }

            @Override
            public final java.lang.String getThingTypeDescription() {
                return this.thingTypeDescription;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMqtt5Configuration() != null) {
                    data.set("mqtt5Configuration", om.valueToTree(this.getMqtt5Configuration()));
                }
                if (this.getSearchableAttributes() != null) {
                    data.set("searchableAttributes", om.valueToTree(this.getSearchableAttributes()));
                }
                if (this.getThingTypeDescription() != null) {
                    data.set("thingTypeDescription", om.valueToTree(this.getThingTypeDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnThingType.ThingTypePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThingTypePropertiesProperty.Jsii$Proxy that = (ThingTypePropertiesProperty.Jsii$Proxy) o;

                if (this.mqtt5Configuration != null ? !this.mqtt5Configuration.equals(that.mqtt5Configuration) : that.mqtt5Configuration != null) return false;
                if (this.searchableAttributes != null ? !this.searchableAttributes.equals(that.searchableAttributes) : that.searchableAttributes != null) return false;
                return this.thingTypeDescription != null ? this.thingTypeDescription.equals(that.thingTypeDescription) : that.thingTypeDescription == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mqtt5Configuration != null ? this.mqtt5Configuration.hashCode() : 0;
                result = 31 * result + (this.searchableAttributes != null ? this.searchableAttributes.hashCode() : 0);
                result = 31 * result + (this.thingTypeDescription != null ? this.thingTypeDescription.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnThingType}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnThingType> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iot.CfnThingTypeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Deprecates a thing type. You can not associate new things with deprecated thing type.
         * <p>
         * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-deprecatethingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-deprecatethingtype</a>
         * @param deprecateThingType Deprecates a thing type. You can not associate new things with deprecated thing type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deprecateThingType(final java.lang.Boolean deprecateThingType) {
            this.props().deprecateThingType(deprecateThingType);
            return this;
        }
        /**
         * Deprecates a thing type. You can not associate new things with deprecated thing type.
         * <p>
         * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-deprecatethingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-deprecatethingtype</a>
         * @param deprecateThingType Deprecates a thing type. You can not associate new things with deprecated thing type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deprecateThingType(final software.amazon.awscdk.IResolvable deprecateThingType) {
            this.props().deprecateThingType(deprecateThingType);
            return this;
        }

        /**
         * Metadata which can be used to manage the thing type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-tags</a>
         * @param tags Metadata which can be used to manage the thing type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The name of the thing type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypename</a>
         * @param thingTypeName The name of the thing type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeName(final java.lang.String thingTypeName) {
            this.props().thingTypeName(thingTypeName);
            return this;
        }

        /**
         * The thing type properties for the thing type to create.
         * <p>
         * It contains information about the new thing type including a description, a list of searchable thing attribute names, and a list of propagating attributes. After a thing type is created, you can only update <code>Mqtt5Configuration</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypeproperties</a>
         * @param thingTypeProperties The thing type properties for the thing type to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeProperties(final software.amazon.awscdk.IResolvable thingTypeProperties) {
            this.props().thingTypeProperties(thingTypeProperties);
            return this;
        }
        /**
         * The thing type properties for the thing type to create.
         * <p>
         * It contains information about the new thing type including a description, a list of searchable thing attribute names, and a list of propagating attributes. After a thing type is created, you can only update <code>Mqtt5Configuration</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypeproperties</a>
         * @param thingTypeProperties The thing type properties for the thing type to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeProperties(final software.amazon.awscdk.services.iot.CfnThingType.ThingTypePropertiesProperty thingTypeProperties) {
            this.props().thingTypeProperties(thingTypeProperties);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.CfnThingType}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnThingType build() {
            return new software.amazon.awscdk.services.iot.CfnThingType(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.CfnThingTypeProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.CfnThingTypeProps.Builder();
            }
            return this.props;
        }
    }
}
