package software.amazon.awscdk.services.iotevents;

/**
 * Represents an alarm model to monitor an AWS IoT Events input attribute.
 * <p>
 * You can use the alarm to get notified when the value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html">Create an alarm model</a> in the <em>AWS IoT Events Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotevents.*;
 * CfnAlarmModel cfnAlarmModel = CfnAlarmModel.Builder.create(this, "MyCfnAlarmModel")
 *         .alarmRule(AlarmRuleProperty.builder()
 *                 .simpleRule(SimpleRuleProperty.builder()
 *                         .comparisonOperator("comparisonOperator")
 *                         .inputProperty("inputProperty")
 *                         .threshold("threshold")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .alarmCapabilities(AlarmCapabilitiesProperty.builder()
 *                 .acknowledgeFlow(AcknowledgeFlowProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .initializationConfiguration(InitializationConfigurationProperty.builder()
 *                         .disabledOnInitialization(false)
 *                         .build())
 *                 .build())
 *         .alarmEventActions(AlarmEventActionsProperty.builder()
 *                 .alarmActions(List.of(AlarmActionProperty.builder()
 *                         .dynamoDb(DynamoDBProperty.builder()
 *                                 .hashKeyField("hashKeyField")
 *                                 .hashKeyValue("hashKeyValue")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .hashKeyType("hashKeyType")
 *                                 .operation("operation")
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .payloadField("payloadField")
 *                                 .rangeKeyField("rangeKeyField")
 *                                 .rangeKeyType("rangeKeyType")
 *                                 .rangeKeyValue("rangeKeyValue")
 *                                 .build())
 *                         .dynamoDBv2(DynamoDBv2Property.builder()
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .firehose(FirehoseProperty.builder()
 *                                 .deliveryStreamName("deliveryStreamName")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .separator("separator")
 *                                 .build())
 *                         .iotEvents(IotEventsProperty.builder()
 *                                 .inputName("inputName")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .iotSiteWise(IotSiteWiseProperty.builder()
 *                                 .assetId("assetId")
 *                                 .entryId("entryId")
 *                                 .propertyAlias("propertyAlias")
 *                                 .propertyId("propertyId")
 *                                 .propertyValue(AssetPropertyValueProperty.builder()
 *                                         .value(AssetPropertyVariantProperty.builder()
 *                                                 .booleanValue("booleanValue")
 *                                                 .doubleValue("doubleValue")
 *                                                 .integerValue("integerValue")
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .quality("quality")
 *                                         .timestamp(AssetPropertyTimestampProperty.builder()
 *                                                 .timeInSeconds("timeInSeconds")
 *                                                 // the properties below are optional
 *                                                 .offsetInNanos("offsetInNanos")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .iotTopicPublish(IotTopicPublishProperty.builder()
 *                                 .mqttTopic("mqttTopic")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .lambda(LambdaProperty.builder()
 *                                 .functionArn("functionArn")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .sns(SnsProperty.builder()
 *                                 .targetArn("targetArn")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .sqs(SqsProperty.builder()
 *                                 .queueUrl("queueUrl")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .useBase64(false)
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .alarmModelDescription("alarmModelDescription")
 *         .alarmModelName("alarmModelName")
 *         .key("key")
 *         .severity(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:16.072Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel")
public class CfnAlarmModel extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnAlarmModel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAlarmModel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotevents.CfnAlarmModel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAlarmModel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.CfnAlarmModelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Defines when your alarm is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAlarmRule() {
        return software.amazon.jsii.Kernel.get(this, "alarmRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines when your alarm is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "alarmRule", java.util.Objects.requireNonNull(value, "alarmRule is required"));
    }

    /**
     * Defines when your alarm is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmRuleProperty value) {
        software.amazon.jsii.Kernel.set(this, "alarmRule", java.util.Objects.requireNonNull(value, "alarmRule is required"));
    }

    /**
     * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * Contains the configuration information of alarm state changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAlarmCapabilities() {
        return software.amazon.jsii.Kernel.get(this, "alarmCapabilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains the configuration information of alarm state changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmCapabilities(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "alarmCapabilities", value);
    }

    /**
     * Contains the configuration information of alarm state changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmCapabilities(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmCapabilitiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "alarmCapabilities", value);
    }

    /**
     * Contains information about one or more alarm actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAlarmEventActions() {
        return software.amazon.jsii.Kernel.get(this, "alarmEventActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about one or more alarm actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmEventActions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "alarmEventActions", value);
    }

    /**
     * Contains information about one or more alarm actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmEventActions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmEventActionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "alarmEventActions", value);
    }

    /**
     * The description of the alarm model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAlarmModelDescription() {
        return software.amazon.jsii.Kernel.get(this, "alarmModelDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the alarm model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmModelDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alarmModelDescription", value);
    }

    /**
     * The name of the alarm model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAlarmModelName() {
        return software.amazon.jsii.Kernel.get(this, "alarmModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the alarm model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmModelName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alarmModelName", value);
    }

    /**
     * An input attribute used as a key to create an alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An input attribute used as a key to create an alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "key", value);
    }

    /**
     * A non-negative integer that reflects the severity level of the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSeverity() {
        return software.amazon.jsii.Kernel.get(this, "severity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A non-negative integer that reflects the severity level of the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSeverity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "severity", value);
    }

    /**
     * A list of key-value pairs that contain metadata for the alarm model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs that contain metadata for the alarm model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Specifies whether to get notified for alarm state changes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AcknowledgeFlowProperty acknowledgeFlowProperty = AcknowledgeFlowProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-acknowledgeflow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-acknowledgeflow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.AcknowledgeFlowProperty")
    @software.amazon.jsii.Jsii.Proxy(AcknowledgeFlowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcknowledgeFlowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value must be <code>TRUE</code> or <code>FALSE</code> .
         * <p>
         * If <code>TRUE</code> , you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to <code>NORMAL</code> . If <code>FALSE</code> , you won't receive notifications. The alarm automatically changes to the <code>NORMAL</code> state when the input property value returns to the specified range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-acknowledgeflow.html#cfn-iotevents-alarmmodel-acknowledgeflow-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-acknowledgeflow.html#cfn-iotevents-alarmmodel-acknowledgeflow-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcknowledgeFlowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcknowledgeFlowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcknowledgeFlowProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link AcknowledgeFlowProperty#getEnabled}
             * @param enabled The value must be <code>TRUE</code> or <code>FALSE</code> .
             *                If <code>TRUE</code> , you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to <code>NORMAL</code> . If <code>FALSE</code> , you won't receive notifications. The alarm automatically changes to the <code>NORMAL</code> state when the input property value returns to the specified range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AcknowledgeFlowProperty#getEnabled}
             * @param enabled The value must be <code>TRUE</code> or <code>FALSE</code> .
             *                If <code>TRUE</code> , you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to <code>NORMAL</code> . If <code>FALSE</code> , you won't receive notifications. The alarm automatically changes to the <code>NORMAL</code> state when the input property value returns to the specified range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcknowledgeFlowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcknowledgeFlowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcknowledgeFlowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcknowledgeFlowProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.AcknowledgeFlowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcknowledgeFlowProperty.Jsii$Proxy that = (AcknowledgeFlowProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies one of the following actions to receive notifications when the alarm state changes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AlarmActionProperty alarmActionProperty = AlarmActionProperty.builder()
     *         .dynamoDb(DynamoDBProperty.builder()
     *                 .hashKeyField("hashKeyField")
     *                 .hashKeyValue("hashKeyValue")
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .hashKeyType("hashKeyType")
     *                 .operation("operation")
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .payloadField("payloadField")
     *                 .rangeKeyField("rangeKeyField")
     *                 .rangeKeyType("rangeKeyType")
     *                 .rangeKeyValue("rangeKeyValue")
     *                 .build())
     *         .dynamoDBv2(DynamoDBv2Property.builder()
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .firehose(FirehoseProperty.builder()
     *                 .deliveryStreamName("deliveryStreamName")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .separator("separator")
     *                 .build())
     *         .iotEvents(IotEventsProperty.builder()
     *                 .inputName("inputName")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .iotSiteWise(IotSiteWiseProperty.builder()
     *                 .assetId("assetId")
     *                 .entryId("entryId")
     *                 .propertyAlias("propertyAlias")
     *                 .propertyId("propertyId")
     *                 .propertyValue(AssetPropertyValueProperty.builder()
     *                         .value(AssetPropertyVariantProperty.builder()
     *                                 .booleanValue("booleanValue")
     *                                 .doubleValue("doubleValue")
     *                                 .integerValue("integerValue")
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         // the properties below are optional
     *                         .quality("quality")
     *                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                 .timeInSeconds("timeInSeconds")
     *                                 // the properties below are optional
     *                                 .offsetInNanos("offsetInNanos")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .iotTopicPublish(IotTopicPublishProperty.builder()
     *                 .mqttTopic("mqttTopic")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .lambda(LambdaProperty.builder()
     *                 .functionArn("functionArn")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .sns(SnsProperty.builder()
     *                 .targetArn("targetArn")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .sqs(SqsProperty.builder()
     *                 .queueUrl("queueUrl")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .useBase64(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.AlarmActionProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines an action to write to the Amazon DynamoDB table that you created.
         * <p>
         * The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         * <p>
         * You must use expressions for all parameters in <code>DynamoDBAction</code> . The expressions accept literals, operators, functions, references, and substitution templates.
         * <p>
         * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code> .
         * <p>
         * <ul>
         * <li>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code> .</li>
         * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
         * </ul>
         * <p>
         * In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template.
         * <p>
         * <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code>
         * <p>
         * <ul>
         * <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
         * </ul>
         * <p>
         * In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
         * <p>
         * <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
         * <p>
         * If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>&lt;payload-field&gt;_raw</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-dynamodb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-dynamodb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDb() {
            return null;
        }

        /**
         * Defines an action to write to the Amazon DynamoDB table that you created.
         * <p>
         * The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         * <p>
         * You must use expressions for all parameters in <code>DynamoDBv2Action</code> . The expressions accept literals, operators, functions, references, and substitution templates.
         * <p>
         * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code> .
         * <p>
         * <ul>
         * <li>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code> .</li>
         * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
         * </ul>
         * <p>
         * In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template.
         * <p>
         * <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code>
         * <p>
         * <ul>
         * <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
         * </ul>
         * <p>
         * In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
         * <p>
         * <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
         * <p>
         * The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-dynamodbv2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-dynamodbv2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDBv2() {
            return null;
        }

        /**
         * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-firehose">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-firehose</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirehose() {
            return null;
        }

        /**
         * Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-iotevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-iotevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotEvents() {
            return null;
        }

        /**
         * Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise .
         * <p>
         * You must use expressions for all parameters in <code>IotSiteWiseAction</code> . The expressions accept literals, operators, functions, references, and substitutions templates.
         * <p>
         * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code> .
         * <p>
         * <ul>
         * <li>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code> .</li>
         * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
         * </ul>
         * <p>
         * In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template.
         * <p>
         * <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code>
         * <p>
         * You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-iotsitewise">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-iotsitewise</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotSiteWise() {
            return null;
        }

        /**
         * Information required to publish the MQTT message through the AWS IoT message broker.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-iottopicpublish">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-iottopicpublish</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotTopicPublish() {
            return null;
        }

        /**
         * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-lambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-lambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambda() {
            return null;
        }

        /**
         * Information required to publish the Amazon SNS message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-sns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-sns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSns() {
            return null;
        }

        /**
         * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-sqs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmaction.html#cfn-iotevents-alarmmodel-alarmaction-sqs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlarmActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmActionProperty> {
            java.lang.Object dynamoDb;
            java.lang.Object dynamoDBv2;
            java.lang.Object firehose;
            java.lang.Object iotEvents;
            java.lang.Object iotSiteWise;
            java.lang.Object iotTopicPublish;
            java.lang.Object lambda;
            java.lang.Object sns;
            java.lang.Object sqs;

            /**
             * Sets the value of {@link AlarmActionProperty#getDynamoDb}
             * @param dynamoDb Defines an action to write to the Amazon DynamoDB table that you created.
             *                 The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
             *                 <p>
             *                 You must use expressions for all parameters in <code>DynamoDBAction</code> . The expressions accept literals, operators, functions, references, and substitution templates.
             *                 <p>
             *                 <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code> .
             *                 <p>
             *                 <ul>
             *                 <li>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code> .</li>
             *                 <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                 </ul>
             *                 <p>
             *                 In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template.
             *                 <p>
             *                 <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code>
             *                 <p>
             *                 <ul>
             *                 <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                 </ul>
             *                 <p>
             *                 In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
             *                 <p>
             *                 <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
             *                 <p>
             *                 For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
             *                 <p>
             *                 If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>&lt;payload-field&gt;_raw</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDb(software.amazon.awscdk.IResolvable dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getDynamoDb}
             * @param dynamoDb Defines an action to write to the Amazon DynamoDB table that you created.
             *                 The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
             *                 <p>
             *                 You must use expressions for all parameters in <code>DynamoDBAction</code> . The expressions accept literals, operators, functions, references, and substitution templates.
             *                 <p>
             *                 <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code> .
             *                 <p>
             *                 <ul>
             *                 <li>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code> .</li>
             *                 <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                 </ul>
             *                 <p>
             *                 In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template.
             *                 <p>
             *                 <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code>
             *                 <p>
             *                 <ul>
             *                 <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                 </ul>
             *                 <p>
             *                 In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
             *                 <p>
             *                 <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
             *                 <p>
             *                 For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
             *                 <p>
             *                 If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>&lt;payload-field&gt;_raw</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDb(software.amazon.awscdk.services.iotevents.CfnAlarmModel.DynamoDBProperty dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getDynamoDBv2}
             * @param dynamoDBv2 Defines an action to write to the Amazon DynamoDB table that you created.
             *                   The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
             *                   <p>
             *                   You must use expressions for all parameters in <code>DynamoDBv2Action</code> . The expressions accept literals, operators, functions, references, and substitution templates.
             *                   <p>
             *                   <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code> .
             *                   <p>
             *                   <ul>
             *                   <li>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code> .</li>
             *                   <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                   </ul>
             *                   <p>
             *                   In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template.
             *                   <p>
             *                   <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code>
             *                   <p>
             *                   <ul>
             *                   <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                   </ul>
             *                   <p>
             *                   In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
             *                   <p>
             *                   <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
             *                   <p>
             *                   For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
             *                   <p>
             *                   The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDBv2(software.amazon.awscdk.IResolvable dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getDynamoDBv2}
             * @param dynamoDBv2 Defines an action to write to the Amazon DynamoDB table that you created.
             *                   The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
             *                   <p>
             *                   You must use expressions for all parameters in <code>DynamoDBv2Action</code> . The expressions accept literals, operators, functions, references, and substitution templates.
             *                   <p>
             *                   <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code> .
             *                   <p>
             *                   <ul>
             *                   <li>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code> .</li>
             *                   <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                   </ul>
             *                   <p>
             *                   In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template.
             *                   <p>
             *                   <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code>
             *                   <p>
             *                   <ul>
             *                   <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                   </ul>
             *                   <p>
             *                   In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
             *                   <p>
             *                   <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
             *                   <p>
             *                   For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
             *                   <p>
             *                   The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDBv2(software.amazon.awscdk.services.iotevents.CfnAlarmModel.DynamoDBv2Property dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getFirehose}
             * @param firehose Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getFirehose}
             * @param firehose Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.services.iotevents.CfnAlarmModel.FirehoseProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getIotEvents}
             * @param iotEvents Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotEvents(software.amazon.awscdk.IResolvable iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getIotEvents}
             * @param iotEvents Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotEvents(software.amazon.awscdk.services.iotevents.CfnAlarmModel.IotEventsProperty iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getIotSiteWise}
             * @param iotSiteWise Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise .
             *                    You must use expressions for all parameters in <code>IotSiteWiseAction</code> . The expressions accept literals, operators, functions, references, and substitutions templates.
             *                    <p>
             *                    <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code> .
             *                    <p>
             *                    <ul>
             *                    <li>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code> .</li>
             *                    <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                    </ul>
             *                    <p>
             *                    In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template.
             *                    <p>
             *                    <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code>
             *                    <p>
             *                    You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise .
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotSiteWise(software.amazon.awscdk.IResolvable iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getIotSiteWise}
             * @param iotSiteWise Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise .
             *                    You must use expressions for all parameters in <code>IotSiteWiseAction</code> . The expressions accept literals, operators, functions, references, and substitutions templates.
             *                    <p>
             *                    <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code> .
             *                    <p>
             *                    <ul>
             *                    <li>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code> .</li>
             *                    <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
             *                    </ul>
             *                    <p>
             *                    In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template.
             *                    <p>
             *                    <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code>
             *                    <p>
             *                    You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise .
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotSiteWise(software.amazon.awscdk.services.iotevents.CfnAlarmModel.IotSiteWiseProperty iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getIotTopicPublish}
             * @param iotTopicPublish Information required to publish the MQTT message through the AWS IoT message broker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotTopicPublish(software.amazon.awscdk.IResolvable iotTopicPublish) {
                this.iotTopicPublish = iotTopicPublish;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getIotTopicPublish}
             * @param iotTopicPublish Information required to publish the MQTT message through the AWS IoT message broker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotTopicPublish(software.amazon.awscdk.services.iotevents.CfnAlarmModel.IotTopicPublishProperty iotTopicPublish) {
                this.iotTopicPublish = iotTopicPublish;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getLambda}
             * @param lambda Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getLambda}
             * @param lambda Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.services.iotevents.CfnAlarmModel.LambdaProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getSns}
             * @param sns Information required to publish the Amazon SNS message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sns(software.amazon.awscdk.IResolvable sns) {
                this.sns = sns;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getSns}
             * @param sns Information required to publish the Amazon SNS message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sns(software.amazon.awscdk.services.iotevents.CfnAlarmModel.SnsProperty sns) {
                this.sns = sns;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getSqs}
             * @param sqs Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqs(software.amazon.awscdk.IResolvable sqs) {
                this.sqs = sqs;
                return this;
            }

            /**
             * Sets the value of {@link AlarmActionProperty#getSqs}
             * @param sqs Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqs(software.amazon.awscdk.services.iotevents.CfnAlarmModel.SqsProperty sqs) {
                this.sqs = sqs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmActionProperty {
            private final java.lang.Object dynamoDb;
            private final java.lang.Object dynamoDBv2;
            private final java.lang.Object firehose;
            private final java.lang.Object iotEvents;
            private final java.lang.Object iotSiteWise;
            private final java.lang.Object iotTopicPublish;
            private final java.lang.Object lambda;
            private final java.lang.Object sns;
            private final java.lang.Object sqs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dynamoDb = software.amazon.jsii.Kernel.get(this, "dynamoDb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDBv2 = software.amazon.jsii.Kernel.get(this, "dynamoDBv2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firehose = software.amazon.jsii.Kernel.get(this, "firehose", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotEvents = software.amazon.jsii.Kernel.get(this, "iotEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotSiteWise = software.amazon.jsii.Kernel.get(this, "iotSiteWise", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotTopicPublish = software.amazon.jsii.Kernel.get(this, "iotTopicPublish", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sns = software.amazon.jsii.Kernel.get(this, "sns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqs = software.amazon.jsii.Kernel.get(this, "sqs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dynamoDb = builder.dynamoDb;
                this.dynamoDBv2 = builder.dynamoDBv2;
                this.firehose = builder.firehose;
                this.iotEvents = builder.iotEvents;
                this.iotSiteWise = builder.iotSiteWise;
                this.iotTopicPublish = builder.iotTopicPublish;
                this.lambda = builder.lambda;
                this.sns = builder.sns;
                this.sqs = builder.sqs;
            }

            @Override
            public final java.lang.Object getDynamoDb() {
                return this.dynamoDb;
            }

            @Override
            public final java.lang.Object getDynamoDBv2() {
                return this.dynamoDBv2;
            }

            @Override
            public final java.lang.Object getFirehose() {
                return this.firehose;
            }

            @Override
            public final java.lang.Object getIotEvents() {
                return this.iotEvents;
            }

            @Override
            public final java.lang.Object getIotSiteWise() {
                return this.iotSiteWise;
            }

            @Override
            public final java.lang.Object getIotTopicPublish() {
                return this.iotTopicPublish;
            }

            @Override
            public final java.lang.Object getLambda() {
                return this.lambda;
            }

            @Override
            public final java.lang.Object getSns() {
                return this.sns;
            }

            @Override
            public final java.lang.Object getSqs() {
                return this.sqs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDynamoDb() != null) {
                    data.set("dynamoDb", om.valueToTree(this.getDynamoDb()));
                }
                if (this.getDynamoDBv2() != null) {
                    data.set("dynamoDBv2", om.valueToTree(this.getDynamoDBv2()));
                }
                if (this.getFirehose() != null) {
                    data.set("firehose", om.valueToTree(this.getFirehose()));
                }
                if (this.getIotEvents() != null) {
                    data.set("iotEvents", om.valueToTree(this.getIotEvents()));
                }
                if (this.getIotSiteWise() != null) {
                    data.set("iotSiteWise", om.valueToTree(this.getIotSiteWise()));
                }
                if (this.getIotTopicPublish() != null) {
                    data.set("iotTopicPublish", om.valueToTree(this.getIotTopicPublish()));
                }
                if (this.getLambda() != null) {
                    data.set("lambda", om.valueToTree(this.getLambda()));
                }
                if (this.getSns() != null) {
                    data.set("sns", om.valueToTree(this.getSns()));
                }
                if (this.getSqs() != null) {
                    data.set("sqs", om.valueToTree(this.getSqs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.AlarmActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmActionProperty.Jsii$Proxy that = (AlarmActionProperty.Jsii$Proxy) o;

                if (this.dynamoDb != null ? !this.dynamoDb.equals(that.dynamoDb) : that.dynamoDb != null) return false;
                if (this.dynamoDBv2 != null ? !this.dynamoDBv2.equals(that.dynamoDBv2) : that.dynamoDBv2 != null) return false;
                if (this.firehose != null ? !this.firehose.equals(that.firehose) : that.firehose != null) return false;
                if (this.iotEvents != null ? !this.iotEvents.equals(that.iotEvents) : that.iotEvents != null) return false;
                if (this.iotSiteWise != null ? !this.iotSiteWise.equals(that.iotSiteWise) : that.iotSiteWise != null) return false;
                if (this.iotTopicPublish != null ? !this.iotTopicPublish.equals(that.iotTopicPublish) : that.iotTopicPublish != null) return false;
                if (this.lambda != null ? !this.lambda.equals(that.lambda) : that.lambda != null) return false;
                if (this.sns != null ? !this.sns.equals(that.sns) : that.sns != null) return false;
                return this.sqs != null ? this.sqs.equals(that.sqs) : that.sqs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dynamoDb != null ? this.dynamoDb.hashCode() : 0;
                result = 31 * result + (this.dynamoDBv2 != null ? this.dynamoDBv2.hashCode() : 0);
                result = 31 * result + (this.firehose != null ? this.firehose.hashCode() : 0);
                result = 31 * result + (this.iotEvents != null ? this.iotEvents.hashCode() : 0);
                result = 31 * result + (this.iotSiteWise != null ? this.iotSiteWise.hashCode() : 0);
                result = 31 * result + (this.iotTopicPublish != null ? this.iotTopicPublish.hashCode() : 0);
                result = 31 * result + (this.lambda != null ? this.lambda.hashCode() : 0);
                result = 31 * result + (this.sns != null ? this.sns.hashCode() : 0);
                result = 31 * result + (this.sqs != null ? this.sqs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the configuration information of alarm state changes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AlarmCapabilitiesProperty alarmCapabilitiesProperty = AlarmCapabilitiesProperty.builder()
     *         .acknowledgeFlow(AcknowledgeFlowProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .initializationConfiguration(InitializationConfigurationProperty.builder()
     *                 .disabledOnInitialization(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmcapabilities.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmcapabilities.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.AlarmCapabilitiesProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmCapabilitiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmCapabilitiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether to get notified for alarm state changes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmcapabilities.html#cfn-iotevents-alarmmodel-alarmcapabilities-acknowledgeflow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmcapabilities.html#cfn-iotevents-alarmmodel-alarmcapabilities-acknowledgeflow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcknowledgeFlow() {
            return null;
        }

        /**
         * Specifies the default alarm state.
         * <p>
         * The configuration applies to all alarms that were created based on this alarm model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmcapabilities.html#cfn-iotevents-alarmmodel-alarmcapabilities-initializationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmcapabilities.html#cfn-iotevents-alarmmodel-alarmcapabilities-initializationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInitializationConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlarmCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmCapabilitiesProperty> {
            java.lang.Object acknowledgeFlow;
            java.lang.Object initializationConfiguration;

            /**
             * Sets the value of {@link AlarmCapabilitiesProperty#getAcknowledgeFlow}
             * @param acknowledgeFlow Specifies whether to get notified for alarm state changes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acknowledgeFlow(software.amazon.awscdk.IResolvable acknowledgeFlow) {
                this.acknowledgeFlow = acknowledgeFlow;
                return this;
            }

            /**
             * Sets the value of {@link AlarmCapabilitiesProperty#getAcknowledgeFlow}
             * @param acknowledgeFlow Specifies whether to get notified for alarm state changes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acknowledgeFlow(software.amazon.awscdk.services.iotevents.CfnAlarmModel.AcknowledgeFlowProperty acknowledgeFlow) {
                this.acknowledgeFlow = acknowledgeFlow;
                return this;
            }

            /**
             * Sets the value of {@link AlarmCapabilitiesProperty#getInitializationConfiguration}
             * @param initializationConfiguration Specifies the default alarm state.
             *                                    The configuration applies to all alarms that were created based on this alarm model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initializationConfiguration(software.amazon.awscdk.IResolvable initializationConfiguration) {
                this.initializationConfiguration = initializationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AlarmCapabilitiesProperty#getInitializationConfiguration}
             * @param initializationConfiguration Specifies the default alarm state.
             *                                    The configuration applies to all alarms that were created based on this alarm model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initializationConfiguration(software.amazon.awscdk.services.iotevents.CfnAlarmModel.InitializationConfigurationProperty initializationConfiguration) {
                this.initializationConfiguration = initializationConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmCapabilitiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmCapabilitiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmCapabilitiesProperty {
            private final java.lang.Object acknowledgeFlow;
            private final java.lang.Object initializationConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acknowledgeFlow = software.amazon.jsii.Kernel.get(this, "acknowledgeFlow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.initializationConfiguration = software.amazon.jsii.Kernel.get(this, "initializationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acknowledgeFlow = builder.acknowledgeFlow;
                this.initializationConfiguration = builder.initializationConfiguration;
            }

            @Override
            public final java.lang.Object getAcknowledgeFlow() {
                return this.acknowledgeFlow;
            }

            @Override
            public final java.lang.Object getInitializationConfiguration() {
                return this.initializationConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcknowledgeFlow() != null) {
                    data.set("acknowledgeFlow", om.valueToTree(this.getAcknowledgeFlow()));
                }
                if (this.getInitializationConfiguration() != null) {
                    data.set("initializationConfiguration", om.valueToTree(this.getInitializationConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.AlarmCapabilitiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmCapabilitiesProperty.Jsii$Proxy that = (AlarmCapabilitiesProperty.Jsii$Proxy) o;

                if (this.acknowledgeFlow != null ? !this.acknowledgeFlow.equals(that.acknowledgeFlow) : that.acknowledgeFlow != null) return false;
                return this.initializationConfiguration != null ? this.initializationConfiguration.equals(that.initializationConfiguration) : that.initializationConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acknowledgeFlow != null ? this.acknowledgeFlow.hashCode() : 0;
                result = 31 * result + (this.initializationConfiguration != null ? this.initializationConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about one or more alarm actions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AlarmEventActionsProperty alarmEventActionsProperty = AlarmEventActionsProperty.builder()
     *         .alarmActions(List.of(AlarmActionProperty.builder()
     *                 .dynamoDb(DynamoDBProperty.builder()
     *                         .hashKeyField("hashKeyField")
     *                         .hashKeyValue("hashKeyValue")
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .hashKeyType("hashKeyType")
     *                         .operation("operation")
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .payloadField("payloadField")
     *                         .rangeKeyField("rangeKeyField")
     *                         .rangeKeyType("rangeKeyType")
     *                         .rangeKeyValue("rangeKeyValue")
     *                         .build())
     *                 .dynamoDBv2(DynamoDBv2Property.builder()
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .firehose(FirehoseProperty.builder()
     *                         .deliveryStreamName("deliveryStreamName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .separator("separator")
     *                         .build())
     *                 .iotEvents(IotEventsProperty.builder()
     *                         .inputName("inputName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .iotSiteWise(IotSiteWiseProperty.builder()
     *                         .assetId("assetId")
     *                         .entryId("entryId")
     *                         .propertyAlias("propertyAlias")
     *                         .propertyId("propertyId")
     *                         .propertyValue(AssetPropertyValueProperty.builder()
     *                                 .value(AssetPropertyVariantProperty.builder()
     *                                         .booleanValue("booleanValue")
     *                                         .doubleValue("doubleValue")
     *                                         .integerValue("integerValue")
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .quality("quality")
     *                                 .timestamp(AssetPropertyTimestampProperty.builder()
     *                                         .timeInSeconds("timeInSeconds")
     *                                         // the properties below are optional
     *                                         .offsetInNanos("offsetInNanos")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .iotTopicPublish(IotTopicPublishProperty.builder()
     *                         .mqttTopic("mqttTopic")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .lambda(LambdaProperty.builder()
     *                         .functionArn("functionArn")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .sns(SnsProperty.builder()
     *                         .targetArn("targetArn")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .sqs(SqsProperty.builder()
     *                         .queueUrl("queueUrl")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .useBase64(false)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmeventactions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmeventactions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.AlarmEventActionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmEventActionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmEventActionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies one or more supported actions to receive notifications when the alarm state changes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmeventactions.html#cfn-iotevents-alarmmodel-alarmeventactions-alarmactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmeventactions.html#cfn-iotevents-alarmmodel-alarmeventactions-alarmactions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlarmActions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlarmEventActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmEventActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmEventActionsProperty> {
            java.lang.Object alarmActions;

            /**
             * Sets the value of {@link AlarmEventActionsProperty#getAlarmActions}
             * @param alarmActions Specifies one or more supported actions to receive notifications when the alarm state changes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmActions(software.amazon.awscdk.IResolvable alarmActions) {
                this.alarmActions = alarmActions;
                return this;
            }

            /**
             * Sets the value of {@link AlarmEventActionsProperty#getAlarmActions}
             * @param alarmActions Specifies one or more supported actions to receive notifications when the alarm state changes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmActions(java.util.List<? extends java.lang.Object> alarmActions) {
                this.alarmActions = alarmActions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmEventActionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmEventActionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmEventActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmEventActionsProperty {
            private final java.lang.Object alarmActions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmActions = software.amazon.jsii.Kernel.get(this, "alarmActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmActions = builder.alarmActions;
            }

            @Override
            public final java.lang.Object getAlarmActions() {
                return this.alarmActions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlarmActions() != null) {
                    data.set("alarmActions", om.valueToTree(this.getAlarmActions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.AlarmEventActionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmEventActionsProperty.Jsii$Proxy that = (AlarmEventActionsProperty.Jsii$Proxy) o;

                return this.alarmActions != null ? this.alarmActions.equals(that.alarmActions) : that.alarmActions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarmActions != null ? this.alarmActions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Defines when your alarm is invoked.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AlarmRuleProperty alarmRuleProperty = AlarmRuleProperty.builder()
     *         .simpleRule(SimpleRuleProperty.builder()
     *                 .comparisonOperator("comparisonOperator")
     *                 .inputProperty("inputProperty")
     *                 .threshold("threshold")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.AlarmRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A rule that compares an input property value to a threshold value with a comparison operator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmrule.html#cfn-iotevents-alarmmodel-alarmrule-simplerule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-alarmrule.html#cfn-iotevents-alarmmodel-alarmrule-simplerule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSimpleRule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlarmRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmRuleProperty> {
            java.lang.Object simpleRule;

            /**
             * Sets the value of {@link AlarmRuleProperty#getSimpleRule}
             * @param simpleRule A rule that compares an input property value to a threshold value with a comparison operator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleRule(software.amazon.awscdk.IResolvable simpleRule) {
                this.simpleRule = simpleRule;
                return this;
            }

            /**
             * Sets the value of {@link AlarmRuleProperty#getSimpleRule}
             * @param simpleRule A rule that compares an input property value to a threshold value with a comparison operator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleRule(software.amazon.awscdk.services.iotevents.CfnAlarmModel.SimpleRuleProperty simpleRule) {
                this.simpleRule = simpleRule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmRuleProperty {
            private final java.lang.Object simpleRule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.simpleRule = software.amazon.jsii.Kernel.get(this, "simpleRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.simpleRule = builder.simpleRule;
            }

            @Override
            public final java.lang.Object getSimpleRule() {
                return this.simpleRule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSimpleRule() != null) {
                    data.set("simpleRule", om.valueToTree(this.getSimpleRule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.AlarmRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmRuleProperty.Jsii$Proxy that = (AlarmRuleProperty.Jsii$Proxy) o;

                return this.simpleRule != null ? this.simpleRule.equals(that.simpleRule) : that.simpleRule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.simpleRule != null ? this.simpleRule.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A structure that contains timestamp information. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html">TimeInNanos</a> in the <em>AWS IoT SiteWise API Reference</em> .
     * <p>
     * You must use expressions for all parameters in <code>AssetPropertyTimestamp</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>timeInSeconds</code> parameter can be <code>'1586400675'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>offsetInNanos</code> parameter can be <code>$variable.time</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>timeInSeconds</code> parameter uses a substitution template.
     * <p>
     * <code>'${$input.TemperatureInput.sensorData.timestamp / 1000}'</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AssetPropertyTimestampProperty assetPropertyTimestampProperty = AssetPropertyTimestampProperty.builder()
     *         .timeInSeconds("timeInSeconds")
     *         // the properties below are optional
     *         .offsetInNanos("offsetInNanos")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertytimestamp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertytimestamp.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.AssetPropertyTimestampProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyTimestampProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyTimestampProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The timestamp, in seconds, in the Unix epoch format.
         * <p>
         * The valid range is between 1-31556889864403199.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertytimestamp.html#cfn-iotevents-alarmmodel-assetpropertytimestamp-timeinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertytimestamp.html#cfn-iotevents-alarmmodel-assetpropertytimestamp-timeinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeInSeconds();

        /**
         * The nanosecond offset converted from <code>timeInSeconds</code> .
         * <p>
         * The valid range is between 0-999999999.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertytimestamp.html#cfn-iotevents-alarmmodel-assetpropertytimestamp-offsetinnanos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertytimestamp.html#cfn-iotevents-alarmmodel-assetpropertytimestamp-offsetinnanos</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOffsetInNanos() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyTimestampProperty> {
            java.lang.String timeInSeconds;
            java.lang.String offsetInNanos;

            /**
             * Sets the value of {@link AssetPropertyTimestampProperty#getTimeInSeconds}
             * @param timeInSeconds The timestamp, in seconds, in the Unix epoch format. This parameter is required.
             *                      The valid range is between 1-31556889864403199.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeInSeconds(java.lang.String timeInSeconds) {
                this.timeInSeconds = timeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyTimestampProperty#getOffsetInNanos}
             * @param offsetInNanos The nanosecond offset converted from <code>timeInSeconds</code> .
             *                      The valid range is between 0-999999999.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offsetInNanos(java.lang.String offsetInNanos) {
                this.offsetInNanos = offsetInNanos;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyTimestampProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyTimestampProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyTimestampProperty {
            private final java.lang.String timeInSeconds;
            private final java.lang.String offsetInNanos;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeInSeconds = software.amazon.jsii.Kernel.get(this, "timeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offsetInNanos = software.amazon.jsii.Kernel.get(this, "offsetInNanos", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeInSeconds = java.util.Objects.requireNonNull(builder.timeInSeconds, "timeInSeconds is required");
                this.offsetInNanos = builder.offsetInNanos;
            }

            @Override
            public final java.lang.String getTimeInSeconds() {
                return this.timeInSeconds;
            }

            @Override
            public final java.lang.String getOffsetInNanos() {
                return this.offsetInNanos;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeInSeconds", om.valueToTree(this.getTimeInSeconds()));
                if (this.getOffsetInNanos() != null) {
                    data.set("offsetInNanos", om.valueToTree(this.getOffsetInNanos()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.AssetPropertyTimestampProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyTimestampProperty.Jsii$Proxy that = (AssetPropertyTimestampProperty.Jsii$Proxy) o;

                if (!timeInSeconds.equals(that.timeInSeconds)) return false;
                return this.offsetInNanos != null ? this.offsetInNanos.equals(that.offsetInNanos) : that.offsetInNanos == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timeInSeconds.hashCode();
                result = 31 * result + (this.offsetInNanos != null ? this.offsetInNanos.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains value information. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html">AssetPropertyValue</a> in the <em>AWS IoT SiteWise API Reference</em> .
     * <p>
     * You must use expressions for all parameters in <code>AssetPropertyValue</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>quality</code> parameter can be <code>'GOOD'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>quality</code> parameter can be <code>$input.TemperatureInput.sensorData.quality</code> .</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AssetPropertyValueProperty assetPropertyValueProperty = AssetPropertyValueProperty.builder()
     *         .value(AssetPropertyVariantProperty.builder()
     *                 .booleanValue("booleanValue")
     *                 .doubleValue("doubleValue")
     *                 .integerValue("integerValue")
     *                 .stringValue("stringValue")
     *                 .build())
     *         // the properties below are optional
     *         .quality("quality")
     *         .timestamp(AssetPropertyTimestampProperty.builder()
     *                 .timeInSeconds("timeInSeconds")
     *                 // the properties below are optional
     *                 .offsetInNanos("offsetInNanos")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.AssetPropertyValueProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to send to an asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvalue.html#cfn-iotevents-alarmmodel-assetpropertyvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvalue.html#cfn-iotevents-alarmmodel-assetpropertyvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * The quality of the asset property value.
         * <p>
         * The value must be <code>'GOOD'</code> , <code>'BAD'</code> , or <code>'UNCERTAIN'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvalue.html#cfn-iotevents-alarmmodel-assetpropertyvalue-quality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvalue.html#cfn-iotevents-alarmmodel-assetpropertyvalue-quality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuality() {
            return null;
        }

        /**
         * The timestamp associated with the asset property value.
         * <p>
         * The default is the current event time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvalue.html#cfn-iotevents-alarmmodel-assetpropertyvalue-timestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvalue.html#cfn-iotevents-alarmmodel-assetpropertyvalue-timestamp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyValueProperty> {
            java.lang.Object value;
            java.lang.String quality;
            java.lang.Object timestamp;

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getValue}
             * @param value The value to send to an asset property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getValue}
             * @param value The value to send to an asset property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.iotevents.CfnAlarmModel.AssetPropertyVariantProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getQuality}
             * @param quality The quality of the asset property value.
             *                The value must be <code>'GOOD'</code> , <code>'BAD'</code> , or <code>'UNCERTAIN'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quality(java.lang.String quality) {
                this.quality = quality;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getTimestamp}
             * @param timestamp The timestamp associated with the asset property value.
             *                  The default is the current event time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getTimestamp}
             * @param timestamp The timestamp associated with the asset property value.
             *                  The default is the current event time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.services.iotevents.CfnAlarmModel.AssetPropertyTimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyValueProperty {
            private final java.lang.Object value;
            private final java.lang.String quality;
            private final java.lang.Object timestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.quality = software.amazon.jsii.Kernel.get(this, "quality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timestamp = software.amazon.jsii.Kernel.get(this, "timestamp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.quality = builder.quality;
                this.timestamp = builder.timestamp;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getQuality() {
                return this.quality;
            }

            @Override
            public final java.lang.Object getTimestamp() {
                return this.timestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));
                if (this.getQuality() != null) {
                    data.set("quality", om.valueToTree(this.getQuality()));
                }
                if (this.getTimestamp() != null) {
                    data.set("timestamp", om.valueToTree(this.getTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.AssetPropertyValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyValueProperty.Jsii$Proxy that = (AssetPropertyValueProperty.Jsii$Proxy) o;

                if (!value.equals(that.value)) return false;
                if (this.quality != null ? !this.quality.equals(that.quality) : that.quality != null) return false;
                return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                result = 31 * result + (this.quality != null ? this.quality.hashCode() : 0);
                result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains an asset property value.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html">Variant</a> in the <em>AWS IoT SiteWise API Reference</em> .
     * <p>
     * You must use expressions for all parameters in <code>AssetPropertyVariant</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>integerValue</code> parameter can be <code>'100'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or parameters. For example, the value for the <code>booleanValue</code> parameter can be <code>$variable.offline</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>doubleValue</code> parameter uses a substitution template.
     * <p>
     * <code>'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * You must specify one of the following value types, depending on the <code>dataType</code> of the specified asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html">AssetProperty</a> in the <em>AWS IoT SiteWise API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AssetPropertyVariantProperty assetPropertyVariantProperty = AssetPropertyVariantProperty.builder()
     *         .booleanValue("booleanValue")
     *         .doubleValue("doubleValue")
     *         .integerValue("integerValue")
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.AssetPropertyVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code> .
         * <p>
         * You must use an expression, and the evaluated result should be a Boolean value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html#cfn-iotevents-alarmmodel-assetpropertyvariant-booleanvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html#cfn-iotevents-alarmmodel-assetpropertyvariant-booleanvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBooleanValue() {
            return null;
        }

        /**
         * The asset property value is a double.
         * <p>
         * You must use an expression, and the evaluated result should be a double.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html#cfn-iotevents-alarmmodel-assetpropertyvariant-doublevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html#cfn-iotevents-alarmmodel-assetpropertyvariant-doublevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDoubleValue() {
            return null;
        }

        /**
         * The asset property value is an integer.
         * <p>
         * You must use an expression, and the evaluated result should be an integer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html#cfn-iotevents-alarmmodel-assetpropertyvariant-integervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html#cfn-iotevents-alarmmodel-assetpropertyvariant-integervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntegerValue() {
            return null;
        }

        /**
         * The asset property value is a string.
         * <p>
         * You must use an expression, and the evaluated result should be a string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html#cfn-iotevents-alarmmodel-assetpropertyvariant-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-assetpropertyvariant.html#cfn-iotevents-alarmmodel-assetpropertyvariant-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyVariantProperty> {
            java.lang.String booleanValue;
            java.lang.String doubleValue;
            java.lang.String integerValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getBooleanValue}
             * @param booleanValue The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code> .
             *                     You must use an expression, and the evaluated result should be a Boolean value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(java.lang.String booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getDoubleValue}
             * @param doubleValue The asset property value is a double.
             *                    You must use an expression, and the evaluated result should be a double.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.String doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getIntegerValue}
             * @param integerValue The asset property value is an integer.
             *                     You must use an expression, and the evaluated result should be an integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerValue(java.lang.String integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getStringValue}
             * @param stringValue The asset property value is a string.
             *                    You must use an expression, and the evaluated result should be a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyVariantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyVariantProperty {
            private final java.lang.String booleanValue;
            private final java.lang.String doubleValue;
            private final java.lang.String integerValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanValue = software.amazon.jsii.Kernel.get(this, "booleanValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "doubleValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integerValue = software.amazon.jsii.Kernel.get(this, "integerValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanValue = builder.booleanValue;
                this.doubleValue = builder.doubleValue;
                this.integerValue = builder.integerValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.String getBooleanValue() {
                return this.booleanValue;
            }

            @Override
            public final java.lang.String getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.String getIntegerValue() {
                return this.integerValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanValue() != null) {
                    data.set("booleanValue", om.valueToTree(this.getBooleanValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("doubleValue", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getIntegerValue() != null) {
                    data.set("integerValue", om.valueToTree(this.getIntegerValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.AssetPropertyVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyVariantProperty.Jsii$Proxy that = (AssetPropertyVariantProperty.Jsii$Proxy) o;

                if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.integerValue != null ? !this.integerValue.equals(that.integerValue) : that.integerValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanValue != null ? this.booleanValue.hashCode() : 0;
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.integerValue != null ? this.integerValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines an action to write to the Amazon DynamoDB table that you created.
     * <p>
     * The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
     * <p>
     * You must use expressions for all parameters in <code>DynamoDBAction</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template.
     * <p>
     * <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code>
     * <p>
     * <ul>
     * <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
     * <p>
     * <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>&lt;payload-field&gt;_raw</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * DynamoDBProperty dynamoDBProperty = DynamoDBProperty.builder()
     *         .hashKeyField("hashKeyField")
     *         .hashKeyValue("hashKeyValue")
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .hashKeyType("hashKeyType")
     *         .operation("operation")
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .payloadField("payloadField")
     *         .rangeKeyField("rangeKeyField")
     *         .rangeKeyType("rangeKeyType")
     *         .rangeKeyValue("rangeKeyValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.DynamoDBProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the hash key (also called the partition key).
         * <p>
         * The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-hashkeyfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-hashkeyfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHashKeyField();

        /**
         * The value of the hash key (also called the partition key).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-hashkeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-hashkeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHashKeyValue();

        /**
         * The name of the DynamoDB table.
         * <p>
         * The <code>tableName</code> value must match the table name of the target DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * The data type for the hash key (also called the partition key). You can specify the following values:.
         * <p>
         * <ul>
         * <li><code>'STRING'</code> - The hash key is a string.</li>
         * <li><code>'NUMBER'</code> - The hash key is a number.</li>
         * </ul>
         * <p>
         * If you don't specify <code>hashKeyType</code> , the default value is <code>'STRING'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-hashkeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-hashkeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHashKeyType() {
            return null;
        }

        /**
         * The type of operation to perform. You can specify the following values:.
         * <p>
         * <ul>
         * <li><code>'INSERT'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</li>
         * <li><code>'UPDATE'</code> - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</li>
         * <li><code>'DELETE'</code> - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</li>
         * </ul>
         * <p>
         * If you don't specify this parameter, AWS IoT Events triggers the <code>'INSERT'</code> operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-operation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-operation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperation() {
            return null;
        }

        /**
         * Information needed to configure the payload.
         * <p>
         * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * The name of the DynamoDB column that receives the action payload.
         * <p>
         * If you don't specify this parameter, the name of the DynamoDB column is <code>payload</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-payloadfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-payloadfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayloadField() {
            return null;
        }

        /**
         * The name of the range key (also called the sort key).
         * <p>
         * The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-rangekeyfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-rangekeyfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyField() {
            return null;
        }

        /**
         * The data type for the range key (also called the sort key), You can specify the following values:.
         * <p>
         * <ul>
         * <li><code>'STRING'</code> - The range key is a string.</li>
         * <li><code>'NUMBER'</code> - The range key is number.</li>
         * </ul>
         * <p>
         * If you don't specify <code>rangeKeyField</code> , the default value is <code>'STRING'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-rangekeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-rangekeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyType() {
            return null;
        }

        /**
         * The value of the range key (also called the sort key).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-rangekeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodb.html#cfn-iotevents-alarmmodel-dynamodb-rangekeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBProperty> {
            java.lang.String hashKeyField;
            java.lang.String hashKeyValue;
            java.lang.String tableName;
            java.lang.String hashKeyType;
            java.lang.String operation;
            java.lang.Object payload;
            java.lang.String payloadField;
            java.lang.String rangeKeyField;
            java.lang.String rangeKeyType;
            java.lang.String rangeKeyValue;

            /**
             * Sets the value of {@link DynamoDBProperty#getHashKeyField}
             * @param hashKeyField The name of the hash key (also called the partition key). This parameter is required.
             *                     The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyField(java.lang.String hashKeyField) {
                this.hashKeyField = hashKeyField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getHashKeyValue}
             * @param hashKeyValue The value of the hash key (also called the partition key). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyValue(java.lang.String hashKeyValue) {
                this.hashKeyValue = hashKeyValue;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getTableName}
             * @param tableName The name of the DynamoDB table. This parameter is required.
             *                  The <code>tableName</code> value must match the table name of the target DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getHashKeyType}
             * @param hashKeyType The data type for the hash key (also called the partition key). You can specify the following values:.
             *                    <ul>
             *                    <li><code>'STRING'</code> - The hash key is a string.</li>
             *                    <li><code>'NUMBER'</code> - The hash key is a number.</li>
             *                    </ul>
             *                    <p>
             *                    If you don't specify <code>hashKeyType</code> , the default value is <code>'STRING'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyType(java.lang.String hashKeyType) {
                this.hashKeyType = hashKeyType;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getOperation}
             * @param operation The type of operation to perform. You can specify the following values:.
             *                  <ul>
             *                  <li><code>'INSERT'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</li>
             *                  <li><code>'UPDATE'</code> - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</li>
             *                  <li><code>'DELETE'</code> - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</li>
             *                  </ul>
             *                  <p>
             *                  If you don't specify this parameter, AWS IoT Events triggers the <code>'INSERT'</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operation(java.lang.String operation) {
                this.operation = operation;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getPayload}
             * @param payload Information needed to configure the payload.
             *                By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getPayload}
             * @param payload Information needed to configure the payload.
             *                By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnAlarmModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getPayloadField}
             * @param payloadField The name of the DynamoDB column that receives the action payload.
             *                     If you don't specify this parameter, the name of the DynamoDB column is <code>payload</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadField(java.lang.String payloadField) {
                this.payloadField = payloadField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getRangeKeyField}
             * @param rangeKeyField The name of the range key (also called the sort key).
             *                      The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyField(java.lang.String rangeKeyField) {
                this.rangeKeyField = rangeKeyField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getRangeKeyType}
             * @param rangeKeyType The data type for the range key (also called the sort key), You can specify the following values:.
             *                     <ul>
             *                     <li><code>'STRING'</code> - The range key is a string.</li>
             *                     <li><code>'NUMBER'</code> - The range key is number.</li>
             *                     </ul>
             *                     <p>
             *                     If you don't specify <code>rangeKeyField</code> , the default value is <code>'STRING'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyType(java.lang.String rangeKeyType) {
                this.rangeKeyType = rangeKeyType;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getRangeKeyValue}
             * @param rangeKeyValue The value of the range key (also called the sort key).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyValue(java.lang.String rangeKeyValue) {
                this.rangeKeyValue = rangeKeyValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBProperty {
            private final java.lang.String hashKeyField;
            private final java.lang.String hashKeyValue;
            private final java.lang.String tableName;
            private final java.lang.String hashKeyType;
            private final java.lang.String operation;
            private final java.lang.Object payload;
            private final java.lang.String payloadField;
            private final java.lang.String rangeKeyField;
            private final java.lang.String rangeKeyType;
            private final java.lang.String rangeKeyValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hashKeyField = software.amazon.jsii.Kernel.get(this, "hashKeyField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hashKeyValue = software.amazon.jsii.Kernel.get(this, "hashKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hashKeyType = software.amazon.jsii.Kernel.get(this, "hashKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operation = software.amazon.jsii.Kernel.get(this, "operation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.payloadField = software.amazon.jsii.Kernel.get(this, "payloadField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyField = software.amazon.jsii.Kernel.get(this, "rangeKeyField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyType = software.amazon.jsii.Kernel.get(this, "rangeKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyValue = software.amazon.jsii.Kernel.get(this, "rangeKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hashKeyField = java.util.Objects.requireNonNull(builder.hashKeyField, "hashKeyField is required");
                this.hashKeyValue = java.util.Objects.requireNonNull(builder.hashKeyValue, "hashKeyValue is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.hashKeyType = builder.hashKeyType;
                this.operation = builder.operation;
                this.payload = builder.payload;
                this.payloadField = builder.payloadField;
                this.rangeKeyField = builder.rangeKeyField;
                this.rangeKeyType = builder.rangeKeyType;
                this.rangeKeyValue = builder.rangeKeyValue;
            }

            @Override
            public final java.lang.String getHashKeyField() {
                return this.hashKeyField;
            }

            @Override
            public final java.lang.String getHashKeyValue() {
                return this.hashKeyValue;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getHashKeyType() {
                return this.hashKeyType;
            }

            @Override
            public final java.lang.String getOperation() {
                return this.operation;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.String getPayloadField() {
                return this.payloadField;
            }

            @Override
            public final java.lang.String getRangeKeyField() {
                return this.rangeKeyField;
            }

            @Override
            public final java.lang.String getRangeKeyType() {
                return this.rangeKeyType;
            }

            @Override
            public final java.lang.String getRangeKeyValue() {
                return this.rangeKeyValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hashKeyField", om.valueToTree(this.getHashKeyField()));
                data.set("hashKeyValue", om.valueToTree(this.getHashKeyValue()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getHashKeyType() != null) {
                    data.set("hashKeyType", om.valueToTree(this.getHashKeyType()));
                }
                if (this.getOperation() != null) {
                    data.set("operation", om.valueToTree(this.getOperation()));
                }
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getPayloadField() != null) {
                    data.set("payloadField", om.valueToTree(this.getPayloadField()));
                }
                if (this.getRangeKeyField() != null) {
                    data.set("rangeKeyField", om.valueToTree(this.getRangeKeyField()));
                }
                if (this.getRangeKeyType() != null) {
                    data.set("rangeKeyType", om.valueToTree(this.getRangeKeyType()));
                }
                if (this.getRangeKeyValue() != null) {
                    data.set("rangeKeyValue", om.valueToTree(this.getRangeKeyValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.DynamoDBProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBProperty.Jsii$Proxy that = (DynamoDBProperty.Jsii$Proxy) o;

                if (!hashKeyField.equals(that.hashKeyField)) return false;
                if (!hashKeyValue.equals(that.hashKeyValue)) return false;
                if (!tableName.equals(that.tableName)) return false;
                if (this.hashKeyType != null ? !this.hashKeyType.equals(that.hashKeyType) : that.hashKeyType != null) return false;
                if (this.operation != null ? !this.operation.equals(that.operation) : that.operation != null) return false;
                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                if (this.payloadField != null ? !this.payloadField.equals(that.payloadField) : that.payloadField != null) return false;
                if (this.rangeKeyField != null ? !this.rangeKeyField.equals(that.rangeKeyField) : that.rangeKeyField != null) return false;
                if (this.rangeKeyType != null ? !this.rangeKeyType.equals(that.rangeKeyType) : that.rangeKeyType != null) return false;
                return this.rangeKeyValue != null ? this.rangeKeyValue.equals(that.rangeKeyValue) : that.rangeKeyValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hashKeyField.hashCode();
                result = 31 * result + (this.hashKeyValue.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.hashKeyType != null ? this.hashKeyType.hashCode() : 0);
                result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                result = 31 * result + (this.payloadField != null ? this.payloadField.hashCode() : 0);
                result = 31 * result + (this.rangeKeyField != null ? this.rangeKeyField.hashCode() : 0);
                result = 31 * result + (this.rangeKeyType != null ? this.rangeKeyType.hashCode() : 0);
                result = 31 * result + (this.rangeKeyValue != null ? this.rangeKeyValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines an action to write to the Amazon DynamoDB table that you created.
     * <p>
     * The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
     * <p>
     * You must use expressions for all parameters in <code>DynamoDBv2Action</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template.
     * <p>
     * <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code>
     * <p>
     * <ul>
     * <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
     * <p>
     * <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * DynamoDBv2Property dynamoDBv2Property = DynamoDBv2Property.builder()
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodbv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodbv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.DynamoDBv2Property")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBv2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBv2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodbv2.html#cfn-iotevents-alarmmodel-dynamodbv2-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodbv2.html#cfn-iotevents-alarmmodel-dynamodbv2-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * Information needed to configure the payload.
         * <p>
         * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodbv2.html#cfn-iotevents-alarmmodel-dynamodbv2-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-dynamodbv2.html#cfn-iotevents-alarmmodel-dynamodbv2-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBv2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBv2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBv2Property> {
            java.lang.String tableName;
            java.lang.Object payload;

            /**
             * Sets the value of {@link DynamoDBv2Property#getTableName}
             * @param tableName The name of the DynamoDB table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBv2Property#getPayload}
             * @param payload Information needed to configure the payload.
             *                By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBv2Property#getPayload}
             * @param payload Information needed to configure the payload.
             *                By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnAlarmModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBv2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBv2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBv2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBv2Property {
            private final java.lang.String tableName;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.DynamoDBv2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBv2Property.Jsii$Proxy that = (DynamoDBv2Property.Jsii$Proxy) o;

                if (!tableName.equals(that.tableName)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tableName.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * FirehoseProperty firehoseProperty = FirehoseProperty.builder()
     *         .deliveryStreamName("deliveryStreamName")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .separator("separator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-firehose.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-firehose.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.FirehoseProperty")
    @software.amazon.jsii.Jsii.Proxy(FirehoseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FirehoseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Kinesis Data Firehose delivery stream where the data is written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-firehose.html#cfn-iotevents-alarmmodel-firehose-deliverystreamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-firehose.html#cfn-iotevents-alarmmodel-firehose-deliverystreamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStreamName();

        /**
         * You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-firehose.html#cfn-iotevents-alarmmodel-firehose-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-firehose.html#cfn-iotevents-alarmmodel-firehose-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream.
         * <p>
         * Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-firehose.html#cfn-iotevents-alarmmodel-firehose-separator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-firehose.html#cfn-iotevents-alarmmodel-firehose-separator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSeparator() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FirehoseProperty> {
            java.lang.String deliveryStreamName;
            java.lang.Object payload;
            java.lang.String separator;

            /**
             * Sets the value of {@link FirehoseProperty#getDeliveryStreamName}
             * @param deliveryStreamName The name of the Kinesis Data Firehose delivery stream where the data is written. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
                this.deliveryStreamName = deliveryStreamName;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnAlarmModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseProperty#getSeparator}
             * @param separator A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream.
             *                  Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder separator(java.lang.String separator) {
                this.separator = separator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FirehoseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FirehoseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirehoseProperty {
            private final java.lang.String deliveryStreamName;
            private final java.lang.Object payload;
            private final java.lang.String separator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.separator = software.amazon.jsii.Kernel.get(this, "separator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryStreamName = java.util.Objects.requireNonNull(builder.deliveryStreamName, "deliveryStreamName is required");
                this.payload = builder.payload;
                this.separator = builder.separator;
            }

            @Override
            public final java.lang.String getDeliveryStreamName() {
                return this.deliveryStreamName;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.String getSeparator() {
                return this.separator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getSeparator() != null) {
                    data.set("separator", om.valueToTree(this.getSeparator()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.FirehoseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FirehoseProperty.Jsii$Proxy that = (FirehoseProperty.Jsii$Proxy) o;

                if (!deliveryStreamName.equals(that.deliveryStreamName)) return false;
                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                return this.separator != null ? this.separator.equals(that.separator) : that.separator == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryStreamName.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                result = 31 * result + (this.separator != null ? this.separator.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default alarm state.
     * <p>
     * The configuration applies to all alarms that were created based on this alarm model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * InitializationConfigurationProperty initializationConfigurationProperty = InitializationConfigurationProperty.builder()
     *         .disabledOnInitialization(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-initializationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-initializationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.InitializationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InitializationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InitializationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value must be <code>TRUE</code> or <code>FALSE</code> .
         * <p>
         * If <code>FALSE</code> , all alarm instances created based on the alarm model are activated. The default value is <code>TRUE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-initializationconfiguration.html#cfn-iotevents-alarmmodel-initializationconfiguration-disabledoninitialization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-initializationconfiguration.html#cfn-iotevents-alarmmodel-initializationconfiguration-disabledoninitialization</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDisabledOnInitialization();

        /**
         * @return a {@link Builder} of {@link InitializationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InitializationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InitializationConfigurationProperty> {
            java.lang.Object disabledOnInitialization;

            /**
             * Sets the value of {@link InitializationConfigurationProperty#getDisabledOnInitialization}
             * @param disabledOnInitialization The value must be <code>TRUE</code> or <code>FALSE</code> . This parameter is required.
             *                                 If <code>FALSE</code> , all alarm instances created based on the alarm model are activated. The default value is <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disabledOnInitialization(java.lang.Boolean disabledOnInitialization) {
                this.disabledOnInitialization = disabledOnInitialization;
                return this;
            }

            /**
             * Sets the value of {@link InitializationConfigurationProperty#getDisabledOnInitialization}
             * @param disabledOnInitialization The value must be <code>TRUE</code> or <code>FALSE</code> . This parameter is required.
             *                                 If <code>FALSE</code> , all alarm instances created based on the alarm model are activated. The default value is <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disabledOnInitialization(software.amazon.awscdk.IResolvable disabledOnInitialization) {
                this.disabledOnInitialization = disabledOnInitialization;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InitializationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InitializationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InitializationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitializationConfigurationProperty {
            private final java.lang.Object disabledOnInitialization;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.disabledOnInitialization = software.amazon.jsii.Kernel.get(this, "disabledOnInitialization", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.disabledOnInitialization = java.util.Objects.requireNonNull(builder.disabledOnInitialization, "disabledOnInitialization is required");
            }

            @Override
            public final java.lang.Object getDisabledOnInitialization() {
                return this.disabledOnInitialization;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("disabledOnInitialization", om.valueToTree(this.getDisabledOnInitialization()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.InitializationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InitializationConfigurationProperty.Jsii$Proxy that = (InitializationConfigurationProperty.Jsii$Proxy) o;

                return this.disabledOnInitialization.equals(that.disabledOnInitialization);
            }

            @Override
            public final int hashCode() {
                int result = this.disabledOnInitialization.hashCode();
                return result;
            }
        }
    }
    /**
     * Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * IotEventsProperty iotEventsProperty = IotEventsProperty.builder()
     *         .inputName("inputName")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotevents.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotevents.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.IotEventsProperty")
    @software.amazon.jsii.Jsii.Proxy(IotEventsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotEventsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AWS IoT Events input where the data is sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotevents.html#cfn-iotevents-alarmmodel-iotevents-inputname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotevents.html#cfn-iotevents-alarmmodel-iotevents-inputname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputName();

        /**
         * You can configure the action payload when you send a message to an AWS IoT Events input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotevents.html#cfn-iotevents-alarmmodel-iotevents-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotevents.html#cfn-iotevents-alarmmodel-iotevents-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotEventsProperty> {
            java.lang.String inputName;
            java.lang.Object payload;

            /**
             * Sets the value of {@link IotEventsProperty#getInputName}
             * @param inputName The name of the AWS IoT Events input where the data is sent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputName(java.lang.String inputName) {
                this.inputName = inputName;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an AWS IoT Events input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an AWS IoT Events input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnAlarmModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotEventsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotEventsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotEventsProperty {
            private final java.lang.String inputName;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputName = software.amazon.jsii.Kernel.get(this, "inputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputName = java.util.Objects.requireNonNull(builder.inputName, "inputName is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getInputName() {
                return this.inputName;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputName", om.valueToTree(this.getInputName()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.IotEventsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotEventsProperty.Jsii$Proxy that = (IotEventsProperty.Jsii$Proxy) o;

                if (!inputName.equals(that.inputName)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputName.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise .
     * <p>
     * You must use expressions for all parameters in <code>IotSiteWiseAction</code> . The expressions accept literals, operators, functions, references, and substitutions templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template.
     * <p>
     * <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code>
     * <p>
     * You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * IotSiteWiseProperty iotSiteWiseProperty = IotSiteWiseProperty.builder()
     *         .assetId("assetId")
     *         .entryId("entryId")
     *         .propertyAlias("propertyAlias")
     *         .propertyId("propertyId")
     *         .propertyValue(AssetPropertyValueProperty.builder()
     *                 .value(AssetPropertyVariantProperty.builder()
     *                         .booleanValue("booleanValue")
     *                         .doubleValue("doubleValue")
     *                         .integerValue("integerValue")
     *                         .stringValue("stringValue")
     *                         .build())
     *                 // the properties below are optional
     *                 .quality("quality")
     *                 .timestamp(AssetPropertyTimestampProperty.builder()
     *                         .timeInSeconds("timeInSeconds")
     *                         // the properties below are optional
     *                         .offsetInNanos("offsetInNanos")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.IotSiteWiseProperty")
    @software.amazon.jsii.Jsii.Proxy(IotSiteWiseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotSiteWiseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the asset that has the specified property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-assetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-assetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssetId() {
            return null;
        }

        /**
         * A unique identifier for this entry.
         * <p>
         * You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-entryid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-entryid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntryId() {
            return null;
        }

        /**
         * The alias of the asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-propertyalias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-propertyalias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyAlias() {
            return null;
        }

        /**
         * The ID of the asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-propertyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-propertyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyId() {
            return null;
        }

        /**
         * The value to send to the asset property.
         * <p>
         * This value contains timestamp, quality, and value (TQV) information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-propertyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iotsitewise.html#cfn-iotevents-alarmmodel-iotsitewise-propertyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotSiteWiseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotSiteWiseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotSiteWiseProperty> {
            java.lang.String assetId;
            java.lang.String entryId;
            java.lang.String propertyAlias;
            java.lang.String propertyId;
            java.lang.Object propertyValue;

            /**
             * Sets the value of {@link IotSiteWiseProperty#getAssetId}
             * @param assetId The ID of the asset that has the specified property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetId(java.lang.String assetId) {
                this.assetId = assetId;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getEntryId}
             * @param entryId A unique identifier for this entry.
             *                You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entryId(java.lang.String entryId) {
                this.entryId = entryId;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getPropertyAlias}
             * @param propertyAlias The alias of the asset property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyAlias(java.lang.String propertyAlias) {
                this.propertyAlias = propertyAlias;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getPropertyId}
             * @param propertyId The ID of the asset property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyId(java.lang.String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getPropertyValue}
             * @param propertyValue The value to send to the asset property.
             *                      This value contains timestamp, quality, and value (TQV) information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValue(software.amazon.awscdk.IResolvable propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getPropertyValue}
             * @param propertyValue The value to send to the asset property.
             *                      This value contains timestamp, quality, and value (TQV) information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValue(software.amazon.awscdk.services.iotevents.CfnAlarmModel.AssetPropertyValueProperty propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotSiteWiseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotSiteWiseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotSiteWiseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotSiteWiseProperty {
            private final java.lang.String assetId;
            private final java.lang.String entryId;
            private final java.lang.String propertyAlias;
            private final java.lang.String propertyId;
            private final java.lang.Object propertyValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assetId = software.amazon.jsii.Kernel.get(this, "assetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entryId = software.amazon.jsii.Kernel.get(this, "entryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyAlias = software.amazon.jsii.Kernel.get(this, "propertyAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyId = software.amazon.jsii.Kernel.get(this, "propertyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyValue = software.amazon.jsii.Kernel.get(this, "propertyValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assetId = builder.assetId;
                this.entryId = builder.entryId;
                this.propertyAlias = builder.propertyAlias;
                this.propertyId = builder.propertyId;
                this.propertyValue = builder.propertyValue;
            }

            @Override
            public final java.lang.String getAssetId() {
                return this.assetId;
            }

            @Override
            public final java.lang.String getEntryId() {
                return this.entryId;
            }

            @Override
            public final java.lang.String getPropertyAlias() {
                return this.propertyAlias;
            }

            @Override
            public final java.lang.String getPropertyId() {
                return this.propertyId;
            }

            @Override
            public final java.lang.Object getPropertyValue() {
                return this.propertyValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssetId() != null) {
                    data.set("assetId", om.valueToTree(this.getAssetId()));
                }
                if (this.getEntryId() != null) {
                    data.set("entryId", om.valueToTree(this.getEntryId()));
                }
                if (this.getPropertyAlias() != null) {
                    data.set("propertyAlias", om.valueToTree(this.getPropertyAlias()));
                }
                if (this.getPropertyId() != null) {
                    data.set("propertyId", om.valueToTree(this.getPropertyId()));
                }
                if (this.getPropertyValue() != null) {
                    data.set("propertyValue", om.valueToTree(this.getPropertyValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.IotSiteWiseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotSiteWiseProperty.Jsii$Proxy that = (IotSiteWiseProperty.Jsii$Proxy) o;

                if (this.assetId != null ? !this.assetId.equals(that.assetId) : that.assetId != null) return false;
                if (this.entryId != null ? !this.entryId.equals(that.entryId) : that.entryId != null) return false;
                if (this.propertyAlias != null ? !this.propertyAlias.equals(that.propertyAlias) : that.propertyAlias != null) return false;
                if (this.propertyId != null ? !this.propertyId.equals(that.propertyId) : that.propertyId != null) return false;
                return this.propertyValue != null ? this.propertyValue.equals(that.propertyValue) : that.propertyValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.assetId != null ? this.assetId.hashCode() : 0;
                result = 31 * result + (this.entryId != null ? this.entryId.hashCode() : 0);
                result = 31 * result + (this.propertyAlias != null ? this.propertyAlias.hashCode() : 0);
                result = 31 * result + (this.propertyId != null ? this.propertyId.hashCode() : 0);
                result = 31 * result + (this.propertyValue != null ? this.propertyValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information required to publish the MQTT message through the AWS IoT message broker.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * IotTopicPublishProperty iotTopicPublishProperty = IotTopicPublishProperty.builder()
     *         .mqttTopic("mqttTopic")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iottopicpublish.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iottopicpublish.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.IotTopicPublishProperty")
    @software.amazon.jsii.Jsii.Proxy(IotTopicPublishProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotTopicPublishProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The MQTT topic of the message.
         * <p>
         * You can use a string expression that includes variables ( <code>$variable.&lt;variable-name&gt;</code> ) and input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ) as the topic string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iottopicpublish.html#cfn-iotevents-alarmmodel-iottopicpublish-mqtttopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iottopicpublish.html#cfn-iotevents-alarmmodel-iottopicpublish-mqtttopic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMqttTopic();

        /**
         * You can configure the action payload when you publish a message to an AWS IoT Core topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iottopicpublish.html#cfn-iotevents-alarmmodel-iottopicpublish-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-iottopicpublish.html#cfn-iotevents-alarmmodel-iottopicpublish-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotTopicPublishProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotTopicPublishProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotTopicPublishProperty> {
            java.lang.String mqttTopic;
            java.lang.Object payload;

            /**
             * Sets the value of {@link IotTopicPublishProperty#getMqttTopic}
             * @param mqttTopic The MQTT topic of the message. This parameter is required.
             *                  You can use a string expression that includes variables ( <code>$variable.&lt;variable-name&gt;</code> ) and input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ) as the topic string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mqttTopic(java.lang.String mqttTopic) {
                this.mqttTopic = mqttTopic;
                return this;
            }

            /**
             * Sets the value of {@link IotTopicPublishProperty#getPayload}
             * @param payload You can configure the action payload when you publish a message to an AWS IoT Core topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link IotTopicPublishProperty#getPayload}
             * @param payload You can configure the action payload when you publish a message to an AWS IoT Core topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnAlarmModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotTopicPublishProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotTopicPublishProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotTopicPublishProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotTopicPublishProperty {
            private final java.lang.String mqttTopic;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mqttTopic = software.amazon.jsii.Kernel.get(this, "mqttTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mqttTopic = java.util.Objects.requireNonNull(builder.mqttTopic, "mqttTopic is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getMqttTopic() {
                return this.mqttTopic;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mqttTopic", om.valueToTree(this.getMqttTopic()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.IotTopicPublishProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotTopicPublishProperty.Jsii$Proxy that = (IotTopicPublishProperty.Jsii$Proxy) o;

                if (!mqttTopic.equals(that.mqttTopic)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mqttTopic.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * LambdaProperty lambdaProperty = LambdaProperty.builder()
     *         .functionArn("functionArn")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-lambda.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-lambda.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.LambdaProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Lambda function that is executed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-lambda.html#cfn-iotevents-alarmmodel-lambda-functionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-lambda.html#cfn-iotevents-alarmmodel-lambda-functionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

        /**
         * You can configure the action payload when you send a message to a Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-lambda.html#cfn-iotevents-alarmmodel-lambda-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-lambda.html#cfn-iotevents-alarmmodel-lambda-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaProperty> {
            java.lang.String functionArn;
            java.lang.Object payload;

            /**
             * Sets the value of {@link LambdaProperty#getFunctionArn}
             * @param functionArn The ARN of the Lambda function that is executed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Sets the value of {@link LambdaProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to a Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link LambdaProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to a Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnAlarmModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaProperty {
            private final java.lang.String functionArn;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.LambdaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaProperty.Jsii$Proxy that = (LambdaProperty.Jsii$Proxy) o;

                if (!functionArn.equals(that.functionArn)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.functionArn.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information needed to configure the payload.
     * <p>
     * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * PayloadProperty payloadProperty = PayloadProperty.builder()
     *         .contentExpression("contentExpression")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-payload.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-payload.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.PayloadProperty")
    @software.amazon.jsii.Jsii.Proxy(PayloadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PayloadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The content of the payload.
         * <p>
         * You can use a string expression that includes quoted strings ( <code>'&lt;string&gt;'</code> ), variables ( <code>$variable.&lt;variable-name&gt;</code> ), input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-payload.html#cfn-iotevents-alarmmodel-payload-contentexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-payload.html#cfn-iotevents-alarmmodel-payload-contentexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContentExpression();

        /**
         * The value of the payload type can be either <code>STRING</code> or <code>JSON</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-payload.html#cfn-iotevents-alarmmodel-payload-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-payload.html#cfn-iotevents-alarmmodel-payload-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link PayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PayloadProperty> {
            java.lang.String contentExpression;
            java.lang.String type;

            /**
             * Sets the value of {@link PayloadProperty#getContentExpression}
             * @param contentExpression The content of the payload. This parameter is required.
             *                          You can use a string expression that includes quoted strings ( <code>'&lt;string&gt;'</code> ), variables ( <code>$variable.&lt;variable-name&gt;</code> ), input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentExpression(java.lang.String contentExpression) {
                this.contentExpression = contentExpression;
                return this;
            }

            /**
             * Sets the value of {@link PayloadProperty#getType}
             * @param type The value of the payload type can be either <code>STRING</code> or <code>JSON</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PayloadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PayloadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PayloadProperty {
            private final java.lang.String contentExpression;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contentExpression = software.amazon.jsii.Kernel.get(this, "contentExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contentExpression = java.util.Objects.requireNonNull(builder.contentExpression, "contentExpression is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getContentExpression() {
                return this.contentExpression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("contentExpression", om.valueToTree(this.getContentExpression()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.PayloadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PayloadProperty.Jsii$Proxy that = (PayloadProperty.Jsii$Proxy) o;

                if (!contentExpression.equals(that.contentExpression)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.contentExpression.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule that compares an input property value to a threshold value with a comparison operator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * SimpleRuleProperty simpleRuleProperty = SimpleRuleProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .inputProperty("inputProperty")
     *         .threshold("threshold")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-simplerule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-simplerule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.SimpleRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(SimpleRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SimpleRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The comparison operator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-simplerule.html#cfn-iotevents-alarmmodel-simplerule-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-simplerule.html#cfn-iotevents-alarmmodel-simplerule-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

        /**
         * The value on the left side of the comparison operator.
         * <p>
         * You can specify an AWS IoT Events input attribute as an input property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-simplerule.html#cfn-iotevents-alarmmodel-simplerule-inputproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-simplerule.html#cfn-iotevents-alarmmodel-simplerule-inputproperty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputProperty();

        /**
         * The value on the right side of the comparison operator.
         * <p>
         * You can enter a number or specify an AWS IoT Events input attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-simplerule.html#cfn-iotevents-alarmmodel-simplerule-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-simplerule.html#cfn-iotevents-alarmmodel-simplerule-threshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getThreshold();

        /**
         * @return a {@link Builder} of {@link SimpleRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SimpleRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SimpleRuleProperty> {
            java.lang.String comparisonOperator;
            java.lang.String inputProperty;
            java.lang.String threshold;

            /**
             * Sets the value of {@link SimpleRuleProperty#getComparisonOperator}
             * @param comparisonOperator The comparison operator. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link SimpleRuleProperty#getInputProperty}
             * @param inputProperty The value on the left side of the comparison operator. This parameter is required.
             *                      You can specify an AWS IoT Events input attribute as an input property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputProperty(java.lang.String inputProperty) {
                this.inputProperty = inputProperty;
                return this;
            }

            /**
             * Sets the value of {@link SimpleRuleProperty#getThreshold}
             * @param threshold The value on the right side of the comparison operator. This parameter is required.
             *                  You can enter a number or specify an AWS IoT Events input attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.String threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SimpleRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SimpleRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SimpleRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimpleRuleProperty {
            private final java.lang.String comparisonOperator;
            private final java.lang.String inputProperty;
            private final java.lang.String threshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputProperty = software.amazon.jsii.Kernel.get(this, "inputProperty", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
                this.inputProperty = java.util.Objects.requireNonNull(builder.inputProperty, "inputProperty is required");
                this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.String getInputProperty() {
                return this.inputProperty;
            }

            @Override
            public final java.lang.String getThreshold() {
                return this.threshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("inputProperty", om.valueToTree(this.getInputProperty()));
                data.set("threshold", om.valueToTree(this.getThreshold()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.SimpleRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SimpleRuleProperty.Jsii$Proxy that = (SimpleRuleProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!inputProperty.equals(that.inputProperty)) return false;
                return this.threshold.equals(that.threshold);
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.inputProperty.hashCode());
                result = 31 * result + (this.threshold.hashCode());
                return result;
            }
        }
    }
    /**
     * Information required to publish the Amazon SNS message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * SnsProperty snsProperty = SnsProperty.builder()
     *         .targetArn("targetArn")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sns.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sns.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.SnsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon SNS target where the message is sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sns.html#cfn-iotevents-alarmmodel-sns-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sns.html#cfn-iotevents-alarmmodel-sns-targetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

        /**
         * You can configure the action payload when you send a message as an Amazon SNS push notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sns.html#cfn-iotevents-alarmmodel-sns-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sns.html#cfn-iotevents-alarmmodel-sns-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnsProperty> {
            java.lang.String targetArn;
            java.lang.Object payload;

            /**
             * Sets the value of {@link SnsProperty#getTargetArn}
             * @param targetArn The ARN of the Amazon SNS target where the message is sent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetArn(java.lang.String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            /**
             * Sets the value of {@link SnsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message as an Amazon SNS push notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link SnsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message as an Amazon SNS push notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnAlarmModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsProperty {
            private final java.lang.String targetArn;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getTargetArn() {
                return this.targetArn;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetArn", om.valueToTree(this.getTargetArn()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.SnsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnsProperty.Jsii$Proxy that = (SnsProperty.Jsii$Proxy) o;

                if (!targetArn.equals(that.targetArn)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetArn.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * SqsProperty sqsProperty = SqsProperty.builder()
     *         .queueUrl("queueUrl")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .useBase64(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sqs.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sqs.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModel.SqsProperty")
    @software.amazon.jsii.Jsii.Proxy(SqsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the SQS queue where the data is written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sqs.html#cfn-iotevents-alarmmodel-sqs-queueurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sqs.html#cfn-iotevents-alarmmodel-sqs-queueurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl();

        /**
         * You can configure the action payload when you send a message to an Amazon SQS queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sqs.html#cfn-iotevents-alarmmodel-sqs-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sqs.html#cfn-iotevents-alarmmodel-sqs-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue.
         * <p>
         * Otherwise, set this to FALSE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sqs.html#cfn-iotevents-alarmmodel-sqs-usebase64">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-alarmmodel-sqs.html#cfn-iotevents-alarmmodel-sqs-usebase64</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseBase64() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SqsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqsProperty> {
            java.lang.String queueUrl;
            java.lang.Object payload;
            java.lang.Object useBase64;

            /**
             * Sets the value of {@link SqsProperty#getQueueUrl}
             * @param queueUrl The URL of the SQS queue where the data is written. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueUrl(java.lang.String queueUrl) {
                this.queueUrl = queueUrl;
                return this;
            }

            /**
             * Sets the value of {@link SqsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an Amazon SQS queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link SqsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an Amazon SQS queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnAlarmModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link SqsProperty#getUseBase64}
             * @param useBase64 Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue.
             *                  Otherwise, set this to FALSE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBase64(java.lang.Boolean useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            /**
             * Sets the value of {@link SqsProperty#getUseBase64}
             * @param useBase64 Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue.
             *                  Otherwise, set this to FALSE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBase64(software.amazon.awscdk.IResolvable useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqsProperty {
            private final java.lang.String queueUrl;
            private final java.lang.Object payload;
            private final java.lang.Object useBase64;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queueUrl = software.amazon.jsii.Kernel.get(this, "queueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useBase64 = software.amazon.jsii.Kernel.get(this, "useBase64", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queueUrl = java.util.Objects.requireNonNull(builder.queueUrl, "queueUrl is required");
                this.payload = builder.payload;
                this.useBase64 = builder.useBase64;
            }

            @Override
            public final java.lang.String getQueueUrl() {
                return this.queueUrl;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.Object getUseBase64() {
                return this.useBase64;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queueUrl", om.valueToTree(this.getQueueUrl()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getUseBase64() != null) {
                    data.set("useBase64", om.valueToTree(this.getUseBase64()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModel.SqsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqsProperty.Jsii$Proxy that = (SqsProperty.Jsii$Proxy) o;

                if (!queueUrl.equals(that.queueUrl)) return false;
                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                return this.useBase64 != null ? this.useBase64.equals(that.useBase64) : that.useBase64 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queueUrl.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                result = 31 * result + (this.useBase64 != null ? this.useBase64.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotevents.CfnAlarmModel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotevents.CfnAlarmModel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotevents.CfnAlarmModelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotevents.CfnAlarmModelProps.Builder();
        }

        /**
         * Defines when your alarm is invoked.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmrule</a>
         * @param alarmRule Defines when your alarm is invoked. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(final software.amazon.awscdk.IResolvable alarmRule) {
            this.props.alarmRule(alarmRule);
            return this;
        }
        /**
         * Defines when your alarm is invoked.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmrule</a>
         * @param alarmRule Defines when your alarm is invoked. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(final software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmRuleProperty alarmRule) {
            this.props.alarmRule(alarmRule);
            return this;
        }

        /**
         * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <em>AWS General Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-rolearn</a>
         * @param roleArn The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Contains the configuration information of alarm state changes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmcapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmcapabilities</a>
         * @param alarmCapabilities Contains the configuration information of alarm state changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmCapabilities(final software.amazon.awscdk.IResolvable alarmCapabilities) {
            this.props.alarmCapabilities(alarmCapabilities);
            return this;
        }
        /**
         * Contains the configuration information of alarm state changes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmcapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmcapabilities</a>
         * @param alarmCapabilities Contains the configuration information of alarm state changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmCapabilities(final software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmCapabilitiesProperty alarmCapabilities) {
            this.props.alarmCapabilities(alarmCapabilities);
            return this;
        }

        /**
         * Contains information about one or more alarm actions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmeventactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmeventactions</a>
         * @param alarmEventActions Contains information about one or more alarm actions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmEventActions(final software.amazon.awscdk.IResolvable alarmEventActions) {
            this.props.alarmEventActions(alarmEventActions);
            return this;
        }
        /**
         * Contains information about one or more alarm actions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmeventactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmeventactions</a>
         * @param alarmEventActions Contains information about one or more alarm actions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmEventActions(final software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmEventActionsProperty alarmEventActions) {
            this.props.alarmEventActions(alarmEventActions);
            return this;
        }

        /**
         * The description of the alarm model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmmodeldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmmodeldescription</a>
         * @param alarmModelDescription The description of the alarm model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmModelDescription(final java.lang.String alarmModelDescription) {
            this.props.alarmModelDescription(alarmModelDescription);
            return this;
        }

        /**
         * The name of the alarm model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmmodelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmmodelname</a>
         * @param alarmModelName The name of the alarm model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmModelName(final java.lang.String alarmModelName) {
            this.props.alarmModelName(alarmModelName);
            return this;
        }

        /**
         * An input attribute used as a key to create an alarm.
         * <p>
         * AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-key</a>
         * @param key An input attribute used as a key to create an alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(final java.lang.String key) {
            this.props.key(key);
            return this;
        }

        /**
         * A non-negative integer that reflects the severity level of the alarm.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-severity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-severity</a>
         * @param severity A non-negative integer that reflects the severity level of the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder severity(final java.lang.Number severity) {
            this.props.severity(severity);
            return this;
        }

        /**
         * A list of key-value pairs that contain metadata for the alarm model.
         * <p>
         * The tags help you manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events resources</a> in the <em>AWS IoT Events Developer Guide</em> .
         * <p>
         * You can create up to 50 tags for one alarm model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-tags</a>
         * @param tags A list of key-value pairs that contain metadata for the alarm model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotevents.CfnAlarmModel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotevents.CfnAlarmModel build() {
            return new software.amazon.awscdk.services.iotevents.CfnAlarmModel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
