package software.amazon.awscdk.services.kinesisfirehose;

/**
 * An Amazon Data Firehose delivery stream destination configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.constructs.*;
 * IDependable dependable;
 * DestinationConfig destinationConfig = DestinationConfig.builder()
 *         .dependables(List.of(dependable))
 *         .extendedS3DestinationConfiguration(ExtendedS3DestinationConfigurationProperty.builder()
 *                 .bucketArn("bucketArn")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .bufferingHints(BufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .compressionFormat("compressionFormat")
 *                 .customTimeZone("customTimeZone")
 *                 .dataFormatConversionConfiguration(DataFormatConversionConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .inputFormatConfiguration(InputFormatConfigurationProperty.builder()
 *                                 .deserializer(DeserializerProperty.builder()
 *                                         .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
 *                                                 .timestampFormats(List.of("timestampFormats"))
 *                                                 .build())
 *                                         .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
 *                                                 .caseInsensitive(false)
 *                                                 .columnToJsonKeyMappings(Map.of(
 *                                                         "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
 *                                                 .convertDotsInJsonKeysToUnderscores(false)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .outputFormatConfiguration(OutputFormatConfigurationProperty.builder()
 *                                 .serializer(SerializerProperty.builder()
 *                                         .orcSerDe(OrcSerDeProperty.builder()
 *                                                 .blockSizeBytes(123)
 *                                                 .bloomFilterColumns(List.of("bloomFilterColumns"))
 *                                                 .bloomFilterFalsePositiveProbability(123)
 *                                                 .compression("compression")
 *                                                 .dictionaryKeyThreshold(123)
 *                                                 .enablePadding(false)
 *                                                 .formatVersion("formatVersion")
 *                                                 .paddingTolerance(123)
 *                                                 .rowIndexStride(123)
 *                                                 .stripeSizeBytes(123)
 *                                                 .build())
 *                                         .parquetSerDe(ParquetSerDeProperty.builder()
 *                                                 .blockSizeBytes(123)
 *                                                 .compression("compression")
 *                                                 .enableDictionaryCompression(false)
 *                                                 .maxPaddingBytes(123)
 *                                                 .pageSizeBytes(123)
 *                                                 .writerVersion("writerVersion")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .schemaConfiguration(SchemaConfigurationProperty.builder()
 *                                 .catalogId("catalogId")
 *                                 .databaseName("databaseName")
 *                                 .region("region")
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 .versionId("versionId")
 *                                 .build())
 *                         .build())
 *                 .dynamicPartitioningConfiguration(DynamicPartitioningConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .retryOptions(RetryOptionsProperty.builder()
 *                                 .durationInSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                 .awskmsKeyArn("awskmsKeyArn")
 *                                 .build())
 *                         .noEncryptionConfig("noEncryptionConfig")
 *                         .build())
 *                 .errorOutputPrefix("errorOutputPrefix")
 *                 .fileExtension("fileExtension")
 *                 .prefix("prefix")
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:16.651Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DestinationConfig")
@software.amazon.jsii.Jsii.Proxy(DestinationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DestinationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Any resources that were created by the destination when binding it to the stack that must be deployed before the delivery stream is deployed.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.constructs.IDependable> getDependables() {
        return null;
    }

    /**
     * S3 destination configuration properties.
     * <p>
     * Default: - S3 destination is not used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty getExtendedS3DestinationConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DestinationConfig> {
        java.util.List<software.constructs.IDependable> dependables;
        software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfiguration;

        /**
         * Sets the value of {@link DestinationConfig#getDependables}
         * @param dependables Any resources that were created by the destination when binding it to the stack that must be deployed before the delivery stream is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder dependables(java.util.List<? extends software.constructs.IDependable> dependables) {
            this.dependables = (java.util.List<software.constructs.IDependable>)dependables;
            return this;
        }

        /**
         * Sets the value of {@link DestinationConfig#getExtendedS3DestinationConfiguration}
         * @param extendedS3DestinationConfiguration S3 destination configuration properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedS3DestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DestinationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DestinationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationConfig {
        private final java.util.List<software.constructs.IDependable> dependables;
        private final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dependables = software.amazon.jsii.Kernel.get(this, "dependables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class)));
            this.extendedS3DestinationConfiguration = software.amazon.jsii.Kernel.get(this, "extendedS3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dependables = (java.util.List<software.constructs.IDependable>)builder.dependables;
            this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
        }

        @Override
        public final java.util.List<software.constructs.IDependable> getDependables() {
            return this.dependables;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty getExtendedS3DestinationConfiguration() {
            return this.extendedS3DestinationConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDependables() != null) {
                data.set("dependables", om.valueToTree(this.getDependables()));
            }
            if (this.getExtendedS3DestinationConfiguration() != null) {
                data.set("extendedS3DestinationConfiguration", om.valueToTree(this.getExtendedS3DestinationConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DestinationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DestinationConfig.Jsii$Proxy that = (DestinationConfig.Jsii$Proxy) o;

            if (this.dependables != null ? !this.dependables.equals(that.dependables) : that.dependables != null) return false;
            return this.extendedS3DestinationConfiguration != null ? this.extendedS3DestinationConfiguration.equals(that.extendedS3DestinationConfiguration) : that.extendedS3DestinationConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dependables != null ? this.dependables.hashCode() : 0;
            result = 31 * result + (this.extendedS3DestinationConfiguration != null ? this.extendedS3DestinationConfiguration.hashCode() : 0);
            return result;
        }
    }
}
