package software.amazon.awscdk.services.lambda;

/**
 * The collection of versions of the ADOT Lambda Layer for JavaScript SDK.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper;
 * import software.amazon.awscdk.services.lambda.AdotLayerVersion;
 * import software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion;
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .adotInstrumentation(AdotInstrumentationConfig.builder()
 *                 .layerVersion(AdotLayerVersion.fromJavaScriptSdkLayerVersion(AdotLambdaLayerJavaScriptSdkVersion.LATEST))
 *                 .execWrapper(AdotLambdaExecWrapper.REGULAR_HANDLER)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:16.768Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.AdotLambdaLayerJavaScriptSdkVersion")
public class AdotLambdaLayerJavaScriptSdkVersion extends software.amazon.jsii.JsiiObject {

    protected AdotLambdaLayerJavaScriptSdkVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AdotLambdaLayerJavaScriptSdkVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        LATEST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class, "LATEST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class));
        V1_15_0_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class, "V1_15_0_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class));
        V1_16_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class, "V1_16_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class));
        V1_17_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class, "V1_17_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class));
        V1_18_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class, "V1_18_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class));
        V1_30_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class, "V1_30_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class));
        V1_7_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class, "V1_7_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion.class));
    }

    /**
     * The ARN of the Lambda layer.
     * <p>
     * @param scope The binding scope. This parameter is required.
     * @param architecture The architecture of the Lambda layer (either X86_64 or ARM_64). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String layerArn(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Architecture architecture) {
        return software.amazon.jsii.Kernel.call(this, "layerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(architecture, "architecture is required") });
    }

    /**
     * The latest layer version available in this CDK version.
     * <p>
     * New versions could
     * introduce incompatible changes. Make sure to test them before deploying to production.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion LATEST;

    /**
     * Version 1.15.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion V1_15_0_1;

    /**
     * Version 1.16.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion V1_16_0;

    /**
     * Version 1.17.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion V1_17_1;

    /**
     * Version 1.18.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion V1_18_1;

    /**
     * Version 1.30.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion V1_30_0;

    /**
     * Version 1.7.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion V1_7_0;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getLayerVersion() {
        return software.amazon.jsii.Kernel.get(this, "layerVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
