package software.amazon.awscdk.services.lambda;

/**
 * Options for creating <code>AssetCode</code> with a custom command, such as running a buildfile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Object commandOptions;
 * DockerImage dockerImage;
 * IGrantable grantable;
 * Key key;
 * ILocalBundling localBundling;
 * CustomCommandOptions customCommandOptions = CustomCommandOptions.builder()
 *         .assetHash("assetHash")
 *         .assetHashType(AssetHashType.SOURCE)
 *         .bundling(BundlingOptions.builder()
 *                 .image(dockerImage)
 *                 // the properties below are optional
 *                 .bundlingFileAccess(BundlingFileAccess.VOLUME_COPY)
 *                 .command(List.of("command"))
 *                 .entrypoint(List.of("entrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .local(localBundling)
 *                 .network("network")
 *                 .outputType(BundlingOutput.ARCHIVED)
 *                 .platform("platform")
 *                 .securityOpt("securityOpt")
 *                 .user("user")
 *                 .volumes(List.of(DockerVolume.builder()
 *                         .containerPath("containerPath")
 *                         .hostPath("hostPath")
 *                         // the properties below are optional
 *                         .consistency(DockerVolumeConsistency.CONSISTENT)
 *                         .build()))
 *                 .volumesFrom(List.of("volumesFrom"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .commandOptions(Map.of(
 *                 "commandOptionsKey", commandOptions))
 *         .deployTime(false)
 *         .displayName("displayName")
 *         .exclude(List.of("exclude"))
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .readers(List.of(grantable))
 *         .sourceKMSKey(key)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:16.865Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CustomCommandOptions")
@software.amazon.jsii.Jsii.Proxy(CustomCommandOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomCommandOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.s3.assets.AssetOptions {

    /**
     * options that are passed to the spawned process, which determine the characteristics of the spawned process.
     * <p>
     * Default: : see `child_process.SpawnSyncOptions` (https://nodejs.org/api/child_process.html#child_processspawnsynccommand-args-options).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getCommandOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomCommandOptions> {
        java.util.Map<java.lang.String, java.lang.Object> commandOptions;
        java.lang.Boolean deployTime;
        java.lang.String displayName;
        java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        software.amazon.awscdk.services.kms.IKey sourceKmsKey;
        java.lang.String assetHash;
        software.amazon.awscdk.AssetHashType assetHashType;
        software.amazon.awscdk.BundlingOptions bundling;
        java.util.List<java.lang.String> exclude;
        software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Sets the value of {@link CustomCommandOptions#getCommandOptions}
         * @param commandOptions options that are passed to the spawned process, which determine the characteristics of the spawned process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder commandOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> commandOptions) {
            this.commandOptions = (java.util.Map<java.lang.String, java.lang.Object>)commandOptions;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getDeployTime}
         * @param deployTime Whether or not the asset needs to exist beyond deployment time;.
         *                   i.e.
         *                   are copied over to a different location and not needed afterwards.
         *                   Setting this property to true has an impact on the lifecycle of the asset,
         *                   because we will assume that it is safe to delete after the CloudFormation
         *                   deployment succeeds.
         *                   <p>
         *                   For example, Lambda Function assets are copied over to Lambda during
         *                   deployment. Therefore, it is not necessary to store the asset in S3, so
         *                   we consider those deployTime assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployTime(java.lang.Boolean deployTime) {
            this.deployTime = deployTime;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getDisplayName}
         * @param displayName A display name for this asset.
         *                    If supplied, the display name will be used in locations where the asset
         *                    identifier is printed, like in the CLI progress information. If the same
         *                    asset is added multiple times, the display name of the first occurrence is
         *                    used.
         *                    <p>
         *                    The default is the construct path of the Asset construct, with respect to
         *                    the enclosing stack. If the asset is produced by a construct helper
         *                    function (such as <code>lambda.Code.fromAsset()</code>), this will look like
         *                    <code>MyFunction/Code</code>.
         *                    <p>
         *                    We use the stack-relative construct path so that in the common case where
         *                    you have multiple stacks with the same asset, we won't show something like
         *                    <code>/MyBetaStack/MyFunction/Code</code> when you are actually deploying to
         *                    production.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getReaders}
         * @param readers A list of principals that should be able to read this asset from S3.
         *                You can use <code>asset.grantRead(principal)</code> to grant read permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder readers(java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers) {
            this.readers = (java.util.List<software.amazon.awscdk.services.iam.IGrantable>)readers;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getSourceKmsKey}
         * @param sourceKmsKey The ARN of the KMS key used to encrypt the handler code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceKmsKey(software.amazon.awscdk.services.kms.IKey sourceKmsKey) {
            this.sourceKmsKey = sourceKmsKey;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getAssetHashType}
         * @param assetHashType Specifies the type of hash to calculate for this asset.
         *                      If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         *                      <code>AssetHashType.CUSTOM</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHashType(software.amazon.awscdk.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getBundling}
         * @param bundling Bundle the asset by executing a command in a Docker container or a custom bundling provider.
         *                 The asset path will be mounted at <code>/asset-input</code>. The Docker
         *                 container is responsible for putting content at <code>/asset-output</code>.
         *                 The content at <code>/asset-output</code> will be zipped and used as the
         *                 final asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundling(software.amazon.awscdk.BundlingOptions bundling) {
            this.bundling = bundling;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getExclude}
         * @param exclude File paths matching the patterns will be excluded.
         *                See <code>ignoreMode</code> to set the matching behavior.
         *                Has no effect on Assets bundled using the <code>bundling</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getFollowSymlinks}
         * @param followSymlinks A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.followSymlinks = followSymlinks;
            return this;
        }

        /**
         * Sets the value of {@link CustomCommandOptions#getIgnoreMode}
         * @param ignoreMode The ignore behavior to use for <code>exclude</code> patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.ignoreMode = ignoreMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomCommandOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomCommandOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomCommandOptions {
        private final java.util.Map<java.lang.String, java.lang.Object> commandOptions;
        private final java.lang.Boolean deployTime;
        private final java.lang.String displayName;
        private final java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        private final software.amazon.awscdk.services.kms.IKey sourceKmsKey;
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.AssetHashType assetHashType;
        private final software.amazon.awscdk.BundlingOptions bundling;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        private final software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.commandOptions = software.amazon.jsii.Kernel.get(this, "commandOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.deployTime = software.amazon.jsii.Kernel.get(this, "deployTime", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readers = software.amazon.jsii.Kernel.get(this, "readers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGrantable.class)));
            this.sourceKmsKey = software.amazon.jsii.Kernel.get(this, "sourceKMSKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHashType = software.amazon.jsii.Kernel.get(this, "assetHashType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.AssetHashType.class));
            this.bundling = software.amazon.jsii.Kernel.get(this, "bundling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.BundlingOptions.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.followSymlinks = software.amazon.jsii.Kernel.get(this, "followSymlinks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SymlinkFollowMode.class));
            this.ignoreMode = software.amazon.jsii.Kernel.get(this, "ignoreMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IgnoreMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.commandOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.commandOptions;
            this.deployTime = builder.deployTime;
            this.displayName = builder.displayName;
            this.readers = (java.util.List<software.amazon.awscdk.services.iam.IGrantable>)builder.readers;
            this.sourceKmsKey = builder.sourceKmsKey;
            this.assetHash = builder.assetHash;
            this.assetHashType = builder.assetHashType;
            this.bundling = builder.bundling;
            this.exclude = builder.exclude;
            this.followSymlinks = builder.followSymlinks;
            this.ignoreMode = builder.ignoreMode;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getCommandOptions() {
            return this.commandOptions;
        }

        @Override
        public final java.lang.Boolean getDeployTime() {
            return this.deployTime;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IGrantable> getReaders() {
            return this.readers;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getSourceKMSKey() {
            return this.sourceKmsKey;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final software.amazon.awscdk.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public final software.amazon.awscdk.BundlingOptions getBundling() {
            return this.bundling;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.SymlinkFollowMode getFollowSymlinks() {
            return this.followSymlinks;
        }

        @Override
        public final software.amazon.awscdk.IgnoreMode getIgnoreMode() {
            return this.ignoreMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCommandOptions() != null) {
                data.set("commandOptions", om.valueToTree(this.getCommandOptions()));
            }
            if (this.getDeployTime() != null) {
                data.set("deployTime", om.valueToTree(this.getDeployTime()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getReaders() != null) {
                data.set("readers", om.valueToTree(this.getReaders()));
            }
            if (this.getSourceKMSKey() != null) {
                data.set("sourceKMSKey", om.valueToTree(this.getSourceKMSKey()));
            }
            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBundling() != null) {
                data.set("bundling", om.valueToTree(this.getBundling()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollowSymlinks() != null) {
                data.set("followSymlinks", om.valueToTree(this.getFollowSymlinks()));
            }
            if (this.getIgnoreMode() != null) {
                data.set("ignoreMode", om.valueToTree(this.getIgnoreMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CustomCommandOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomCommandOptions.Jsii$Proxy that = (CustomCommandOptions.Jsii$Proxy) o;

            if (this.commandOptions != null ? !this.commandOptions.equals(that.commandOptions) : that.commandOptions != null) return false;
            if (this.deployTime != null ? !this.deployTime.equals(that.deployTime) : that.deployTime != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.readers != null ? !this.readers.equals(that.readers) : that.readers != null) return false;
            if (this.sourceKmsKey != null ? !this.sourceKmsKey.equals(that.sourceKmsKey) : that.sourceKmsKey != null) return false;
            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            if (this.bundling != null ? !this.bundling.equals(that.bundling) : that.bundling != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.followSymlinks != null ? !this.followSymlinks.equals(that.followSymlinks) : that.followSymlinks != null) return false;
            return this.ignoreMode != null ? this.ignoreMode.equals(that.ignoreMode) : that.ignoreMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.commandOptions != null ? this.commandOptions.hashCode() : 0;
            result = 31 * result + (this.deployTime != null ? this.deployTime.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.readers != null ? this.readers.hashCode() : 0);
            result = 31 * result + (this.sourceKmsKey != null ? this.sourceKmsKey.hashCode() : 0);
            result = 31 * result + (this.assetHash != null ? this.assetHash.hashCode() : 0);
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.bundling != null ? this.bundling.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.followSymlinks != null ? this.followSymlinks.hashCode() : 0);
            result = 31 * result + (this.ignoreMode != null ? this.ignoreMode.hashCode() : 0);
            return result;
        }
    }
}
