package software.amazon.awscdk.services.lambda;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.*;
 * IEventSourceDlq eventSourceDlq;
 * Object filters;
 * Key key;
 * ISchemaRegistry schemaRegistry;
 * SourceAccessConfigurationType sourceAccessConfigurationType;
 * EventSourceMappingOptions eventSourceMappingOptions = EventSourceMappingOptions.builder()
 *         .batchSize(123)
 *         .bisectBatchOnError(false)
 *         .enabled(false)
 *         .eventSourceArn("eventSourceArn")
 *         .filterEncryption(key)
 *         .filters(List.of(Map.of(
 *                 "filtersKey", filters)))
 *         .kafkaBootstrapServers(List.of("kafkaBootstrapServers"))
 *         .kafkaConsumerGroupId("kafkaConsumerGroupId")
 *         .kafkaTopic("kafkaTopic")
 *         .maxBatchingWindow(Duration.minutes(30))
 *         .maxConcurrency(123)
 *         .maxRecordAge(Duration.minutes(30))
 *         .metricsConfig(MetricsConfig.builder()
 *                 .metrics(List.of(MetricType.EVENT_COUNT))
 *                 .build())
 *         .onFailure(eventSourceDlq)
 *         .parallelizationFactor(123)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .maximumPollers(123)
 *                 .minimumPollers(123)
 *                 .build())
 *         .reportBatchItemFailures(false)
 *         .retryAttempts(123)
 *         .schemaRegistryConfig(schemaRegistry)
 *         .sourceAccessConfigurations(List.of(SourceAccessConfiguration.builder()
 *                 .type(sourceAccessConfigurationType)
 *                 .uri("uri")
 *                 .build()))
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .startingPositionTimestamp(123)
 *         .supportS3OnFailureDestination(false)
 *         .tumblingWindow(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:16.889Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.EventSourceMappingOptions")
@software.amazon.jsii.Jsii.Proxy(EventSourceMappingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventSourceMappingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
     * <p>
     * Your function receives an
     * event with all the retrieved records.
     * <p>
     * Valid Range: Minimum value of 1. Maximum value of 10000.
     * <p>
     * Default: - Amazon Kinesis, Amazon DynamoDB, and Amazon MSK is 100 records.
     * The default for Amazon SQS is 10 messages. For standard SQS queues, the maximum is 10,000. For FIFO SQS queues, the maximum is 10.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
        return null;
    }

    /**
     * If the function returns an error, split the batch in two and retry.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBisectBatchOnError() {
        return null;
    }

    /**
     * Set to false to disable the event source upon creation.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the event source.
     * <p>
     * Any record added to
     * this stream can invoke the Lambda function.
     * <p>
     * Default: - not set if using a self managed Kafka cluster, throws an error otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceArn() {
        return null;
    }

    /**
     * Add Customer managed KMS key to encrypt Filter Criteria.
     * <p>
     * Default: - none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getFilterEncryption() {
        return null;
    }

    /**
     * Add filter criteria to Event Source.
     * <p>
     * Default: - none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getFilters() {
        return null;
    }

    /**
     * A list of host and port pairs that are the addresses of the Kafka brokers in a self managed "bootstrap" Kafka cluster that a Kafka client connects to initially to bootstrap itself.
     * <p>
     * They are in the format <code>abc.example.com:9096</code>.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getKafkaBootstrapServers() {
        return null;
    }

    /**
     * The identifier for the Kafka consumer group to join.
     * <p>
     * The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value. The value must have a length between 1 and 200 and full the pattern '[a-zA-Z0-9-/<em>:_+=.&#64;-]</em>'. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id">Customizable consumer group ID</a>.
     * <p>
     * Default: - none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-selfmanagedkafkaeventsourceconfig.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-selfmanagedkafkaeventsourceconfig.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKafkaConsumerGroupId() {
        return null;
    }

    /**
     * The name of the Kafka topic.
     * <p>
     * Default: - no topic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKafkaTopic() {
        return null;
    }

    /**
     * The maximum amount of time to gather records before invoking the function.
     * <p>
     * Maximum of Duration.minutes(5)
     * <p>
     * Default: Duration.seconds(0)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxBatchingWindow() {
        return null;
    }

    /**
     * The maximum concurrency setting limits the number of concurrent instances of the function that an Amazon SQS event source can invoke.
     * <p>
     * Default: - No specific limit.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency
     * Valid Range: Minimum value of 2. Maximum value of 1000.">https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency
     * Valid Range: Minimum value of 2. Maximum value of 1000.</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrency() {
        return null;
    }

    /**
     * The maximum age of a record that Lambda sends to a function for processing.
     * <p>
     * Valid Range:
     * <p>
     * <ul>
     * <li>Minimum value of 60 seconds</li>
     * <li>Maximum value of 7 days</li>
     * </ul>
     * <p>
     * Default: - infinite or until the record expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxRecordAge() {
        return null;
    }

    /**
     * Configuration for enhanced monitoring metrics collection When specified, enables collection of additional metrics for the stream event source.
     * <p>
     * Default: - Enhanced monitoring is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.MetricsConfig getMetricsConfig() {
        return null;
    }

    /**
     * An Amazon S3, Amazon SQS queue or Amazon SNS topic destination for discarded records.
     * <p>
     * Default: discarded records are ignored
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
        return null;
    }

    /**
     * The number of batches to process from each shard concurrently.
     * <p>
     * Valid Range:
     * <p>
     * <ul>
     * <li>Minimum value of 1</li>
     * <li>Maximum value of 10</li>
     * </ul>
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
        return null;
    }

    /**
     * Configuration for provisioned pollers that read from the event source.
     * <p>
     * When specified, allows control over the minimum and maximum number of pollers
     * that can be provisioned to process events from the source.
     * <p>
     * Default: - no provisioned pollers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ProvisionedPollerConfig getProvisionedPollerConfig() {
        return null;
    }

    /**
     * Allow functions to return partially successful responses for a batch of records.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting">https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReportBatchItemFailures() {
        return null;
    }

    /**
     * The maximum number of times to retry when the function returns an error.
     * <p>
     * Set to <code>undefined</code> if you want lambda to keep retrying infinitely or until
     * the record expires.
     * <p>
     * Valid Range:
     * <p>
     * <ul>
     * <li>Minimum value of 0</li>
     * <li>Maximum value of 10000</li>
     * </ul>
     * <p>
     * Default: - infinite or until the record expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return null;
    }

    /**
     * Specific configuration settings for a Kafka schema registry.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ISchemaRegistry getSchemaRegistryConfig() {
        return null;
    }

    /**
     * Specific settings like the authentication protocol or the VPC components to secure access to your event source.
     * <p>
     * Default: - none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.SourceAccessConfiguration> getSourceAccessConfigurations() {
        return null;
    }

    /**
     * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
     * <p>
     * Default: - no starting position
     * <p>
     * @see <a href="https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType">https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
        return null;
    }

    /**
     * The time from which to start reading, in Unix time seconds.
     * <p>
     * Default: - no timestamp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStartingPositionTimestamp() {
        return null;
    }

    /**
     * Check if support S3 onfailure destination(OFD).
     * <p>
     * Kinesis, DynamoDB, MSK and self managed kafka event support S3 OFD
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportS3OnFailureDestination() {
        return null;
    }

    /**
     * The size of the tumbling windows to group records sent to DynamoDB or Kinesis.
     * <p>
     * Default: - None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-windows
     * Valid Range: 0 - 15 minutes">https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-windows
     * Valid Range: 0 - 15 minutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTumblingWindow() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventSourceMappingOptions> {
        java.lang.Number batchSize;
        java.lang.Boolean bisectBatchOnError;
        java.lang.Boolean enabled;
        java.lang.String eventSourceArn;
        software.amazon.awscdk.services.kms.IKey filterEncryption;
        java.util.List<java.util.Map<java.lang.String, java.lang.Object>> filters;
        java.util.List<java.lang.String> kafkaBootstrapServers;
        java.lang.String kafkaConsumerGroupId;
        java.lang.String kafkaTopic;
        software.amazon.awscdk.Duration maxBatchingWindow;
        java.lang.Number maxConcurrency;
        software.amazon.awscdk.Duration maxRecordAge;
        software.amazon.awscdk.services.lambda.MetricsConfig metricsConfig;
        software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        java.lang.Number parallelizationFactor;
        software.amazon.awscdk.services.lambda.ProvisionedPollerConfig provisionedPollerConfig;
        java.lang.Boolean reportBatchItemFailures;
        java.lang.Number retryAttempts;
        software.amazon.awscdk.services.lambda.ISchemaRegistry schemaRegistryConfig;
        java.util.List<software.amazon.awscdk.services.lambda.SourceAccessConfiguration> sourceAccessConfigurations;
        software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        java.lang.Number startingPositionTimestamp;
        java.lang.Boolean supportS3OnFailureDestination;
        software.amazon.awscdk.Duration tumblingWindow;

        /**
         * Sets the value of {@link EventSourceMappingOptions#getBatchSize}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         *                  Your function receives an
         *                  event with all the retrieved records.
         *                  <p>
         *                  Valid Range: Minimum value of 1. Maximum value of 10000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getBisectBatchOnError}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(java.lang.Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getEnabled}
         * @param enabled Set to false to disable the event source upon creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getEventSourceArn}
         * @param eventSourceArn The Amazon Resource Name (ARN) of the event source.
         *                       Any record added to
         *                       this stream can invoke the Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceArn(java.lang.String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getFilterEncryption}
         * @param filterEncryption Add Customer managed KMS key to encrypt Filter Criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterEncryption(software.amazon.awscdk.services.kms.IKey filterEncryption) {
            this.filterEncryption = filterEncryption;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getFilters}
         * @param filters Add filter criteria to Event Source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder filters(java.util.List<? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> filters) {
            this.filters = (java.util.List<java.util.Map<java.lang.String, java.lang.Object>>)filters;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getKafkaBootstrapServers}
         * @param kafkaBootstrapServers A list of host and port pairs that are the addresses of the Kafka brokers in a self managed "bootstrap" Kafka cluster that a Kafka client connects to initially to bootstrap itself.
         *                              They are in the format <code>abc.example.com:9096</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaBootstrapServers(java.util.List<java.lang.String> kafkaBootstrapServers) {
            this.kafkaBootstrapServers = kafkaBootstrapServers;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getKafkaConsumerGroupId}
         * @param kafkaConsumerGroupId The identifier for the Kafka consumer group to join.
         *                             The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value. The value must have a length between 1 and 200 and full the pattern '[a-zA-Z0-9-/<em>:_+=.&#64;-]</em>'. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id">Customizable consumer group ID</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaConsumerGroupId(java.lang.String kafkaConsumerGroupId) {
            this.kafkaConsumerGroupId = kafkaConsumerGroupId;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getKafkaTopic}
         * @param kafkaTopic The name of the Kafka topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaTopic(java.lang.String kafkaTopic) {
            this.kafkaTopic = kafkaTopic;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getMaxBatchingWindow}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function.
         *                          Maximum of Duration.minutes(5)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(software.amazon.awscdk.Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getMaxConcurrency}
         * @param maxConcurrency The maximum concurrency setting limits the number of concurrent instances of the function that an Amazon SQS event source can invoke.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(java.lang.Number maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getMaxRecordAge}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing.
         *                     Valid Range:
         *                     <p>
         *                     <ul>
         *                     <li>Minimum value of 60 seconds</li>
         *                     <li>Maximum value of 7 days</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(software.amazon.awscdk.Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getMetricsConfig}
         * @param metricsConfig Configuration for enhanced monitoring metrics collection When specified, enables collection of additional metrics for the stream event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfig(software.amazon.awscdk.services.lambda.MetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getOnFailure}
         * @param onFailure An Amazon S3, Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getParallelizationFactor}
         * @param parallelizationFactor The number of batches to process from each shard concurrently.
         *                              Valid Range:
         *                              <p>
         *                              <ul>
         *                              <li>Minimum value of 1</li>
         *                              <li>Maximum value of 10</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getProvisionedPollerConfig}
         * @param provisionedPollerConfig Configuration for provisioned pollers that read from the event source.
         *                                When specified, allows control over the minimum and maximum number of pollers
         *                                that can be provisioned to process events from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedPollerConfig(software.amazon.awscdk.services.lambda.ProvisionedPollerConfig provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getReportBatchItemFailures}
         * @param reportBatchItemFailures Allow functions to return partially successful responses for a batch of records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportBatchItemFailures(java.lang.Boolean reportBatchItemFailures) {
            this.reportBatchItemFailures = reportBatchItemFailures;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Set to <code>undefined</code> if you want lambda to keep retrying infinitely or until
         *                      the record expires.
         *                      <p>
         *                      Valid Range:
         *                      <p>
         *                      <ul>
         *                      <li>Minimum value of 0</li>
         *                      <li>Maximum value of 10000</li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getSchemaRegistryConfig}
         * @param schemaRegistryConfig Specific configuration settings for a Kafka schema registry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistryConfig(software.amazon.awscdk.services.lambda.ISchemaRegistry schemaRegistryConfig) {
            this.schemaRegistryConfig = schemaRegistryConfig;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getSourceAccessConfigurations}
         * @param sourceAccessConfigurations Specific settings like the authentication protocol or the VPC components to secure access to your event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sourceAccessConfigurations(java.util.List<? extends software.amazon.awscdk.services.lambda.SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = (java.util.List<software.amazon.awscdk.services.lambda.SourceAccessConfiguration>)sourceAccessConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getStartingPosition}
         * @param startingPosition The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getStartingPositionTimestamp}
         * @param startingPositionTimestamp The time from which to start reading, in Unix time seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPositionTimestamp(java.lang.Number startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getSupportS3OnFailureDestination}
         * @param supportS3OnFailureDestination Check if support S3 onfailure destination(OFD).
         *                                      Kinesis, DynamoDB, MSK and self managed kafka event support S3 OFD
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportS3OnFailureDestination(java.lang.Boolean supportS3OnFailureDestination) {
            this.supportS3OnFailureDestination = supportS3OnFailureDestination;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getTumblingWindow}
         * @param tumblingWindow The size of the tumbling windows to group records sent to DynamoDB or Kinesis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tumblingWindow(software.amazon.awscdk.Duration tumblingWindow) {
            this.tumblingWindow = tumblingWindow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventSourceMappingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventSourceMappingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceMappingOptions {
        private final java.lang.Number batchSize;
        private final java.lang.Boolean bisectBatchOnError;
        private final java.lang.Boolean enabled;
        private final java.lang.String eventSourceArn;
        private final software.amazon.awscdk.services.kms.IKey filterEncryption;
        private final java.util.List<java.util.Map<java.lang.String, java.lang.Object>> filters;
        private final java.util.List<java.lang.String> kafkaBootstrapServers;
        private final java.lang.String kafkaConsumerGroupId;
        private final java.lang.String kafkaTopic;
        private final software.amazon.awscdk.Duration maxBatchingWindow;
        private final java.lang.Number maxConcurrency;
        private final software.amazon.awscdk.Duration maxRecordAge;
        private final software.amazon.awscdk.services.lambda.MetricsConfig metricsConfig;
        private final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        private final java.lang.Number parallelizationFactor;
        private final software.amazon.awscdk.services.lambda.ProvisionedPollerConfig provisionedPollerConfig;
        private final java.lang.Boolean reportBatchItemFailures;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.services.lambda.ISchemaRegistry schemaRegistryConfig;
        private final java.util.List<software.amazon.awscdk.services.lambda.SourceAccessConfiguration> sourceAccessConfigurations;
        private final software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private final java.lang.Number startingPositionTimestamp;
        private final java.lang.Boolean supportS3OnFailureDestination;
        private final software.amazon.awscdk.Duration tumblingWindow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.bisectBatchOnError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnError", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.eventSourceArn = software.amazon.jsii.Kernel.get(this, "eventSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterEncryption = software.amazon.jsii.Kernel.get(this, "filterEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
            this.kafkaBootstrapServers = software.amazon.jsii.Kernel.get(this, "kafkaBootstrapServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kafkaConsumerGroupId = software.amazon.jsii.Kernel.get(this, "kafkaConsumerGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kafkaTopic = software.amazon.jsii.Kernel.get(this, "kafkaTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxBatchingWindow = software.amazon.jsii.Kernel.get(this, "maxBatchingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRecordAge = software.amazon.jsii.Kernel.get(this, "maxRecordAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.metricsConfig = software.amazon.jsii.Kernel.get(this, "metricsConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.MetricsConfig.class));
            this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSourceDlq.class));
            this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.provisionedPollerConfig = software.amazon.jsii.Kernel.get(this, "provisionedPollerConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ProvisionedPollerConfig.class));
            this.reportBatchItemFailures = software.amazon.jsii.Kernel.get(this, "reportBatchItemFailures", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.schemaRegistryConfig = software.amazon.jsii.Kernel.get(this, "schemaRegistryConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ISchemaRegistry.class));
            this.sourceAccessConfigurations = software.amazon.jsii.Kernel.get(this, "sourceAccessConfigurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfiguration.class)));
            this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.StartingPosition.class));
            this.startingPositionTimestamp = software.amazon.jsii.Kernel.get(this, "startingPositionTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.supportS3OnFailureDestination = software.amazon.jsii.Kernel.get(this, "supportS3OnFailureDestination", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.tumblingWindow = software.amazon.jsii.Kernel.get(this, "tumblingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.batchSize = builder.batchSize;
            this.bisectBatchOnError = builder.bisectBatchOnError;
            this.enabled = builder.enabled;
            this.eventSourceArn = builder.eventSourceArn;
            this.filterEncryption = builder.filterEncryption;
            this.filters = (java.util.List<java.util.Map<java.lang.String, java.lang.Object>>)builder.filters;
            this.kafkaBootstrapServers = builder.kafkaBootstrapServers;
            this.kafkaConsumerGroupId = builder.kafkaConsumerGroupId;
            this.kafkaTopic = builder.kafkaTopic;
            this.maxBatchingWindow = builder.maxBatchingWindow;
            this.maxConcurrency = builder.maxConcurrency;
            this.maxRecordAge = builder.maxRecordAge;
            this.metricsConfig = builder.metricsConfig;
            this.onFailure = builder.onFailure;
            this.parallelizationFactor = builder.parallelizationFactor;
            this.provisionedPollerConfig = builder.provisionedPollerConfig;
            this.reportBatchItemFailures = builder.reportBatchItemFailures;
            this.retryAttempts = builder.retryAttempts;
            this.schemaRegistryConfig = builder.schemaRegistryConfig;
            this.sourceAccessConfigurations = (java.util.List<software.amazon.awscdk.services.lambda.SourceAccessConfiguration>)builder.sourceAccessConfigurations;
            this.startingPosition = builder.startingPosition;
            this.startingPositionTimestamp = builder.startingPositionTimestamp;
            this.supportS3OnFailureDestination = builder.supportS3OnFailureDestination;
            this.tumblingWindow = builder.tumblingWindow;
        }

        @Override
        public final java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final java.lang.Boolean getBisectBatchOnError() {
            return this.bisectBatchOnError;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getFilterEncryption() {
            return this.filterEncryption;
        }

        @Override
        public final java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getFilters() {
            return this.filters;
        }

        @Override
        public final java.util.List<java.lang.String> getKafkaBootstrapServers() {
            return this.kafkaBootstrapServers;
        }

        @Override
        public final java.lang.String getKafkaConsumerGroupId() {
            return this.kafkaConsumerGroupId;
        }

        @Override
        public final java.lang.String getKafkaTopic() {
            return this.kafkaTopic;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxBatchingWindow() {
            return this.maxBatchingWindow;
        }

        @Override
        public final java.lang.Number getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxRecordAge() {
            return this.maxRecordAge;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.MetricsConfig getMetricsConfig() {
            return this.metricsConfig;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
            return this.onFailure;
        }

        @Override
        public final java.lang.Number getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ProvisionedPollerConfig getProvisionedPollerConfig() {
            return this.provisionedPollerConfig;
        }

        @Override
        public final java.lang.Boolean getReportBatchItemFailures() {
            return this.reportBatchItemFailures;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ISchemaRegistry getSchemaRegistryConfig() {
            return this.schemaRegistryConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.SourceAccessConfiguration> getSourceAccessConfigurations() {
            return this.sourceAccessConfigurations;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public final java.lang.Number getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        @Override
        public final java.lang.Boolean getSupportS3OnFailureDestination() {
            return this.supportS3OnFailureDestination;
        }

        @Override
        public final software.amazon.awscdk.Duration getTumblingWindow() {
            return this.tumblingWindow;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getBisectBatchOnError() != null) {
                data.set("bisectBatchOnError", om.valueToTree(this.getBisectBatchOnError()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEventSourceArn() != null) {
                data.set("eventSourceArn", om.valueToTree(this.getEventSourceArn()));
            }
            if (this.getFilterEncryption() != null) {
                data.set("filterEncryption", om.valueToTree(this.getFilterEncryption()));
            }
            if (this.getFilters() != null) {
                data.set("filters", om.valueToTree(this.getFilters()));
            }
            if (this.getKafkaBootstrapServers() != null) {
                data.set("kafkaBootstrapServers", om.valueToTree(this.getKafkaBootstrapServers()));
            }
            if (this.getKafkaConsumerGroupId() != null) {
                data.set("kafkaConsumerGroupId", om.valueToTree(this.getKafkaConsumerGroupId()));
            }
            if (this.getKafkaTopic() != null) {
                data.set("kafkaTopic", om.valueToTree(this.getKafkaTopic()));
            }
            if (this.getMaxBatchingWindow() != null) {
                data.set("maxBatchingWindow", om.valueToTree(this.getMaxBatchingWindow()));
            }
            if (this.getMaxConcurrency() != null) {
                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
            }
            if (this.getMaxRecordAge() != null) {
                data.set("maxRecordAge", om.valueToTree(this.getMaxRecordAge()));
            }
            if (this.getMetricsConfig() != null) {
                data.set("metricsConfig", om.valueToTree(this.getMetricsConfig()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getParallelizationFactor() != null) {
                data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
            }
            if (this.getProvisionedPollerConfig() != null) {
                data.set("provisionedPollerConfig", om.valueToTree(this.getProvisionedPollerConfig()));
            }
            if (this.getReportBatchItemFailures() != null) {
                data.set("reportBatchItemFailures", om.valueToTree(this.getReportBatchItemFailures()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getSchemaRegistryConfig() != null) {
                data.set("schemaRegistryConfig", om.valueToTree(this.getSchemaRegistryConfig()));
            }
            if (this.getSourceAccessConfigurations() != null) {
                data.set("sourceAccessConfigurations", om.valueToTree(this.getSourceAccessConfigurations()));
            }
            if (this.getStartingPosition() != null) {
                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            }
            if (this.getStartingPositionTimestamp() != null) {
                data.set("startingPositionTimestamp", om.valueToTree(this.getStartingPositionTimestamp()));
            }
            if (this.getSupportS3OnFailureDestination() != null) {
                data.set("supportS3OnFailureDestination", om.valueToTree(this.getSupportS3OnFailureDestination()));
            }
            if (this.getTumblingWindow() != null) {
                data.set("tumblingWindow", om.valueToTree(this.getTumblingWindow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.EventSourceMappingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventSourceMappingOptions.Jsii$Proxy that = (EventSourceMappingOptions.Jsii$Proxy) o;

            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.bisectBatchOnError != null ? !this.bisectBatchOnError.equals(that.bisectBatchOnError) : that.bisectBatchOnError != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.eventSourceArn != null ? !this.eventSourceArn.equals(that.eventSourceArn) : that.eventSourceArn != null) return false;
            if (this.filterEncryption != null ? !this.filterEncryption.equals(that.filterEncryption) : that.filterEncryption != null) return false;
            if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) return false;
            if (this.kafkaBootstrapServers != null ? !this.kafkaBootstrapServers.equals(that.kafkaBootstrapServers) : that.kafkaBootstrapServers != null) return false;
            if (this.kafkaConsumerGroupId != null ? !this.kafkaConsumerGroupId.equals(that.kafkaConsumerGroupId) : that.kafkaConsumerGroupId != null) return false;
            if (this.kafkaTopic != null ? !this.kafkaTopic.equals(that.kafkaTopic) : that.kafkaTopic != null) return false;
            if (this.maxBatchingWindow != null ? !this.maxBatchingWindow.equals(that.maxBatchingWindow) : that.maxBatchingWindow != null) return false;
            if (this.maxConcurrency != null ? !this.maxConcurrency.equals(that.maxConcurrency) : that.maxConcurrency != null) return false;
            if (this.maxRecordAge != null ? !this.maxRecordAge.equals(that.maxRecordAge) : that.maxRecordAge != null) return false;
            if (this.metricsConfig != null ? !this.metricsConfig.equals(that.metricsConfig) : that.metricsConfig != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
            if (this.provisionedPollerConfig != null ? !this.provisionedPollerConfig.equals(that.provisionedPollerConfig) : that.provisionedPollerConfig != null) return false;
            if (this.reportBatchItemFailures != null ? !this.reportBatchItemFailures.equals(that.reportBatchItemFailures) : that.reportBatchItemFailures != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            if (this.schemaRegistryConfig != null ? !this.schemaRegistryConfig.equals(that.schemaRegistryConfig) : that.schemaRegistryConfig != null) return false;
            if (this.sourceAccessConfigurations != null ? !this.sourceAccessConfigurations.equals(that.sourceAccessConfigurations) : that.sourceAccessConfigurations != null) return false;
            if (this.startingPosition != null ? !this.startingPosition.equals(that.startingPosition) : that.startingPosition != null) return false;
            if (this.startingPositionTimestamp != null ? !this.startingPositionTimestamp.equals(that.startingPositionTimestamp) : that.startingPositionTimestamp != null) return false;
            if (this.supportS3OnFailureDestination != null ? !this.supportS3OnFailureDestination.equals(that.supportS3OnFailureDestination) : that.supportS3OnFailureDestination != null) return false;
            return this.tumblingWindow != null ? this.tumblingWindow.equals(that.tumblingWindow) : that.tumblingWindow == null;
        }

        @Override
        public final int hashCode() {
            int result = this.batchSize != null ? this.batchSize.hashCode() : 0;
            result = 31 * result + (this.bisectBatchOnError != null ? this.bisectBatchOnError.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.eventSourceArn != null ? this.eventSourceArn.hashCode() : 0);
            result = 31 * result + (this.filterEncryption != null ? this.filterEncryption.hashCode() : 0);
            result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
            result = 31 * result + (this.kafkaBootstrapServers != null ? this.kafkaBootstrapServers.hashCode() : 0);
            result = 31 * result + (this.kafkaConsumerGroupId != null ? this.kafkaConsumerGroupId.hashCode() : 0);
            result = 31 * result + (this.kafkaTopic != null ? this.kafkaTopic.hashCode() : 0);
            result = 31 * result + (this.maxBatchingWindow != null ? this.maxBatchingWindow.hashCode() : 0);
            result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
            result = 31 * result + (this.maxRecordAge != null ? this.maxRecordAge.hashCode() : 0);
            result = 31 * result + (this.metricsConfig != null ? this.metricsConfig.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
            result = 31 * result + (this.provisionedPollerConfig != null ? this.provisionedPollerConfig.hashCode() : 0);
            result = 31 * result + (this.reportBatchItemFailures != null ? this.reportBatchItemFailures.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.schemaRegistryConfig != null ? this.schemaRegistryConfig.hashCode() : 0);
            result = 31 * result + (this.sourceAccessConfigurations != null ? this.sourceAccessConfigurations.hashCode() : 0);
            result = 31 * result + (this.startingPosition != null ? this.startingPosition.hashCode() : 0);
            result = 31 * result + (this.startingPositionTimestamp != null ? this.startingPositionTimestamp.hashCode() : 0);
            result = 31 * result + (this.supportS3OnFailureDestination != null ? this.supportS3OnFailureDestination.hashCode() : 0);
            result = 31 * result + (this.tumblingWindow != null ? this.tumblingWindow.hashCode() : 0);
            return result;
        }
    }
}
