package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a <code>CfnLogAnomalyDetector</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnLogAnomalyDetectorProps cfnLogAnomalyDetectorProps = CfnLogAnomalyDetectorProps.builder()
 *         .accountId("accountId")
 *         .anomalyVisibilityTime(123)
 *         .detectorName("detectorName")
 *         .evaluationFrequency("evaluationFrequency")
 *         .filterPattern("filterPattern")
 *         .kmsKeyId("kmsKeyId")
 *         .logGroupArnList(List.of("logGroupArnList"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:17.272Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnLogAnomalyDetectorProps")
@software.amazon.jsii.Jsii.Proxy(CfnLogAnomalyDetectorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLogAnomalyDetectorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the account to create the anomaly detector in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-accountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-accountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccountId() {
        return null;
    }

    /**
     * The number of days to have visibility on an anomaly.
     * <p>
     * After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in <code>AnomalyVisibilityTime</code> , it will be considered normal going forward and will not be detected as an anomaly.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-anomalyvisibilitytime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-anomalyvisibilitytime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAnomalyVisibilityTime() {
        return null;
    }

    /**
     * A name for this anomaly detector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-detectorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-detectorname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDetectorName() {
        return null;
    }

    /**
     * Specifies how often the anomaly detector is to run and look for anomalies.
     * <p>
     * Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for <code>EvaluationFrequency</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-evaluationfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-evaluationfrequency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEvaluationFrequency() {
        return null;
    }

    /**
     * You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-filterpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-filterpattern</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFilterPattern() {
        return null;
    }

    /**
     * Optionally assigns a AWS KMS key to secure this anomaly detector and its findings.
     * <p>
     * If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
     * <p>
     * For more information about using a AWS KMS key and to see the required IAM policy, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/LogsAnomalyDetection-KMS.html">Use a AWS KMS key with an anomaly detector</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The ARN of the log group that is associated with this anomaly detector.
     * <p>
     * You can specify only one log group ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-loggrouparnlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loganomalydetector.html#cfn-logs-loganomalydetector-loggrouparnlist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogGroupArnList() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLogAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLogAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLogAnomalyDetectorProps> {
        java.lang.String accountId;
        java.lang.Number anomalyVisibilityTime;
        java.lang.String detectorName;
        java.lang.String evaluationFrequency;
        java.lang.String filterPattern;
        java.lang.String kmsKeyId;
        java.util.List<java.lang.String> logGroupArnList;

        /**
         * Sets the value of {@link CfnLogAnomalyDetectorProps#getAccountId}
         * @param accountId The ID of the account to create the anomaly detector in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(java.lang.String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogAnomalyDetectorProps#getAnomalyVisibilityTime}
         * @param anomalyVisibilityTime The number of days to have visibility on an anomaly.
         *                              After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in <code>AnomalyVisibilityTime</code> , it will be considered normal going forward and will not be detected as an anomaly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anomalyVisibilityTime(java.lang.Number anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogAnomalyDetectorProps#getDetectorName}
         * @param detectorName A name for this anomaly detector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorName(java.lang.String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogAnomalyDetectorProps#getEvaluationFrequency}
         * @param evaluationFrequency Specifies how often the anomaly detector is to run and look for anomalies.
         *                            Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for <code>EvaluationFrequency</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationFrequency(java.lang.String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogAnomalyDetectorProps#getFilterPattern}
         * @param filterPattern You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here.
         *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(java.lang.String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogAnomalyDetectorProps#getKmsKeyId}
         * @param kmsKeyId Optionally assigns a AWS KMS key to secure this anomaly detector and its findings.
         *                 If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
         *                 <p>
         *                 For more information about using a AWS KMS key and to see the required IAM policy, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/LogsAnomalyDetection-KMS.html">Use a AWS KMS key with an anomaly detector</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogAnomalyDetectorProps#getLogGroupArnList}
         * @param logGroupArnList The ARN of the log group that is associated with this anomaly detector.
         *                        You can specify only one log group ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupArnList(java.util.List<java.lang.String> logGroupArnList) {
            this.logGroupArnList = logGroupArnList;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLogAnomalyDetectorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLogAnomalyDetectorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLogAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLogAnomalyDetectorProps {
        private final java.lang.String accountId;
        private final java.lang.Number anomalyVisibilityTime;
        private final java.lang.String detectorName;
        private final java.lang.String evaluationFrequency;
        private final java.lang.String filterPattern;
        private final java.lang.String kmsKeyId;
        private final java.util.List<java.lang.String> logGroupArnList;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.anomalyVisibilityTime = software.amazon.jsii.Kernel.get(this, "anomalyVisibilityTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.detectorName = software.amazon.jsii.Kernel.get(this, "detectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationFrequency = software.amazon.jsii.Kernel.get(this, "evaluationFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterPattern = software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupArnList = software.amazon.jsii.Kernel.get(this, "logGroupArnList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountId = builder.accountId;
            this.anomalyVisibilityTime = builder.anomalyVisibilityTime;
            this.detectorName = builder.detectorName;
            this.evaluationFrequency = builder.evaluationFrequency;
            this.filterPattern = builder.filterPattern;
            this.kmsKeyId = builder.kmsKeyId;
            this.logGroupArnList = builder.logGroupArnList;
        }

        @Override
        public final java.lang.String getAccountId() {
            return this.accountId;
        }

        @Override
        public final java.lang.Number getAnomalyVisibilityTime() {
            return this.anomalyVisibilityTime;
        }

        @Override
        public final java.lang.String getDetectorName() {
            return this.detectorName;
        }

        @Override
        public final java.lang.String getEvaluationFrequency() {
            return this.evaluationFrequency;
        }

        @Override
        public final java.lang.String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.util.List<java.lang.String> getLogGroupArnList() {
            return this.logGroupArnList;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountId() != null) {
                data.set("accountId", om.valueToTree(this.getAccountId()));
            }
            if (this.getAnomalyVisibilityTime() != null) {
                data.set("anomalyVisibilityTime", om.valueToTree(this.getAnomalyVisibilityTime()));
            }
            if (this.getDetectorName() != null) {
                data.set("detectorName", om.valueToTree(this.getDetectorName()));
            }
            if (this.getEvaluationFrequency() != null) {
                data.set("evaluationFrequency", om.valueToTree(this.getEvaluationFrequency()));
            }
            if (this.getFilterPattern() != null) {
                data.set("filterPattern", om.valueToTree(this.getFilterPattern()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLogGroupArnList() != null) {
                data.set("logGroupArnList", om.valueToTree(this.getLogGroupArnList()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnLogAnomalyDetectorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLogAnomalyDetectorProps.Jsii$Proxy that = (CfnLogAnomalyDetectorProps.Jsii$Proxy) o;

            if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
            if (this.anomalyVisibilityTime != null ? !this.anomalyVisibilityTime.equals(that.anomalyVisibilityTime) : that.anomalyVisibilityTime != null) return false;
            if (this.detectorName != null ? !this.detectorName.equals(that.detectorName) : that.detectorName != null) return false;
            if (this.evaluationFrequency != null ? !this.evaluationFrequency.equals(that.evaluationFrequency) : that.evaluationFrequency != null) return false;
            if (this.filterPattern != null ? !this.filterPattern.equals(that.filterPattern) : that.filterPattern != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            return this.logGroupArnList != null ? this.logGroupArnList.equals(that.logGroupArnList) : that.logGroupArnList == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountId != null ? this.accountId.hashCode() : 0;
            result = 31 * result + (this.anomalyVisibilityTime != null ? this.anomalyVisibilityTime.hashCode() : 0);
            result = 31 * result + (this.detectorName != null ? this.detectorName.hashCode() : 0);
            result = 31 * result + (this.evaluationFrequency != null ? this.evaluationFrequency.hashCode() : 0);
            result = 31 * result + (this.filterPattern != null ? this.filterPattern.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.logGroupArnList != null ? this.logGroupArnList.hashCode() : 0);
            return result;
        }
    }
}
