package software.amazon.awscdk.services.memorydb;

/**
 * Properties for defining a <code>CfnMultiRegionCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.memorydb.*;
 * CfnMultiRegionClusterProps cfnMultiRegionClusterProps = CfnMultiRegionClusterProps.builder()
 *         .nodeType("nodeType")
 *         // the properties below are optional
 *         .description("description")
 *         .engine("engine")
 *         .engineVersion("engineVersion")
 *         .multiRegionClusterNameSuffix("multiRegionClusterNameSuffix")
 *         .multiRegionParameterGroupName("multiRegionParameterGroupName")
 *         .numShards(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tlsEnabled(false)
 *         .updateStrategy("updateStrategy")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:18.508Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_memorydb.CfnMultiRegionClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnMultiRegionClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMultiRegionClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The node type used by the multi-Region cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-nodetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-nodetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNodeType();

    /**
     * The description of the multi-Region cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the engine used by the multi-Region cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return null;
    }

    /**
     * The version of the engine used by the multi-Region cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * A suffix to be added to the Multi-Region cluster name.
     * <p>
     * Amazon MemoryDB automatically applies a prefix to the Multi-Region cluster Name when it is created. Each Amazon Region has its own prefix. For instance, a Multi-Region cluster Name created in the US-West-1 region will begin with "virxk", along with the suffix name you provide. The suffix guarantees uniqueness of the Multi-Region cluster name across multiple regions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-multiregionclusternamesuffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-multiregionclusternamesuffix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMultiRegionClusterNameSuffix() {
        return null;
    }

    /**
     * The name of the multi-Region parameter group associated with the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-multiregionparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-multiregionparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMultiRegionParameterGroupName() {
        return null;
    }

    /**
     * The number of shards in the multi-Region cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-numshards">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-numshards</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumShards() {
        return null;
    }

    /**
     * A list of tags to be applied to the multi-Region cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Indiciates if the multi-Region cluster is TLS enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-tlsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-tlsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTlsEnabled() {
        return null;
    }

    /**
     * The strategy to use for the update operation.
     * <p>
     * Supported values are "coordinated" or "uncoordinated".
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-updatestrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-multiregioncluster.html#cfn-memorydb-multiregioncluster-updatestrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUpdateStrategy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMultiRegionClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMultiRegionClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMultiRegionClusterProps> {
        java.lang.String nodeType;
        java.lang.String description;
        java.lang.String engine;
        java.lang.String engineVersion;
        java.lang.String multiRegionClusterNameSuffix;
        java.lang.String multiRegionParameterGroupName;
        java.lang.Number numShards;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object tlsEnabled;
        java.lang.String updateStrategy;

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getNodeType}
         * @param nodeType The node type used by the multi-Region cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeType(java.lang.String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getDescription}
         * @param description The description of the multi-Region cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getEngine}
         * @param engine The name of the engine used by the multi-Region cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getEngineVersion}
         * @param engineVersion The version of the engine used by the multi-Region cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getMultiRegionClusterNameSuffix}
         * @param multiRegionClusterNameSuffix A suffix to be added to the Multi-Region cluster name.
         *                                     Amazon MemoryDB automatically applies a prefix to the Multi-Region cluster Name when it is created. Each Amazon Region has its own prefix. For instance, a Multi-Region cluster Name created in the US-West-1 region will begin with "virxk", along with the suffix name you provide. The suffix guarantees uniqueness of the Multi-Region cluster name across multiple regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionClusterNameSuffix(java.lang.String multiRegionClusterNameSuffix) {
            this.multiRegionClusterNameSuffix = multiRegionClusterNameSuffix;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getMultiRegionParameterGroupName}
         * @param multiRegionParameterGroupName The name of the multi-Region parameter group associated with the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionParameterGroupName(java.lang.String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getNumShards}
         * @param numShards The number of shards in the multi-Region cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numShards(java.lang.Number numShards) {
            this.numShards = numShards;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getTags}
         * @param tags A list of tags to be applied to the multi-Region cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getTlsEnabled}
         * @param tlsEnabled Indiciates if the multi-Region cluster is TLS enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsEnabled(java.lang.Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getTlsEnabled}
         * @param tlsEnabled Indiciates if the multi-Region cluster is TLS enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsEnabled(software.amazon.awscdk.IResolvable tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnMultiRegionClusterProps#getUpdateStrategy}
         * @param updateStrategy The strategy to use for the update operation.
         *                       Supported values are "coordinated" or "uncoordinated".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateStrategy(java.lang.String updateStrategy) {
            this.updateStrategy = updateStrategy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMultiRegionClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMultiRegionClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMultiRegionClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMultiRegionClusterProps {
        private final java.lang.String nodeType;
        private final java.lang.String description;
        private final java.lang.String engine;
        private final java.lang.String engineVersion;
        private final java.lang.String multiRegionClusterNameSuffix;
        private final java.lang.String multiRegionParameterGroupName;
        private final java.lang.Number numShards;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object tlsEnabled;
        private final java.lang.String updateStrategy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.nodeType = software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiRegionClusterNameSuffix = software.amazon.jsii.Kernel.get(this, "multiRegionClusterNameSuffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiRegionParameterGroupName = software.amazon.jsii.Kernel.get(this, "multiRegionParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numShards = software.amazon.jsii.Kernel.get(this, "numShards", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.tlsEnabled = software.amazon.jsii.Kernel.get(this, "tlsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.updateStrategy = software.amazon.jsii.Kernel.get(this, "updateStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.nodeType = java.util.Objects.requireNonNull(builder.nodeType, "nodeType is required");
            this.description = builder.description;
            this.engine = builder.engine;
            this.engineVersion = builder.engineVersion;
            this.multiRegionClusterNameSuffix = builder.multiRegionClusterNameSuffix;
            this.multiRegionParameterGroupName = builder.multiRegionParameterGroupName;
            this.numShards = builder.numShards;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.tlsEnabled = builder.tlsEnabled;
            this.updateStrategy = builder.updateStrategy;
        }

        @Override
        public final java.lang.String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getMultiRegionClusterNameSuffix() {
            return this.multiRegionClusterNameSuffix;
        }

        @Override
        public final java.lang.String getMultiRegionParameterGroupName() {
            return this.multiRegionParameterGroupName;
        }

        @Override
        public final java.lang.Number getNumShards() {
            return this.numShards;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTlsEnabled() {
            return this.tlsEnabled;
        }

        @Override
        public final java.lang.String getUpdateStrategy() {
            return this.updateStrategy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("nodeType", om.valueToTree(this.getNodeType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getMultiRegionClusterNameSuffix() != null) {
                data.set("multiRegionClusterNameSuffix", om.valueToTree(this.getMultiRegionClusterNameSuffix()));
            }
            if (this.getMultiRegionParameterGroupName() != null) {
                data.set("multiRegionParameterGroupName", om.valueToTree(this.getMultiRegionParameterGroupName()));
            }
            if (this.getNumShards() != null) {
                data.set("numShards", om.valueToTree(this.getNumShards()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTlsEnabled() != null) {
                data.set("tlsEnabled", om.valueToTree(this.getTlsEnabled()));
            }
            if (this.getUpdateStrategy() != null) {
                data.set("updateStrategy", om.valueToTree(this.getUpdateStrategy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_memorydb.CfnMultiRegionClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMultiRegionClusterProps.Jsii$Proxy that = (CfnMultiRegionClusterProps.Jsii$Proxy) o;

            if (!nodeType.equals(that.nodeType)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.multiRegionClusterNameSuffix != null ? !this.multiRegionClusterNameSuffix.equals(that.multiRegionClusterNameSuffix) : that.multiRegionClusterNameSuffix != null) return false;
            if (this.multiRegionParameterGroupName != null ? !this.multiRegionParameterGroupName.equals(that.multiRegionParameterGroupName) : that.multiRegionParameterGroupName != null) return false;
            if (this.numShards != null ? !this.numShards.equals(that.numShards) : that.numShards != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tlsEnabled != null ? !this.tlsEnabled.equals(that.tlsEnabled) : that.tlsEnabled != null) return false;
            return this.updateStrategy != null ? this.updateStrategy.equals(that.updateStrategy) : that.updateStrategy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.nodeType.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.multiRegionClusterNameSuffix != null ? this.multiRegionClusterNameSuffix.hashCode() : 0);
            result = 31 * result + (this.multiRegionParameterGroupName != null ? this.multiRegionParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.numShards != null ? this.numShards.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tlsEnabled != null ? this.tlsEnabled.hashCode() : 0);
            result = 31 * result + (this.updateStrategy != null ? this.updateStrategy.hashCode() : 0);
            return result;
        }
    }
}
