package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a <code>CfnDevice</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnDeviceProps cfnDeviceProps = CfnDeviceProps.builder()
 *         .globalNetworkId("globalNetworkId")
 *         // the properties below are optional
 *         .awsLocation(AWSLocationProperty.builder()
 *                 .subnetArn("subnetArn")
 *                 .zone("zone")
 *                 .build())
 *         .description("description")
 *         .location(LocationProperty.builder()
 *                 .address("address")
 *                 .latitude("latitude")
 *                 .longitude("longitude")
 *                 .build())
 *         .model("model")
 *         .serialNumber("serialNumber")
 *         .siteId("siteId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .type("type")
 *         .vendor("vendor")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:18.902Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnDeviceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeviceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeviceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the global network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-globalnetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-globalnetworkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlobalNetworkId();

    /**
     * The AWS location of the device.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-awslocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-awslocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAwsLocation() {
        return null;
    }

    /**
     * A description of the device.
     * <p>
     * Constraints: Maximum length of 256 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The site location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLocation() {
        return null;
    }

    /**
     * The model of the device.
     * <p>
     * Constraints: Maximum length of 128 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-model">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-model</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModel() {
        return null;
    }

    /**
     * The serial number of the device.
     * <p>
     * Constraints: Maximum length of 128 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-serialnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-serialnumber</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSerialNumber() {
        return null;
    }

    /**
     * The site ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-siteid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-siteid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSiteId() {
        return null;
    }

    /**
     * The tags for the device.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The device type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * The vendor of the device.
     * <p>
     * Constraints: Maximum length of 128 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-vendor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html#cfn-networkmanager-device-vendor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVendor() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeviceProps> {
        java.lang.String globalNetworkId;
        java.lang.Object awsLocation;
        java.lang.String description;
        java.lang.Object location;
        java.lang.String model;
        java.lang.String serialNumber;
        java.lang.String siteId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String type;
        java.lang.String vendor;

        /**
         * Sets the value of {@link CfnDeviceProps#getGlobalNetworkId}
         * @param globalNetworkId The ID of the global network. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNetworkId(java.lang.String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getAwsLocation}
         * @param awsLocation The AWS location of the device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsLocation(software.amazon.awscdk.IResolvable awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getAwsLocation}
         * @param awsLocation The AWS location of the device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsLocation(software.amazon.awscdk.services.networkmanager.CfnDevice.AWSLocationProperty awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getDescription}
         * @param description A description of the device.
         *                    Constraints: Maximum length of 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getLocation}
         * @param location The site location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(software.amazon.awscdk.IResolvable location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getLocation}
         * @param location The site location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(software.amazon.awscdk.services.networkmanager.CfnDevice.LocationProperty location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getModel}
         * @param model The model of the device.
         *              Constraints: Maximum length of 128 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder model(java.lang.String model) {
            this.model = model;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getSerialNumber}
         * @param serialNumber The serial number of the device.
         *                     Constraints: Maximum length of 128 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serialNumber(java.lang.String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getSiteId}
         * @param siteId The site ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder siteId(java.lang.String siteId) {
            this.siteId = siteId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getTags}
         * @param tags The tags for the device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getType}
         * @param type The device type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceProps#getVendor}
         * @param vendor The vendor of the device.
         *               Constraints: Maximum length of 128 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vendor(java.lang.String vendor) {
            this.vendor = vendor;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeviceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeviceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeviceProps {
        private final java.lang.String globalNetworkId;
        private final java.lang.Object awsLocation;
        private final java.lang.String description;
        private final java.lang.Object location;
        private final java.lang.String model;
        private final java.lang.String serialNumber;
        private final java.lang.String siteId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String type;
        private final java.lang.String vendor;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.globalNetworkId = software.amazon.jsii.Kernel.get(this, "globalNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.awsLocation = software.amazon.jsii.Kernel.get(this, "awsLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.model = software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serialNumber = software.amazon.jsii.Kernel.get(this, "serialNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.siteId = software.amazon.jsii.Kernel.get(this, "siteId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vendor = software.amazon.jsii.Kernel.get(this, "vendor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.globalNetworkId = java.util.Objects.requireNonNull(builder.globalNetworkId, "globalNetworkId is required");
            this.awsLocation = builder.awsLocation;
            this.description = builder.description;
            this.location = builder.location;
            this.model = builder.model;
            this.serialNumber = builder.serialNumber;
            this.siteId = builder.siteId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.type = builder.type;
            this.vendor = builder.vendor;
        }

        @Override
        public final java.lang.String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        @Override
        public final java.lang.Object getAwsLocation() {
            return this.awsLocation;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getLocation() {
            return this.location;
        }

        @Override
        public final java.lang.String getModel() {
            return this.model;
        }

        @Override
        public final java.lang.String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final java.lang.String getSiteId() {
            return this.siteId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getVendor() {
            return this.vendor;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("globalNetworkId", om.valueToTree(this.getGlobalNetworkId()));
            if (this.getAwsLocation() != null) {
                data.set("awsLocation", om.valueToTree(this.getAwsLocation()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLocation() != null) {
                data.set("location", om.valueToTree(this.getLocation()));
            }
            if (this.getModel() != null) {
                data.set("model", om.valueToTree(this.getModel()));
            }
            if (this.getSerialNumber() != null) {
                data.set("serialNumber", om.valueToTree(this.getSerialNumber()));
            }
            if (this.getSiteId() != null) {
                data.set("siteId", om.valueToTree(this.getSiteId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getVendor() != null) {
                data.set("vendor", om.valueToTree(this.getVendor()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnDeviceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeviceProps.Jsii$Proxy that = (CfnDeviceProps.Jsii$Proxy) o;

            if (!globalNetworkId.equals(that.globalNetworkId)) return false;
            if (this.awsLocation != null ? !this.awsLocation.equals(that.awsLocation) : that.awsLocation != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
            if (this.model != null ? !this.model.equals(that.model) : that.model != null) return false;
            if (this.serialNumber != null ? !this.serialNumber.equals(that.serialNumber) : that.serialNumber != null) return false;
            if (this.siteId != null ? !this.siteId.equals(that.siteId) : that.siteId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.vendor != null ? this.vendor.equals(that.vendor) : that.vendor == null;
        }

        @Override
        public final int hashCode() {
            int result = this.globalNetworkId.hashCode();
            result = 31 * result + (this.awsLocation != null ? this.awsLocation.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
            result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
            result = 31 * result + (this.serialNumber != null ? this.serialNumber.hashCode() : 0);
            result = 31 * result + (this.siteId != null ? this.siteId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.vendor != null ? this.vendor.hashCode() : 0);
            return result;
        }
    }
}
