package software.amazon.awscdk.services.odb;

/**
 * Properties for defining a <code>CfnCloudExadataInfrastructure</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.odb.*;
 * CfnCloudExadataInfrastructureProps cfnCloudExadataInfrastructureProps = CfnCloudExadataInfrastructureProps.builder()
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneId("availabilityZoneId")
 *         .computeCount(123)
 *         .customerContactsToSendToOci(List.of(CustomerContactProperty.builder()
 *                 .email("email")
 *                 .build()))
 *         .databaseServerType("databaseServerType")
 *         .displayName("displayName")
 *         .shape("shape")
 *         .storageCount(123)
 *         .storageServerType("storageServerType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:19.093Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudExadataInfrastructureProps")
@software.amazon.jsii.Jsii.Proxy(CfnCloudExadataInfrastructureProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCloudExadataInfrastructureProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
     * <p>
     * Required when creating an Exadata infrastructure. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the infrastructure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The AZ ID of the AZ where the Exadata infrastructure is located.
     * <p>
     * Required when creating an Exadata infrastructure. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the infrastructure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-availabilityzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-availabilityzoneid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
        return null;
    }

    /**
     * The number of database servers for the Exadata infrastructure.
     * <p>
     * Required when creating an Exadata infrastructure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-computecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-computecount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getComputeCount() {
        return null;
    }

    /**
     * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-customercontactstosendtooci">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-customercontactstosendtooci</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerContactsToSendToOci() {
        return null;
    }

    /**
     * The database server model type of the Exadata infrastructure.
     * <p>
     * For the list of valid model names, use the <code>ListDbSystemShapes</code> operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-databaseservertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-databaseservertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseServerType() {
        return null;
    }

    /**
     * The user-friendly name for the Exadata infrastructure.
     * <p>
     * Required when creating an Exadata infrastructure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The model name of the Exadata infrastructure.
     * <p>
     * Required when creating an Exadata infrastructure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-shape">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-shape</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getShape() {
        return null;
    }

    /**
     * The number of storage servers that are activated for the Exadata infrastructure.
     * <p>
     * Required when creating an Exadata infrastructure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-storagecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-storagecount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStorageCount() {
        return null;
    }

    /**
     * The storage server model type of the Exadata infrastructure.
     * <p>
     * For the list of valid model names, use the <code>ListDbSystemShapes</code> operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-storageservertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-storageservertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageServerType() {
        return null;
    }

    /**
     * Tags to assign to the Exadata Infrastructure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCloudExadataInfrastructureProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCloudExadataInfrastructureProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCloudExadataInfrastructureProps> {
        java.lang.String availabilityZone;
        java.lang.String availabilityZoneId;
        java.lang.Number computeCount;
        java.lang.Object customerContactsToSendToOci;
        java.lang.String databaseServerType;
        java.lang.String displayName;
        java.lang.String shape;
        java.lang.Number storageCount;
        java.lang.String storageServerType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getAvailabilityZone}
         * @param availabilityZone The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
         *                         Required when creating an Exadata infrastructure. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getAvailabilityZoneId}
         * @param availabilityZoneId The AZ ID of the AZ where the Exadata infrastructure is located.
         *                           Required when creating an Exadata infrastructure. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneId(java.lang.String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getComputeCount}
         * @param computeCount The number of database servers for the Exadata infrastructure.
         *                     Required when creating an Exadata infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeCount(java.lang.Number computeCount) {
            this.computeCount = computeCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getCustomerContactsToSendToOci}
         * @param customerContactsToSendToOci The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerContactsToSendToOci(software.amazon.awscdk.IResolvable customerContactsToSendToOci) {
            this.customerContactsToSendToOci = customerContactsToSendToOci;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getCustomerContactsToSendToOci}
         * @param customerContactsToSendToOci The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerContactsToSendToOci(java.util.List<? extends java.lang.Object> customerContactsToSendToOci) {
            this.customerContactsToSendToOci = customerContactsToSendToOci;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getDatabaseServerType}
         * @param databaseServerType The database server model type of the Exadata infrastructure.
         *                           For the list of valid model names, use the <code>ListDbSystemShapes</code> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseServerType(java.lang.String databaseServerType) {
            this.databaseServerType = databaseServerType;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getDisplayName}
         * @param displayName The user-friendly name for the Exadata infrastructure.
         *                    Required when creating an Exadata infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getShape}
         * @param shape The model name of the Exadata infrastructure.
         *              Required when creating an Exadata infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shape(java.lang.String shape) {
            this.shape = shape;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getStorageCount}
         * @param storageCount The number of storage servers that are activated for the Exadata infrastructure.
         *                     Required when creating an Exadata infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCount(java.lang.Number storageCount) {
            this.storageCount = storageCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getStorageServerType}
         * @param storageServerType The storage server model type of the Exadata infrastructure.
         *                          For the list of valid model names, use the <code>ListDbSystemShapes</code> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageServerType(java.lang.String storageServerType) {
            this.storageServerType = storageServerType;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudExadataInfrastructureProps#getTags}
         * @param tags Tags to assign to the Exadata Infrastructure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCloudExadataInfrastructureProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCloudExadataInfrastructureProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCloudExadataInfrastructureProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCloudExadataInfrastructureProps {
        private final java.lang.String availabilityZone;
        private final java.lang.String availabilityZoneId;
        private final java.lang.Number computeCount;
        private final java.lang.Object customerContactsToSendToOci;
        private final java.lang.String databaseServerType;
        private final java.lang.String displayName;
        private final java.lang.String shape;
        private final java.lang.Number storageCount;
        private final java.lang.String storageServerType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneId = software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computeCount = software.amazon.jsii.Kernel.get(this, "computeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.customerContactsToSendToOci = software.amazon.jsii.Kernel.get(this, "customerContactsToSendToOci", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.databaseServerType = software.amazon.jsii.Kernel.get(this, "databaseServerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.shape = software.amazon.jsii.Kernel.get(this, "shape", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageCount = software.amazon.jsii.Kernel.get(this, "storageCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.storageServerType = software.amazon.jsii.Kernel.get(this, "storageServerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = builder.availabilityZone;
            this.availabilityZoneId = builder.availabilityZoneId;
            this.computeCount = builder.computeCount;
            this.customerContactsToSendToOci = builder.customerContactsToSendToOci;
            this.databaseServerType = builder.databaseServerType;
            this.displayName = builder.displayName;
            this.shape = builder.shape;
            this.storageCount = builder.storageCount;
            this.storageServerType = builder.storageServerType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final java.lang.Number getComputeCount() {
            return this.computeCount;
        }

        @Override
        public final java.lang.Object getCustomerContactsToSendToOci() {
            return this.customerContactsToSendToOci;
        }

        @Override
        public final java.lang.String getDatabaseServerType() {
            return this.databaseServerType;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getShape() {
            return this.shape;
        }

        @Override
        public final java.lang.Number getStorageCount() {
            return this.storageCount;
        }

        @Override
        public final java.lang.String getStorageServerType() {
            return this.storageServerType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getAvailabilityZoneId() != null) {
                data.set("availabilityZoneId", om.valueToTree(this.getAvailabilityZoneId()));
            }
            if (this.getComputeCount() != null) {
                data.set("computeCount", om.valueToTree(this.getComputeCount()));
            }
            if (this.getCustomerContactsToSendToOci() != null) {
                data.set("customerContactsToSendToOci", om.valueToTree(this.getCustomerContactsToSendToOci()));
            }
            if (this.getDatabaseServerType() != null) {
                data.set("databaseServerType", om.valueToTree(this.getDatabaseServerType()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getShape() != null) {
                data.set("shape", om.valueToTree(this.getShape()));
            }
            if (this.getStorageCount() != null) {
                data.set("storageCount", om.valueToTree(this.getStorageCount()));
            }
            if (this.getStorageServerType() != null) {
                data.set("storageServerType", om.valueToTree(this.getStorageServerType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnCloudExadataInfrastructureProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCloudExadataInfrastructureProps.Jsii$Proxy that = (CfnCloudExadataInfrastructureProps.Jsii$Proxy) o;

            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.availabilityZoneId != null ? !this.availabilityZoneId.equals(that.availabilityZoneId) : that.availabilityZoneId != null) return false;
            if (this.computeCount != null ? !this.computeCount.equals(that.computeCount) : that.computeCount != null) return false;
            if (this.customerContactsToSendToOci != null ? !this.customerContactsToSendToOci.equals(that.customerContactsToSendToOci) : that.customerContactsToSendToOci != null) return false;
            if (this.databaseServerType != null ? !this.databaseServerType.equals(that.databaseServerType) : that.databaseServerType != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.shape != null ? !this.shape.equals(that.shape) : that.shape != null) return false;
            if (this.storageCount != null ? !this.storageCount.equals(that.storageCount) : that.storageCount != null) return false;
            if (this.storageServerType != null ? !this.storageServerType.equals(that.storageServerType) : that.storageServerType != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
            result = 31 * result + (this.availabilityZoneId != null ? this.availabilityZoneId.hashCode() : 0);
            result = 31 * result + (this.computeCount != null ? this.computeCount.hashCode() : 0);
            result = 31 * result + (this.customerContactsToSendToOci != null ? this.customerContactsToSendToOci.hashCode() : 0);
            result = 31 * result + (this.databaseServerType != null ? this.databaseServerType.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.shape != null ? this.shape.hashCode() : 0);
            result = 31 * result + (this.storageCount != null ? this.storageCount.hashCode() : 0);
            result = 31 * result + (this.storageServerType != null ? this.storageServerType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
