package software.amazon.awscdk.services.pcs;

/**
 * Properties for defining a <code>CfnCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pcs.*;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .networking(NetworkingProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .scheduler(SchedulerProperty.builder()
 *                 .type("type")
 *                 .version("version")
 *                 .build())
 *         .size("size")
 *         // the properties below are optional
 *         .name("name")
 *         .slurmConfiguration(SlurmConfigurationProperty.builder()
 *                 .accounting(AccountingProperty.builder()
 *                         .mode("mode")
 *                         // the properties below are optional
 *                         .defaultPurgeTimeInDays(123)
 *                         .build())
 *                 .authKey(AuthKeyProperty.builder()
 *                         .secretArn("secretArn")
 *                         .secretVersion("secretVersion")
 *                         .build())
 *                 .scaleDownIdleTimeInSeconds(123)
 *                 .slurmCustomSettings(List.of(SlurmCustomSettingProperty.builder()
 *                         .parameterName("parameterName")
 *                         .parameterValue("parameterValue")
 *                         .build()))
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:19.393Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcs.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The networking configuration for the cluster's control plane.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-networking">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-networking</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getNetworking();

    /**
     * The cluster management and job scheduling software associated with the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-scheduler">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-scheduler</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getScheduler();

    /**
     * The size of the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-size</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSize();

    /**
     * The name that identifies the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Additional options related to the Slurm scheduler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-slurmconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-slurmconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSlurmConfiguration() {
        return null;
    }

    /**
     * 1 or more tags added to the resource.
     * <p>
     * Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-cluster.html#cfn-pcs-cluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.Object networking;
        java.lang.Object scheduler;
        java.lang.String size;
        java.lang.String name;
        java.lang.Object slurmConfiguration;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnClusterProps#getNetworking}
         * @param networking The networking configuration for the cluster's control plane. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networking(software.amazon.awscdk.IResolvable networking) {
            this.networking = networking;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNetworking}
         * @param networking The networking configuration for the cluster's control plane. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networking(software.amazon.awscdk.services.pcs.CfnCluster.NetworkingProperty networking) {
            this.networking = networking;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getScheduler}
         * @param scheduler The cluster management and job scheduling software associated with the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduler(software.amazon.awscdk.IResolvable scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getScheduler}
         * @param scheduler The cluster management and job scheduling software associated with the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduler(software.amazon.awscdk.services.pcs.CfnCluster.SchedulerProperty scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSize}
         * @param size The size of the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(java.lang.String size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getName}
         * @param name The name that identifies the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSlurmConfiguration}
         * @param slurmConfiguration Additional options related to the Slurm scheduler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slurmConfiguration(software.amazon.awscdk.IResolvable slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSlurmConfiguration}
         * @param slurmConfiguration Additional options related to the Slurm scheduler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slurmConfiguration(software.amazon.awscdk.services.pcs.CfnCluster.SlurmConfigurationProperty slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags 1 or more tags added to the resource.
         *             Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.Object networking;
        private final java.lang.Object scheduler;
        private final java.lang.String size;
        private final java.lang.String name;
        private final java.lang.Object slurmConfiguration;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networking = software.amazon.jsii.Kernel.get(this, "networking", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scheduler = software.amazon.jsii.Kernel.get(this, "scheduler", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.slurmConfiguration = software.amazon.jsii.Kernel.get(this, "slurmConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networking = java.util.Objects.requireNonNull(builder.networking, "networking is required");
            this.scheduler = java.util.Objects.requireNonNull(builder.scheduler, "scheduler is required");
            this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
            this.name = builder.name;
            this.slurmConfiguration = builder.slurmConfiguration;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getNetworking() {
            return this.networking;
        }

        @Override
        public final java.lang.Object getScheduler() {
            return this.scheduler;
        }

        @Override
        public final java.lang.String getSize() {
            return this.size;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSlurmConfiguration() {
            return this.slurmConfiguration;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networking", om.valueToTree(this.getNetworking()));
            data.set("scheduler", om.valueToTree(this.getScheduler()));
            data.set("size", om.valueToTree(this.getSize()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getSlurmConfiguration() != null) {
                data.set("slurmConfiguration", om.valueToTree(this.getSlurmConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcs.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (!networking.equals(that.networking)) return false;
            if (!scheduler.equals(that.scheduler)) return false;
            if (!size.equals(that.size)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.slurmConfiguration != null ? !this.slurmConfiguration.equals(that.slurmConfiguration) : that.slurmConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.networking.hashCode();
            result = 31 * result + (this.scheduler.hashCode());
            result = 31 * result + (this.size.hashCode());
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.slurmConfiguration != null ? this.slurmConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
