package software.amazon.awscdk.services.personalize;

/**
 * Properties for defining a <code>CfnDataset</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.personalize.*;
 * Object dataSource;
 * CfnDatasetProps cfnDatasetProps = CfnDatasetProps.builder()
 *         .datasetGroupArn("datasetGroupArn")
 *         .datasetType("datasetType")
 *         .name("name")
 *         .schemaArn("schemaArn")
 *         // the properties below are optional
 *         .datasetImportJob(DatasetImportJobProperty.builder()
 *                 .datasetArn("datasetArn")
 *                 .datasetImportJobArn("datasetImportJobArn")
 *                 .dataSource(dataSource)
 *                 .jobName("jobName")
 *                 .roleArn("roleArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:19.404Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnDatasetProps")
@software.amazon.jsii.Jsii.Proxy(CfnDatasetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDatasetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the dataset group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-datasetgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-datasetgrouparn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatasetGroupArn();

    /**
     * One of the following values:.
     * <p>
     * <ul>
     * <li>Interactions</li>
     * <li>Items</li>
     * <li>Users</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * You can't use CloudFormation to create an Action Interactions or Actions dataset.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-datasettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-datasettype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatasetType();

    /**
     * The name of the dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ARN of the associated schema.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-schemaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-schemaarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchemaArn();

    /**
     * Describes a job that imports training data from a data source (Amazon S3 bucket) to an Amazon Personalize dataset.
     * <p>
     * If you specify a dataset import job as part of a dataset, all dataset import job fields are required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-datasetimportjob">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-dataset.html#cfn-personalize-dataset-datasetimportjob</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDatasetImportJob() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDatasetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDatasetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDatasetProps> {
        java.lang.String datasetGroupArn;
        java.lang.String datasetType;
        java.lang.String name;
        java.lang.String schemaArn;
        java.lang.Object datasetImportJob;

        /**
         * Sets the value of {@link CfnDatasetProps#getDatasetGroupArn}
         * @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetGroupArn(java.lang.String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getDatasetType}
         * @param datasetType One of the following values:. This parameter is required.
         *                    <ul>
         *                    <li>Interactions</li>
         *                    <li>Items</li>
         *                    <li>Users</li>
         *                    </ul>
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    You can't use CloudFormation to create an Action Interactions or Actions dataset.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetType(java.lang.String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getName}
         * @param name The name of the dataset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getSchemaArn}
         * @param schemaArn The ARN of the associated schema. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaArn(java.lang.String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getDatasetImportJob}
         * @param datasetImportJob Describes a job that imports training data from a data source (Amazon S3 bucket) to an Amazon Personalize dataset.
         *                         If you specify a dataset import job as part of a dataset, all dataset import job fields are required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetImportJob(software.amazon.awscdk.IResolvable datasetImportJob) {
            this.datasetImportJob = datasetImportJob;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatasetProps#getDatasetImportJob}
         * @param datasetImportJob Describes a job that imports training data from a data source (Amazon S3 bucket) to an Amazon Personalize dataset.
         *                         If you specify a dataset import job as part of a dataset, all dataset import job fields are required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetImportJob(software.amazon.awscdk.services.personalize.CfnDataset.DatasetImportJobProperty datasetImportJob) {
            this.datasetImportJob = datasetImportJob;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDatasetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDatasetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDatasetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDatasetProps {
        private final java.lang.String datasetGroupArn;
        private final java.lang.String datasetType;
        private final java.lang.String name;
        private final java.lang.String schemaArn;
        private final java.lang.Object datasetImportJob;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.datasetGroupArn = software.amazon.jsii.Kernel.get(this, "datasetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datasetType = software.amazon.jsii.Kernel.get(this, "datasetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schemaArn = software.amazon.jsii.Kernel.get(this, "schemaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datasetImportJob = software.amazon.jsii.Kernel.get(this, "datasetImportJob", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.datasetGroupArn = java.util.Objects.requireNonNull(builder.datasetGroupArn, "datasetGroupArn is required");
            this.datasetType = java.util.Objects.requireNonNull(builder.datasetType, "datasetType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.schemaArn = java.util.Objects.requireNonNull(builder.schemaArn, "schemaArn is required");
            this.datasetImportJob = builder.datasetImportJob;
        }

        @Override
        public final java.lang.String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        @Override
        public final java.lang.String getDatasetType() {
            return this.datasetType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final java.lang.Object getDatasetImportJob() {
            return this.datasetImportJob;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("datasetGroupArn", om.valueToTree(this.getDatasetGroupArn()));
            data.set("datasetType", om.valueToTree(this.getDatasetType()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("schemaArn", om.valueToTree(this.getSchemaArn()));
            if (this.getDatasetImportJob() != null) {
                data.set("datasetImportJob", om.valueToTree(this.getDatasetImportJob()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnDatasetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDatasetProps.Jsii$Proxy that = (CfnDatasetProps.Jsii$Proxy) o;

            if (!datasetGroupArn.equals(that.datasetGroupArn)) return false;
            if (!datasetType.equals(that.datasetType)) return false;
            if (!name.equals(that.name)) return false;
            if (!schemaArn.equals(that.schemaArn)) return false;
            return this.datasetImportJob != null ? this.datasetImportJob.equals(that.datasetImportJob) : that.datasetImportJob == null;
        }

        @Override
        public final int hashCode() {
            int result = this.datasetGroupArn.hashCode();
            result = 31 * result + (this.datasetType.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.schemaArn.hashCode());
            result = 31 * result + (this.datasetImportJob != null ? this.datasetImportJob.hashCode() : 0);
            return result;
        }
    }
}
