package software.amazon.awscdk.services.quicksight;

/**
 * Properties for defining a <code>CfnDashboard</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:20.697Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDashboardProps")
@software.amazon.jsii.Jsii.Proxy(CfnDashboardProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDashboardProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the AWS account where you want to create the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-awsaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The ID for the dashboard, also added to the IAM policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDashboardId();

    /**
     * The display name of the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Options for publishing the dashboard when you create it:.
     * <p>
     * <ul>
     * <li><code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . When this is set to <code>DISABLED</code> , Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default.</li>
     * <li><code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code> . This option is <code>ENABLED</code> by default.</li>
     * <li><code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code> . This option is <code>COLLAPSED</code> by default.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardpublishoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardpublishoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDashboardPublishOptions() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-definition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-folderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-folderarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFolderArns() {
        return null;
    }

    /**
     * A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-linkentities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-linkentities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLinkEntities() {
        return null;
    }

    /**
     * A structure that contains the link sharing configurations that you want to apply overrides to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-linksharingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-linksharingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLinkSharingConfiguration() {
        return null;
    }

    /**
     * The parameters for the creation of the dashboard, which you want to use to override the default settings.
     * <p>
     * A dashboard can have any type of parameters, and some parameters might accept multiple values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * A structure that contains the permissions of the dashboard.
     * <p>
     * You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
     * <p>
     * To specify no permissions, omit the permissions list.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-permissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return null;
    }

    /**
     * The entity that you are using as a source when you create the dashboard.
     * <p>
     * In <code>SourceEntity</code> , you specify the type of object that you want to use. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code>CreateTemplate</code> API operation. For <code>SourceTemplate</code> , specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS account; and any QuickSight-supported AWS Region .
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-sourceentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-sourceentity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceEntity() {
        return null;
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
     * <p>
     * If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same AWS account where you create the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-themearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-themearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThemeArn() {
        return null;
    }

    /**
     * The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
     * <p>
     * When you set this value to <code>LENIENT</code> , validation is skipped for specific errors.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-validationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-validationstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getValidationStrategy() {
        return null;
    }

    /**
     * A description for the first version of the dashboard being created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-versiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-versiondescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDashboardProps> {
        java.lang.String awsAccountId;
        java.lang.String dashboardId;
        java.lang.String name;
        java.lang.Object dashboardPublishOptions;
        java.lang.Object definition;
        java.util.List<java.lang.String> folderArns;
        java.util.List<java.lang.String> linkEntities;
        java.lang.Object linkSharingConfiguration;
        java.lang.Object parameters;
        java.lang.Object permissions;
        java.lang.Object sourceEntity;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String themeArn;
        java.lang.Object validationStrategy;
        java.lang.String versionDescription;

        /**
         * Sets the value of {@link CfnDashboardProps#getAwsAccountId}
         * @param awsAccountId The ID of the AWS account where you want to create the dashboard. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getDashboardId}
         * @param dashboardId The ID for the dashboard, also added to the IAM policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardId(java.lang.String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getName}
         * @param name The display name of the dashboard. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getDashboardPublishOptions}
         * @param dashboardPublishOptions Options for publishing the dashboard when you create it:.
         *                                <ul>
         *                                <li><code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . When this is set to <code>DISABLED</code> , Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default.</li>
         *                                <li><code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code> . This option is <code>ENABLED</code> by default.</li>
         *                                <li><code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code> . This option is <code>COLLAPSED</code> by default.</li>
         *                                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardPublishOptions(software.amazon.awscdk.IResolvable dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getDashboardPublishOptions}
         * @param dashboardPublishOptions Options for publishing the dashboard when you create it:.
         *                                <ul>
         *                                <li><code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . When this is set to <code>DISABLED</code> , Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default.</li>
         *                                <li><code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code> . The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code> . This option is <code>ENABLED</code> by default.</li>
         *                                <li><code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code> . This option is <code>COLLAPSED</code> by default.</li>
         *                                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardPublishOptions(software.amazon.awscdk.services.quicksight.CfnDashboard.DashboardPublishOptionsProperty dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getDefinition}
         * @param definition the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.IResolvable definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getDefinition}
         * @param definition the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.services.quicksight.CfnDashboard.DashboardVersionDefinitionProperty definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getFolderArns}
         * @param folderArns the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder folderArns(java.util.List<java.lang.String> folderArns) {
            this.folderArns = folderArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getLinkEntities}
         * @param linkEntities A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkEntities(java.util.List<java.lang.String> linkEntities) {
            this.linkEntities = linkEntities;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getLinkSharingConfiguration}
         * @param linkSharingConfiguration A structure that contains the link sharing configurations that you want to apply overrides to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkSharingConfiguration(software.amazon.awscdk.IResolvable linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getLinkSharingConfiguration}
         * @param linkSharingConfiguration A structure that contains the link sharing configurations that you want to apply overrides to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkSharingConfiguration(software.amazon.awscdk.services.quicksight.CfnDashboard.LinkSharingConfigurationProperty linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getParameters}
         * @param parameters The parameters for the creation of the dashboard, which you want to use to override the default settings.
         *                   A dashboard can have any type of parameters, and some parameters might accept multiple values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getParameters}
         * @param parameters The parameters for the creation of the dashboard, which you want to use to override the default settings.
         *                   A dashboard can have any type of parameters, and some parameters might accept multiple values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.services.quicksight.CfnDashboard.ParametersProperty parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getPermissions}
         * @param permissions A structure that contains the permissions of the dashboard.
         *                    You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
         *                    <p>
         *                    To specify no permissions, omit the permissions list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(software.amazon.awscdk.IResolvable permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getPermissions}
         * @param permissions A structure that contains the permissions of the dashboard.
         *                    You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
         *                    <p>
         *                    To specify no permissions, omit the permissions list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.util.List<? extends java.lang.Object> permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getSourceEntity}
         * @param sourceEntity The entity that you are using as a source when you create the dashboard.
         *                     In <code>SourceEntity</code> , you specify the type of object that you want to use. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code>CreateTemplate</code> API operation. For <code>SourceTemplate</code> , specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS account; and any QuickSight-supported AWS Region .
         *                     <p>
         *                     Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(software.amazon.awscdk.IResolvable sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getSourceEntity}
         * @param sourceEntity The entity that you are using as a source when you create the dashboard.
         *                     In <code>SourceEntity</code> , you specify the type of object that you want to use. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code>CreateTemplate</code> API operation. For <code>SourceTemplate</code> , specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS account; and any QuickSight-supported AWS Region .
         *                     <p>
         *                     Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(software.amazon.awscdk.services.quicksight.CfnDashboard.DashboardSourceEntityProperty sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getTags}
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getThemeArn}
         * @param themeArn The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
         *                 If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same AWS account where you create the dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder themeArn(java.lang.String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getValidationStrategy}
         * @param validationStrategy The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
         *                           When you set this value to <code>LENIENT</code> , validation is skipped for specific errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationStrategy(software.amazon.awscdk.IResolvable validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getValidationStrategy}
         * @param validationStrategy The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
         *                           When you set this value to <code>LENIENT</code> , validation is skipped for specific errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationStrategy(software.amazon.awscdk.services.quicksight.CfnDashboard.ValidationStrategyProperty validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getVersionDescription}
         * @param versionDescription A description for the first version of the dashboard being created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(java.lang.String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDashboardProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDashboardProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDashboardProps {
        private final java.lang.String awsAccountId;
        private final java.lang.String dashboardId;
        private final java.lang.String name;
        private final java.lang.Object dashboardPublishOptions;
        private final java.lang.Object definition;
        private final java.util.List<java.lang.String> folderArns;
        private final java.util.List<java.lang.String> linkEntities;
        private final java.lang.Object linkSharingConfiguration;
        private final java.lang.Object parameters;
        private final java.lang.Object permissions;
        private final java.lang.Object sourceEntity;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String themeArn;
        private final java.lang.Object validationStrategy;
        private final java.lang.String versionDescription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dashboardId = software.amazon.jsii.Kernel.get(this, "dashboardId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dashboardPublishOptions = software.amazon.jsii.Kernel.get(this, "dashboardPublishOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.folderArns = software.amazon.jsii.Kernel.get(this, "folderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.linkEntities = software.amazon.jsii.Kernel.get(this, "linkEntities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.linkSharingConfiguration = software.amazon.jsii.Kernel.get(this, "linkSharingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceEntity = software.amazon.jsii.Kernel.get(this, "sourceEntity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.themeArn = software.amazon.jsii.Kernel.get(this, "themeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validationStrategy = software.amazon.jsii.Kernel.get(this, "validationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.versionDescription = software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.dashboardId = java.util.Objects.requireNonNull(builder.dashboardId, "dashboardId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.dashboardPublishOptions = builder.dashboardPublishOptions;
            this.definition = builder.definition;
            this.folderArns = builder.folderArns;
            this.linkEntities = builder.linkEntities;
            this.linkSharingConfiguration = builder.linkSharingConfiguration;
            this.parameters = builder.parameters;
            this.permissions = builder.permissions;
            this.sourceEntity = builder.sourceEntity;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.themeArn = builder.themeArn;
            this.validationStrategy = builder.validationStrategy;
            this.versionDescription = builder.versionDescription;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getDashboardId() {
            return this.dashboardId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getDashboardPublishOptions() {
            return this.dashboardPublishOptions;
        }

        @Override
        public final java.lang.Object getDefinition() {
            return this.definition;
        }

        @Override
        public final java.util.List<java.lang.String> getFolderArns() {
            return this.folderArns;
        }

        @Override
        public final java.util.List<java.lang.String> getLinkEntities() {
            return this.linkEntities;
        }

        @Override
        public final java.lang.Object getLinkSharingConfiguration() {
            return this.linkSharingConfiguration;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Object getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.lang.Object getSourceEntity() {
            return this.sourceEntity;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getThemeArn() {
            return this.themeArn;
        }

        @Override
        public final java.lang.Object getValidationStrategy() {
            return this.validationStrategy;
        }

        @Override
        public final java.lang.String getVersionDescription() {
            return this.versionDescription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("dashboardId", om.valueToTree(this.getDashboardId()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDashboardPublishOptions() != null) {
                data.set("dashboardPublishOptions", om.valueToTree(this.getDashboardPublishOptions()));
            }
            if (this.getDefinition() != null) {
                data.set("definition", om.valueToTree(this.getDefinition()));
            }
            if (this.getFolderArns() != null) {
                data.set("folderArns", om.valueToTree(this.getFolderArns()));
            }
            if (this.getLinkEntities() != null) {
                data.set("linkEntities", om.valueToTree(this.getLinkEntities()));
            }
            if (this.getLinkSharingConfiguration() != null) {
                data.set("linkSharingConfiguration", om.valueToTree(this.getLinkSharingConfiguration()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }
            if (this.getSourceEntity() != null) {
                data.set("sourceEntity", om.valueToTree(this.getSourceEntity()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThemeArn() != null) {
                data.set("themeArn", om.valueToTree(this.getThemeArn()));
            }
            if (this.getValidationStrategy() != null) {
                data.set("validationStrategy", om.valueToTree(this.getValidationStrategy()));
            }
            if (this.getVersionDescription() != null) {
                data.set("versionDescription", om.valueToTree(this.getVersionDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDashboardProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDashboardProps.Jsii$Proxy that = (CfnDashboardProps.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!dashboardId.equals(that.dashboardId)) return false;
            if (!name.equals(that.name)) return false;
            if (this.dashboardPublishOptions != null ? !this.dashboardPublishOptions.equals(that.dashboardPublishOptions) : that.dashboardPublishOptions != null) return false;
            if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
            if (this.folderArns != null ? !this.folderArns.equals(that.folderArns) : that.folderArns != null) return false;
            if (this.linkEntities != null ? !this.linkEntities.equals(that.linkEntities) : that.linkEntities != null) return false;
            if (this.linkSharingConfiguration != null ? !this.linkSharingConfiguration.equals(that.linkSharingConfiguration) : that.linkSharingConfiguration != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
            if (this.sourceEntity != null ? !this.sourceEntity.equals(that.sourceEntity) : that.sourceEntity != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.themeArn != null ? !this.themeArn.equals(that.themeArn) : that.themeArn != null) return false;
            if (this.validationStrategy != null ? !this.validationStrategy.equals(that.validationStrategy) : that.validationStrategy != null) return false;
            return this.versionDescription != null ? this.versionDescription.equals(that.versionDescription) : that.versionDescription == null;
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.dashboardId.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.dashboardPublishOptions != null ? this.dashboardPublishOptions.hashCode() : 0);
            result = 31 * result + (this.definition != null ? this.definition.hashCode() : 0);
            result = 31 * result + (this.folderArns != null ? this.folderArns.hashCode() : 0);
            result = 31 * result + (this.linkEntities != null ? this.linkEntities.hashCode() : 0);
            result = 31 * result + (this.linkSharingConfiguration != null ? this.linkSharingConfiguration.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            result = 31 * result + (this.sourceEntity != null ? this.sourceEntity.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.themeArn != null ? this.themeArn.hashCode() : 0);
            result = 31 * result + (this.validationStrategy != null ? this.validationStrategy.hashCode() : 0);
            result = 31 * result + (this.versionDescription != null ? this.versionDescription.hashCode() : 0);
            return result;
        }
    }
}
