package software.amazon.awscdk.services.quicksight;

/**
 * Creates a refresh schedule for a dataset in QuickSight .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnRefreshSchedule cfnRefreshSchedule = CfnRefreshSchedule.Builder.create(this, "MyCfnRefreshSchedule")
 *         .awsAccountId("awsAccountId")
 *         .dataSetId("dataSetId")
 *         .schedule(RefreshScheduleMapProperty.builder()
 *                 .refreshType("refreshType")
 *                 .scheduleFrequency(ScheduleFrequencyProperty.builder()
 *                         .interval("interval")
 *                         .refreshOnDay(RefreshOnDayProperty.builder()
 *                                 .dayOfMonth("dayOfMonth")
 *                                 .dayOfWeek("dayOfWeek")
 *                                 .build())
 *                         .timeOfTheDay("timeOfTheDay")
 *                         .timeZone("timeZone")
 *                         .build())
 *                 .scheduleId("scheduleId")
 *                 .startAfterDateTime("startAfterDateTime")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:20.774Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnRefreshSchedule")
public class CfnRefreshSchedule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRefreshSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRefreshSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnRefreshSchedule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRefreshSchedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnRefreshScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRefreshSchedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) for the refresh schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The AWS account ID of the account that you are creating a schedule in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID of the account that you are creating a schedule in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", value);
    }

    /**
     * The ID of the dataset that you are creating a refresh schedule for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataSetId() {
        return software.amazon.jsii.Kernel.get(this, "dataSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the dataset that you are creating a refresh schedule for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataSetId", value);
    }

    /**
     * The refresh schedule of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The refresh schedule of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The refresh schedule of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnRefreshSchedule.RefreshScheduleMapProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }
    /**
     * The day that you want yout dataset to refresh.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RefreshOnDayProperty refreshOnDayProperty = RefreshOnDayProperty.builder()
     *         .dayOfMonth("dayOfMonth")
     *         .dayOfWeek("dayOfWeek")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshonday.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshonday.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnRefreshSchedule.RefreshOnDayProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshOnDayProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshOnDayProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The day of the month that you want your dataset to refresh.
         * <p>
         * This value is required for monthly refresh intervals.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshonday.html#cfn-quicksight-refreshschedule-refreshonday-dayofmonth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshonday.html#cfn-quicksight-refreshschedule-refreshonday-dayofmonth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDayOfMonth() {
            return null;
        }

        /**
         * The day of the week that you want to schedule the refresh on.
         * <p>
         * This value is required for weekly and monthly refresh intervals.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshonday.html#cfn-quicksight-refreshschedule-refreshonday-dayofweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshonday.html#cfn-quicksight-refreshschedule-refreshonday-dayofweek</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDayOfWeek() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RefreshOnDayProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshOnDayProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshOnDayProperty> {
            java.lang.String dayOfMonth;
            java.lang.String dayOfWeek;

            /**
             * Sets the value of {@link RefreshOnDayProperty#getDayOfMonth}
             * @param dayOfMonth The day of the month that you want your dataset to refresh.
             *                   This value is required for monthly refresh intervals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dayOfMonth(java.lang.String dayOfMonth) {
                this.dayOfMonth = dayOfMonth;
                return this;
            }

            /**
             * Sets the value of {@link RefreshOnDayProperty#getDayOfWeek}
             * @param dayOfWeek The day of the week that you want to schedule the refresh on.
             *                  This value is required for weekly and monthly refresh intervals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dayOfWeek(java.lang.String dayOfWeek) {
                this.dayOfWeek = dayOfWeek;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshOnDayProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshOnDayProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshOnDayProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshOnDayProperty {
            private final java.lang.String dayOfMonth;
            private final java.lang.String dayOfWeek;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dayOfMonth = software.amazon.jsii.Kernel.get(this, "dayOfMonth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dayOfWeek = software.amazon.jsii.Kernel.get(this, "dayOfWeek", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dayOfMonth = builder.dayOfMonth;
                this.dayOfWeek = builder.dayOfWeek;
            }

            @Override
            public final java.lang.String getDayOfMonth() {
                return this.dayOfMonth;
            }

            @Override
            public final java.lang.String getDayOfWeek() {
                return this.dayOfWeek;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDayOfMonth() != null) {
                    data.set("dayOfMonth", om.valueToTree(this.getDayOfMonth()));
                }
                if (this.getDayOfWeek() != null) {
                    data.set("dayOfWeek", om.valueToTree(this.getDayOfWeek()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnRefreshSchedule.RefreshOnDayProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshOnDayProperty.Jsii$Proxy that = (RefreshOnDayProperty.Jsii$Proxy) o;

                if (this.dayOfMonth != null ? !this.dayOfMonth.equals(that.dayOfMonth) : that.dayOfMonth != null) return false;
                return this.dayOfWeek != null ? this.dayOfWeek.equals(that.dayOfWeek) : that.dayOfWeek == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dayOfMonth != null ? this.dayOfMonth.hashCode() : 0;
                result = 31 * result + (this.dayOfWeek != null ? this.dayOfWeek.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A summary of a configured refresh schedule for a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RefreshScheduleMapProperty refreshScheduleMapProperty = RefreshScheduleMapProperty.builder()
     *         .refreshType("refreshType")
     *         .scheduleFrequency(ScheduleFrequencyProperty.builder()
     *                 .interval("interval")
     *                 .refreshOnDay(RefreshOnDayProperty.builder()
     *                         .dayOfMonth("dayOfMonth")
     *                         .dayOfWeek("dayOfWeek")
     *                         .build())
     *                 .timeOfTheDay("timeOfTheDay")
     *                 .timeZone("timeZone")
     *                 .build())
     *         .scheduleId("scheduleId")
     *         .startAfterDateTime("startAfterDateTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnRefreshSchedule.RefreshScheduleMapProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshScheduleMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshScheduleMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of refresh that a dataset undergoes. Valid values are as follows:.
         * <p>
         * <ul>
         * <li><code>FULL_REFRESH</code> : A complete refresh of a dataset.</li>
         * <li><code>INCREMENTAL_REFRESH</code> : A partial refresh of some rows of a dataset, based on the time window specified.</li>
         * </ul>
         * <p>
         * For more information on full and incremental refreshes, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/refreshing-imported-data.html">Refreshing SPICE data</a> in the <em>QuickSight User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html#cfn-quicksight-refreshschedule-refreshschedulemap-refreshtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html#cfn-quicksight-refreshschedule-refreshschedulemap-refreshtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshType() {
            return null;
        }

        /**
         * The frequency for the refresh schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html#cfn-quicksight-refreshschedule-refreshschedulemap-schedulefrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html#cfn-quicksight-refreshschedule-refreshschedulemap-schedulefrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScheduleFrequency() {
            return null;
        }

        /**
         * An identifier for the refresh schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html#cfn-quicksight-refreshschedule-refreshschedulemap-scheduleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html#cfn-quicksight-refreshschedule-refreshschedulemap-scheduleid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScheduleId() {
            return null;
        }

        /**
         * Time after which the refresh schedule can be started, expressed in <code>YYYY-MM-DDTHH:MM:SS</code> format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html#cfn-quicksight-refreshschedule-refreshschedulemap-startafterdatetime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-refreshschedulemap.html#cfn-quicksight-refreshschedule-refreshschedulemap-startafterdatetime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartAfterDateTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RefreshScheduleMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshScheduleMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshScheduleMapProperty> {
            java.lang.String refreshType;
            java.lang.Object scheduleFrequency;
            java.lang.String scheduleId;
            java.lang.String startAfterDateTime;

            /**
             * Sets the value of {@link RefreshScheduleMapProperty#getRefreshType}
             * @param refreshType The type of refresh that a dataset undergoes. Valid values are as follows:.
             *                    <ul>
             *                    <li><code>FULL_REFRESH</code> : A complete refresh of a dataset.</li>
             *                    <li><code>INCREMENTAL_REFRESH</code> : A partial refresh of some rows of a dataset, based on the time window specified.</li>
             *                    </ul>
             *                    <p>
             *                    For more information on full and incremental refreshes, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/refreshing-imported-data.html">Refreshing SPICE data</a> in the <em>QuickSight User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshType(java.lang.String refreshType) {
                this.refreshType = refreshType;
                return this;
            }

            /**
             * Sets the value of {@link RefreshScheduleMapProperty#getScheduleFrequency}
             * @param scheduleFrequency The frequency for the refresh schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleFrequency(software.amazon.awscdk.IResolvable scheduleFrequency) {
                this.scheduleFrequency = scheduleFrequency;
                return this;
            }

            /**
             * Sets the value of {@link RefreshScheduleMapProperty#getScheduleFrequency}
             * @param scheduleFrequency The frequency for the refresh schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleFrequency(software.amazon.awscdk.services.quicksight.CfnRefreshSchedule.ScheduleFrequencyProperty scheduleFrequency) {
                this.scheduleFrequency = scheduleFrequency;
                return this;
            }

            /**
             * Sets the value of {@link RefreshScheduleMapProperty#getScheduleId}
             * @param scheduleId An identifier for the refresh schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleId(java.lang.String scheduleId) {
                this.scheduleId = scheduleId;
                return this;
            }

            /**
             * Sets the value of {@link RefreshScheduleMapProperty#getStartAfterDateTime}
             * @param startAfterDateTime Time after which the refresh schedule can be started, expressed in <code>YYYY-MM-DDTHH:MM:SS</code> format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startAfterDateTime(java.lang.String startAfterDateTime) {
                this.startAfterDateTime = startAfterDateTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshScheduleMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshScheduleMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshScheduleMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshScheduleMapProperty {
            private final java.lang.String refreshType;
            private final java.lang.Object scheduleFrequency;
            private final java.lang.String scheduleId;
            private final java.lang.String startAfterDateTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.refreshType = software.amazon.jsii.Kernel.get(this, "refreshType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduleFrequency = software.amazon.jsii.Kernel.get(this, "scheduleFrequency", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scheduleId = software.amazon.jsii.Kernel.get(this, "scheduleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startAfterDateTime = software.amazon.jsii.Kernel.get(this, "startAfterDateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.refreshType = builder.refreshType;
                this.scheduleFrequency = builder.scheduleFrequency;
                this.scheduleId = builder.scheduleId;
                this.startAfterDateTime = builder.startAfterDateTime;
            }

            @Override
            public final java.lang.String getRefreshType() {
                return this.refreshType;
            }

            @Override
            public final java.lang.Object getScheduleFrequency() {
                return this.scheduleFrequency;
            }

            @Override
            public final java.lang.String getScheduleId() {
                return this.scheduleId;
            }

            @Override
            public final java.lang.String getStartAfterDateTime() {
                return this.startAfterDateTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRefreshType() != null) {
                    data.set("refreshType", om.valueToTree(this.getRefreshType()));
                }
                if (this.getScheduleFrequency() != null) {
                    data.set("scheduleFrequency", om.valueToTree(this.getScheduleFrequency()));
                }
                if (this.getScheduleId() != null) {
                    data.set("scheduleId", om.valueToTree(this.getScheduleId()));
                }
                if (this.getStartAfterDateTime() != null) {
                    data.set("startAfterDateTime", om.valueToTree(this.getStartAfterDateTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnRefreshSchedule.RefreshScheduleMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshScheduleMapProperty.Jsii$Proxy that = (RefreshScheduleMapProperty.Jsii$Proxy) o;

                if (this.refreshType != null ? !this.refreshType.equals(that.refreshType) : that.refreshType != null) return false;
                if (this.scheduleFrequency != null ? !this.scheduleFrequency.equals(that.scheduleFrequency) : that.scheduleFrequency != null) return false;
                if (this.scheduleId != null ? !this.scheduleId.equals(that.scheduleId) : that.scheduleId != null) return false;
                return this.startAfterDateTime != null ? this.startAfterDateTime.equals(that.startAfterDateTime) : that.startAfterDateTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.refreshType != null ? this.refreshType.hashCode() : 0;
                result = 31 * result + (this.scheduleFrequency != null ? this.scheduleFrequency.hashCode() : 0);
                result = 31 * result + (this.scheduleId != null ? this.scheduleId.hashCode() : 0);
                result = 31 * result + (this.startAfterDateTime != null ? this.startAfterDateTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The frequency for the refresh schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ScheduleFrequencyProperty scheduleFrequencyProperty = ScheduleFrequencyProperty.builder()
     *         .interval("interval")
     *         .refreshOnDay(RefreshOnDayProperty.builder()
     *                 .dayOfMonth("dayOfMonth")
     *                 .dayOfWeek("dayOfWeek")
     *                 .build())
     *         .timeOfTheDay("timeOfTheDay")
     *         .timeZone("timeZone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnRefreshSchedule.ScheduleFrequencyProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleFrequencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleFrequencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The interval between scheduled refreshes. Valid values are as follows:.
         * <p>
         * <ul>
         * <li><code>MINUTE15</code> : The dataset refreshes every 15 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.</li>
         * <li><code>MINUTE30</code> : The dataset refreshes every 30 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.</li>
         * <li><code>HOURLY</code> : The dataset refreshes every hour. This interval can only be used for one schedule per dataset.</li>
         * <li><code>DAILY</code> : The dataset refreshes every day.</li>
         * <li><code>WEEKLY</code> : The dataset refreshes every week.</li>
         * <li><code>MONTHLY</code> : The dataset refreshes every month.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html#cfn-quicksight-refreshschedule-schedulefrequency-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html#cfn-quicksight-refreshschedule-schedulefrequency-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInterval() {
            return null;
        }

        /**
         * The day of the week that you want to schedule the refresh on.
         * <p>
         * This value is required for weekly and monthly refresh intervals.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html#cfn-quicksight-refreshschedule-schedulefrequency-refreshonday">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html#cfn-quicksight-refreshschedule-schedulefrequency-refreshonday</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRefreshOnDay() {
            return null;
        }

        /**
         * The time of day that you want the dataset to refresh.
         * <p>
         * This value is expressed in HH:MM format. This field is not required for schedules that refresh hourly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html#cfn-quicksight-refreshschedule-schedulefrequency-timeoftheday">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html#cfn-quicksight-refreshschedule-schedulefrequency-timeoftheday</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeOfTheDay() {
            return null;
        }

        /**
         * The timezone that you want the refresh schedule to use.
         * <p>
         * The timezone ID must match a corresponding ID found on <code>java.util.time.getAvailableIDs()</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html#cfn-quicksight-refreshschedule-schedulefrequency-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-refreshschedule-schedulefrequency.html#cfn-quicksight-refreshschedule-schedulefrequency-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleFrequencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleFrequencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleFrequencyProperty> {
            java.lang.String interval;
            java.lang.Object refreshOnDay;
            java.lang.String timeOfTheDay;
            java.lang.String timeZone;

            /**
             * Sets the value of {@link ScheduleFrequencyProperty#getInterval}
             * @param interval The interval between scheduled refreshes. Valid values are as follows:.
             *                 <ul>
             *                 <li><code>MINUTE15</code> : The dataset refreshes every 15 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.</li>
             *                 <li><code>MINUTE30</code> : The dataset refreshes every 30 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.</li>
             *                 <li><code>HOURLY</code> : The dataset refreshes every hour. This interval can only be used for one schedule per dataset.</li>
             *                 <li><code>DAILY</code> : The dataset refreshes every day.</li>
             *                 <li><code>WEEKLY</code> : The dataset refreshes every week.</li>
             *                 <li><code>MONTHLY</code> : The dataset refreshes every month.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.String interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleFrequencyProperty#getRefreshOnDay}
             * @param refreshOnDay The day of the week that you want to schedule the refresh on.
             *                     This value is required for weekly and monthly refresh intervals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshOnDay(software.amazon.awscdk.IResolvable refreshOnDay) {
                this.refreshOnDay = refreshOnDay;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleFrequencyProperty#getRefreshOnDay}
             * @param refreshOnDay The day of the week that you want to schedule the refresh on.
             *                     This value is required for weekly and monthly refresh intervals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshOnDay(software.amazon.awscdk.services.quicksight.CfnRefreshSchedule.RefreshOnDayProperty refreshOnDay) {
                this.refreshOnDay = refreshOnDay;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleFrequencyProperty#getTimeOfTheDay}
             * @param timeOfTheDay The time of day that you want the dataset to refresh.
             *                     This value is expressed in HH:MM format. This field is not required for schedules that refresh hourly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeOfTheDay(java.lang.String timeOfTheDay) {
                this.timeOfTheDay = timeOfTheDay;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleFrequencyProperty#getTimeZone}
             * @param timeZone The timezone that you want the refresh schedule to use.
             *                 The timezone ID must match a corresponding ID found on <code>java.util.time.getAvailableIDs()</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeZone(java.lang.String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleFrequencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleFrequencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleFrequencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleFrequencyProperty {
            private final java.lang.String interval;
            private final java.lang.Object refreshOnDay;
            private final java.lang.String timeOfTheDay;
            private final java.lang.String timeZone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshOnDay = software.amazon.jsii.Kernel.get(this, "refreshOnDay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeOfTheDay = software.amazon.jsii.Kernel.get(this, "timeOfTheDay", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interval = builder.interval;
                this.refreshOnDay = builder.refreshOnDay;
                this.timeOfTheDay = builder.timeOfTheDay;
                this.timeZone = builder.timeZone;
            }

            @Override
            public final java.lang.String getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.Object getRefreshOnDay() {
                return this.refreshOnDay;
            }

            @Override
            public final java.lang.String getTimeOfTheDay() {
                return this.timeOfTheDay;
            }

            @Override
            public final java.lang.String getTimeZone() {
                return this.timeZone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getRefreshOnDay() != null) {
                    data.set("refreshOnDay", om.valueToTree(this.getRefreshOnDay()));
                }
                if (this.getTimeOfTheDay() != null) {
                    data.set("timeOfTheDay", om.valueToTree(this.getTimeOfTheDay()));
                }
                if (this.getTimeZone() != null) {
                    data.set("timeZone", om.valueToTree(this.getTimeZone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnRefreshSchedule.ScheduleFrequencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleFrequencyProperty.Jsii$Proxy that = (ScheduleFrequencyProperty.Jsii$Proxy) o;

                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.refreshOnDay != null ? !this.refreshOnDay.equals(that.refreshOnDay) : that.refreshOnDay != null) return false;
                if (this.timeOfTheDay != null ? !this.timeOfTheDay.equals(that.timeOfTheDay) : that.timeOfTheDay != null) return false;
                return this.timeZone != null ? this.timeZone.equals(that.timeZone) : that.timeZone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.interval != null ? this.interval.hashCode() : 0;
                result = 31 * result + (this.refreshOnDay != null ? this.refreshOnDay.hashCode() : 0);
                result = 31 * result + (this.timeOfTheDay != null ? this.timeOfTheDay.hashCode() : 0);
                result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnRefreshSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnRefreshSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.quicksight.CfnRefreshScheduleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The AWS account ID of the account that you are creating a schedule in.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-awsaccountid</a>
         * @param awsAccountId The AWS account ID of the account that you are creating a schedule in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props().awsAccountId(awsAccountId);
            return this;
        }

        /**
         * The ID of the dataset that you are creating a refresh schedule for.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-datasetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-datasetid</a>
         * @param dataSetId The ID of the dataset that you are creating a refresh schedule for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetId(final java.lang.String dataSetId) {
            this.props().dataSetId(dataSetId);
            return this;
        }

        /**
         * The refresh schedule of a dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-schedule</a>
         * @param schedule The refresh schedule of a dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props().schedule(schedule);
            return this;
        }
        /**
         * The refresh schedule of a dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-refreshschedule.html#cfn-quicksight-refreshschedule-schedule</a>
         * @param schedule The refresh schedule of a dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.quicksight.CfnRefreshSchedule.RefreshScheduleMapProperty schedule) {
            this.props().schedule(schedule);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnRefreshSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnRefreshSchedule build() {
            return new software.amazon.awscdk.services.quicksight.CfnRefreshSchedule(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.quicksight.CfnRefreshScheduleProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.quicksight.CfnRefreshScheduleProps.Builder();
            }
            return this.props;
        }
    }
}
