package software.amazon.awscdk.services.rds;

/**
 * The type of Aurora Cluster Instance.
 * <p>
 * Can be either serverless v2
 * or provisioned
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * ClusterInstanceType clusterInstanceType = new ClusterInstanceType("instanceType", InstanceType.PROVISIONED);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:21.486Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ClusterInstanceType")
public class ClusterInstanceType extends software.amazon.jsii.JsiiObject {

    protected ClusterInstanceType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClusterInstanceType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instanceType This parameter is required.
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ClusterInstanceType(final @org.jetbrains.annotations.NotNull java.lang.String instanceType, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceType type) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceType, "instanceType is required"), java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * Aurora Provisioned instance type.
     * <p>
     * @param instanceType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterInstanceType provisioned(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType instanceType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ClusterInstanceType.class, "provisioned", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ClusterInstanceType.class), new Object[] { instanceType });
    }

    /**
     * Aurora Provisioned instance type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterInstanceType provisioned() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ClusterInstanceType.class, "provisioned", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ClusterInstanceType.class));
    }

    /**
     * Aurora Serverless V2 instance type.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterInstanceType serverlessV2() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ClusterInstanceType.class, "serverlessV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ClusterInstanceType.class));
    }

    /**
     * String representation of the instance type that can be used in the CloudFormation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.InstanceType.class));
    }
}
