package software.amazon.awscdk.services.redshiftserverless;

/**
 * Properties for defining a <code>CfnWorkgroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * CfnWorkgroupProps cfnWorkgroupProps = CfnWorkgroupProps.builder()
 *         .workgroupName("workgroupName")
 *         // the properties below are optional
 *         .baseCapacity(123)
 *         .configParameters(List.of(ConfigParameterProperty.builder()
 *                 .parameterKey("parameterKey")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .enhancedVpcRouting(false)
 *         .maxCapacity(123)
 *         .namespaceName("namespaceName")
 *         .port(123)
 *         .pricePerformanceTarget(PerformanceTargetProperty.builder()
 *                 .level(123)
 *                 .status("status")
 *                 .build())
 *         .publiclyAccessible(false)
 *         .recoveryPointId("recoveryPointId")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .snapshotArn("snapshotArn")
 *         .snapshotName("snapshotName")
 *         .snapshotOwnerAccount("snapshotOwnerAccount")
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trackName("trackName")
 *         .workgroup(WorkgroupProperty.builder()
 *                 .baseCapacity(123)
 *                 .configParameters(List.of(ConfigParameterProperty.builder()
 *                         .parameterKey("parameterKey")
 *                         .parameterValue("parameterValue")
 *                         .build()))
 *                 .creationDate("creationDate")
 *                 .endpoint(EndpointProperty.builder()
 *                         .address("address")
 *                         .port(123)
 *                         .vpcEndpoints(List.of(VpcEndpointProperty.builder()
 *                                 .networkInterfaces(List.of(NetworkInterfaceProperty.builder()
 *                                         .availabilityZone("availabilityZone")
 *                                         .networkInterfaceId("networkInterfaceId")
 *                                         .privateIpAddress("privateIpAddress")
 *                                         .subnetId("subnetId")
 *                                         .build()))
 *                                 .vpcEndpointId("vpcEndpointId")
 *                                 .vpcId("vpcId")
 *                                 .build()))
 *                         .build())
 *                 .enhancedVpcRouting(false)
 *                 .maxCapacity(123)
 *                 .namespaceName("namespaceName")
 *                 .pricePerformanceTarget(PerformanceTargetProperty.builder()
 *                         .level(123)
 *                         .status("status")
 *                         .build())
 *                 .publiclyAccessible(false)
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .status("status")
 *                 .subnetIds(List.of("subnetIds"))
 *                 .trackName("trackName")
 *                 .workgroupArn("workgroupArn")
 *                 .workgroupId("workgroupId")
 *                 .workgroupName("workgroupName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:21.691Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkgroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkgroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the workgroup.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkgroupName();

    /**
     * The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-basecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-basecapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBaseCapacity() {
        return null;
    }

    /**
     * The key of the parameter.
     * <p>
     * The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-configparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-configparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigParameters() {
        return null;
    }

    /**
     * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-enhancedvpcrouting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-enhancedvpcrouting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedVpcRouting() {
        return null;
    }

    /**
     * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries.
     * <p>
     * The max capacity is specified in RPUs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-maxcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * The namespace the workgroup is associated with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-namespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-namespacename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceName() {
        return null;
    }

    /**
     * The custom port to use when connecting to a workgroup.
     * <p>
     * Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * An object that represents the price performance target settings for the workgroup.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-priceperformancetarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-priceperformancetarget</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPricePerformanceTarget() {
        return null;
    }

    /**
     * A value that specifies whether the workgroup can be accessible from a public network.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-publiclyaccessible</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return null;
    }

    /**
     * The recovery point id to restore from.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-recoverypointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-recoverypointid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRecoveryPointId() {
        return null;
    }

    /**
     * A list of security group IDs to associate with the workgroup.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the snapshot to restore from.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotArn() {
        return null;
    }

    /**
     * The snapshot name to restore from.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotName() {
        return null;
    }

    /**
     * The Amazon Web Services account that owns the snapshot.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotowneraccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotowneraccount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotOwnerAccount() {
        return null;
    }

    /**
     * A list of subnet IDs the workgroup is associated with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return null;
    }

    /**
     * The map of the key-value pairs used to tag the workgroup.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * An optional parameter for the name of the track for the workgroup.
     * <p>
     * If you don't provide a track name, the workgroup is assigned to the current track.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-trackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-trackname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTrackName() {
        return null;
    }

    /**
     * The collection of computing resources from which an endpoint is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkgroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkgroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkgroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkgroupProps> {
        java.lang.String workgroupName;
        java.lang.Number baseCapacity;
        java.lang.Object configParameters;
        java.lang.Object enhancedVpcRouting;
        java.lang.Number maxCapacity;
        java.lang.String namespaceName;
        java.lang.Number port;
        java.lang.Object pricePerformanceTarget;
        java.lang.Object publiclyAccessible;
        java.lang.String recoveryPointId;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String snapshotArn;
        java.lang.String snapshotName;
        java.lang.String snapshotOwnerAccount;
        java.util.List<java.lang.String> subnetIds;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String trackName;
        java.lang.Object workgroup;

        /**
         * Sets the value of {@link CfnWorkgroupProps#getWorkgroupName}
         * @param workgroupName The name of the workgroup. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workgroupName(java.lang.String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getBaseCapacity}
         * @param baseCapacity The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(java.lang.Number baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getConfigParameters}
         * @param configParameters The key of the parameter.
         *                         The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configParameters(software.amazon.awscdk.IResolvable configParameters) {
            this.configParameters = configParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getConfigParameters}
         * @param configParameters The key of the parameter.
         *                         The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configParameters(java.util.List<? extends java.lang.Object> configParameters) {
            this.configParameters = configParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getEnhancedVpcRouting}
         * @param enhancedVpcRouting The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(java.lang.Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getEnhancedVpcRouting}
         * @param enhancedVpcRouting The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(software.amazon.awscdk.IResolvable enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getMaxCapacity}
         * @param maxCapacity The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries.
         *                    The max capacity is specified in RPUs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getNamespaceName}
         * @param namespaceName The namespace the workgroup is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceName(java.lang.String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getPort}
         * @param port The custom port to use when connecting to a workgroup.
         *             Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getPricePerformanceTarget}
         * @param pricePerformanceTarget An object that represents the price performance target settings for the workgroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricePerformanceTarget(software.amazon.awscdk.IResolvable pricePerformanceTarget) {
            this.pricePerformanceTarget = pricePerformanceTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getPricePerformanceTarget}
         * @param pricePerformanceTarget An object that represents the price performance target settings for the workgroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricePerformanceTarget(software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.PerformanceTargetProperty pricePerformanceTarget) {
            this.pricePerformanceTarget = pricePerformanceTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getPubliclyAccessible}
         * @param publiclyAccessible A value that specifies whether the workgroup can be accessible from a public network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getPubliclyAccessible}
         * @param publiclyAccessible A value that specifies whether the workgroup can be accessible from a public network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getRecoveryPointId}
         * @param recoveryPointId The recovery point id to restore from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPointId(java.lang.String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getSecurityGroupIds}
         * @param securityGroupIds A list of security group IDs to associate with the workgroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getSnapshotArn}
         * @param snapshotArn The Amazon Resource Name (ARN) of the snapshot to restore from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotArn(java.lang.String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getSnapshotName}
         * @param snapshotName The snapshot name to restore from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotName(java.lang.String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getSnapshotOwnerAccount}
         * @param snapshotOwnerAccount The Amazon Web Services account that owns the snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOwnerAccount(java.lang.String snapshotOwnerAccount) {
            this.snapshotOwnerAccount = snapshotOwnerAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getSubnetIds}
         * @param subnetIds A list of subnet IDs the workgroup is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getTags}
         * @param tags The map of the key-value pairs used to tag the workgroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getTrackName}
         * @param trackName An optional parameter for the name of the track for the workgroup.
         *                  If you don't provide a track name, the workgroup is assigned to the current track.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackName(java.lang.String trackName) {
            this.trackName = trackName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getWorkgroup}
         * @param workgroup The collection of computing resources from which an endpoint is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workgroup(software.amazon.awscdk.IResolvable workgroup) {
            this.workgroup = workgroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkgroupProps#getWorkgroup}
         * @param workgroup The collection of computing resources from which an endpoint is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workgroup(software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.WorkgroupProperty workgroup) {
            this.workgroup = workgroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkgroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkgroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkgroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkgroupProps {
        private final java.lang.String workgroupName;
        private final java.lang.Number baseCapacity;
        private final java.lang.Object configParameters;
        private final java.lang.Object enhancedVpcRouting;
        private final java.lang.Number maxCapacity;
        private final java.lang.String namespaceName;
        private final java.lang.Number port;
        private final java.lang.Object pricePerformanceTarget;
        private final java.lang.Object publiclyAccessible;
        private final java.lang.String recoveryPointId;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String snapshotArn;
        private final java.lang.String snapshotName;
        private final java.lang.String snapshotOwnerAccount;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String trackName;
        private final java.lang.Object workgroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.workgroupName = software.amazon.jsii.Kernel.get(this, "workgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.baseCapacity = software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.configParameters = software.amazon.jsii.Kernel.get(this, "configParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enhancedVpcRouting = software.amazon.jsii.Kernel.get(this, "enhancedVpcRouting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.namespaceName = software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.pricePerformanceTarget = software.amazon.jsii.Kernel.get(this, "pricePerformanceTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.recoveryPointId = software.amazon.jsii.Kernel.get(this, "recoveryPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.snapshotArn = software.amazon.jsii.Kernel.get(this, "snapshotArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotName = software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotOwnerAccount = software.amazon.jsii.Kernel.get(this, "snapshotOwnerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.trackName = software.amazon.jsii.Kernel.get(this, "trackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workgroup = software.amazon.jsii.Kernel.get(this, "workgroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.workgroupName = java.util.Objects.requireNonNull(builder.workgroupName, "workgroupName is required");
            this.baseCapacity = builder.baseCapacity;
            this.configParameters = builder.configParameters;
            this.enhancedVpcRouting = builder.enhancedVpcRouting;
            this.maxCapacity = builder.maxCapacity;
            this.namespaceName = builder.namespaceName;
            this.port = builder.port;
            this.pricePerformanceTarget = builder.pricePerformanceTarget;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.recoveryPointId = builder.recoveryPointId;
            this.securityGroupIds = builder.securityGroupIds;
            this.snapshotArn = builder.snapshotArn;
            this.snapshotName = builder.snapshotName;
            this.snapshotOwnerAccount = builder.snapshotOwnerAccount;
            this.subnetIds = builder.subnetIds;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.trackName = builder.trackName;
            this.workgroup = builder.workgroup;
        }

        @Override
        public final java.lang.String getWorkgroupName() {
            return this.workgroupName;
        }

        @Override
        public final java.lang.Number getBaseCapacity() {
            return this.baseCapacity;
        }

        @Override
        public final java.lang.Object getConfigParameters() {
            return this.configParameters;
        }

        @Override
        public final java.lang.Object getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.String getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.Object getPricePerformanceTarget() {
            return this.pricePerformanceTarget;
        }

        @Override
        public final java.lang.Object getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.lang.String getRecoveryPointId() {
            return this.recoveryPointId;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getSnapshotArn() {
            return this.snapshotArn;
        }

        @Override
        public final java.lang.String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final java.lang.String getSnapshotOwnerAccount() {
            return this.snapshotOwnerAccount;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTrackName() {
            return this.trackName;
        }

        @Override
        public final java.lang.Object getWorkgroup() {
            return this.workgroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("workgroupName", om.valueToTree(this.getWorkgroupName()));
            if (this.getBaseCapacity() != null) {
                data.set("baseCapacity", om.valueToTree(this.getBaseCapacity()));
            }
            if (this.getConfigParameters() != null) {
                data.set("configParameters", om.valueToTree(this.getConfigParameters()));
            }
            if (this.getEnhancedVpcRouting() != null) {
                data.set("enhancedVpcRouting", om.valueToTree(this.getEnhancedVpcRouting()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getNamespaceName() != null) {
                data.set("namespaceName", om.valueToTree(this.getNamespaceName()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPricePerformanceTarget() != null) {
                data.set("pricePerformanceTarget", om.valueToTree(this.getPricePerformanceTarget()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getRecoveryPointId() != null) {
                data.set("recoveryPointId", om.valueToTree(this.getRecoveryPointId()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSnapshotArn() != null) {
                data.set("snapshotArn", om.valueToTree(this.getSnapshotArn()));
            }
            if (this.getSnapshotName() != null) {
                data.set("snapshotName", om.valueToTree(this.getSnapshotName()));
            }
            if (this.getSnapshotOwnerAccount() != null) {
                data.set("snapshotOwnerAccount", om.valueToTree(this.getSnapshotOwnerAccount()));
            }
            if (this.getSubnetIds() != null) {
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTrackName() != null) {
                data.set("trackName", om.valueToTree(this.getTrackName()));
            }
            if (this.getWorkgroup() != null) {
                data.set("workgroup", om.valueToTree(this.getWorkgroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnWorkgroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkgroupProps.Jsii$Proxy that = (CfnWorkgroupProps.Jsii$Proxy) o;

            if (!workgroupName.equals(that.workgroupName)) return false;
            if (this.baseCapacity != null ? !this.baseCapacity.equals(that.baseCapacity) : that.baseCapacity != null) return false;
            if (this.configParameters != null ? !this.configParameters.equals(that.configParameters) : that.configParameters != null) return false;
            if (this.enhancedVpcRouting != null ? !this.enhancedVpcRouting.equals(that.enhancedVpcRouting) : that.enhancedVpcRouting != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.namespaceName != null ? !this.namespaceName.equals(that.namespaceName) : that.namespaceName != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.pricePerformanceTarget != null ? !this.pricePerformanceTarget.equals(that.pricePerformanceTarget) : that.pricePerformanceTarget != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.recoveryPointId != null ? !this.recoveryPointId.equals(that.recoveryPointId) : that.recoveryPointId != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.snapshotArn != null ? !this.snapshotArn.equals(that.snapshotArn) : that.snapshotArn != null) return false;
            if (this.snapshotName != null ? !this.snapshotName.equals(that.snapshotName) : that.snapshotName != null) return false;
            if (this.snapshotOwnerAccount != null ? !this.snapshotOwnerAccount.equals(that.snapshotOwnerAccount) : that.snapshotOwnerAccount != null) return false;
            if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.trackName != null ? !this.trackName.equals(that.trackName) : that.trackName != null) return false;
            return this.workgroup != null ? this.workgroup.equals(that.workgroup) : that.workgroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.workgroupName.hashCode();
            result = 31 * result + (this.baseCapacity != null ? this.baseCapacity.hashCode() : 0);
            result = 31 * result + (this.configParameters != null ? this.configParameters.hashCode() : 0);
            result = 31 * result + (this.enhancedVpcRouting != null ? this.enhancedVpcRouting.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.namespaceName != null ? this.namespaceName.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.pricePerformanceTarget != null ? this.pricePerformanceTarget.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.recoveryPointId != null ? this.recoveryPointId.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.snapshotArn != null ? this.snapshotArn.hashCode() : 0);
            result = 31 * result + (this.snapshotName != null ? this.snapshotName.hashCode() : 0);
            result = 31 * result + (this.snapshotOwnerAccount != null ? this.snapshotOwnerAccount.hashCode() : 0);
            result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trackName != null ? this.trackName.hashCode() : 0);
            result = 31 * result + (this.workgroup != null ? this.workgroup.hashCode() : 0);
            return result;
        }
    }
}
