package software.amazon.awscdk.services.route53;

/**
 * Common properties to create a Route 53 hosted zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CommonHostedZoneProps commonHostedZoneProps = CommonHostedZoneProps.builder()
 *         .zoneName("zoneName")
 *         // the properties below are optional
 *         .addTrailingDot(false)
 *         .comment("comment")
 *         .queryLogsLogGroupArn("queryLogsLogGroupArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:21.875Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CommonHostedZoneProps")
@software.amazon.jsii.Jsii.Proxy(CommonHostedZoneProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonHostedZoneProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the domain.
     * <p>
     * For resource record types that include a domain
     * name, specify a fully qualified domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getZoneName();

    /**
     * Whether to add a trailing dot to the zone name.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAddTrailingDot() {
        return null;
    }

    /**
     * Any comments that you want to include about the hosted zone.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
     * <p>
     * Default: disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueryLogsLogGroupArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonHostedZoneProps> {
        java.lang.String zoneName;
        java.lang.Boolean addTrailingDot;
        java.lang.String comment;
        java.lang.String queryLogsLogGroupArn;

        /**
         * Sets the value of {@link CommonHostedZoneProps#getZoneName}
         * @param zoneName The name of the domain. This parameter is required.
         *                 For resource record types that include a domain
         *                 name, specify a fully qualified domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(java.lang.String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        /**
         * Sets the value of {@link CommonHostedZoneProps#getAddTrailingDot}
         * @param addTrailingDot Whether to add a trailing dot to the zone name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addTrailingDot(java.lang.Boolean addTrailingDot) {
            this.addTrailingDot = addTrailingDot;
            return this;
        }

        /**
         * Sets the value of {@link CommonHostedZoneProps#getComment}
         * @param comment Any comments that you want to include about the hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link CommonHostedZoneProps#getQueryLogsLogGroupArn}
         * @param queryLogsLogGroupArn The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogsLogGroupArn(java.lang.String queryLogsLogGroupArn) {
            this.queryLogsLogGroupArn = queryLogsLogGroupArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonHostedZoneProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonHostedZoneProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonHostedZoneProps {
        private final java.lang.String zoneName;
        private final java.lang.Boolean addTrailingDot;
        private final java.lang.String comment;
        private final java.lang.String queryLogsLogGroupArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.zoneName = software.amazon.jsii.Kernel.get(this, "zoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addTrailingDot = software.amazon.jsii.Kernel.get(this, "addTrailingDot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLogsLogGroupArn = software.amazon.jsii.Kernel.get(this, "queryLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.zoneName = java.util.Objects.requireNonNull(builder.zoneName, "zoneName is required");
            this.addTrailingDot = builder.addTrailingDot;
            this.comment = builder.comment;
            this.queryLogsLogGroupArn = builder.queryLogsLogGroupArn;
        }

        @Override
        public final java.lang.String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final java.lang.Boolean getAddTrailingDot() {
            return this.addTrailingDot;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getQueryLogsLogGroupArn() {
            return this.queryLogsLogGroupArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("zoneName", om.valueToTree(this.getZoneName()));
            if (this.getAddTrailingDot() != null) {
                data.set("addTrailingDot", om.valueToTree(this.getAddTrailingDot()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLogsLogGroupArn() != null) {
                data.set("queryLogsLogGroupArn", om.valueToTree(this.getQueryLogsLogGroupArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CommonHostedZoneProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonHostedZoneProps.Jsii$Proxy that = (CommonHostedZoneProps.Jsii$Proxy) o;

            if (!zoneName.equals(that.zoneName)) return false;
            if (this.addTrailingDot != null ? !this.addTrailingDot.equals(that.addTrailingDot) : that.addTrailingDot != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            return this.queryLogsLogGroupArn != null ? this.queryLogsLogGroupArn.equals(that.queryLogsLogGroupArn) : that.queryLogsLogGroupArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.zoneName.hashCode();
            result = 31 * result + (this.addTrailingDot != null ? this.addTrailingDot.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLogsLogGroupArn != null ? this.queryLogsLogGroupArn.hashCode() : 0);
            return result;
        }
    }
}
