package software.amazon.awscdk.services.route53.targets;

/**
 * Defines an AppSync Graphql API as the alias target.
 * <p>
 * Requires that the domain
 * name will be defined through <code>GraphqlApiProps.domainName</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.appsync.*;
 * HostedZone zone;
 * GraphqlApi graphqlApi;
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new AppSyncTarget(graphqlApi)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:21.933Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53_targets.AppSyncTarget")
public class AppSyncTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.route53.IAliasRecordTarget {

    protected AppSyncTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppSyncTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param graphqlApi This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AppSyncTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlApi graphqlApi) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(graphqlApi, "graphqlApi is required") });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param _record This parameter is required.
     * @param _zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet _record, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone _zone) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_record, "_record is required"), _zone });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param _record This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet _record) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_record, "_record is required") });
    }
}
