package software.amazon.awscdk.services.s3;

/**
 * Specifies which Amazon S3 objects to replicate and where to store the replicas.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * Key key;
 * ReplicationTimeValue replicationTimeValue;
 * StorageClass storageClass;
 * ReplicationRule replicationRule = ReplicationRule.builder()
 *         .destination(bucket)
 *         // the properties below are optional
 *         .accessControlTransition(false)
 *         .deleteMarkerReplication(false)
 *         .filter(Filter.builder()
 *                 .prefix("prefix")
 *                 .tags(List.of(Tag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .id("id")
 *         .kmsKey(key)
 *         .metrics(replicationTimeValue)
 *         .priority(123)
 *         .replicaModifications(false)
 *         .replicationTimeControl(replicationTimeValue)
 *         .sseKmsEncryptedObjects(false)
 *         .storageClass(storageClass)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:22.156Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.ReplicationRule")
@software.amazon.jsii.Jsii.Proxy(ReplicationRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReplicationRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination bucket for the replicated objects.
     * <p>
     * The destination can be either in the same AWS account or a cross account.
     * <p>
     * If you want to configure cross-account replication,
     * the destination bucket must have a policy that allows the source bucket to replicate objects to it.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-walkthrough-2.html">https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-walkthrough-2.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getDestination();

    /**
     * Whether to want to change replica ownership to the AWS account that owns the destination bucket.
     * <p>
     * This can only be specified if the source bucket and the destination bucket are not in the same AWS account.
     * <p>
     * Default: - The replicas are owned by same AWS account that owns the source object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAccessControlTransition() {
        return null;
    }

    /**
     * Specifies whether Amazon S3 replicates delete markers.
     * <p>
     * Default: - delete markers in source bucket is not replicated to destination bucket
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/delete-marker-replication.html">https://docs.aws.amazon.com/AmazonS3/latest/userguide/delete-marker-replication.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeleteMarkerReplication() {
        return null;
    }

    /**
     * A filter that identifies the subset of objects to which the replication rule applies.
     * <p>
     * Default: - applies to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Filter getFilter() {
        return null;
    }

    /**
     * A unique identifier for the rule.
     * <p>
     * The maximum value is 255 characters.
     * <p>
     * Default: - auto generated random ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * The customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket.
     * <p>
     * Amazon S3 uses this key to encrypt replica objects.
     * <p>
     * Amazon S3 only supports symmetric encryption KMS keys.
     * <p>
     * Default: - Amazon S3 uses the AWS managed KMS key for encryption
     * <p>
     * @see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * A container specifying replication metrics-related settings enabling replication metrics and events.
     * <p>
     * When a value is set, metrics will be output to indicate whether the replication took longer than the specified time.
     * <p>
     * Default: - Replication metrics are not enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.ReplicationTimeValue getMetrics() {
        return null;
    }

    /**
     * The priority indicates which rule has precedence whenever two or more replication rules conflict.
     * <p>
     * Amazon S3 will attempt to replicate objects according to all replication rules.
     * However, if there are two or more rules with the same destination bucket,
     * then objects will be replicated according to the rule with the highest priority.
     * <p>
     * The higher the number, the higher the priority.
     * <p>
     * It is essential to specify priority explicitly when the replication configuration has multiple rules.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * Specifies whether Amazon S3 replicates modifications on replicas.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReplicaModifications() {
        return null;
    }

    /**
     * Specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated.
     * <p>
     * Default: - S3 Replication Time Control is not enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.ReplicationTimeValue getReplicationTimeControl() {
        return null;
    }

    /**
     * Specifies whether Amazon S3 replicates objects created with server-side encryption using an AWS KMS key stored in AWS Key Management Service.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSseKmsEncryptedObjects() {
        return null;
    }

    /**
     * The storage class to use when replicating objects, such as S3 Standard or reduced redundancy.
     * <p>
     * Default: - The storage class of the source object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ReplicationRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReplicationRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReplicationRule> {
        software.amazon.awscdk.services.s3.IBucket destination;
        java.lang.Boolean accessControlTransition;
        java.lang.Boolean deleteMarkerReplication;
        software.amazon.awscdk.services.s3.Filter filter;
        java.lang.String id;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.services.s3.ReplicationTimeValue metrics;
        java.lang.Number priority;
        java.lang.Boolean replicaModifications;
        software.amazon.awscdk.services.s3.ReplicationTimeValue replicationTimeControl;
        java.lang.Boolean sseKmsEncryptedObjects;
        software.amazon.awscdk.services.s3.StorageClass storageClass;

        /**
         * Sets the value of {@link ReplicationRule#getDestination}
         * @param destination The destination bucket for the replicated objects. This parameter is required.
         *                    The destination can be either in the same AWS account or a cross account.
         *                    <p>
         *                    If you want to configure cross-account replication,
         *                    the destination bucket must have a policy that allows the source bucket to replicate objects to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.s3.IBucket destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getAccessControlTransition}
         * @param accessControlTransition Whether to want to change replica ownership to the AWS account that owns the destination bucket.
         *                                This can only be specified if the source bucket and the destination bucket are not in the same AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlTransition(java.lang.Boolean accessControlTransition) {
            this.accessControlTransition = accessControlTransition;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getDeleteMarkerReplication}
         * @param deleteMarkerReplication Specifies whether Amazon S3 replicates delete markers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteMarkerReplication(java.lang.Boolean deleteMarkerReplication) {
            this.deleteMarkerReplication = deleteMarkerReplication;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getFilter}
         * @param filter A filter that identifies the subset of objects to which the replication rule applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filter(software.amazon.awscdk.services.s3.Filter filter) {
            this.filter = filter;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getId}
         * @param id A unique identifier for the rule.
         *           The maximum value is 255 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getKmsKey}
         * @param kmsKey The customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket.
         *               Amazon S3 uses this key to encrypt replica objects.
         *               <p>
         *               Amazon S3 only supports symmetric encryption KMS keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getMetrics}
         * @param metrics A container specifying replication metrics-related settings enabling replication metrics and events.
         *                When a value is set, metrics will be output to indicate whether the replication took longer than the specified time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(software.amazon.awscdk.services.s3.ReplicationTimeValue metrics) {
            this.metrics = metrics;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getPriority}
         * @param priority The priority indicates which rule has precedence whenever two or more replication rules conflict.
         *                 Amazon S3 will attempt to replicate objects according to all replication rules.
         *                 However, if there are two or more rules with the same destination bucket,
         *                 then objects will be replicated according to the rule with the highest priority.
         *                 <p>
         *                 The higher the number, the higher the priority.
         *                 <p>
         *                 It is essential to specify priority explicitly when the replication configuration has multiple rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getReplicaModifications}
         * @param replicaModifications Specifies whether Amazon S3 replicates modifications on replicas.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaModifications(java.lang.Boolean replicaModifications) {
            this.replicaModifications = replicaModifications;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getReplicationTimeControl}
         * @param replicationTimeControl Specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationTimeControl(software.amazon.awscdk.services.s3.ReplicationTimeValue replicationTimeControl) {
            this.replicationTimeControl = replicationTimeControl;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getSseKmsEncryptedObjects}
         * @param sseKmsEncryptedObjects Specifies whether Amazon S3 replicates objects created with server-side encryption using an AWS KMS key stored in AWS Key Management Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseKmsEncryptedObjects(java.lang.Boolean sseKmsEncryptedObjects) {
            this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
            return this;
        }

        /**
         * Sets the value of {@link ReplicationRule#getStorageClass}
         * @param storageClass The storage class to use when replicating objects, such as S3 Standard or reduced redundancy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClass(software.amazon.awscdk.services.s3.StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReplicationRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReplicationRule build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReplicationRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationRule {
        private final software.amazon.awscdk.services.s3.IBucket destination;
        private final java.lang.Boolean accessControlTransition;
        private final java.lang.Boolean deleteMarkerReplication;
        private final software.amazon.awscdk.services.s3.Filter filter;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.services.s3.ReplicationTimeValue metrics;
        private final java.lang.Number priority;
        private final java.lang.Boolean replicaModifications;
        private final software.amazon.awscdk.services.s3.ReplicationTimeValue replicationTimeControl;
        private final java.lang.Boolean sseKmsEncryptedObjects;
        private final software.amazon.awscdk.services.s3.StorageClass storageClass;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.accessControlTransition = software.amazon.jsii.Kernel.get(this, "accessControlTransition", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deleteMarkerReplication = software.amazon.jsii.Kernel.get(this, "deleteMarkerReplication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Filter.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ReplicationTimeValue.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.replicaModifications = software.amazon.jsii.Kernel.get(this, "replicaModifications", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.replicationTimeControl = software.amazon.jsii.Kernel.get(this, "replicationTimeControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ReplicationTimeValue.class));
            this.sseKmsEncryptedObjects = software.amazon.jsii.Kernel.get(this, "sseKmsEncryptedObjects", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.StorageClass.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
            this.accessControlTransition = builder.accessControlTransition;
            this.deleteMarkerReplication = builder.deleteMarkerReplication;
            this.filter = builder.filter;
            this.id = builder.id;
            this.kmsKey = builder.kmsKey;
            this.metrics = builder.metrics;
            this.priority = builder.priority;
            this.replicaModifications = builder.replicaModifications;
            this.replicationTimeControl = builder.replicationTimeControl;
            this.sseKmsEncryptedObjects = builder.sseKmsEncryptedObjects;
            this.storageClass = builder.storageClass;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.Boolean getAccessControlTransition() {
            return this.accessControlTransition;
        }

        @Override
        public final java.lang.Boolean getDeleteMarkerReplication() {
            return this.deleteMarkerReplication;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Filter getFilter() {
            return this.filter;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.s3.ReplicationTimeValue getMetrics() {
            return this.metrics;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.Boolean getReplicaModifications() {
            return this.replicaModifications;
        }

        @Override
        public final software.amazon.awscdk.services.s3.ReplicationTimeValue getReplicationTimeControl() {
            return this.replicationTimeControl;
        }

        @Override
        public final java.lang.Boolean getSseKmsEncryptedObjects() {
            return this.sseKmsEncryptedObjects;
        }

        @Override
        public final software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.storageClass;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            if (this.getAccessControlTransition() != null) {
                data.set("accessControlTransition", om.valueToTree(this.getAccessControlTransition()));
            }
            if (this.getDeleteMarkerReplication() != null) {
                data.set("deleteMarkerReplication", om.valueToTree(this.getDeleteMarkerReplication()));
            }
            if (this.getFilter() != null) {
                data.set("filter", om.valueToTree(this.getFilter()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getMetrics() != null) {
                data.set("metrics", om.valueToTree(this.getMetrics()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getReplicaModifications() != null) {
                data.set("replicaModifications", om.valueToTree(this.getReplicaModifications()));
            }
            if (this.getReplicationTimeControl() != null) {
                data.set("replicationTimeControl", om.valueToTree(this.getReplicationTimeControl()));
            }
            if (this.getSseKmsEncryptedObjects() != null) {
                data.set("sseKmsEncryptedObjects", om.valueToTree(this.getSseKmsEncryptedObjects()));
            }
            if (this.getStorageClass() != null) {
                data.set("storageClass", om.valueToTree(this.getStorageClass()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.ReplicationRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReplicationRule.Jsii$Proxy that = (ReplicationRule.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            if (this.accessControlTransition != null ? !this.accessControlTransition.equals(that.accessControlTransition) : that.accessControlTransition != null) return false;
            if (this.deleteMarkerReplication != null ? !this.deleteMarkerReplication.equals(that.deleteMarkerReplication) : that.deleteMarkerReplication != null) return false;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            if (this.replicaModifications != null ? !this.replicaModifications.equals(that.replicaModifications) : that.replicaModifications != null) return false;
            if (this.replicationTimeControl != null ? !this.replicationTimeControl.equals(that.replicationTimeControl) : that.replicationTimeControl != null) return false;
            if (this.sseKmsEncryptedObjects != null ? !this.sseKmsEncryptedObjects.equals(that.sseKmsEncryptedObjects) : that.sseKmsEncryptedObjects != null) return false;
            return this.storageClass != null ? this.storageClass.equals(that.storageClass) : that.storageClass == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.accessControlTransition != null ? this.accessControlTransition.hashCode() : 0);
            result = 31 * result + (this.deleteMarkerReplication != null ? this.deleteMarkerReplication.hashCode() : 0);
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.replicaModifications != null ? this.replicaModifications.hashCode() : 0);
            result = 31 * result + (this.replicationTimeControl != null ? this.replicationTimeControl.hashCode() : 0);
            result = 31 * result + (this.sseKmsEncryptedObjects != null ? this.sseKmsEncryptedObjects.hashCode() : 0);
            result = 31 * result + (this.storageClass != null ? this.storageClass.hashCode() : 0);
            return result;
        }
    }
}
