package software.amazon.awscdk.services.s3.assets;

/**
 * An asset represents a local file or directory, which is automatically uploaded to S3 and then can be referenced within a CDK application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Asset asset = Asset.Builder.create(this, "BundledAsset")
 *         .path("/path/to/asset")
 *         .bundling(BundlingOptions.builder()
 *                 .image(DockerImage.fromRegistry("alpine"))
 *                 .command(List.of("command-that-produces-an-archive.sh"))
 *                 .outputType(BundlingOutput.NOT_ARCHIVED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:22.175Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_assets.Asset")
public class Asset extends software.constructs.Construct implements software.amazon.awscdk.IAsset {

    protected Asset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Asset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Asset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.assets.AssetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds CloudFormation template metadata to the specified resource with information that indicates which resource property is mapped to this local asset.
     * <p>
     * This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     * <p>
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     * <p>
     * @see <a href="https://github.com/aws/aws-cdk/issues/1432">https://github.com/aws/aws-cdk/issues/1432</a>
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface]. This parameter is required.
     * @param resourceProperty The property name where this asset is referenced (e.g. "Code" for AWS::Lambda::Function). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addResourceMetadata(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource resource, final @org.jetbrains.annotations.NotNull java.lang.String resourceProperty) {
        software.amazon.jsii.Kernel.call(this, "addResourceMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required"), java.util.Objects.requireNonNull(resourceProperty, "resourceProperty is required") });
    }

    /**
     * Grants read permissions to the principal on the assets bucket.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * A hash of this asset, which is available at construction time.
     * <p>
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetHash() {
        return software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path to the asset, relative to the current Cloud Assembly.
     * <p>
     * If asset staging is disabled, this will just be the original path.
     * If asset staging is enabled it will be the staged path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetPath() {
        return software.amazon.jsii.Kernel.get(this, "assetPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The S3 bucket in which this asset resides.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * Attribute which represents the S3 HTTP URL of this asset.
     * <p>
     * For example, <code>https://s3.us-west-1.amazonaws.com/bucket/key</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHttpUrl() {
        return software.amazon.jsii.Kernel.get(this, "httpUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates if this asset is a single file.
     * <p>
     * Allows constructs to ensure that the
     * correct file type was used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsFile() {
        return software.amazon.jsii.Kernel.get(this, "isFile", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if this asset is a zip archive.
     * <p>
     * Allows constructs to ensure that the
     * correct file type was used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsZipArchive() {
        return software.amazon.jsii.Kernel.get(this, "isZipArchive", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Attribute that represents the name of the bucket this asset exists in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName() {
        return software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Attribute which represents the S3 object key of this asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectKey() {
        return software.amazon.jsii.Kernel.get(this, "s3ObjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Attribute which represents the S3 URL of this asset.
     * <p>
     * For example, <code>s3://bucket/key</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectUrl() {
        return software.amazon.jsii.Kernel.get(this, "s3ObjectUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.assets.Asset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.assets.Asset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.assets.AssetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.assets.AssetProps.Builder();
        }

        /**
         * Specify a custom hash for this asset.
         * <p>
         * If <code>assetHashType</code> is set it must
         * be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         * hash.
         * <p>
         * NOTE: the hash is used in order to identify a specific revision of the asset, and
         * used for optimizing and caching deployment activities related to this asset such as
         * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         * need to make sure it is updated every time the asset changes, or otherwise it is
         * possible that some deployments will not be invalidated.
         * <p>
         * Default: - based on `assetHashType`
         * <p>
         * @return {@code this}
         * @param assetHash Specify a custom hash for this asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHash(final java.lang.String assetHash) {
            this.props.assetHash(assetHash);
            return this;
        }

        /**
         * Specifies the type of hash to calculate for this asset.
         * <p>
         * If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         * <code>AssetHashType.CUSTOM</code>.
         * <p>
         * Default: - the default is `AssetHashType.SOURCE`, but if `assetHash` is
         * explicitly specified this value defaults to `AssetHashType.CUSTOM`.
         * <p>
         * @return {@code this}
         * @param assetHashType Specifies the type of hash to calculate for this asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHashType(final software.amazon.awscdk.AssetHashType assetHashType) {
            this.props.assetHashType(assetHashType);
            return this;
        }

        /**
         * Bundle the asset by executing a command in a Docker container or a custom bundling provider.
         * <p>
         * The asset path will be mounted at <code>/asset-input</code>. The Docker
         * container is responsible for putting content at <code>/asset-output</code>.
         * The content at <code>/asset-output</code> will be zipped and used as the
         * final asset.
         * <p>
         * Default: - uploaded as-is to S3 if the asset is a regular file or a .zip file,
         * archived into a .zip file and uploaded to S3 otherwise
         * <p>
         * @return {@code this}
         * @param bundling Bundle the asset by executing a command in a Docker container or a custom bundling provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundling(final software.amazon.awscdk.BundlingOptions bundling) {
            this.props.bundling(bundling);
            return this;
        }

        /**
         * File paths matching the patterns will be excluded.
         * <p>
         * See <code>ignoreMode</code> to set the matching behavior.
         * Has no effect on Assets bundled using the <code>bundling</code> property.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude File paths matching the patterns will be excluded. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(final software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.props.followSymlinks(followSymlinks);
            return this;
        }

        /**
         * The ignore behavior to use for <code>exclude</code> patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for <code>exclude</code> patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(final software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.props.ignoreMode(ignoreMode);
            return this;
        }

        /**
         * Whether or not the asset needs to exist beyond deployment time;
         * <p>
         * i.e.
         * are copied over to a different location and not needed afterwards.
         * Setting this property to true has an impact on the lifecycle of the asset,
         * because we will assume that it is safe to delete after the CloudFormation
         * deployment succeeds.
         * <p>
         * For example, Lambda Function assets are copied over to Lambda during
         * deployment. Therefore, it is not necessary to store the asset in S3, so
         * we consider those deployTime assets.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deployTime Whether or not the asset needs to exist beyond deployment time;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployTime(final java.lang.Boolean deployTime) {
            this.props.deployTime(deployTime);
            return this;
        }

        /**
         * A display name for this asset.
         * <p>
         * If supplied, the display name will be used in locations where the asset
         * identifier is printed, like in the CLI progress information. If the same
         * asset is added multiple times, the display name of the first occurrence is
         * used.
         * <p>
         * The default is the construct path of the Asset construct, with respect to
         * the enclosing stack. If the asset is produced by a construct helper
         * function (such as <code>lambda.Code.fromAsset()</code>), this will look like
         * <code>MyFunction/Code</code>.
         * <p>
         * We use the stack-relative construct path so that in the common case where
         * you have multiple stacks with the same asset, we won't show something like
         * <code>/MyBetaStack/MyFunction/Code</code> when you are actually deploying to
         * production.
         * <p>
         * Default: - Stack-relative construct path
         * <p>
         * @return {@code this}
         * @param displayName A display name for this asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * A list of principals that should be able to read this asset from S3.
         * <p>
         * You can use <code>asset.grantRead(principal)</code> to grant read permissions later.
         * <p>
         * Default: - No principals that can read file asset.
         * <p>
         * @return {@code this}
         * @param readers A list of principals that should be able to read this asset from S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readers(final java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers) {
            this.props.readers(readers);
            return this;
        }

        /**
         * The ARN of the KMS key used to encrypt the handler code.
         * <p>
         * Default: - the default server-side encryption with Amazon S3 managed keys(SSE-S3) key will be used.
         * <p>
         * @return {@code this}
         * @param sourceKmsKey The ARN of the KMS key used to encrypt the handler code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceKmsKey(final software.amazon.awscdk.services.kms.IKey sourceKmsKey) {
            this.props.sourceKmsKey(sourceKmsKey);
            return this;
        }

        /**
         * The disk location of the asset.
         * <p>
         * The path should refer to one of the following:
         * <p>
         * <ul>
         * <li>A regular file or a .zip file, in which case the file will be uploaded as-is to S3.</li>
         * <li>A directory, in which case it will be archived into a .zip file and uploaded to S3.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param path The disk location of the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3.assets.Asset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.assets.Asset build() {
            return new software.amazon.awscdk.services.s3.assets.Asset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
