package software.amazon.awscdk.services.s3.deployment;

/**
 * Used for HTTP cache-control header, which influences downstream caches.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket destinationBucket;
 * BucketDeployment.Builder.create(this, "BucketDeployment")
 *         .sources(List.of(Source.asset("./website", AssetOptions.builder().exclude(List.of("index.html")).build())))
 *         .destinationBucket(destinationBucket)
 *         .cacheControl(List.of(CacheControl.maxAge(Duration.days(365)), CacheControl.immutable()))
 *         .prune(false)
 *         .build();
 * BucketDeployment.Builder.create(this, "HTMLBucketDeployment")
 *         .sources(List.of(Source.asset("./website", AssetOptions.builder().exclude(List.of("*", "!index.html")).build())))
 *         .destinationBucket(destinationBucket)
 *         .cacheControl(List.of(CacheControl.maxAge(Duration.seconds(0))))
 *         .prune(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:22.187Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.CacheControl")
public class CacheControl extends software.amazon.jsii.JsiiObject {

    protected CacheControl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CacheControl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a custom cache control key from the literal value.
     * <p>
     * @param s This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl fromString(final @org.jetbrains.annotations.NotNull java.lang.String s) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class), new Object[] { java.util.Objects.requireNonNull(s, "s is required") });
    }

    /**
     * Sets 'immutable'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl immutable() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "immutable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 'max-age=<duration-in-seconds>'.
     * <p>
     * @param t This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl maxAge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "maxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * Sets 'must-revalidate'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl mustRevalidate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "mustRevalidate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 'must-understand'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl mustUnderstand() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "mustUnderstand", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 'no-cache'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl noCache() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "noCache", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 'no-store'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl noStore() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "noStore", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 'no-transform'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl noTransform() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "noTransform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 'proxy-revalidate'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl proxyRevalidate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "proxyRevalidate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 'private'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl setPrivate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "setPrivate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 'public'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl setPublic() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "setPublic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class));
    }

    /**
     * Sets 's-maxage=<duration-in-seconds>'.
     * <p>
     * @param t This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl sMaxAge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "sMaxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * Sets 'stale-if-error=<duration-in-seconds>'.
     * <p>
     * @param t This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl staleIfError(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "staleIfError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * Sets 'stale-while-revalidate=<duration-in-seconds>'.
     * <p>
     * @param t This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.CacheControl staleWhileRevalidate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.CacheControl.class, "staleWhileRevalidate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * The raw cache control setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
