package software.amazon.awscdk.services.s3objectlambda;

/**
 * Properties for defining a <code>CfnAccessPoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3objectlambda.*;
 * Object contentTransformation;
 * CfnAccessPointProps cfnAccessPointProps = CfnAccessPointProps.builder()
 *         .objectLambdaConfiguration(ObjectLambdaConfigurationProperty.builder()
 *                 .supportingAccessPoint("supportingAccessPoint")
 *                 .transformationConfigurations(List.of(TransformationConfigurationProperty.builder()
 *                         .actions(List.of("actions"))
 *                         .contentTransformation(contentTransformation)
 *                         .build()))
 *                 // the properties below are optional
 *                 .allowedFeatures(List.of("allowedFeatures"))
 *                 .cloudWatchMetricsEnabled(false)
 *                 .build())
 *         // the properties below are optional
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:22.220Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3objectlambda.CfnAccessPointProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccessPointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccessPointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A configuration used when creating an Object Lambda Access Point.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-objectlambdaconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getObjectLambdaConfiguration();

    /**
     * The name of this access point.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html#cfn-s3objectlambda-accesspoint-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccessPointProps> {
        java.lang.Object objectLambdaConfiguration;
        java.lang.String name;

        /**
         * Sets the value of {@link CfnAccessPointProps#getObjectLambdaConfiguration}
         * @param objectLambdaConfiguration A configuration used when creating an Object Lambda Access Point. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLambdaConfiguration(software.amazon.awscdk.IResolvable objectLambdaConfiguration) {
            this.objectLambdaConfiguration = objectLambdaConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getObjectLambdaConfiguration}
         * @param objectLambdaConfiguration A configuration used when creating an Object Lambda Access Point. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLambdaConfiguration(software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint.ObjectLambdaConfigurationProperty objectLambdaConfiguration) {
            this.objectLambdaConfiguration = objectLambdaConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getName}
         * @param name The name of this access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccessPointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccessPointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccessPointProps {
        private final java.lang.Object objectLambdaConfiguration;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.objectLambdaConfiguration = software.amazon.jsii.Kernel.get(this, "objectLambdaConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.objectLambdaConfiguration = java.util.Objects.requireNonNull(builder.objectLambdaConfiguration, "objectLambdaConfiguration is required");
            this.name = builder.name;
        }

        @Override
        public final java.lang.Object getObjectLambdaConfiguration() {
            return this.objectLambdaConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("objectLambdaConfiguration", om.valueToTree(this.getObjectLambdaConfiguration()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3objectlambda.CfnAccessPointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccessPointProps.Jsii$Proxy that = (CfnAccessPointProps.Jsii$Proxy) o;

            if (!objectLambdaConfiguration.equals(that.objectLambdaConfiguration)) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.objectLambdaConfiguration.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
