package software.amazon.awscdk.services.scheduler;

/**
 * ScheduleExpression for EventBridge Schedule.
 * <p>
 * You can choose from three schedule types when configuring your schedule: rate-based, cron-based, and one-time schedules.
 * Both rate-based and cron-based schedules are recurring schedules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * IDeliveryStream deliveryStream;
 * Map&lt;String, String&gt; payload = Map.of(
 *         "Data", "record");
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(60)))
 *         .target(FirehosePutRecord.Builder.create(deliveryStream)
 *                 .input(ScheduleTargetInput.fromObject(payload))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:22.703Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.ScheduleExpression")
public abstract class ScheduleExpression extends software.amazon.jsii.JsiiObject {

    protected ScheduleExpression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduleExpression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ScheduleExpression() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Construct a one-time schedule from a date.
     * <p>
     * @param date The date and time to use. This parameter is required.
     * @param timeZone The time zone to use for interpreting the date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleExpression at(final @org.jetbrains.annotations.NotNull java.time.Instant date, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeZone timeZone) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.ScheduleExpression.class, "at", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleExpression.class), new Object[] { java.util.Objects.requireNonNull(date, "date is required"), timeZone });
    }

    /**
     * Construct a one-time schedule from a date.
     * <p>
     * @param date The date and time to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleExpression at(final @org.jetbrains.annotations.NotNull java.time.Instant date) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.ScheduleExpression.class, "at", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleExpression.class), new Object[] { java.util.Objects.requireNonNull(date, "date is required") });
    }

    /**
     * Create a recurring schedule from a set of cron fields and time zone.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleExpression cron(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.CronOptionsWithTimezone options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.ScheduleExpression.class, "cron", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleExpression.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Construct a schedule from a literal schedule expression.
     * <p>
     * @param expression The expression to use. This parameter is required.
     * @param timeZone The time zone to use for interpreting the expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleExpression expression(final @org.jetbrains.annotations.NotNull java.lang.String expression, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeZone timeZone) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.ScheduleExpression.class, "expression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleExpression.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required"), timeZone });
    }

    /**
     * Construct a schedule from a literal schedule expression.
     * <p>
     * @param expression The expression to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleExpression expression(final @org.jetbrains.annotations.NotNull java.lang.String expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.ScheduleExpression.class, "expression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleExpression.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * Construct a recurring schedule from an interval and a time unit.
     * <p>
     * Rates may be defined with any unit of time, but when converted into minutes, the duration must be a positive whole number of minutes.
     * <p>
     * @param duration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleExpression rate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.ScheduleExpression.class, "rate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleExpression.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Retrieve the expression for this schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getExpressionString();

    /**
     * Retrieve the expression for this schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeZone getTimeZone();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.scheduler.ScheduleExpression {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Retrieve the expression for this schedule.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getExpressionString() {
            return software.amazon.jsii.Kernel.get(this, "expressionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Retrieve the expression for this schedule.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeZone getTimeZone() {
            return software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        }
    }
}
