package software.amazon.awscdk.services.scheduler.targets;

/**
 * Send an event to an AWS EventBridge by AWS EventBridge Scheduler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.*;
 * EventBus eventBus = EventBus.Builder.create(this, "EventBus")
 *         .eventBusName("DomainEvents")
 *         .build();
 * EventBridgePutEventsEntry eventEntry = EventBridgePutEventsEntry.builder()
 *         .eventBus(eventBus)
 *         .source("PetService")
 *         .detail(ScheduleTargetInput.fromObject(Map.of("Name", "Fluffy")))
 *         .detailType("🐶")
 *         .build();
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.hours(1)))
 *         .target(new EventBridgePutEvents(eventEntry))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:22.733Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler_targets.EventBridgePutEvents")
public class EventBridgePutEvents extends software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase implements software.amazon.awscdk.services.scheduler.IScheduleTarget {

    protected EventBridgePutEvents(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventBridgePutEvents(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param entry This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBridgePutEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.targets.EventBridgePutEventsEntry entry, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(entry, "entry is required"), props });
    }

    /**
     * @param entry This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBridgePutEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.targets.EventBridgePutEventsEntry entry) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(entry, "entry is required") });
    }

    /**
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void addTargetActionToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        software.amazon.jsii.Kernel.call(this, "addTargetActionToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * @param _schedule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleTargetConfig bindBaseTargetConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ISchedule _schedule) {
        return software.amazon.jsii.Kernel.call(this, "bindBaseTargetConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_schedule, "_schedule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.scheduler.targets.EventBridgePutEvents}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.scheduler.targets.EventBridgePutEvents> {
        /**
         * @return a new instance of {@link Builder}.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBaseProps props) {
            return new Builder(props);
        }
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder(null);
        }

        private final software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBaseProps props;
        private final software.amazon.awscdk.services.scheduler.targets.EventBridgePutEventsEntry.Builder entry;

        private Builder(final software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBaseProps props) {
            this.props = props;
            this.entry = new software.amazon.awscdk.services.scheduler.targets.EventBridgePutEventsEntry.Builder();
        }

        /**
         * The event body.
         * <p>
         * Can either be provided as an object or as a JSON-serialized string
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * ScheduleTargetInput.fromText("{\"instance-id\": \"i-1234567890abcdef0\", \"state\": \"terminated\"}");
         * ScheduleTargetInput.fromObject(Map.of("Message", "Hello from a friendly event :)"));
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param detail The event body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detail(final software.amazon.awscdk.services.scheduler.ScheduleTargetInput detail) {
            this.entry.detail(detail);
            return this;
        }

        /**
         * Used along with the source field to help identify the fields and values expected in the detail field.
         * <p>
         * For example, events by CloudTrail have detail type "AWS API Call via CloudTrail"
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html">https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html</a>
         * @param detailType Used along with the source field to help identify the fields and values expected in the detail field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(final java.lang.String detailType) {
            this.entry.detailType(detailType);
            return this;
        }

        /**
         * The event bus the entry will be sent to.
         * <p>
         * @return {@code this}
         * @param eventBus The event bus the entry will be sent to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBus(final software.amazon.awscdk.services.events.IEventBus eventBus) {
            this.entry.eventBus(eventBus);
            return this;
        }

        /**
         * The service or application that caused this event to be generated.
         * <p>
         * Example value: <code>com.example.service</code>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html">https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html</a>
         * @param source The service or application that caused this event to be generated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final java.lang.String source) {
            this.entry.source(source);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.scheduler.targets.EventBridgePutEvents}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.scheduler.targets.EventBridgePutEvents build() {
            return new software.amazon.awscdk.services.scheduler.targets.EventBridgePutEvents(
                this.entry.build(),
                this.props
            );
        }
    }
}
