package software.amazon.awscdk.services.secretsmanager;

/**
 * Properties for defining a <code>CfnResourcePolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Object resourcePolicy;
 * CfnResourcePolicyProps cfnResourcePolicyProps = CfnResourcePolicyProps.builder()
 *         .resourcePolicy(resourcePolicy)
 *         .secretId("secretId")
 *         // the properties below are optional
 *         .blockPublicPolicy(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-resourcepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-resourcepolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:22.750Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnResourcePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourcePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourcePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A JSON-formatted string for an AWS resource-based policy.
     * <p>
     * For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-resourcepolicy.html#cfn-secretsmanager-resourcepolicy-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-resourcepolicy.html#cfn-secretsmanager-resourcepolicy-resourcepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourcePolicy();

    /**
     * The ARN or name of the secret to attach the resource-based policy.
     * <p>
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-resourcepolicy.html#cfn-secretsmanager-resourcepolicy-secretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-resourcepolicy.html#cfn-secretsmanager-resourcepolicy-secretid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecretId();

    /**
     * Specifies whether to block resource-based policies that allow broad access to the secret.
     * <p>
     * By default, Secrets Manager blocks policies that allow broad access, for example those that use a wildcard for the principal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-resourcepolicy.html#cfn-secretsmanager-resourcepolicy-blockpublicpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-resourcepolicy.html#cfn-secretsmanager-resourcepolicy-blockpublicpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBlockPublicPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourcePolicyProps> {
        java.lang.Object resourcePolicy;
        java.lang.String secretId;
        java.lang.Object blockPublicPolicy;

        /**
         * Sets the value of {@link CfnResourcePolicyProps#getResourcePolicy}
         * @param resourcePolicy A JSON-formatted string for an AWS resource-based policy. This parameter is required.
         *                       For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(java.lang.Object resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourcePolicyProps#getSecretId}
         * @param secretId The ARN or name of the secret to attach the resource-based policy. This parameter is required.
         *                 For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretId(java.lang.String secretId) {
            this.secretId = secretId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourcePolicyProps#getBlockPublicPolicy}
         * @param blockPublicPolicy Specifies whether to block resource-based policies that allow broad access to the secret.
         *                          By default, Secrets Manager blocks policies that allow broad access, for example those that use a wildcard for the principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockPublicPolicy(java.lang.Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourcePolicyProps#getBlockPublicPolicy}
         * @param blockPublicPolicy Specifies whether to block resource-based policies that allow broad access to the secret.
         *                          By default, Secrets Manager blocks policies that allow broad access, for example those that use a wildcard for the principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockPublicPolicy(software.amazon.awscdk.IResolvable blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourcePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourcePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourcePolicyProps {
        private final java.lang.Object resourcePolicy;
        private final java.lang.String secretId;
        private final java.lang.Object blockPublicPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.secretId = software.amazon.jsii.Kernel.get(this, "secretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockPublicPolicy = software.amazon.jsii.Kernel.get(this, "blockPublicPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourcePolicy = java.util.Objects.requireNonNull(builder.resourcePolicy, "resourcePolicy is required");
            this.secretId = java.util.Objects.requireNonNull(builder.secretId, "secretId is required");
            this.blockPublicPolicy = builder.blockPublicPolicy;
        }

        @Override
        public final java.lang.Object getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final java.lang.String getSecretId() {
            return this.secretId;
        }

        @Override
        public final java.lang.Object getBlockPublicPolicy() {
            return this.blockPublicPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
            data.set("secretId", om.valueToTree(this.getSecretId()));
            if (this.getBlockPublicPolicy() != null) {
                data.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnResourcePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourcePolicyProps.Jsii$Proxy that = (CfnResourcePolicyProps.Jsii$Proxy) o;

            if (!resourcePolicy.equals(that.resourcePolicy)) return false;
            if (!secretId.equals(that.secretId)) return false;
            return this.blockPublicPolicy != null ? this.blockPublicPolicy.equals(that.blockPublicPolicy) : that.blockPublicPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourcePolicy.hashCode();
            result = 31 * result + (this.secretId.hashCode());
            result = 31 * result + (this.blockPublicPolicy != null ? this.blockPublicPolicy.hashCode() : 0);
            return result;
        }
    }
}
