package software.amazon.awscdk.services.securityhub;

/**
 * Properties for defining a <code>CfnFindingAggregator</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnFindingAggregatorProps cfnFindingAggregatorProps = CfnFindingAggregatorProps.builder()
 *         .regionLinkingMode("regionLinkingMode")
 *         // the properties below are optional
 *         .regions(List.of("regions"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-findingaggregator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-findingaggregator.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:22.851Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnFindingAggregatorProps")
@software.amazon.jsii.Jsii.Proxy(CfnFindingAggregatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFindingAggregatorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether to aggregate findings from all of the available Regions in the current partition.
     * <p>
     * Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
     * <p>
     * The selected option also determines how to use the Regions provided in the Regions list.
     * <p>
     * In AWS CloudFormation , the options for this property are as follows:
     * <p>
     * <ul>
     * <li><code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.</li>
     * <li><code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.</li>
     * <li><code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-findingaggregator.html#cfn-securityhub-findingaggregator-regionlinkingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-findingaggregator.html#cfn-securityhub-findingaggregator-regionlinkingmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegionLinkingMode();

    /**
     * If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> , then this is a space-separated list of Regions that do not aggregate findings to the aggregation Region.
     * <p>
     * If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code> , then this is a space-separated list of Regions that do aggregate findings to the aggregation Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-findingaggregator.html#cfn-securityhub-findingaggregator-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-findingaggregator.html#cfn-securityhub-findingaggregator-regions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFindingAggregatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFindingAggregatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFindingAggregatorProps> {
        java.lang.String regionLinkingMode;
        java.util.List<java.lang.String> regions;

        /**
         * Sets the value of {@link CfnFindingAggregatorProps#getRegionLinkingMode}
         * @param regionLinkingMode Indicates whether to aggregate findings from all of the available Regions in the current partition. This parameter is required.
         *                          Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
         *                          <p>
         *                          The selected option also determines how to use the Regions provided in the Regions list.
         *                          <p>
         *                          In AWS CloudFormation , the options for this property are as follows:
         *                          <p>
         *                          <ul>
         *                          <li><code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.</li>
         *                          <li><code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.</li>
         *                          <li><code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionLinkingMode(java.lang.String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnFindingAggregatorProps#getRegions}
         * @param regions If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> , then this is a space-separated list of Regions that do not aggregate findings to the aggregation Region.
         *                If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code> , then this is a space-separated list of Regions that do aggregate findings to the aggregation Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(java.util.List<java.lang.String> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFindingAggregatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFindingAggregatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFindingAggregatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFindingAggregatorProps {
        private final java.lang.String regionLinkingMode;
        private final java.util.List<java.lang.String> regions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.regionLinkingMode = software.amazon.jsii.Kernel.get(this, "regionLinkingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.regionLinkingMode = java.util.Objects.requireNonNull(builder.regionLinkingMode, "regionLinkingMode is required");
            this.regions = builder.regions;
        }

        @Override
        public final java.lang.String getRegionLinkingMode() {
            return this.regionLinkingMode;
        }

        @Override
        public final java.util.List<java.lang.String> getRegions() {
            return this.regions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("regionLinkingMode", om.valueToTree(this.getRegionLinkingMode()));
            if (this.getRegions() != null) {
                data.set("regions", om.valueToTree(this.getRegions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnFindingAggregatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFindingAggregatorProps.Jsii$Proxy that = (CfnFindingAggregatorProps.Jsii$Proxy) o;

            if (!regionLinkingMode.equals(that.regionLinkingMode)) return false;
            return this.regions != null ? this.regions.equals(that.regions) : that.regions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.regionLinkingMode.hashCode();
            result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
            return result;
        }
    }
}
