package software.amazon.awscdk.services.servicediscovery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * INamespace namespace;
 * ServiceAttributes serviceAttributes = ServiceAttributes.builder()
 *         .dnsRecordType(DnsRecordType.A)
 *         .namespace(namespace)
 *         .routingPolicy(RoutingPolicy.WEIGHTED)
 *         .serviceArn("serviceArn")
 *         .serviceId("serviceId")
 *         .serviceName("serviceName")
 *         // the properties below are optional
 *         .discoveryType(DiscoveryType.API)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:23.036Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.ServiceAttributes")
@software.amazon.jsii.Jsii.Proxy(ServiceAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.DnsRecordType getDnsRecordType();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.INamespace getNamespace();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.RoutingPolicy getRoutingPolicy();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceArn();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceId();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceName();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.DiscoveryType getDiscoveryType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceAttributes> {
        software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType;
        software.amazon.awscdk.services.servicediscovery.INamespace namespace;
        software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy;
        java.lang.String serviceArn;
        java.lang.String serviceId;
        java.lang.String serviceName;
        software.amazon.awscdk.services.servicediscovery.DiscoveryType discoveryType;

        /**
         * Sets the value of {@link ServiceAttributes#getDnsRecordType}
         * @param dnsRecordType the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsRecordType(software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType) {
            this.dnsRecordType = dnsRecordType;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getNamespace}
         * @param namespace the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(software.amazon.awscdk.services.servicediscovery.INamespace namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getRoutingPolicy}
         * @param routingPolicy the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingPolicy(software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy) {
            this.routingPolicy = routingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getServiceArn}
         * @param serviceArn the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceArn(java.lang.String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getServiceId}
         * @param serviceId the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceId(java.lang.String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getServiceName}
         * @param serviceName the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getDiscoveryType}
         * @param discoveryType the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder discoveryType(software.amazon.awscdk.services.servicediscovery.DiscoveryType discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceAttributes {
        private final software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType;
        private final software.amazon.awscdk.services.servicediscovery.INamespace namespace;
        private final software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy;
        private final java.lang.String serviceArn;
        private final java.lang.String serviceId;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.services.servicediscovery.DiscoveryType discoveryType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dnsRecordType = software.amazon.jsii.Kernel.get(this, "dnsRecordType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.DnsRecordType.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.INamespace.class));
            this.routingPolicy = software.amazon.jsii.Kernel.get(this, "routingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.RoutingPolicy.class));
            this.serviceArn = software.amazon.jsii.Kernel.get(this, "serviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceId = software.amazon.jsii.Kernel.get(this, "serviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.discoveryType = software.amazon.jsii.Kernel.get(this, "discoveryType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.DiscoveryType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dnsRecordType = java.util.Objects.requireNonNull(builder.dnsRecordType, "dnsRecordType is required");
            this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            this.routingPolicy = java.util.Objects.requireNonNull(builder.routingPolicy, "routingPolicy is required");
            this.serviceArn = java.util.Objects.requireNonNull(builder.serviceArn, "serviceArn is required");
            this.serviceId = java.util.Objects.requireNonNull(builder.serviceId, "serviceId is required");
            this.serviceName = java.util.Objects.requireNonNull(builder.serviceName, "serviceName is required");
            this.discoveryType = builder.discoveryType;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.DnsRecordType getDnsRecordType() {
            return this.dnsRecordType;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.INamespace getNamespace() {
            return this.namespace;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.RoutingPolicy getRoutingPolicy() {
            return this.routingPolicy;
        }

        @Override
        public final java.lang.String getServiceArn() {
            return this.serviceArn;
        }

        @Override
        public final java.lang.String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.DiscoveryType getDiscoveryType() {
            return this.discoveryType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dnsRecordType", om.valueToTree(this.getDnsRecordType()));
            data.set("namespace", om.valueToTree(this.getNamespace()));
            data.set("routingPolicy", om.valueToTree(this.getRoutingPolicy()));
            data.set("serviceArn", om.valueToTree(this.getServiceArn()));
            data.set("serviceId", om.valueToTree(this.getServiceId()));
            data.set("serviceName", om.valueToTree(this.getServiceName()));
            if (this.getDiscoveryType() != null) {
                data.set("discoveryType", om.valueToTree(this.getDiscoveryType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.ServiceAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceAttributes.Jsii$Proxy that = (ServiceAttributes.Jsii$Proxy) o;

            if (!dnsRecordType.equals(that.dnsRecordType)) return false;
            if (!namespace.equals(that.namespace)) return false;
            if (!routingPolicy.equals(that.routingPolicy)) return false;
            if (!serviceArn.equals(that.serviceArn)) return false;
            if (!serviceId.equals(that.serviceId)) return false;
            if (!serviceName.equals(that.serviceName)) return false;
            return this.discoveryType != null ? this.discoveryType.equals(that.discoveryType) : that.discoveryType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dnsRecordType.hashCode();
            result = 31 * result + (this.namespace.hashCode());
            result = 31 * result + (this.routingPolicy.hashCode());
            result = 31 * result + (this.serviceArn.hashCode());
            result = 31 * result + (this.serviceId.hashCode());
            result = 31 * result + (this.serviceName.hashCode());
            result = 31 * result + (this.discoveryType != null ? this.discoveryType.hashCode() : 0);
            return result;
        }
    }
}
