package software.amazon.awscdk.services.ses;

/**
 * Virtual Deliverability Manager (VDM) attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Enables engagement tracking and optimized shared delivery by default
 * // Enables engagement tracking and optimized shared delivery by default
 * new VdmAttributes(this, "Vdm");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:23.163Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.VdmAttributes")
public class VdmAttributes extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ses.IVdmAttributes {

    protected VdmAttributes(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VdmAttributes(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.VdmAttributes.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VdmAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.VdmAttributesProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VdmAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Use an existing Virtual Deliverability Manager attributes resource.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param vdmAttributesName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IVdmAttributes fromVdmAttributesName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String vdmAttributesName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.VdmAttributes.class, "fromVdmAttributesName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IVdmAttributes.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(vdmAttributesName, "vdmAttributesName is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The name of the resource behind the Virtual Deliverability Manager attributes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVdmAttributesName() {
        return software.amazon.jsii.Kernel.get(this, "vdmAttributesName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Resource ID for the Virtual Deliverability Manager attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVdmAttributesResourceId() {
        return software.amazon.jsii.Kernel.get(this, "vdmAttributesResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.VdmAttributes}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.VdmAttributes> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ses.VdmAttributesProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Whether engagement metrics are enabled for your account.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param engagementMetrics Whether engagement metrics are enabled for your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engagementMetrics(final java.lang.Boolean engagementMetrics) {
            this.props().engagementMetrics(engagementMetrics);
            return this;
        }

        /**
         * Whether optimized shared delivery is enabled for your account.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param optimizedSharedDelivery Whether optimized shared delivery is enabled for your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optimizedSharedDelivery(final java.lang.Boolean optimizedSharedDelivery) {
            this.props().optimizedSharedDelivery(optimizedSharedDelivery);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.VdmAttributes}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.VdmAttributes build() {
            return new software.amazon.awscdk.services.ses.VdmAttributes(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ses.VdmAttributesProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ses.VdmAttributesProps.Builder();
            }
            return this.props;
        }
    }
}
